/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/session/spi/InvalidSessionState.java $
  $Revision: 27 $
  $Modtime: 1/09/02 3:31p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.spi;

import com.novell.service.jncpv2.clx.*;
import com.novell.service.session.*;
import com.novell.service.session.util.Debug;
import com.novell.java.security.*;

/** @internal
 * Throws an exception for all operations.  Strictly a place-holder
 * state for sessions that no longer "exist," in case a reference to
 * the session is still being maintained by  an application.
 */
public class InvalidSessionState extends SessionState
{
   // Always access debug via final static...hopefully a final static of
   // false will be optimized out by the compiler
	final static private boolean DEBUG = false;
	final static private boolean MAKE_INVALID_DEBUG = false;
	final static private boolean S_DEBUG = false; // May have side effects

   // Print message if deprecated API is used
   final static private boolean ERROR_ON_DEPRECATED = false;

   private static InvalidSessionState singletonInstance;
   final private static String INVALID =  "Session no longer valid";

   private Throwable reason;

   private InvalidSessionState
   (
   )
   throws SessionException
   {
      super(null);
      setReason(
         new SessionException("State not fully initialized"));
   }

   public InvalidSessionState
   (
      SessionImpl attachedSession,
      Throwable rootCause  //non null if invalidating as the result of an exception (as opposed to someone calling close() )
   )
   throws SessionException
   {
      super(attachedSession);
      SessionException se;
      if(rootCause == null)
         se = new SessionException("Session invalidated");
      else
         se = new SessionException("Session invalidated", rootCause);
      setReason(se);

      // We're ready to be used!
      this.attachedSession.setState(this);
   }

   /**
    * Returns a singleton instance of InvalidSessionState.
    */
   public static InvalidSessionState getInstance
   (
   )
   throws SessionException
   {
      if (null == singletonInstance)
      {
         singletonInstance = new InvalidSessionState();
      }
      return singletonInstance;
   }

   /**
    * Inherited from Session
    *
    * @see Session#close
    */
   public void close
   (
   )
   throws SessionException
   {
      // Just return...already closed.
//      throw getInvalidException();
   }

   /**
    * Inherited from Session
    *
    * @see Session#getSession
    */
   public Session getSession
   (
      String domainName,
      SessionEnv environment
   )
   throws SessionException
   {
      throw getInvalidException();
   }

   /**
    * Inherited from Session
    *
    * @see Session#getSessionTop
    */
   public Session getSessionTop
   (
      String domainName,
      SessionEnv environment
   )
   throws SessionException
   {
      throw getInvalidException();
   }

   /**
    * Inherited from Session
    *
    * @see Session#getAttributes()
    */
   public SessionAttrs getAttributes
   (
   )
   throws SessionException
   {
      throw getInvalidException();
   }

   /**
    * Inherited from Session
    *
    * @see Session#getAttributes(String[])
    */
   public SessionAttrs getAttributes
   (
      String attrIds[]
   )
   throws SessionException
   {
      throw getInvalidException();
   }

   /**
    * Inherited from Session
    *
    * @see Session#search
    */
   public SessionEnumerator search
   (
      SessionAttrs matchingSessionAttrSet
   )
   throws SessionException
   {
      throw getInvalidException();
   }

   /**
    * Inherited from Session
    *
    * @see Session#getDomainName
    */
   public String getDomainName
   (
   )
   throws SessionException
   {
      throw getInvalidException();
   }

   /**
    * Inherited from Session
    *
    * @see Session#getChildren
    */
   public SessionEnumerator getChildren
   (
   )
   throws SessionException
   {
      throw getInvalidException();
   }

   /**
    * Inherited from Session
    *
    * @see Session#invalidate
    */
   public void invalidate
   (
      Throwable rootCause
   )
   throws SessionException
   {
      throw getInvalidException();
   }

   /**
    * Inherited from Session
    *
    * @see Session#validateLinks
    */
   public void validateLinks
   (
   )
   throws SessionException
   {
      throw getInvalidException();
   }

   /**
    * Inherited from Session
    *
    * @see Session#isValid
    */
   public boolean isValid()
   {
      return false;
   }

   /**
    * @deprecated Use com.novell.service.security and related packages.
    *
    * Inherited from Authenticatable.
    *
    * @see Authenticatable.#getName
    */
   public String getName
   (
   )
   throws SessionException
   {
      if (ERROR_ON_DEPRECATED)
      {
         System.out.println("This API has been deprecated..." +
            "see documentation for more details. Stack trace follows:");
         Thread.dumpStack();
      }

      throw getInvalidException();
   }

   /**
    * @deprecated Use com.novell.service.security and related packages.
    *
    * Inherited from Authenticatable
    *
    * @see Authenticatable#authenticate()
    */
   public void authenticate
   (
      String name
   )
   throws SessionException
   {
      if (ERROR_ON_DEPRECATED)
      {
         System.out.println("This API has been deprecated..." +
            "see documentation for more details. Stack trace follows:");
         Thread.dumpStack();
      }

      throw getInvalidException();
   }

   /**
    * @deprecated Use com.novell.service.security and related packages.
    *
    * Inherited from Authenticatable
    *
    * @see Authenticatable#authenticate()
    */
   public void authenticate
   (
   )
   throws SessionException
   {
      if (ERROR_ON_DEPRECATED)
      {
         System.out.println("This API has been deprecated..." +
            "see documentation for more details. Stack trace follows:");
         Thread.dumpStack();
      }

      throw getInvalidException();
   }

   /**
    * @deprecated Use com.novell.service.security and related packages.
    *
    * Inherited from Authenticatable
    *
    * @see Authenticatable#unauthenticate
    */
   public void unauthenticate
   (
   )
   throws SessionException
   {
      if (ERROR_ON_DEPRECATED)
      {
         System.out.println("This API has been deprecated..." +
            "see documentation for more details. Stack trace follows:");
         Thread.dumpStack();
      }

      throw getInvalidException();
   }

   /**
    * Inherited from Authenticatable
    *
    * @see Authenticatable#isAuthenticated
    */
   public boolean isAuthenticated
   (
   )
   throws SessionException
   {
      throw getInvalidException();
   }

   /**
    * Inherited from Session
    *
    * @see Session#getService
    */
   public SessionService getService
   (
      String serviceKey
   )
   throws SessionException
   {
      throw getInvalidException();
   }

   /**
    * Inherited from Authenticatable.
    *
    * @see Authenticatable#createIdentity
    */
   public Identity createIdentity
   (
      String userName
   )
   throws SessionException
   {
      throw getInvalidException();
   }

//   synchronized public void setReason
   public void setReason
   (
      Throwable reason
   )
   {
      this.reason = reason;
   }

//   synchronized protected Throwable getReason
   protected Throwable getReason
   (
   )
   {
      return this.reason;
   }

   static public SessionException makeInvalid
   (
      SessionImpl session,
      Throwable rootException
   )
   throws SessionException
   {
      if (DEBUG | MAKE_INVALID_DEBUG)
      {
         Debug.println(session.toString());
         Debug.dumpException(rootException);
      }
      if (null == rootException)
         throw new NullPointerException("rootException");
      session.invalidate(rootException);
      InvalidSessionState state = (InvalidSessionState)session.getState();
      state.setReason(rootException);
      return new InvalidSessionException(
         INVALID + ": " + session.domainName,
         rootException);
   }

   /**
    * Inherited from Session
    */
   public Session findSession(String domainName)
   throws SessionException
   {
      throw getInvalidException();
   }

   /**
    * Inherited from Session
    */
   public Session findSessionTop(String domainName)
   throws SessionException
   {
      throw getInvalidException();
   }

   /*
    * Inherited from SessionState.
    */
   public SessionException getInvalidException()
   throws SessionException
   {
      return new InvalidSessionException(
         INVALID,
         getReason());
   }
}

