/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/session/spi/SessionManagerImpl.java $
  $Revision: 17 $
  $Modtime: 1/24/00 8:00p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.spi;

import com.novell.service.jncpv2.clx.*;
import com.novell.service.session.*;
import com.novell.service.session.spi.*;
import com.novell.service.session.util.Debug;

/** @internal
 * Implements SessionManager
 * NOTE: This object is technically not needed any more, and is a no-op
 * extension of SessionImpl.
 * However, SessionManagerFactory.getSessionManager() returns an object
 * of type SessionManager...not Session.
 */
public class SessionManagerImpl
extends SessionImpl
implements SessionManager
{
   // Always access debug via final static...hopefully a final static of
   // false will be optimized out by the compiler
	final static private boolean DEBUG = false;
   private int scope = SessionManagerFactory.SCOPE;

   /**
    * Constructor intented to be used by getInstance() to maintain singleton
    * SessionManager object.
    */
   protected SessionManagerImpl
   (
      String domainName,
      int scope,
      SessionEnv environment
   )
   throws SessionException
   {
      super(null, domainName, environment);
      this.scope = scope;
   }

   /* @internal
    * Returns the scope at which this session manager was created.
    */
   public int getScope()
   {
      return scope;
   }
}

