/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/session/spi/SessionManagerServiceImpl.java $
  $Revision: 18 $
  $Modtime: 1/24/00 8:00p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.spi;

import com.novell.service.jncpv2.clx.*;
import java.util.Hashtable;
import com.novell.service.session.*;
import com.novell.service.session.util.*;
import com.novell.service.session.spi.*;
import java.rmi.*;
import com.novell.service.session.util.Debug;
import com.novell.service.session.util.TestBuildMarker;
import java.util.Enumeration;

/** @internal
 * Server-side class handles creating new session managers
 */
public class SessionManagerServiceImpl
implements SessionManagerService
{
   // Always access debug via final static...hopefully a final static of
   // false will be optimized out by the compiler
	final static private boolean DEBUG = false;
	final static private boolean S_DEBUG = false; // May have side effects

   Hashtable workstationSessionManagers = null;
   static SessionManagerService singletonInstance = null;

   /**
    */
   protected SessionManagerServiceImpl
   (
   )
   throws SessionException
   {
      TestBuildMarker.emit();
      workstationSessionManagers = new Hashtable();
   }

   static public SessionManagerService getInstance
   (
   )
   throws SessionException
   {
      if (null == singletonInstance)
         singletonInstance = new SessionManagerServiceImpl();
      return singletonInstance;
   }

   /**
    * Inherited from SessionManagerService.
    */
   public SessionManager getSessionManager
   (
      SessionEnv environment,
      int scope
   )
   throws SessionException
   {
      if (DEBUG)
      {
	      Debug.println("->SMSI.getSessionManager()");
      }
      SessionManager sm = new SessionManagerImpl(
         SessionManager.SESSION_MANAGER,
         scope,
         (SessionEnv)environment.clone());

      SessionState state = new SessionManagerState(sm);

      sm.validateLinks();

      // This will spawn a daemon thread if ALLOW_BACKGROUND_VALIDATION
      // is true in environment
      spawnDaemon(
         sm,
         (SessionEnv)environment.clone());

      if (DEBUG)
      {
         Debug.println("--SMSI.getSessionManager(): ..spawn second daemon");
         spawnDaemon(
            sm,
            (SessionEnv)environment.clone());
         spawnDaemon(
            sm,
            (SessionEnv)environment.clone());
         spawnDaemon(
            sm,
            (SessionEnv)environment.clone());
         spawnDaemon(
            sm,
            (SessionEnv)environment.clone());
         spawnDaemon(
            sm,
            (SessionEnv)environment.clone());
      }
      if (DEBUG)
      {
	      Debug.println("<-SMSI.getSessionManager()");
      }
      return sm;
   }

   /*
    * Checks environment and spawns daemon thread if
    * ALLOW_BACKGROUND_VALIDATION is true
    */
   private void spawnDaemon
   (
      SessionManager sm,
      SessionEnv environment
   )
   throws SessionException
   {
      boolean runDaemon = false;
      if (DEBUG)
      {
	      Debug.println("->SMSI.spawnDaemon()");
      }
      try
      {
         Boolean runDaemonObject =
            (Boolean)environment.get(SessionEnv.ALLOW_BACKGROUND_VALIDATION);
         if (null != runDaemonObject)
         {
            runDaemon = runDaemonObject.booleanValue();
         }
         else
         {
            if (DEBUG)
            {
	            Debug.println("--SMSI.spawnDaemon(): Run daemon: env not set");
            }
         }
         if (DEBUG)
         {
	         Debug.println("--SMSI.spawnDaemon(): Run daemon: " + runDaemon);
         }

         if (runDaemon)
         {
            SessionManagerServiceDaemon sd = new SessionManagerServiceDaemon(sm);
            Thread t = new Thread(sd);

            // Dies when program ends
            t.setDaemon(true);

            // Slightly lower priority that spawning thread
            int priority = t.getPriority();
            if (priority > Thread.MIN_PRIORITY)
               priority -= 1;
            t.setPriority(priority);
            t.setName(
               sd.toString());

            // Do it
            if (DEBUG)
            {
	            Debug.println(
                  "--SMSI.spawnDaemon(): Started daemon thread: " + t.getName());
            }
            t.start();
         }
      }
      catch (Exception e)
      {
         throw new SessionException("Unexpected exception", e);
      }
      if (DEBUG)
      {
	      Debug.println("<-SMSI.spawnDaemon()");
      }
   }

   /**
    * Returns SessionManager unique to calling workstation.
    */
   public SessionManager getWorkstationSessionManager
   (
      SessionEnv environment,
      int scope
   )
   throws SessionException
   {
      throw new SessionException("NOT YET IMPLEMENTED");
/*
      String workstation;
      try
      {
         workstation = this.getClientHost();
      }
      catch (java.rmi.server.ServerNotActiveException e)
      {
//       Misc.consoleException(e);
         throw new SessionException("Unexpected exception", e);
      }
      SessionManager sm;
      if (workstationSessionManagers.containsKey(workstation))
         sm = (SessionManager)workstationSessionManagers.get(workstation);
      else
      {
         sm = getSessionManager((SessionEnv)environment.clone());
         workstationSessionManagers.put(workstation, sm);
      }
      return sm;
*/
   }

/*
   public static void main(String argv[])
   {
      try
      {
         System.setSecurityManager(new RMISecurityManager());
         SessionManagerServiceImpl sms = new SessionManagerServiceImpl();
         String name = "//" +
//            "djharris3.npd.provo.novell/" +
            "SessionManagerService";
         Naming.rebind(name, sms);
         Misc.printlnConsole(name + " created/bound in registry");
      }
      catch (Exception e)
      {
//       Misc.consoleException(e);
      }
   }
*/
}

