/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/session/util/Misc.java $
  $Revision: 9 $
  $Modtime: 4/04/99 5:29p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.util;

import com.novell.service.session.SessionException;

/** @internal
 */
public class Misc
{
   // Always access debug via final static...hopefully a final static of
   // false will be optimized out by the compiler
	final static private boolean DEBUG = false;
	final static private boolean S_DEBUG = false; // May have side effects

   /**
    * Serialize an object.
    */
   static public void serialize(java.io.Serializable o, String name)
   {
      try
      {
         java.io.FileOutputStream f = new java.io.FileOutputStream("nul");
         java.io.ObjectOutput  oos  =  new  java.io.ObjectOutputStream(f);
         oos.writeObject(name);
         oos.writeObject(o);
         oos.flush();
      }
      catch (java.io.IOException e)
      {
         e.printStackTrace();
      }
   }

   /*
    * Handle console exception
    */
   static public void consoleException(Throwable e)
   {
      printlnConsoleBeep("Exception...");
      e.printStackTrace();
   }

   /*
    * Print to console.
    */
   static public void printlnConsole(String output)
   {
      System.out.println(output);
   }

   /*
    * Print with beep if debug true, else quiet.
    */
   static public void printlnConsoleBeep(String output)
   {
      if (DEBUG)
         if (Debug.getDebug())
            printlnConsole("\007" + output);
      else
         printlnConsole(output);
   }
}

