/* **************************************************************************
  $Archive: /njcl_v2/src/com/novell/service/session/xplat/BasicNCPService.java $
  $Revision: 1 $
  $Modtime: 1/28/00 5:29p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import com.novell.service.session.*;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.clx.ClxJNI;

/** @internal
 * Object returned by Session.getService()
 */
public class BasicNCPService implements NCPService
{
   Connection conn;

   public BasicNCPService(Connection connection)
   throws SessionException
   {
      conn = connection;
   }
   
   public int fragmentRequest
   (
      int function,
      int verb,
      int reserved,
      byte[][] reqFrags,
      /*inout*/ byte[][] replyFrags
   )
   throws NSIException, SessionException
   {
      int connHandle = conn.getHandle();
      return ClxJNI.NWCCFragmentRequest(
         connHandle, function, verb, reserved, reqFrags, replyFrags);
   }
}
