/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/session/xplat/CallsService.java $
  $Revision: 16 $
  $Modtime: 1/28/04 4:16p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import java.rmi.*;
import com.novell.service.session.*;
import com.novell.java.lang.IntegerBuffer;
import com.novell.java.lang.BooleanBuffer;
import com.novell.service.file.nw.*;
import com.novell.service.server.*;
import com.novell.service.ncpext.*;
import com.novell.service.file.nw.calls.*;
import com.novell.service.qms.*;
import com.novell.service.jncp.NSIException;

/** @internal
 * Object returned by Session.getService()
 */
public interface CallsService extends SessionService
{
   /**
    * The key used to generate an object of this type via the
    * Session.getService() interface.
    */
// Please leave OLD versions here but commented out for the purpose of
// tracking unique identifiers.
//   public static final String KEY =
//"com.novell.service.session.xplat.CallsService.4655434B01";
   public static final String KEY =
"com.novell.service.session.xplat.CallsService.4461766964";

   public boolean areSLPCallsAvailable() throws NSIException;

   public void getObjectNamesBeginA
   (
      int type,
      IntegerBuffer handle
   )
   throws NSIException;

   public void getObjectNamesNextA
   (
      IntegerBuffer handle,
      IntegerBuffer bufLen,
      StringBuffer buf
   )
   throws NSIException;

   public void getObjectNamesEndA
   (
      IntegerBuffer handle
   )
   throws NSIException;

   public String getObjectName
   (
      int objectId,
      IntegerBuffer type
   )
   throws SessionException;

   public void freePtr(int mallocedPtr)
   throws SessionException;

   public int allocEAHandle()
   throws SessionException;

   public int allocEAFFStruct()
   throws SessionException;

   public void addObjectToSet
      (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   String   memberName,
      /*in*/   int      memberType
      )
   throws SessionException;

   public void changeObjectSecurity
      (
      /*in */  String objName,
      /*in*/   int objType,
      /*in*/   int newObjSecurity
      )
   throws SessionException;

   public void changePropertySecurity
      (
      /*in */  String objName,
      /*in*/   int objType,
      /*in*/   String propertyName,
      /*in*/   int   newPropertySecurity
      )

   throws SessionException;

   public void closeBindery ()

   throws SessionException;

   public void createObject
      (
      /*in */  String objName,
      /*in*/   int objType,
      /*in*/   int objFlags,
      /*in*/   int objSecurity
      )
   throws SessionException;

   public void createProperty
      (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   int      propertyFlags,
      /*in*/   int      propertySecurity
      )
   throws SessionException;
   public void deleteObject
      (
      /*in */  String objName,
      /*in*/   int objType
      )

   throws SessionException;

   public void deleteObjectFromSet
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   String   memberName,
      /*in*/   int      memberType
   )
   throws SessionException;

   public void deleteProperty
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName
   )

   throws SessionException;

   public void disallowObjectPassword
   (
      /*in */  String objName,
      /*in*/   int objType,
      /*in*/   String disallowedPassword
   )

   throws SessionException;

   public void getBinderyAccessLevel
   (
      /*out*/  IntegerBuffer accessLevel,
      /*out*/  IntegerBuffer objID
   )
   throws SessionException;

   public void getObjectDiskSpaceLeft
   (
      /*in*/   int   objID,
      /*out*/  IntegerBuffer systemElapsedTime,
      /*out*/  IntegerBuffer unusedDiskBlocks,
      /*out*/  IntegerBuffer restrictionEnforced
   )

   throws SessionException;

   public void getObjectID
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*out*/  IntegerBuffer  objID
   )
   throws SessionException;

   public void isObjectInSet
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   String   memberName,
      /*in*/   int      memberType
   )
   throws SessionException;

   public void openBindery()

   throws SessionException;

   public void readPropertyValue
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   int      segmentNum,
      /*out*/  byte[]  segmentData,
      /*out*/  IntegerBuffer   moreSegments,
      /*out*/  IntegerBuffer      flags
   )

   throws SessionException;

   public void renameObject
   (
      /*in */  String oldObjName,
      /*in*/   String newObjName,
      /*in*/   int objType
   )
   throws SessionException;

   public void scanObject
   (
      /*in*/      String searchName,
      /*in*/      int searchType,
      /*out*/     IntegerBuffer objID,              // optional
      /*out*/     StringBuffer objName,             // optional
      /*out*/     IntegerBuffer objType,            // optional
      /*out*/     IntegerBuffer hasPropertiesFlag,  // optional
      /*out*/     IntegerBuffer objFlags,           // optional
      /*out*/     IntegerBuffer objSecurity         // optional
   )

   // the rights are not returned through this API because the NCP does
   //   not support the rights because it was written for the 2.x rights
   //   scheme.  To get a valid rights mask for the path, call the
   //   NWScanForTrustees method in this class.
   throws SessionException;
   public void scanProperty
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   searchPropertyName,
      /*out*/  IntegerBuffer   iterHandle,
      /*out*/  StringBuffer      propertyName,
      /*out*/  IntegerBuffer      propertyFlags,
      /*out*/  IntegerBuffer      propertySecurity,
      /*out*/  IntegerBuffer      valueAvailable,
      /*out*/  IntegerBuffer      moreFlag
   )
   throws SessionException;

   public void writePropertyValue
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   int      segmentNum,
      /*in*/   byte[]  segmentData, //128 byte buffer.
      /*in*/   boolean  moreSegments
   )
   throws SessionException;

   public void getNSEntryInfo
   (
      int dirHandle,
      String path,
      int srcNamSpc,
      int dstNamSpc,
      int attributes,
      int retInfoMask,
      DirectoryEntryInfoImpl entryInfo
   )
   throws SessionException;

   public void scanNSEntryInfo
   (
      int dirHandle,
      int nameSpace,
      int attr,
      int[] volNumber,
      int[] dirNumber,
      int[] searchDirNumber,
      String pattern,
      int retInfoMask,
      DirectoryEntryInfoImpl entryInfo
   )
   throws SessionException;

   public void getVolumeName
   (
      int volNumber,
      String[] volName  // return a new string in first element
   )
   throws SessionException;

   public void getVolumeNumber
   (
      String volName,
      int[] volNumber   // return vol number in first element
   )
   throws SessionException;

   public void getNSLoadedList
   (
      int volNumber,
      int[][] NSLoadedList // return new int array in first element
   )
   throws SessionException;

   public void openCreateNSEntry
   (
      int dirHandle,
      String path,
      int nameSpace,
      int openCreateMode,
      int searchSessionAttrSet,
      int createSessionAttrSet,
      int accessRights,
      int[] fileHandle
   )
   throws SessionException;

   public void openNSEntry
   (
      int dirHandle,
      int nameSpace,
      int dataStream,
      String path,
      int openCreateMode,
      int searchSessionAttrSet,
      int createSessionAttrSet,
      int accessRights,
      int[] fileHandle
   )
   throws SessionException;

   public void deleteNSEntry
   (
      int dirHandle,
      String filePath,
      int nameSpace,
      int searchAttr
   )
   throws SessionException;

   public void NSRename
   (
      int dirHandle,
      int nameSpace,
      String oldName,
      boolean isFile,
      String newName,
      boolean renameInAllNS
   )
   throws SessionException;

   public void openEA
   (
      int dirHandle,
      String path,
      String EAName,
      int nameSpace,
      int EAHandle
   )
   throws SessionException;

   public void closeEA
   (
      int EAHandle
   )
   throws SessionException;

   public void readEA
   (
      int EAHandle,
      byte[] buf,
      int off,
      int len,
      int[] totalEASize,
      int[] bytesRead
   )
   throws SessionException;

   public void writeEA
   (
      int EAHandle,
      int totalWriteSize,
      byte[] buf,
      int off,
      int len,
      int[] bytesWritten
   )
   throws SessionException;

   public void findFirstEA
   (
      int dirHandle,
      String path,
      int dstNamSpc,
      int EAFFStruct,
      int EAHandle,
      StringBuffer EAName
   )
   throws SessionException;

   public void findNextEA
   (
      int EAFFStruct,
      int EAHandle,
      StringBuffer EAName
   )
   throws SessionException;

   // assumes that there are already 100 elements allocated in the
   //   'trusteeList' member of 'tEnum'
   public void scanForTrustees
   (
      int dirHandle,
      String path,
      int nameSpace,
      TrusteeEnumeratorImpl tEnum
   )
   throws SessionException;

   public void getDirSpaceLimitList
   (
      int dirHandle,
      String path,
      int nameSpace,
      int[] maxAvailable,
      int[] currentUse
   )
   throws SessionException;

   public void setDirSpaceLimit
   (
      int dirHandle,
      String path,
      int nameSpace,
      int limit
   )
   throws SessionException;

   public void setCompressedFileSize
   (
      int OSFileHandle,
      int desiredSize,
      int[] actualSize
   )
   throws SessionException;

   public void addTrustee
   (
      int dirHandle,
      String path,
      int nameSpace,
      int objID,
      int rightsMask
   )
   throws SessionException;

   public void deleteTrustee
   (
      int dirHandle,
      String path,
      int nameSpace,
      int objID
   )
   throws SessionException;

   public void getNSInfo
   (
      int volume,
      int nameSpace
//      NSInformation info
   )
   throws SessionException;

   // the 'data' array must be 512 bytes long
   public void readNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int NSInfoBitMask,
      byte[] data      // output parameter
   )
   throws SessionException;

   // the 'data' array must be 512 bytes long
   public void writeNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int NSInfoBitMask,
      byte[] data      // input parameter
   )
   throws SessionException;

   // the 'hugeData' array must be big enough to hold any huge data that the
   //   server may choose to send -- it's not doc'd in the NCP doc how big
   // the 'hugeStateInfo' is a 16-byte iter handle
   public void readExtendedNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int extendedBitMask,
      byte[] hugeStateInfo,
      int[] hugeDataLength,   // output parameter
      byte[] hugeData         // output parameter
   )
   throws SessionException;
   
   // the 'hugeStateInfo' is a 16-byte iter handle
   // when this function returns, 'hugeDataLength' will contain an int
   //   that is returned from the server specifying how much of the huge
   //   data was consumed by the name space module
   public void writeExtendedNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int extendedBitMask,
      byte[] hugeStateInfo,
      int[] hugeDataLength,   // input/output parameter
      byte[] hugeData,        // input parameter
      int offset
   )
   throws SessionException;

   // the C code underneath really uses the MODIFY_DOS_INFO struct
   //   we're just passing in a DirectoryEntryInfoImpl, because it has
   //   all the information in it that we need.
   // the modifyMask that we pass in here is passed straight to the lib,
   //   and does NOT correspond with the IM_... constants.
   public void setNSEntryDOSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int searchAttr,
      int modifyMask,
      DirectoryEntryInformation info
   )
   throws SessionException;

   public void getVolumeInfoWithNumber
   (
      int volNumber,
      VolumeInformation info
   )
   throws SessionException;

   public void getExtendedVolumeInfo
   (
      int volNumber,
      VolumeInformation info
   )
   throws SessionException;

   public void getDirSpaceInfo
   (
      int volNumber,
      String path,
      int nameSpace,
      DirectorySpaceInformation info
   )
   throws SessionException;

   public void getDiskUtilization
   (
      int objID,
      int volNum,
      VolumeUtilization data
   )
   throws SessionException;

   public void getObjDiskRestrictions
   (
      int volNumber,
      int objectId,
      VolumeRestriction data
   )
   throws SessionException;

   public void scanVolDiskRestrictions2
   (
      int volNumber,
      VolumeRestrictionEnumeratorImpl data
   )
   throws SessionException;

   public void removeObjectDiskRestrictions
   (
      int volNumber,
      int objectId
   )
   throws SessionException;

   public void setObjectVolSpaceLimit
   (
      int volNumber,
      int objectId,
      int restriction
   )
   throws SessionException;

   public void smMountVolume
   (
      String volName,
      int[] volNumber
   )
   throws SessionException;

   public void smDismountVolumeByName
   (
      String volName
   )
   throws SessionException;

   public void scanMountedVolumes
   (
      int startVolNumber,
      int[][] numbers,
      String[][] names,    // return new array of vol names in first elem.
      int[] nextVolNumber  // return next vol number in first element
   )
   throws SessionException;

   public void allocTempNSDirHandle
   (
      int dirHandle,
      String path,
      int srcNameSpace,
      int dstNameSpace,
      int[] newDirHandle
   )
   throws SessionException;

   public void deallocateDirectoryHandle
   (
      int dirHandle
   )
   throws SessionException;

   public void scanForDeletedFiles
   (
      int dirHandle,
      int[] iterHandle,
      int[] volNum,
      int[] dirBase,
      DeletedFileInfoImpl info
   )
   throws SessionException;

   public void purgeDeletedFile
   (
      int dirHandle,
      int iterHandle,
      int volNum,
      int dirBase,
      String delFileName
   )
   throws SessionException;

   //
   // does not support the 2.x variant of NWRecoverDeletedFile
   //

   public void recoverDeletedFile
   (
      int dirHandle,
      int iterHandle,
      int volNum,
      int dirBase,
      String delFileName,
      String newFileName
   )
   throws SessionException;

   public void getEffectiveRights
   (
      int dirHandle,
      String path,
      int nameSpace,
      int[] effectiveRights
   )
   throws SessionException;

   public void getObjectEffectiveRights
   (
      int objID,
      int dirHandle,
      String path,
      int nameSpace,
      int[] rights
   )
   throws SessionException;

   public void scanObjectTrusteePaths
   (
      int objID,
      int volNumber,
      int nameSpace,
      int[] iterHandle,
      int[] rights,
      String[] path
   )
   throws SessionException;

   // NCP Extension methods ===================================================
   public void getNCPExtensionInfoByName
      (
      /*out*/  NCPExtensionInfoImpl   extension
      )

   throws SessionException;

   public void ncpExtensionRequest
      (
      /*in*/   int      extensionID,
      /*in*/   byte[]   request,
      /*in*/   short    maxReplyLength,
      /*out*/  Object[] replyHolder   //replyHolder is a one element array
      )
   throws SessionException;

   public NCPExtensionInfoImpl scanNCPExtensions
      (
      NCPExtensionInfoImpl   extension
      )
   throws SessionException;

   // QMS methods ============================================================
   public void abortServicingQueueJob2 (
         int   QueueID,
         int   JobNumber,
         int   fileHandle)
      throws SessionException;

   public void attachQueueServerToQueue (
         int   queueID)
      throws SessionException;

   public void changeQueueJobEntry2 (
         int         queueID,
         NWQueueJob  job)
      throws SessionException;

   public void changeQueueJobPosition2 (
         int queueID,
         int jobNumber,
         int newJobPos)
      throws SessionException;

   public void changeToClientRights2 (
         int   queueID,
         int   jobNumber)
      throws SessionException;

   public void closeFileAndAbortQueueJob2 (
         int   queueID,
         int   jobNumber,
         int   fileHandle)
      throws SessionException;

   public void closeFileAndStartQueueJob2 (
         int   queueID,
         int   jobNumber,
         int   fileHandle)
      throws SessionException;

   public void createQueue (
         String         queueName,
         int            queueType,
         int            dirPath,
         String         path,
         IntegerBuffer  queueID)
      throws SessionException;

   public void createQueueFile2 (
         int            queueID,
         NWQueueJob     job,
         IntegerBuffer  fileHandle)
      throws SessionException;

   public void destroyQueue (
         int queueID)
      throws SessionException;

   public void detachQueueServerFromQueue (
         int   queueID)
      throws SessionException;

   public void finishServicingQueueJob2 (
         int   queueID,
         int   jobNumber,
         int   fileHandle)
      throws SessionException;

   // NWGetPrinterQueueID() is not supported
   
   public void getQueueJobFileSize2 (
         int queueID,
         int jobNumber,
         IntegerBuffer fileSize)
      throws SessionException;

   public void getQueueJobList2 (
         int               queueID,
         int               queueStartPos,
         QueueJobListReply job)
      throws SessionException;

   public void readQueueCurrentStatus2 (
         /*in*/   int            queueID,
         /*out*/  IntegerBuffer  queueStatus,
         /*out*/  IntegerBuffer  numberOfJobs,
         /*out*/  IntegerBuffer  numberOfServers,
         /*out*/  int[]          serverIDlist,
         /*out*/  int[]          serverConnList)
      throws SessionException;

   public void readQueueJobEntry2 (
         int               queueID,
         int               jobNumber,
         NWQueueJob        job)
      throws SessionException;

   // NWReadQueueServerCurrentStatus2() is not supported
   
   public void removeJobFromQueue2 (
         int queueID,
         int jobNumber)
      throws SessionException;

   // NWRestoreQueueServerRights() is not supported
   
   public void serviceQueueJob2 (
         int   queueID,
         int   targetJobType,
         NWQueueJob job,
         IntegerBuffer fileHandle)
      throws SessionException;

   public void setQueueCurrentStatus2 (
         /*in*/   int queueID,
         /*in*/   int queueStatus)
      throws SessionException;

   // NWSetQueueServerCurrentStatus() is not supported

   // Server natives =========================================================
   public void getFileServerVersionInfo
      (
      CVersionInfo info
      )
   throws SessionException;

   public void getFileServerInfo
      (
      CNWFSEFileServerInfo info
      )
   throws SessionException;

   public void getFileServerLoginStatus
      (
      BooleanBuffer info
      )
   throws SessionException;

   public void loadNLM(String loadCommand)
   throws SessionException;

   public void unloadNLM(String NLMName)
   throws SessionException;

   public void openSemaphore(
      String semaphoreName,
      int resourceAccessCount,
      int[] semaphoreHandle,
      int[] semaphoreOpenCount)
      throws SessionException;

   public void examineSemaphore(
      int semaphoreHandle,
      int[] semaphoreValue,
      int[] semaphoreOpenCount)
      throws SessionException;

   public void waitOnSemaphore(int semaphoreHandle, int timeOutValue)
   throws SessionException;

   public void signalSemaphore(int semaphoreHandle)
   throws SessionException;

   public void closeSemaphore(int semaphoreHandle)
   throws SessionException;

   public void getFileServerDescription
      (
      StringBuffer companyName,
      StringBuffer revision,
      StringBuffer revisionDate,
      StringBuffer copyrightNotice
      )
   throws SessionException;

   public void getFileServerDateAndTime
      (
      Object[] holder //holder is a one element array
      )
   throws SessionException;

   public void setFileServerDateAndTime
      (
      int year,
      int month,
      int day,
      int hour,
      int minute,
      int second
      )
   throws SessionException;
}
