/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/session/xplat/CallsServiceImpl.java $
  $Revision: 23 $
  $Modtime: 1/28/04 4:13p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import com.novell.service.jncpv2.cal.*;
import com.novell.service.session.*;
import com.novell.service.session.util.Debug;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncp.NSIExceptionBuilder;
import com.novell.java.lang.IntegerBuffer;
import com.novell.java.lang.BooleanBuffer;
import com.novell.service.file.nw.*;
import com.novell.service.server.*;
import com.novell.service.ncpext.*;
import com.novell.service.file.nw.calls.*;
import com.novell.service.qms.*;

/** @internal
 * Object returned by Session.getService() that wraps all NWCALLS
 * native services (via CalJNI).
 */
public class CallsServiceImpl
implements CallsService
{
   // Always access debug via final static...hopefully a final static of
   // false will be optimized out by the compiler
   final static private boolean DEBUG = false;
   final static private boolean S_DEBUG = false; // May have side effects

   Connection conn;
   int connection;

   public CallsServiceImpl
   (
      Connection connection
   )
   throws SessionException
   {
      conn = connection;
      this.connection = conn.getHandle(); //NOTE:this needs to be fixed
   }

   public boolean areSLPCallsAvailable()
   throws NSIException
   {
      return CalJNI.areSLPCallsAvailable();
   }

   public void getObjectNamesBeginA
   (
      int type,
      IntegerBuffer handle
   )
   throws NSIException
   {
      int ccode = CalJNI.NWGetObjectNamesBeginA(type, handle);
      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void getObjectNamesNextA
   (
      IntegerBuffer handle,
      IntegerBuffer bufLen,
      StringBuffer buf
   )
   throws NSIException
   {
      int ccode = CalJNI.NWGetObjectNamesNextA(handle, bufLen, buf);
      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void getObjectNamesEndA
   (
      IntegerBuffer handle
   )
   throws NSIException
   {
      int ccode = CalJNI.NWGetObjectNamesEndA(handle);
      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public String getObjectName
   (
      int objectId,
      IntegerBuffer type
   )
   throws SessionException
   {
      StringBuffer name = new StringBuffer();
      int ccode = CalJNI.NWGetObjectName(connection, objectId, name, type);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
      return name.toString();
   }

   public void freePtr(int mallocedPtr)
   throws SessionException
   {
      CalJNI.freePtr(mallocedPtr);
   }

   public int allocEAHandle()
   throws SessionException
   {
      return CalJNI.allocEAHandle();
   }

   public int allocEAFFStruct()
   throws SessionException
   {
      return CalJNI.allocEAFFStruct();
   }

   public void addObjectToSet
      (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   String   memberName,
      /*in*/   int      memberType
      )
   throws SessionException
   {
      int ccode = CalJNI.NWAddObjectToSet(
                                         this.connection,
                                         objName,
                                         objType,
                                         propertyName,
                                         memberName,
                                         memberType);

      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void changeObjectSecurity
      (
      /*in */  String objName,
      /*in*/   int objType,
      /*in*/   int newObjSecurity
      )
   throws SessionException
   {
      int ccode = CalJNI.NWChangeObjectSecurity(
                                               this.connection,
                                               objName,
                                               objType,
                                               newObjSecurity);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void changePropertySecurity
      (
      /*in */  String objName,
      /*in*/   int objType,
      /*in*/   String propertyName,
      /*in*/   int   newPropertySecurity
      )

   throws SessionException
   {
      int ccode = CalJNI.NWChangePropertySecurity(
                                                 this.connection,
      /*in */  objName,
      /*in*/   objType,
      /*in*/   propertyName,
      /*in*/   newPropertySecurity);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void closeBindery ()

   throws SessionException
   {
      int ccode = CalJNI.NWCloseBindery(this.connection);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void createObject
      (
      /*in */  String objName,
      /*in*/   int objType,
      /*in*/   int objFlags,
      /*in*/   int objSecurity
      )
   throws SessionException
   {
      int ccode = CalJNI.NWCreateObject (
                                        this.connection,
                                        objName,
                                        objType,
                                        objFlags,
                                        objSecurity);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void createProperty
      (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   int      propertyFlags,
      /*in*/   int      propertySecurity
      )
   throws SessionException
   {
      int ccode = CalJNI.NWCreateProperty (
                                          this.connection,
                                          objName,
                                          objType,
                                          propertyName,
                                          propertyFlags,
                                          propertySecurity);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }
   public void deleteObject
      (
      /*in */  String objName,
      /*in*/   int objType
      )

   throws SessionException
   {
      int ccode = CalJNI.NWDeleteObject(
                                       this.connection,
                                       objName,
                                       objType);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void deleteObjectFromSet
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   String   memberName,
      /*in*/   int      memberType
   )
   throws SessionException
   {
      int ccode = CalJNI.NWDeleteObjectFromSet (
                                               this.connection,
                                               objName,
                                               objType,
                                               propertyName,
                                               memberName,
                                               memberType);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void deleteProperty
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName
   )

   throws SessionException
   {
      int ccode = CalJNI.NWDeleteProperty (
                                          this.connection,
                                          objName,
                                          objType,
                                          propertyName);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void disallowObjectPassword
   (
      /*in */  String objName,
      /*in*/   int objType,
      /*in*/   String disallowedPassword
   )

   throws SessionException
   {
      int ccode = CalJNI.NWDisallowObjectPassword (
                                                  this.connection,
                                                  objName,
                                                  objType,
                                                  disallowedPassword);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void getBinderyAccessLevel
   (
      /*out*/  IntegerBuffer accessLevel,
      /*out*/  IntegerBuffer objID
   )
   throws SessionException
   {
      int ccode = CalJNI.NWGetBinderyAccessLevel (
                                                 this.connection,
                                                 accessLevel,
                                                 objID);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void getObjectDiskSpaceLeft
   (
      /*in*/   int   objID,
      /*out*/  IntegerBuffer systemElapsedTime,
      /*out*/  IntegerBuffer unusedDiskBlocks,
      /*out*/  IntegerBuffer restrictionEnforced
   )

   throws SessionException
   {
      int ccode = CalJNI. NWGetObjectDiskSpaceLeft (
                                                   this.connection,
                                                   objID,
                                                   systemElapsedTime,
                                                   unusedDiskBlocks,
                                                   restrictionEnforced);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void getObjectID
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*out*/  IntegerBuffer  objID
   )
   throws SessionException
   {
      int ccode = CalJNI.NWGetObjectID (
                                       this.connection,
                                       objName,
                                       objType,
                                       objID);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void isObjectInSet
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   String   memberName,
      /*in*/   int      memberType
   )
   throws SessionException
   {
      int ccode = CalJNI.NWIsObjectInSet (
                                         this.connection,
                                         objName,
                                         objType,
                                         propertyName,
                                         memberName,
                                         memberType);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void openBindery()

   throws SessionException
   {
      int ccode = CalJNI.NWOpenBindery(this.connection);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void readPropertyValue
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   int      segmentNum,
      /*out*/  byte[]  segmentData,
      /*out*/  IntegerBuffer   moreSegments,
      /*out*/  IntegerBuffer      flags
   )

   throws SessionException
   {
      int ccode = CalJNI.NWReadPropertyValue(
                                            this.connection,
                                            objName,
                                            objType,
                                            propertyName,
                                            segmentNum,
                                            segmentData,
                                            moreSegments,
                                            flags);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void renameObject
   (
      /*in */  String oldObjName,
      /*in*/   String newObjName,
      /*in*/   int objType
   )
   throws SessionException
   {
      int ccode = CalJNI.NWRenameObject(
                                       this.connection,
                                       oldObjName,
                                       newObjName,
                                       objType);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void scanObject
   (
      /*in*/      String searchName,
      /*in*/      int searchType,
      /*out*/     IntegerBuffer objID,              // optional
      /*out*/     StringBuffer objName,             // optional
      /*out*/     IntegerBuffer objType,            // optional
      /*out*/     IntegerBuffer hasPropertiesFlag,  // optional
      /*out*/     IntegerBuffer objFlags,           // optional
      /*out*/     IntegerBuffer objSecurity         // optional
   )

   // the rights are not returned through this API because the NCP does
   //   not support the rights because it was written for the 2.x rights
   //   scheme.  To get a valid rights mask for the path, call the
   //   NWScanForTrustees method in this class.
   throws SessionException
   {
      int ccode = CalJNI.NWScanObject(
                                     this.connection,
                                     searchName,
                                     searchType,
                                     objID,
                                     objName,
                                     objType,
                                     hasPropertiesFlag,
                                     objFlags,
                                     objSecurity);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void scanProperty
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   searchPropertyName,
      /*out*/  IntegerBuffer   iterHandle,
      /*out*/  StringBuffer      propertyName,
      /*out*/  IntegerBuffer      propertyFlags,
      /*out*/  IntegerBuffer      propertySecurity,
      /*out*/  IntegerBuffer      valueAvailable,
      /*out*/  IntegerBuffer      moreFlag
   )
   throws SessionException
   {
      int ccode = CalJNI.NWScanProperty(
                                       this.connection,
                                       objName,
                                       objType,
                                       searchPropertyName,
                                       iterHandle,
                                       propertyName,
                                       propertyFlags,
                                       propertySecurity,
                                       valueAvailable,
                                       moreFlag);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void writePropertyValue
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   int      segmentNum,
      /*in*/   byte[]  segmentData, //128 byte buffer.
      /*in*/   boolean  moreSegments
   )
   throws SessionException
   {
      int ccode = CalJNI.NWWritePropertyValue(
                                             this.connection,
                                             objName,
                                             objType,
                                             propertyName,
                                             segmentNum,
                                             segmentData, //128 byte bu
                                             moreSegments);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void getNSEntryInfo
   (
      int dirHandle,
      String path,
      int srcNamSpc,
      int dstNamSpc,
      int attributes,
      int retInfoMask,
      DirectoryEntryInfoImpl entryInfo
   )
   throws SessionException
   {
      int ccode = CalJNI.NWGetNSEntryInfo(
                                         this.connection,
                                         dirHandle,
                                         path,
                                         srcNamSpc,
                                         dstNamSpc,
                                         attributes,
                                         retInfoMask,
                                         entryInfo);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void scanNSEntryInfo
   (
      int dirHandle,
      int nameSpace,
      int attr,
      int[] volNumber,
      int[] dirNumber,
      int[] searchDirNumber,
      String pattern,
      int retInfoMask,
      DirectoryEntryInfoImpl entryInfo
   )
   throws SessionException
   {
      int ccode = CalJNI.NWScanNSEntryInfo(
                                          this.connection,
                                          dirHandle,
                                          nameSpace,
                                          attr,
                                          volNumber,
                                          dirNumber,
                                          searchDirNumber,
                                          pattern,
                                          retInfoMask,
                                          entryInfo);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void getVolumeName
   (
      int volNumber,
      String[] volName  // return a new string in first element
   )
   throws SessionException
   {
      int ccode = CalJNI.NWGetVolumeName(
                                        this.connection,
                                        volNumber,
                                        volName);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void getVolumeNumber
   (
      String volName,
      int[] volNumber   // return vol number in first element
   )
   throws SessionException
   {
      int ccode = CalJNI.NWGetVolumeNumber(
                                          this.connection,
                                          volName,
                                          volNumber);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void getNSLoadedList
   (
      int volNumber,
      int[][] NSLoadedList // return new int array in first element
   )
   throws SessionException
   {
      int ccode = CalJNI.NWGetNSLoadedList(
                                          this.connection,
                                          volNumber,
                                          NSLoadedList);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void openCreateNSEntry
   (
      int dirHandle,
      String path,
      int nameSpace,
      int openCreateMode,
      int searchSessionAttrSet,
      int createSessionAttrSet,
      int accessRights,
      int[] fileHandle
   )
   throws SessionException
   {
      int ccode = CalJNI.NWOpenCreateNSEntry(
                                            this.connection,
                                            dirHandle,
                                            path,
                                            nameSpace,
                                            openCreateMode,
                                            searchSessionAttrSet,
                                            createSessionAttrSet,
                                            accessRights,
                                            fileHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void openNSEntry
   (
      int dirHandle,
      int nameSpace,
      int dataStream,
      String path,
      int openCreateMode,
      int searchSessionAttrSet,
      int createSessionAttrSet,
      int accessRights,
      int[] fileHandle
   )
   throws SessionException
   {
      int ccode = CalJNI.NWOpenNSEntry(
                                      this.connection,
                                      dirHandle,
                                      nameSpace,
                                      dataStream,
                                      path,
                                      openCreateMode,
                                      searchSessionAttrSet,
                                      createSessionAttrSet,
                                      accessRights,
                                      fileHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void deleteNSEntry
   (
      int dirHandle,
      String filePath,
      int nameSpace,
      int searchAttr
   )

   throws SessionException
   {
      int ccode = CalJNI.NWDeleteNSEntry(
                                        this.connection,
                                        dirHandle,
                                        filePath,
                                        nameSpace,
                                        searchAttr);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void NSRename
   (
      int dirHandle,
      int nameSpace,
      String oldName,
      boolean isFile,
      String newName,
      boolean renameInAllNS
   )

   throws SessionException
   {
      int ccode = CalJNI.NWNSRename(
                                   this.connection,
                                   dirHandle,
                                   nameSpace,
                                   oldName,
                                   isFile,
                                   newName,
                                   renameInAllNS);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void openEA
   (
      int dirHandle,
      String path,
      String EAName,
      int nameSpace,
      int EAHandle
   )

   throws SessionException
   {
      int ccode = CalJNI.NWOpenEA(
                                 this.connection,
                                 dirHandle,
                                 path,
                                 EAName,
                                 nameSpace,
                                 EAHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void closeEA
   (
      int EAHandle
   )
   throws SessionException
   {
      int ccode = CalJNI.NWCloseEA(EAHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void readEA
   (
      int EAHandle,
      byte[] buf,
      int off,
      int len,
      int[] totalEASize,
      int[] bytesRead
   )
   throws SessionException
   {
      int ccode = CalJNI.NWReadEA(
                                 EAHandle,
                                 buf,
                                 off,
                                 len,
                                 totalEASize,
                                 bytesRead);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void writeEA
   (
      int EAHandle,
      int totalWriteSize,
      byte[] buf,
      int off,
      int len,
      int[] bytesWritten
   )
   throws SessionException
   {
      int ccode = CalJNI.NWWriteEA(
                                  EAHandle,
                                  totalWriteSize,
                                  buf,
                                  off,
                                  len,
                                  bytesWritten);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void findFirstEA
   (
      int dirHandle,
      String path,
      int dstNamSpc,
      int EAFFStruct,
      int EAHandle,
      StringBuffer EAName
   )
   throws SessionException
   {
      int ccode = CalJNI.NWFindFirstEA(
                                      this.connection,
                                      dirHandle,
                                      path,
                                      dstNamSpc,
                                      EAFFStruct,
                                      EAHandle,
                                      EAName);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void findNextEA
   (
      int EAFFStruct,
      int EAHandle,
      StringBuffer EAName
   )
   throws SessionException
   {
      int ccode = CalJNI.NWFindNextEA(
                                     EAFFStruct,
                                     EAHandle,
                                     EAName);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   // assumes that there are already 100 elements allocated in the
   //   'trusteeList' member of 'tEnum'
   public void scanForTrustees
   (
      int dirHandle,
      String path,
      int nameSpace,
      TrusteeEnumeratorImpl tEnum
   )
   throws SessionException
   {
      int ccode = CalJNI.NWScanForTrustees(
                                          this.connection,
                                          dirHandle,
                                          path,
                                          nameSpace,
                                          tEnum);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void getDirSpaceLimitList
   (
      int dirHandle,
      String path,
      int nameSpace,
      int[] maxAvailable,
      int[] currentUse
   )
   throws SessionException
   {
      int ccode = CalJNI.NWGetDirSpaceLimitList(
                                               this.connection,
                                               dirHandle,
                                               path,
                                               nameSpace,
                                               maxAvailable,
                                               currentUse);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void setDirSpaceLimit
   (
      int dirHandle,
      String path,
      int nameSpace,
      int limit
   )
   throws SessionException
   {
      int ccode = CalJNI.NWSetDirSpaceLimit(
                                           this.connection,
                                           dirHandle,
                                           path,
                                           nameSpace,
                                           limit);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void setCompressedFileSize
   (
      int OSFileHandle,
      int desiredSize,
      int[] actualSize
   )
   throws SessionException
   {
      int ccode = CalJNI.NWSetCompressedFileSize(
                                                this.connection,
                                                OSFileHandle,
                                                desiredSize,
                                                actualSize);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void addTrustee
   (
      int dirHandle,
      String path,
      int nameSpace,
      int objID,
      int rightsMask
   )
   throws SessionException
   {
      int ccode = CalJNI.NWAddTrustee(
                                     this.connection,
                                     dirHandle,
                                     path,
                                     nameSpace,
                                     objID,
                                     rightsMask);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void deleteTrustee
   (
      int dirHandle,
      String path,
      int nameSpace,
      int objID
   )
   throws SessionException
   {
      int ccode = CalJNI.NWDeleteTrustee(
                                        this.connection,
                                        dirHandle,
                                        path,
                                        nameSpace,
                                        objID);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void getNSInfo
   (
      int volume,
      int nameSpace
//      NSInformation info
   )
   throws SessionException
   {
/*
      int ccode = CalJNI.NWGetNSInfo(
                                    this.connection,
                                    volume,
                                    nameSpace,
                                    info);
      if (0!= ccode)
*/
      int ccode = 0;
         throw NSIExceptionBuilder.build(ccode);
   }

   // the 'data' array must be 512 bytes long
   public void readNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int NSInfoBitMask,
      byte[] data      // output parameter
   )
   // the 'data' array must be 512 bytes long
   throws SessionException
   {
      int ccode = CalJNI.NWReadNSInfo(
                                     this.connection,
                                     dirHandle,
                                     path,
                                     nameSpace,
                                     dstNameSpace,
                                     NSInfoBitMask,
                                     data);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void writeNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int NSInfoBitMask,
      byte[] data      // input parameter
   )
   throws SessionException
   {
      int ccode = CalJNI.NWWriteNSInfo(
                                      this.connection,
                                      dirHandle,
                                      path,
                                      nameSpace,
                                      dstNameSpace,
                                      NSInfoBitMask,
                                      data);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   // the 'hugeData' array must be big enough to hold any huge data that the
   //   server may choose to send -- it's not doc'd in the NCP doc how big
   // the 'hugeStateInfo' is a 16-byte iter handle
   public void readExtendedNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int extendedBitMask,
      byte[] hugeStateInfo,
      int[] hugeDataLength,   // output parameter
      byte[] hugeData         // output parameter
   )
   throws SessionException
   {
      int ccode = CalJNI.NWReadExtendedNSInfo(
                                             this.connection,
                                             dirHandle,
                                             path,
                                             nameSpace,
                                             dstNameSpace,
                                             extendedBitMask,
                                             hugeStateInfo,
                                             hugeDataLength,   // output paramete
                                             hugeData );        // output paramete


      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   // the 'hugeStateInfo' is a 16-byte iter handle
   // when this function returns, 'hugeDataLength' will contain an int
   //   that is returned from the server specifying how much of the huge
   //   data was consumed by the name space module
   public void writeExtendedNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int extendedBitMask,
      byte[] hugeStateInfo,
      int[] hugeDataLength,   // input/output parameter
      byte[] hugeData,        // input parameter
      int offset
   )
   throws SessionException
   {
      int ccode = CalJNI.NWWriteExtendedNSInfo(
                                              this.connection,
                                              dirHandle,
                                              path,
                                              nameSpace,
                                              dstNameSpace,
                                              extendedBitMask,
                                              hugeStateInfo,
                                              hugeDataLength,
                                              hugeData,
                                              offset);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   // the C code underneath really uses the MODIFY_DOS_INFO struct
   //   we're just passing in a DirectoryEntryInfoImpl, because it has
   //   all the information in it that we need.
   // the modifyMask that we pass in here is passed straight to the lib,
   //   and does NOT correspond with the IM_... constants.
   public void setNSEntryDOSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int searchAttr,
      int modifyMask,
      DirectoryEntryInformation info
   )
   throws SessionException
   {
      int ccode = CalJNI.NWSetNSEntryDOSInfo(
                                            this.connection,
                                            dirHandle,
                                            path,
                                            nameSpace,
                                            searchAttr,
                                            modifyMask,
                                            info);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void getVolumeInfoWithNumber
   (
      int volNumber,
      VolumeInformation info
   )
   throws SessionException
   {
      int ccode = CalJNI.NWGetVolumeInfoWithNumber(
                                                  this.connection,
                                                  volNumber,
                                                  info);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void getExtendedVolumeInfo
   (
      int volNumber,
      VolumeInformation info
   )
   throws SessionException
   {
      int ccode = CalJNI.NWGetExtendedVolumeInfo(
                                                this.connection,
                                                volNumber,
                                                info);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void getDirSpaceInfo
   (
      int volNumber,
      String path,
      int nameSpace,
      DirectorySpaceInformation info
   )
   throws SessionException
   {
      int ccode = CalJNI.NWGetDirSpaceInfo(
                                          this.connection,
                                          volNumber,
                                          path,
                                          nameSpace,
                                          info);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void getDiskUtilization
   (
      int objID,
      int volNum,
      VolumeUtilization data
   )
   throws SessionException
   {
      int ccode = CalJNI.NWGetDiskUtilization(
                                             this.connection,
                                             objID,
                                             volNum,
                                             data);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void getObjDiskRestrictions
   (
      int volNumber,
      int objectId,
      VolumeRestriction data
   )
   throws SessionException
   {
      int ccode = CalJNI.NWGetObjDiskRestrictions(
                                                 this.connection,
                                                 volNumber,
                                                 objectId,
                                                 data);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void scanVolDiskRestrictions2
   (
      int volNumber,
      VolumeRestrictionEnumeratorImpl data
   )
   throws SessionException
   {
      int ccode = CalJNI.NWScanVolDiskRestrictions2(
                                                   this.connection,
                                                   volNumber,
                                                   data);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void removeObjectDiskRestrictions
   (
      int volNumber,
      int objectId
   )
   throws SessionException
   {
      int ccode = CalJNI.NWRemoveObjectDiskRestrictions(
                                                       this.connection,
                                                       volNumber,
                                                       objectId);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void setObjectVolSpaceLimit
   (
      int volNumber,
      int objectId,
      int restriction
   )
   throws SessionException
   {
      int ccode = CalJNI.NWSetObjectVolSpaceLimit(
                                                 this.connection,
                                                 volNumber,
                                                 objectId,
                                                 restriction);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void smMountVolume
   (
      String volName,
      int[] volNumber
   )
   throws SessionException
   {
      int ccode = CalJNI.NWSMMountVolume(
                                        this.connection,
                                        volName,
                                        volNumber);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void smDismountVolumeByName
   (
      String volName
   )
   throws SessionException
   {
      int ccode = CalJNI.NWSMDismountVolumeByName(
                                                 this.connection,
                                                 volName);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void scanMountedVolumes
   (
      int startVolNumber,
      int[][] numbers,
      String[][] names,    // return new array of vol names in first elem.
      int[] nextVolNumber  // return next vol number in first element
   )
   throws SessionException
   {
      int ccode = CalJNI.NWScanMountedVolumes(
            this.connection,
            startVolNumber,
            numbers,
            names,
            nextVolNumber);

      if (ccode != 0)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void allocTempNSDirHandle
   (
      int dirHandle,
      String path,
      int srcNameSpace,
      int dstNameSpace,
      int[] newDirHandle
   )
   throws SessionException
   {
      int ccode = CalJNI.NWAllocTempNSDirHandle(
            this.connection,
            dirHandle,
            path,
            srcNameSpace,
            dstNameSpace,
            newDirHandle);

      if (ccode != 0)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void deallocateDirectoryHandle
   (
      int dirHandle
   )
   throws SessionException
   {
      int ccode = CalJNI.NWDeallocateDirectoryHandle(
            this.connection,
            dirHandle);

      if (ccode != 0)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void scanForDeletedFiles
   (
      int dirHandle,
      int[] iterHandle,
      int[] volNum,
      int[] dirBase,
      DeletedFileInfoImpl info
   )
   throws SessionException
   {
      int ccode = CalJNI.NWScanForDeletedFiles(
            this.connection,
            dirHandle,
            iterHandle,
            volNum,
            dirBase,
            info);

      if (ccode != 0)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void purgeDeletedFile
   (
      int dirHandle,
      int iterHandle,
      int volNum,
      int dirBase,
      String delFileName
   )
   throws SessionException
   {
      int ccode = CalJNI.NWPurgeDeletedFile(
            this.connection,
            dirHandle,
            iterHandle,
            volNum,
            dirBase,
            delFileName);

      if (ccode != 0)
         throw NSIExceptionBuilder.build(ccode);
   }

   //
   // does not support the 2.x variant of NWRecoverDeletedFile
   //

   public void recoverDeletedFile
   (
      int dirHandle,
      int iterHandle,
      int volNum,
      int dirBase,
      String delFileName,
      String newFileName
   )
   throws SessionException
   {
      int ccode = CalJNI.NWRecoverDeletedFile(
            this.connection,
            dirHandle,
            iterHandle,
            volNum,
            dirBase,
            delFileName,
            newFileName);

      if (ccode != 0)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void getEffectiveRights
   (
      int dirHandle,
      String path,
      int nameSpace,
      int[] effectiveRights
   )
   throws SessionException
   {
      int ccode = CalJNI.NWGetEffectiveRights(
            this.connection,
            dirHandle,
            path,
            nameSpace,
            effectiveRights);

      if (ccode != 0)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void getObjectEffectiveRights
   (
      int objID,
      int dirHandle,
      String path,
      int nameSpace,
      int[] rights
   )
   throws SessionException
   {
      int ccode = CalJNI.NWGetObjectEffectiveRights (
                                                    this.connection,
                                                    objID,
                                                    dirHandle,
                                                    path,
                                                    nameSpace,
                                                    rights);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void scanObjectTrusteePaths
   (
      int objID,
      int volNumber,
      int nameSpace,
      int[] iterHandle,
      int[] rights,
      String[] path
   )
   throws SessionException
   {
      int ccode = CalJNI.NWScanObjectTrusteePaths(
            this.connection,
            objID,
            volNumber,
            nameSpace,
            iterHandle,
            rights,
            path);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);

      String s = path[0].replace(':', '/');
      s = s.replace('\\', '/');

      path[0] = s;
   }

/* *************************************************************************
* NCP extension natives
****************************************************************************/

   public void getNCPExtensionInfoByName
      (
      /*out*/  NCPExtensionInfoImpl   extension
      )

   throws SessionException
   {
      int ccode = CalJNI.NWGetNCPExtensionInfoByName(
                                                    this.connection,
                                                    extension);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void ncpExtensionRequest
      (
      /*in*/   int      extensionID,
      /*in*/   byte[]   request,
      /*in*/   short    maxReplyLength,
      /*out*/  Object[] replyHolder   //replyHolder is a one element array
      )
   throws SessionException
   {
      int ccode = CalJNI.NWNCPExtensionRequest(
                                              this.connection,
                                              extensionID,
                                              request,
                                              maxReplyLength,
                                              replyHolder);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public NCPExtensionInfoImpl scanNCPExtensions
      (
      NCPExtensionInfoImpl   extension
      )
   throws SessionException
   {
      int ccode = CalJNI.NWScanNCPExtensions(
                                            this.connection,
                                            extension);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
      return(extension);
   }

   public void createQueueFile2
      (
      int            queueID,
      NWQueueJob     job,
      IntegerBuffer  fileHandle
      )

   throws SessionException
   {
      int ccode = CalJNI.NWCreateQueueFile2(
                                           this.connection,
                                           queueID,
                                           job,
                                           fileHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void closeFileAndAbortQueueJob2
      (
      int   queueID,
      int   jobNumber,
      int   fileHandle
      )

   throws SessionException
   {
      int ccode = CalJNI.NWCloseFileAndAbortQueueJob2(
                                                     this.connection,
                                                     queueID,
                                                     jobNumber,
                                                     fileHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void closeFileAndStartQueueJob2
      (
      int   queueID,
      int   jobNumber,
      int   fileHandle
      )

   throws SessionException
   {
      int ccode = CalJNI.NWCloseFileAndStartQueueJob2(
                                                     this.connection,
                                                     queueID,
                                                     jobNumber,
                                                     fileHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void abortServicingQueueJob2
      (
      int   QueueID,
      int   JobNumber,
      int   fileHandle
      )
   throws SessionException
   {
      int ccode = CalJNI.NWAbortServicingQueueJob2(
                                                  this.connection,
                                                  QueueID,
                                                  JobNumber,
                                                  fileHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void attachQueueServerToQueue
   (
      int   queueID
   )
   throws SessionException
   {
      int ccode = CalJNI.NWAttachQueueServerToQueue(
         this.connection, queueID);
      if(0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void changeQueueJobEntry2
      (
      int queueID,
      NWQueueJob   job
      )

   throws SessionException
   {
      int ccode = CalJNI.NWChangeQueueJobEntry2(
                                               this.connection,
                                               queueID,
                                               job);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void changeQueueJobPosition2
      (
      int queueID,
      int jobNumber,
      int newJobPos
      )

   throws SessionException
   {
      int ccode = CalJNI.NWChangeQueueJobPosition2(
                                                  this.connection,
                                                  queueID,
                                                  jobNumber,
                                                  newJobPos);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void changeToClientRights2
   (
      int   queueID,
      int   jobNumber
   )
   throws SessionException
   {
      int ccode = CalJNI.NWChangeToClientRights2(
         this.connection, queueID, jobNumber);
      if(0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void getQueueJobList2
      (
      int               queueID,
      int               queueStartPos,
      QueueJobListReply job
      )

   throws SessionException
   {
      int ccode = CalJNI.NWGetQueueJobList2(
                                           this.connection,
                                           queueID,
                                           queueStartPos,
                                           job);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

/*
   public void readQueueCurrentSessionAttrSet2
      (
      int queueID,
      IntegerBuffer queueSessionAttrSet,
      IntegerBuffer numberOfJobs,
      IntegerBuffer numberOfServers,
      int[] serverIDlist,
      int[] serverConnList
      )
   throws SessionException
   {
      int ccode = CalJNI.NWReadQueueCurrentSessionAttrSet2(
                                                  this.connection,
                                                  queueID,
                                                  queueSessionAttrSet,
                                                  numberOfJobs,
                                                  numberOfServers,
                                                  serverIDlist,
                                                  serverConnList);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }
*/

   public void readQueueCurrentStatus2 (
         /*in*/   int   queueID,
         /*out*/  IntegerBuffer queueStatus,
         /*out*/  IntegerBuffer numberOfJobs,
         /*out*/  IntegerBuffer numberOfServers,
         /*out*/  int[] serverIDlist,
         /*out*/  int[] serverConnList)
      throws SessionException
   {
      int ccode = CalJNI.NWReadQueueCurrentStatus2 (
                                             this.connection,
                                             queueID,
                                             queueStatus,
                                             numberOfJobs,
                                             numberOfServers,
                                             serverIDlist,
                                             serverConnList);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


   public void readQueueJobEntry2
      (
      int               queueID,
      int               jobNumber,
      NWQueueJob        job
      )

   throws SessionException
   {
      int ccode = CalJNI.NWReadQueueJobEntry2(
                                             this.connection,
                                             queueID,
                                             jobNumber,
                                             job);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void removeJobFromQueue2
      (
      int queueID,
      int jobNumber
      )

   throws SessionException
   {
      int ccode = CalJNI.NWRemoveJobFromQueue2(
                                              this.connection,
                                              queueID,
                                              jobNumber);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void serviceQueueJob2
   (
      int   queueID,
      int   targetJobType,
      NWQueueJob job,
      IntegerBuffer fileHandle
   )
   throws SessionException
   {
      int ccode = CalJNI.NWServiceQueueJob2(
         this.connection, queueID, targetJobType, job, fileHandle);
      if(0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

/*
   public void setQueueCurrentSessionAttrSet2
      (
      int queueID,
      int queueSessionAttrSet
      )
   throws SessionException
   {
      int ccode = CalJNI.NWSetQueueCurrentSessionAttrSet2(
                                                 this.connection,
                                                 queueID,
                                                 queueSessionAttrSet);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }
*/

   public void setQueueCurrentStatus2 (
         /*in*/   int queueID,
         /*in*/   int queueStatus)
      throws SessionException
   {
      int ccode = CalJNI.NWSetQueueCurrentStatus2(
                                      this.connection,
                                      queueID,
                                      queueStatus);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void createQueue
      (
      String   queueName,
      int      queueType,
      int      dirPath,
      String   path,
      IntegerBuffer queueID
      )
   throws SessionException
   {
      int ccode = CalJNI.NWCreateQueue(
                                      this.connection,
                                      queueName,
                                      queueType,
                                      dirPath,
                                      path,
                                      queueID);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void destroyQueue
      (
      int queueID
      )
   throws SessionException
   {
      int ccode = CalJNI.NWDestroyQueue(
                                       this.connection,
                                       queueID);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void detachQueueServerFromQueue
   (
      int   queueID
   )
   throws SessionException
   {
      int ccode = CalJNI.NWDetachQueueServerFromQueue(
         this.connection, queueID);
      if(0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void finishServicingQueueJob2
   (
      int   queueID,
      int   jobNumber,
      int   fileHandle
   )
   throws SessionException
   {
      int ccode = CalJNI.NWFinishServicingQueueJob2(
         this.connection, queueID, jobNumber, fileHandle);
      if(0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void getQueueJobFileSize2
      (
      int queueID,
      int jobNumber,
      IntegerBuffer fileSize
      )
   throws SessionException
   {
      int ccode = CalJNI.NWGetQueueJobFileSize2(
                                               this.connection,
                                               queueID,
                                               jobNumber,
                                               fileSize);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

/* *************************************************************************
* Server natives
****************************************************************************/
   public void getFileServerVersionInfo
      (
      CVersionInfo info
      )

   throws SessionException
   {
      int ccode = CalJNI.NWGetFileServerVersionInfo(
                                                   this.connection,
                                                   info);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void getFileServerInfo
      (
      CNWFSEFileServerInfo info
      )
   throws SessionException
   {
      int ccode = CalJNI.NWGetFileServerInfo(
                                            this.connection,
                                            info);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void getFileServerLoginStatus
      (
      BooleanBuffer info
      )
   throws SessionException
   {
      int ccode = CalJNI.NWGetFileServerLoginStatus(connection, info);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void loadNLM(String loadCommand)
   throws SessionException
   {
      int ccode = CalJNI.NWSMLoadNLM(connection, loadCommand);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void unloadNLM(String NLMName)
   throws SessionException
   {
      int ccode = CalJNI.NWSMUnloadNLM(connection, NLMName);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void openSemaphore(
      String semaphoreName,
      int resourceAccessCount,
      int[] semaphoreHandle,
      int[] semaphoreOpenCount)
      throws SessionException
   {
      int ccode = CalJNI.NWOpenSemaphore(
                     connection,
                     semaphoreName,
                     resourceAccessCount,
                     semaphoreHandle,
                     semaphoreOpenCount);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void examineSemaphore(
      int semaphoreHandle,
      int[] semaphoreValue,
      int[] semaphoreOpenCount)
      throws SessionException
   {
      int ccode = CalJNI.NWExamineSemaphore(
                     connection,
                     semaphoreHandle,
                     semaphoreValue,
                     semaphoreOpenCount);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void waitOnSemaphore(int semaphoreHandle, int timeOutValue)
   throws SessionException
   {
      int ccode = CalJNI.NWWaitOnSemaphore(
         connection,
         semaphoreHandle,
         timeOutValue);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void signalSemaphore(int semaphoreHandle)
   throws SessionException
   {
      int ccode = CalJNI.NWSignalSemaphore(connection, semaphoreHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void closeSemaphore(int semaphoreHandle)
   throws SessionException
   {
      int ccode = CalJNI.NWCloseSemaphore(connection, semaphoreHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void getFileServerDescription
      (
      StringBuffer companyName,
      StringBuffer revision,
      StringBuffer revisionDate,
      StringBuffer copyrightNotice
      )
   throws SessionException
   {
      int ccode = CalJNI.NWGetFileServerDescription(
                                                   this.connection,
                                                   companyName,
                                                   revision,
                                                   revisionDate,
                                                   copyrightNotice);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void getFileServerDateAndTime
      (
      Object[] holder //holder is a one element array
      )
   throws SessionException
   {
      int ccode = CalJNI.NWGetFileServerDateAndTime(
                                                   this.connection,
                                                   holder);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void setFileServerDateAndTime
      (
      int year,
      int month,
      int day,
      int hour,
      int minute,
      int second
      )
   throws SessionException
   {
      int ccode = CalJNI.NWSetFileServerDateAndTime(
                                                   this.connection,
                                                   year,
                                                   month,
                                                   day,
                                                   hour,
                                                   minute,
                                                   second);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }
}



