/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/session/xplat/ConnectionEnumerator.java $
  $Revision: 5 $
  $Modtime: 1/28/00 1:03p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import com.novell.service.session.util.Debug;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncp.NSIExceptionBuilder;
import com.novell.service.jncpv2.clx.ClxJNI;
import com.novell.service.jncpv2.cal.CalJNI;
import com.novell.service.jncpv2.net.NetJNI;
import com.novell.service.session.SessionAttr;
import com.novell.service.session.SessionAttrEnumerator;
import com.novell.service.session.SessionAttrs;
import com.novell.service.session.SessionEnv;
import com.novell.service.session.SessionException;
import com.novell.service.session.spi.SessionManagerImpl;
import com.novell.service.session.SessionManagerFactory;
import com.novell.service.session.SessionRuntimeException;
import com.novell.service.session.InvalidDomainNameException;
import com.novell.service.session.InvalidUserNameException;
import com.novell.service.session.util.TwoWayHashtable;
import com.novell.service.toolkit.jcl.NWLong;
import com.novell.service.toolkit.jcl.NWVersion;
import com.novell.java.lang.IntegerBuffer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.io.Serializable;

/** @internal
 * Utility class shared by NDS and Bindery Session providers.
 */
public class ConnectionEnumerator implements Enumeration
{
   Enumeration enum;

   ConnectionEnumerator(
      Connections connections)
   {
      this.enum = connections.elements();
   }

   ConnectionEnumerator(
      Enumeration enum)
   {
      this.enum = enum;
   }

   public boolean hasMoreElements()
   {
      return (enum.hasMoreElements());
   }

   public Object nextElement()
   {
      return (enum.nextElement());
   }

   public Connection next()
   throws NoSuchElementException
   {
      return((Connection) nextElement());
   }

   /**
    * Returns an array of Connections for the next object(s) in the enumeration.
    */
   public Connection[] next(
      int batchSize)
   {
      Connection[] batch = new Connection[(int) batchSize];

      for (int i = 0; i < batchSize; i++)
      {
         batch[i] = next();
      }
      return (batch);
   }
} // class ConnectionEnumerator
