
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/session/xplat/MultiTreeSupportException.java $
  $Revision: 8 $
  $Modtime: 1/24/00 8:00p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.session.xplat;


import com.novell.service.jncpv2.clx.*;

import com.novell.java.lang.HasRootCause;


/**
 * Top-level exception thrown by Session object.  All Session exceptions
 * extend this exception.
 */
public class MultiTreeSupportException
   extends Exception
   implements java.io.Serializable, HasRootCause
{
 /**
  * @internal
  */
   protected Throwable rootException = null;

   /**
    * Constructs a MultiTreeSupportException with the specified detail message.
    * A detail message is a String that describes this particular exception.
    *
    * @param s The detail message description.
    */
   public MultiTreeSupportException
   (
      String s
   )
   {
      super(s);
   }

   /**
    * Constructs a MultiTreeSupportException with a root-cause exception.
    * The root cause exception can be retrieved using getRootCause().
    *
    * @param rootException The root-cause exception.
    */
   public MultiTreeSupportException
   (
      Throwable rootException
   )
   {
      super("Wrapped exception");
      this.rootException = rootException;
   }

   /**
    * Constructs a MultiTreeSupportException with the specified detail
    * messagea and root-cause exception. The root cause exception can be
    * retrieved using getRootCause().
    *
    * @param s The detail message description.
    * @param rootException The root-cause exception.
    */
   public MultiTreeSupportException
   (
      String s,
      Throwable rootException
   )
   {
      super(s + ": " + rootException.toString());
      this.rootException = rootException;
   }

   /**
    * Returns the root-cause exception. It is inherited from
    * HasRootCause().
    *
    * @return The root cause exception as a Throwable object.
    */
   public Throwable getRootCause
   (
   )
   {
      return rootException;
   }
}

