/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/session/xplat/NativeContextDuplicate.java $
  $Revision: 4 $
  $Modtime: 8/19/99 1:32p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

/** @internal
 * Class which contains both a native context handle and a native thread group
 * id for use in nlm thread-group switching.
 *
 * Intended to be returned by ClxJNI.NWDSCreateContextHandle().
 */
public class NativeContextDuplicate extends NativeContext
{
   protected NativeContextMaster master;

   public NativeContextDuplicate(
      NativeContextMaster master,
      int contextHandle
   )
   {
      super(master.threadGroup, contextHandle);
      this.master = master;
      master.addChild(this);
   }

   public void close()
   {
      master.removeChild(this);
      free();
   }

   public String toString()
   {
      StringBuffer out = new StringBuffer();
      out.append("NativeContextDuplicate$");
      out.append(
         ":C=0x" + Integer.toHexString(this.contextHandle));
      out.append(
         ":TG=0x" + Integer.toHexString(this.threadGroup));

      return (out.toString());
   }
}

