/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/session/xplat/NativeContexts.java $
  $Revision: 5 $
  $Modtime: 8/24/99 6:19p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import java.util.Enumeration;
import java.util.Hashtable;
import com.novell.service.session.SessionException;

/**
 * @internal
 */
public class NativeContexts
{
   private Hashtable nativeContexts;

   NativeContexts()
   {
      nativeContexts = new Hashtable();
   }

   public NativeContextMaster put(
      NativeContextMaster master)
   throws SessionException
   {
      NativeContextMaster lastMaster;
      String tree = master.getTree();
//      synchronized (master)
      {
         lastMaster =
            (NativeContextMaster)nativeContexts.put(tree, master);
         master.setOwner(this);
      }
      return lastMaster;
   }

   public NativeContextMaster get(
      String tree)
   throws SessionException
   {
      return (NativeContextMaster)nativeContexts.get(tree);
   }

//   synchronized public NativeContextMaster remove(
   public NativeContextMaster remove(
      NativeContextMaster master)
   {
      return (NativeContextMaster)nativeContexts.remove(master.getTree());
   }

//   synchronized public boolean contains(
   public boolean contains(
      NativeContextMaster master)
   throws SessionException
   {
      return (nativeContexts.containsKey(
         master.getTree()));
   }

//   synchronized public boolean contains(
   public boolean contains(
      String tree)
   throws SessionException
   {
      return (nativeContexts.containsKey(tree));
   }

   public Enumeration nativeContexts()
   {
      return nativeContexts.elements();
   }

   public Enumeration trees()
   {
      return nativeContexts.keys();
   }

   public int size()
   {
      return nativeContexts.size();
   }
} // class NativeContexts

