/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/session/xplat/ServerTreeMismatchException.java $
  $Revision: 5 $
  $Modtime: 4/04/99 5:29p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import com.novell.service.session.SessionException;

/**
 * Thrown when a server is not part of a required tree.
 */
public class ServerTreeMismatchException extends SessionException
{
   /**
    * Constructs a ServerTreeMismatchException with the specified requested
    * server, requested tree, and connection tree.
    *
    * @param requestedServer The specified server requested.
    * @param requestedTree   The specified tree requested.
    * @param connectionTree  The specified connection tree.
    */
   public ServerTreeMismatchException
   (
      String requestedServer,
      String requestedTree,
      String connectionTree
   )
   {
      super(requestedServer + "(" + requestedTree + " != " + connectionTree + ")");
   }
}

