
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/utility/naming/ContextWrapper.java $
  $Revision: 3 $
  $Modtime: 8/11/99 10:44a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.utility.naming;


import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.Name;
import javax.naming.CompositeName;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;


/** @internal
 * The ContextWrapper class provides "type-safe" containment of a 
 * ContextWrappable object.
 *
 * This class implements the Context interface.  The methods of 
 * ContextWrapper call the ContextWrappable implementation.
 */
public class ContextWrapper implements Context
{
   protected ContextWrappable impl;


   /**
    *
    */
   protected ContextWrapper (
         ContextWrappable impl)
   {
      this.impl = impl;
   }

   // ******************** Context Interface ********************

   /**
    *
    */
   public Object lookup (
         String name)
      throws NamingException
   {
      return (lookup (new CompositeName (name)));
   }

   /**
    *
    */
   public Object lookup (
         Name name)
      throws NamingException
   {
      return (((Context) impl).lookup (name));
   }

   /**
    *
    */
   public void bind (
         String name,
         Object object)
      throws NamingException
   {
      bind (new CompositeName (name), object);
   }

   /**
    *
    */
   public void bind (
         Name name,
         Object object)
      throws NamingException
   {
      ((Context) impl).bind (name, object);
   }

   /**
    *
    */
   public void rebind (
         String name,
         Object object)
      throws NamingException
   {
      rebind (new CompositeName (name), object);
   }

   /**
    *
    */
   public void rebind (
         Name name,
         Object object)
      throws NamingException
   {
      ((Context) impl).rebind (name, object);
   }

   /**
    *
    */
   public void unbind (
         String name)
      throws NamingException
   {
      unbind (new CompositeName (name));
   }

   /**
    *
    */
   public void unbind (
         Name name)
      throws NamingException
   {
      ((Context) impl).unbind (name);
   }

   /**
    *
    */
   public void rename (
         String oldName,
         String newName)
      throws NamingException
   {
      rename (new CompositeName (oldName), new CompositeName (newName));
   }

   /**
    *
    */
   public void rename (
         Name oldName,
         Name newName)
      throws NamingException
   {
      ((Context) impl).rename (oldName, newName);
   }

   /**
    *
    */
   public NamingEnumeration list (
         String name)
      throws NamingException
   {
      return (list (new CompositeName (name)));
   }

   /**
    *
    */
   public NamingEnumeration list (
         Name name)
      throws NamingException
   {
      return (((Context) impl).list (name));
   }

   /**
    *
    */
   public NamingEnumeration listBindings (
         String name)
      throws NamingException
   {
      return (listBindings (new CompositeName (name)));
   }

   /**
    *
    */
   public NamingEnumeration listBindings (
         Name name)
      throws NamingException
   {
      return (((Context) impl).listBindings (name));
   }

   /**
    *
    */
   public void destroySubcontext (
         String name)
      throws NamingException
   {
      destroySubcontext (new CompositeName (name));
   }

   /**
    *
    */
   public void destroySubcontext (
         Name name)
      throws NamingException
   {
      ((Context) impl).destroySubcontext (name);
   }

   /**
    *
    */
   public Context createSubcontext (
         String name)
      throws NamingException
   {
      return (createSubcontext (new CompositeName (name)));
   }

   /**
    *
    */
   public Context createSubcontext (
         Name name)
      throws NamingException
   {
      return (((Context) impl).createSubcontext (name));
   }

   /**
    *
    */
   public Object lookupLink (
         String name)
      throws NamingException
   {
      return (lookupLink (new CompositeName (name)));
   }

   /**
    *
    */
   public Object lookupLink (
         Name name)
      throws NamingException
   {
      return (((Context) impl).lookupLink (name));
   }

   /**
    *
    */
   public NameParser getNameParser (
         String name)
      throws NamingException
   {
      return (getNameParser (new CompositeName (name)));
   }

   /**
    *
    */
   public NameParser getNameParser (
         Name name)
      throws NamingException
   {
      return (((Context) impl).getNameParser (name));
   }

   /**
    *
    */
   public String composeName (
         String name, 
         String prefix)
      throws NamingException
   {
      Name fullName;

      fullName = composeName (
                     new CompositeName (name),
                     new CompositeName (prefix));
      return (fullName.toString ());

   } /* composeName () */

   /**
    *
    */
   public Name composeName (
         Name name, 
         Name prefix) 
      throws NamingException
   {
      return (((Context) impl).composeName (name, prefix));

   } /* composeName () */

   /** 
    *
    */
   public String getNameInNamespace ()
      throws NamingException
   {
      return (((Context) impl).getNameInNamespace ());

   } /* getNameInNamespace() */

   /**
    *
    */
   public Object addToEnvironment (
         String propName, 
         Object propVal) 
      throws NamingException
   {
      return (((Context) impl).addToEnvironment (propName, propVal));

   } /* addToEnvironment () */

   /**
    *
    */
   public Object removeFromEnvironment (
         String propName) 
      throws NamingException
   {
      return (((Context) impl).removeFromEnvironment (propName));

   } /* removeFromEnvironment () */

   /**
    *
    */
   public Hashtable getEnvironment ()
      throws NamingException
   {
      return (((Context) impl).getEnvironment ());

   }

   /**
    *
    */
   public void close ()
      throws NamingException
   {
      ((Context) impl).close ();
   }

} /* ContextWrapper */


