
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/java/io/EndianInput.java $
  $Revision: 5 $
  $Modtime: 9/10/99 4:15p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.java.io;


import java.io.DataInput;
import java.io.IOException;


/**
 * Provides an interface that is implemented by streams that can read 
 * primitive Java data types from a stream in a machine-dependent 
 * manner. 
 *
 * @see EndianInputStream
 * @see EndianOutput
 */
public interface EndianInput extends DataInput
{
   /**
    * Reads two bytes of a short value in high-low order from the
    * input stream. 
    *
    * @return The 16-bit value read.
    * 
    * @exception EOFException If this stream reaches the end before
    *             reading all the bytes.
    * @exception IOException If an I/O error occurs.
    */
   public short readHiLoShort ()
      throws IOException;

   /**
    * Reads two bytes of a short value in low-high order from the
    * input stream. 
    *
    * @return The 16-bit value read.
    * 
    * @exception EOFException If this stream reaches the end before
    *             reading all the bytes.
    * @exception IOException If an I/O error occurs.
    */
   public short readLoHiShort ()
      throws IOException;

   /**
    * Reads two bytes of a Unicode char value in high-low order from the
    * input stream. 
    *
    * @return The Unicode char read.
    * 
    * @exception EOFException If this stream reaches the end before reading
    *               all the bytes.
    * @exception IOException If an I/O error occurs.
    */
   public char readHiLoChar ()
      throws IOException;

   /**
    * Reads two bytes of a Unicode char value in low-high order from the
    * input stream. 
    *
    * @return The Unicode char read.
    * 
    * @exception EOFException If this stream reaches the end before reading
    *               all the bytes.
    * @exception IOException If an I/O error occurs.
    */
   public char readLoHiChar ()
      throws IOException;

   /**
    * Reads four bytes of a int value in high-low order from the
    * input stream. 
    *
    * @return The int value read.
    * 
    * @exception EOFException If this stream reaches the end before reading
    *               all the bytes.
    * @exception IOException If an I/O error occurs.
    */
   public int readHiLoInt ()
      throws IOException;

   /**
    * Reads four bytes of a int value in low-high order from the
    * input stream. 
    *
    * @return The int value read.
    * 
    * @exception EOFException If this stream reaches the end before reading
    *               all the bytes.
    * @exception IOException If an I/O error occurs.
    */
   public int readLoHiInt ()
      throws IOException;

   /**
    * Reads eight bytes of a long value in high-low order from the
    * input stream. 
    *
    * @return The long value read.
    *
    * @exception EOFException If this stream reaches the end before
    *             reading all the bytes.
    * @exception IOException If an I/O error occurs.
    */
   public long readHiLoLong ()
      throws IOException;

   /**
    * Reads eight bytes of a long value in low-high order from the
    * input stream. 
    *
    * @return The long value read.
    * 
    * @exception EOFException If this stream reaches the end before
    *             reading all the bytes.
    * @exception IOException If an I/O error occurs.
    */
   public long readLoHiLong ()
      throws IOException;

   /** @internal
    * @deprecated
    *
    * Reads in a sequence of chars from low-high order that has been
    * length-preceeded null-terminated.
    * </p>
    *
    * @return                    A String copy of the sequence.
    *
    * @exception  EOFException  if this stream reaches the end before reading
    *               all the bytes.
    * @exception  IOException   if an I/O error occurs.
    */
   public String readUString ()
      throws IOException;

} /* EndianInput */


