
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/java/io/EndianOutput.java $
  $Revision: 4 $
  $Modtime: 1/18/00 9:01a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.java.io;


import java.io.DataOutput;
import java.io.IOException;


/**
 * Provides an interface describing streams that can write output in an 
 * endian-dependent format.
 *
 */
public interface EndianOutput extends DataOutput
{
   /**
    * Writes a string as a null-terminated sequence of chars in high-low 
    * order.
    *
    * @param s A string of chars to be written.
    * 
    * @exception IOException If an I/O error occurs.
    */
   public void writeHiLoChars (
         String s)
      throws IOException;

   /**
    * Writes a string as a null-terminated sequence of chars in low-high 
    * order.
    *
    * @param s A string of chars to be written.
    * 
    * @exception IOException If an I/O error has occurred.
    */
   public void writeLoHiChars (
         String s) 
      throws IOException;

   /**
    * Writes a 32-bit int in high-low order.
    *
    * @param v An integer value to be written.
    * 
    * @exception IOException If an I/O error has occurred.
    */
   public void writeHiLoInt (
         int v)
      throws IOException;

   /**
    * Writes a 32-bit int in low-high order.
    *
    * @param v An integer value to be written.
    *
    * @exception IOException If an I/O error has occurred.
    */
   public void writeLoHiInt (
         int v)
      throws IOException;

   /**
    * Writes a 16-bit short in high-low order.
    *
    * @param v A short value to be written.
    * 
    * @exception IOException If an I/O error has occurred.
    */
   public void writeHiLoShort (
         int v)
      throws IOException;

   /**
    * Writes a 16-bit short in low-high order.
    *
    * @param v A short value to be written.
    * 
    * @exception IOException If an I/O error has occurred.
    */
   public void writeLoHiShort (
         int v)
      throws IOException;

   /**
    * Writes a 64-bit long in high-low order.
    *
    * @param v A long value to be written.
    * 
    * @exception IOException If an I/O error has occurred.
    */
   public void writeHiLoLong (
         long v)
      throws IOException;

   /**
    * Writes a 64-bit long in low-high order.
    *
    * @param v A long value to be written.
    * 
    * @exception IOException If an I/O error has occurred.
    */
   public void writeLoHiLong (
         long v)
      throws IOException;

} /* EndianOutput */


