/* **************************************************************************

  $Archive: /njcl/src/com/novell/java/lang/IntegerBuffer.java $
  $Revision: 3 $
  $Modtime: 4/08/98 11:00a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.java.lang;


/** @internal
 * This class is used only for communication with the native libraries.
 */

public final class IntegerBuffer extends Number 
{
   /**
    * The value of the IntegerBuffer.
    */
   private int value;

   /**
    * Constructs a zero Integer buffer.
    */
   public IntegerBuffer ()
   {
      this (0);
   }

   /**
    * Constructs an IntegerBuffer object initialized to the specified int 
    * value.
    *
    * @param value  the initial value of the IntegerBuffer
    */
   public IntegerBuffer (
      int value)
   {
      this.value = value;
   }

   /**
    * Constructs an IntegerBuffer object initialized to the value specified by 
    * the String parameter.  The radix is assumed to be 10.
    *
    * @param s    the String to be converted to an IntegerBuffer
    * @exception  NumberFormatException  If the String does not contain a 
    *                                    parsable integer.
    */
   public IntegerBuffer (
         String s) 
      throws NumberFormatException 
   {
      this.value = Integer.parseInt (s, 10);
   }

   /**
    * Constructs a Integer buffer with the specified initial value.
    * @param val  the initial value of the buffer
    */
   public IntegerBuffer (
      Integer val) 
   {
      this (val.intValue ());
   }

   /**
    * Returns the value of this IntegerBuffer as an int.
    */
   public int intValue ()
   {
      return (value);
   }

   /**
    * Returns the value of this IntegerBuffer as a long.
    */
   public long longValue ()
   {
      return ((long) value);
   }

   /**
    * Returns the value of this IntegerBuffer as a float.
    */
   public float floatValue ()
   {
      return ((float) value);
   }

   /**
    * Returns the value of this Integer buffer as a double.
    */
   public double doubleValue ()
   {
      return ((double) value);
   }

   /**
    * Assigns the value of this Integer buffer with an int.
    *
    * @param value  the new value of the buffer.
    */
   public void setValue (
      int value) 
   {
      this.value = value;
   }

   /**
    * Assigns the value of this Integer buffer with an Integer.
    *
    * @param val   the new value of the buffer.
    */
   public void setValue (
      Integer val) 
   {
      this.value = val.intValue();
   }

   /**
    * Returns a String object representing this IntegerBuffer's value.
    */
   public String toString ()
   {
      return (String.valueOf (value));
   }

   /**
    * Returns a hashcode for this IntegerBuffer.
    */
   public int hashCode ()
   {
      return (value);
   }

   /**
    * Compares this object to the specified object.
    *
    * @param obj  the object to compare with
    * @return     true if the objects are the same; false otherwise.
    */
   public boolean equals (
      Object obj)
   {
      if ((obj != null) && (obj instanceof IntegerBuffer)) 
      {
         return (value == ((IntegerBuffer) obj).intValue ());
      }
      return (false);
   }

} /* IntegerBuffer */


