/* **************************************************************************

  $Archive: /njcl/src/com/novell/java/security/GuiAuthenticatorTab.java $
  $Revision: 5 $
  $Modtime: 5/14/98 2:22p $

  Copyright (c) 1997-1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.java.security;

import java.awt.Panel;

/**@internal
 *
 * @author Jan Sture Nielsen
 * @version 1.0.0
 */
public abstract class GuiAuthenticatorTab extends Panel
{
	/**
	* Return true if UI is required to collect authentication data,
	* false if all necessary data can be collected without any UI.
	* For example, if one authentication class is used to handle
	* both smart card and password based logins, when a smart card
	* is present, return false, otherwise return true to have the
	* password page added to the LoginBook.
	*/

   public abstract boolean requiresUserInterface();

	/**
	* Returns the String which LoginBook will display in the pages
	* list for this page.
	*/
	public abstract String getPageName();

	/**
	* Called by LoginBook when OK button is pressed.  LoginPage should
	* determine if all required data have been provided, but should not
	* attempt to authenticate using the data at this point. Return
	* false if some required datum is missing.
	*/
	public abstract boolean canClose();
}
