/*
 * @(#)Key.java	1.37 97/11/19
 * 
 * Copyright 1993-1997 Sun Microsystems, Inc. 901 San Antonio Road, 
 * Palo Alto, California, 94303, U.S.A.  All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * CopyrightVersion 1.2
 * 
 */
 
package com.novell.java.security;

/**
 * Defines the functionality shared by all key objects. 
 * It is the top-level interface for all keys. All keys
 * have three characteristics:
 *
 * <UL><LI>A Key Algorithm, which is usually an encryption or
 * asymmetric operation algorithm, such as DSA or RSA.The key
 * algorithm name is returned by the getAlgorithm() method.
 * <LI>An Encoded Form, which is an external encoded form for the
 * key that is used when a standard representation of the key is
 * needed outside the JVM. It is returned by the getEncoded() method.
 * <LI>A Format, which is the name of the format of the encoded
 * key. It is returned by the getFormat() method.</UL>
 * 
 * <P>Keys are usually obtained through key generators,
 * certificates, or various Identity classes used to manage keys.
 * Keys may also be obtained from key specifications (transparent
 * representations of the underlying key material) through the use
 * of a key factory.</p>
 *  
 * @see PublicKey
 * @see Identity
 *
 * @version 1.37 98/01/14
 * @author Benjamin Renaud 
 */

public interface Key extends java.io.Serializable {

    /**
     * Returns the standard algorithm name for this key. It will work
     * with asymmetric operation algorithm, such as DSA or RSA, and
     * with related algorithms, such as MD5 with RSA, SHA-1 with RSA,
     * Raw DSA, and so forth). For example, DSA would indicate that
     * this key is a DSA key. For information about standard algorithm
     * names see Appendix A in Sun's Java Cryptography Architecture API
     * Specification & Reference documentation.
     * 
     * @return The name of the algorithm associated with this key. 
     */
    public String getAlgorithm();

    /**
     * Returns the name of the primary encoding format of this key, 
     * or NULL if this key does not support encoding. The primary
     * encoding format is named in terms of the appropriate ASN.1
     * data format, if an ASN.1 specification for this key exists.
     *
     * <p>For example, the name of the ASN.1 data format for public 
     * keys is SubjectPublicKeyInfo, as defined by the X.509 standard;
     * in this case, the returned format is X.509. Similarly, the
     * name of the ASN.1 data format for private keys is PrivateKeyInfo,
     * as defined by the PKCS #8 standard; in this case, the returned
     * format is PKCS#8.
     * 
     * @return The primary encoding format for this key, or NULL if
     *         this key does not support encoding.
     */
    public String getFormat();

    /**
     * Returns the key in its primary encoding format, or NULL
     * if this key does not support encoding. The Encoded Form is an
     * external encoded form for the key that is used when a standard
     * representation of the key is needed outside the JVM, as when
     * transmitting the key to some other party. The key is encoded
     * according to a standard format, such as X.509 or PKCS#8.</P>
     * 
     * @return The encoded key as a byte array, or NULL if the key does
     *         not support encoding.
     */
    public byte[] getEncoded();
}
