/* **************************************************************************

  $Archive: /njcl/src/com/novell/java/security/VerifyTokensException.java $
  $Revision: 1 $
  $Modtime: 2/25/99 6:40p $

  Copyright (c) 1997-1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.java.security;

/**
 * Thrown when an error occurs during the verification of
 * authentication tokens.
 *
 * @see AuthenticatorException
 *
 * @version 1.0.0
 */
public class VerifyTokensException extends AuthenticatorException
{
   /**
    * The default constructor.
    */
   public VerifyTokensException()
   {
      super(I2L.getString(XMsg.VERIFY_TOKENS));
   }

   /**
    * Constructor with a message.
    *
    * @param message A message associated with the exception.
    */
   public VerifyTokensException(String message)
   {
      super(message);
   }

   /**
    * Constructor with a message and a root cause exception.
    *
    * @param message   A message associated with the exception.
    * @param exception The root cause exception.
    */
   public VerifyTokensException(String message,java.lang.Throwable exception)
   {
      super(message,exception);
   }

   /**
    * Constructor with a root cause exception.
    *
    * @param exception The root cause exception.
    */
   public VerifyTokensException(java.lang.Throwable exception)
   {
      this(I2L.getString(XMsg.VERIFY_TOKENS),exception);
   }
}

