/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/bindery/BinderySchemaContext.java $
  $Revision: 7 $
  $Modtime: 10/18/99 11:52a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.bindery;


import javax.naming.*;

import com.novell.utility.naming.directory.StaticSchemaContext;


/**@internal
 * Schema root for the bindery system.
 *
 * <p>This is the root schema DirContext that is returned from all bindery
 * contexts getSchema methods.
 * </p>
 */
public class BinderySchemaContext extends StaticSchemaContext
{
   /* ***********************************************************************
    * These arrays are parallel and are used to construct the
    * childNameClassPairs and childBindings. Each array must contain an
    * entry for each child and each array must be the same length.
    * Consequently, if you add or delete a subordinate, you must add a 
    * subordinate in each of the following three arrays:
    *   childNames = The string (name) used by lookup
    *   childClasses = The class name placed in the NameClassPair
    *   childObjects = The object placed in the Binding
    ************************************************************************/

   private static String binderyChildNames[] =
   {
      "Classes"
   };

   protected static String binderyChildClasses[] =
   {
      "com.novell.service.bindery.BinderySchemaClassDefsContext"
   };

   protected static Object binderyChildObjects[] =
   {
      new BinderySchemaClassDefsContext ()
   };

   /**
    * Constructs a static schema root object for the bindery.
    */
   public BinderySchemaContext ()
   {
      super ("[Root]");

      initBindingsAndPairs (        // Setup the parent's bindings and pairs
            binderyChildNames,
            binderyChildClasses,
            binderyChildObjects);
   }

} /* class BinderySchemaContext */


