/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/bindery/ClassNames.java $
  $Revision: 4 $
  $Modtime: 5/19/99 4:44p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.bindery;

import java.util.Hashtable;
import java.io.Serializable;

import javax.naming.*;

import com.novell.utility.naming.Environment;

import com.novell.service.session.*;
import com.novell.service.session.xplat.CallsService;

/**
 * @internal
 *
 * Defines the set of constant Strings that uniquely controls
 * the behavior of the Bindery name provider. It also contains convenience
 * functions for managing the bindery objects.
 *
 * <p>The BinderyEnvironment class extends the Environment class, which
 * provides constants for environment variables associated with
 * Novell JNDI providers.</p>
 * 
 * @see Environment
 */

public class ClassNames
{
   // JNDI property strings =================================================

   public static final String BINDERY = 
               "com.novell.service.bindery.BinderyDirContext";

   public static final String BINDERY_OBJECT = 
               "com.novell.service.bindery.BinderyObjectDirContext";

   public static final String QUEUE_BINDERY_OBJECT = 
               "com.novell.service.bindery.QueueBinderyObjectDirContext";

   public static final String SERVER_BINDERY_OBJECT = 
               "com.novell.service.bindery.ServerBinderyObjectDirContext";

   public static final String TREE_BINDERY_OBJECT = 
               "com.novell.service.bindery.TreeBinderyObjectDirContext";

   public static final String BINDERY_OBJECT_FACTORY = 
               "com.novell.service.bindery.BinderyObjectFactory";

   public static final String OBJECT_CLASS_DEF = 
               "com.novell.service.bindery.BinderyObjectClassDefContext";

   public static final String SCHEMA_CLASS_DEFS = 
               "com.novell.service.bindery.BinderySchemaClassDefsContext";

   public static final String BINDERY_PROPERTY = 
               "com.novell.service.bindery.BinderyPropertyAttrVal";

}  // end ClassNames