/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/bindery/ReferenceFactoryImpl.java $
  $Revision: 4 $
  $Modtime: 4/27/98 11:55a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.bindery;

import javax.naming.*;
import java.util.*;

import com.novell.utility.naming.URLParser;

/** @internal
 *
 *    This class lets us build references to Bindery objects.  One method is
 *    public so that other JNDI name spaces can federate to the Bindery,
 *    while the other is protected so that only Bindery classes can use it.
 */

public class ReferenceFactoryImpl
      implements com.novell.utility.naming.spi.ReferenceFactory
{
   protected final static String SERVICE_HOST = "ServiceHost" ;
   protected final static String OBJECT_NAME  = "ObjectName"  ;

   /**
    *   This is the intra-nsi federation method, so we always create
    *      a top-level bindery object.
    */

   public Reference createReference(Hashtable props) throws NamingException
   {
      Reference ret = null;
      String    serverName;

		String url = (String)props.get(Context.PROVIDER_URL);
		serverName = new URLParser (url).getHost ();
      if (serverName != null)
      {
         StringRefAddr refAddr = new StringRefAddr(SERVICE_HOST, serverName);

         ret = new Reference (
                     ClassNames.BINDERY,
                     refAddr,
                     ClassNames.BINDERY_OBJECT_FACTORY, "" );
      }
      return ret;
   }

   /* This version of createRef is for use by classes in the package that
    *  need to create a ref that other packages will store.  These refs
    *  need to know exactly what object to create, so must pass the name of
    *  the server on which the bindery is located, the name of the class,
    *  and the name of the object itself (including the type number).

    * Turns out we don't need class name since the type must be on the
    *  objName, and type tells what kind of class, but the Reference
    *  constructor needs it.
    */

   Reference createReference( String serviceHost,
                              String className,
                              String objName)
      throws NamingException
   {
      Reference ref = null;
      String    serverName;

      if (serviceHost != null  &&  className != null  &&  objName != null)
      {
         StringRefAddr refAddr = new StringRefAddr(SERVICE_HOST,serviceHost);

         ref = new Reference (
                     className,
                     refAddr,
                     ClassNames.BINDERY_OBJECT_FACTORY, "" );

         ref.add( new StringRefAddr( OBJECT_NAME, objName ) );
      }
      return ref;

   }  // end package version of createReference

}
