/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/bindery/TreeBinderyObjectDirContext.java $
  $Revision: 11 $
  $Modtime: 1/05/01 2:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.bindery;

import java.util.*;
import javax.naming.*;
import javax.naming.directory.*;
import javax.naming.spi.*;
import  com.sun.jndi.toolkit.ctx.*;

import com.novell.service.session.*;
import com.novell.service.jncpv2r.net.NetJNI;
import com.novell.service.jncpv2r.net.NetService;
import com.novell.java.lang.*;
import com.novell.utility.naming.Environment;


/**
 * Represents a bindery object that is an NDS tree.
 * TreeBinderyObjectDirContext is responsible for federating from
 * the bindery name system to the NDS tree name system. As such,
 * it subclasses BinderyObjectDirContext and obtains all of its
 * other functionality from that parent class.
 *
 * @see BinderyObjectDirContext
 */
 /*
  * Override the methods for next name system
  * (i.e. a_resolveIntermediate_nns, and a_lookup_nns).
  */
public class TreeBinderyObjectDirContext
   extends BinderyObjectDirContext
{

   /**@internal
    * The constructor does nothing more than call super().  The only thing
    * unique about this class is the federation point, and that does not
    * require anything special to be done in the constructor.
    */
   public TreeBinderyObjectDirContext (
         Environment    env,
         String         binderyObjectName,
         int            binderyObjectType,
         int            binderyObjectID,
         int            hasProperties,
         int            objSecurity,
         int            objFlags)
      throws NamingException
   {
      super (
         env,
         binderyObjectName,
         binderyObjectType,
         binderyObjectID,
         hasProperties,
         objSecurity,
         objFlags);
   } // TreeBinderyObjectDirContext ()


   // Since this is a Federation point, need to implement nns methods.

   /**@internal
    */
   protected Object a_resolveIntermediate_nns (
         String name,
         Continuation cont)
      throws NamingException
   {
      return a_lookup_nns (name, cont);
   } // a_resolveIntermediate_nns ()

   /**@internal
    */
   public Object a_lookup_nns (
         String name,
         Continuation cont)
      throws NamingException
   {
      Object    ndsContext = null;
      Reference ref = null;

      if (0 == name.length ())
      {  // Name is empty, user did lookup("/...")
         try
         {
            Hashtable hash = new Hashtable ();
            String treeNameOnly =
               binderyObjectNameOnly.substring (0, NetService.MAX_TREE_NAME_CHARS);
            hash.put (PROVIDER_URL, treeNameOnly);

            com.novell.service.nds.naming.ReferenceFactoryImpl
               referenceFactory =
               new com.novell.service.nds.naming.ReferenceFactoryImpl ();

            ref = referenceFactory.createReference (hash);

            ndsContext = NamingManager.getObjectInstance (
                                          ref,
                                          null,
                                          null,
                                          getEnvironment ());  // ?hash?
         }
         catch (NamingException e)
         {
            cont.setError (this, name);
            throw cont.fillInException (e);
         }
         catch (Exception e)
         {
            NamingException ne = new NamingException ();
            cont.setError (this, name);
            ne.setRootCause (e);
            throw cont.fillInException (ne);
         }
         if (ndsContext != null)
         {
            cont.setSuccess ();
            return ndsContext;
         }
         else
         {
            cont.setErrorNNS (this, name);
            NameNotFoundException e = new NameNotFoundException ();
            throw cont.fillInException (e);
         }
      }
      else
      {  // no objects to lookup since we are a flat namespace
         cont.setError (this, name);
         NameNotFoundException e = new NameNotFoundException ();
         throw cont.fillInException (e);
      }
   }  // a_lookup_nns ()

} // TreeBinderyObjectDirContext
