
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/file/nw/calls/NativeFileAccessor.java $
  $Revision: 8 $
  $Modtime: 8/17/01 12:31p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.file.nw.calls;


import java.io.IOException;

import com.novell.service.jncp.NSIException;

import com.novell.service.file.nw.DataAccessableParameters;

import com.novell.service.session.Session;
import com.novell.service.session.SessionException;
import com.novell.service.session.xplat.CallsService;


/** @internal
 * Allows native I/O access to a native Netware open file handle.
 *
 * <p>Special NetWare functionality is added if the OPEN_COMPRESSED bit is
 * set in the file open mode.  If this is the case, the logical file size
 * is set by calling a special NetWare API, otherwise, only platform native
 * APIs are used.
 * </p>
 */
public class NativeFileAccessor extends NativeDeviceAccessor
{
   private static final String serviceKey    = CallsService.KEY;


   private int mode;       // used to test the OPEN_COMPRESSED bit
   private CallsService service;


   /**
    * Constructs a native data accessor that can access a platform native
    * file handle.
    *
    * @param      fileHandle     The platform native file handle.
    * @param      mode           The NetWare mode in which the file handle
    *                            was opened.
    */
   public NativeFileAccessor
   (
         int handle,
         int mode,
      Session session
   )
      throws IOException
   {
      super(handle, session, (((mode & DataAccessableParameters.WRITE) == 0) ? true : false));
      try
      {
         this.mode = mode;
         this.service = (CallsService) session.getService (serviceKey);
      }
      catch (SessionException e)
      {
         throw (new IOException (e.getMessage ()));
      }

   }

   /**
    * Closes the file just like NativeDeviceAccessor, except that if
    * the file was opened with the OPEN_COMPRESSED bit set, then
    * the file size will be set.
    *
    * <p>If there was data written to the stream that has not yet been
    * written to disk, then this data is flushed to disk before closing the
    * stream.
    * </p>
    *
    * @exception  IOException    When there is an error flushing data or
    *                            closing the native file handle.  Or also
    *                            on compressed NetWare files, when an
    *                            error occurs setting the compressed file
    *                            size.
    */
   synchronized public void close ()
      throws IOException
   {
      // if the file is already closed, don't do anything
      if (closed)
         return;

      flush ();

      if ((mode & DataAccessableParameters.OPEN_COMPRESSED) != 0)
      {
         try
         {
            int[] actualSize = new int[1];

            service.setCompressedFileSize (
//                  0,    // only valid under NETX
                  super.handle,
                  (int) length (),
                  actualSize);
         }
         catch (SessionException e)
         {
            throw (new IOException (e.getMessage ()));
         }
      }

      super.close ();

   } /* close () */

} /* NativeFileAccessor */


