/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/jncp/ClientErrors.java $
  $Revision: 5 $
  $Modtime: 1/28/00 11:06a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

/* @(#)ClientErrors.java        1.00  96/11/11    NSI Development Team
 *
 */

package com.novell.service.jncp;

/**
 * Static list of known errors returned from native client calls<p>
 *
 * @version     1.00, 11 Nov 1996
 * @author      NSI Development Team
 */

public class ClientErrors
{
   // List of expected error codes

   /**
    * <p>(DOS_INVALID_DRIVE                       = 0x000F)
    * </p>
    */
   public static final int DOS_INVALID_DRIVE                       = 0x000F;

   /**
    * <p>(SHELL_ERROR                             = 0x8800)
    * </p>
    */
   public static final int SHELL_ERROR                             = 0x8800;

   /**
    * <p>(VLM_ERROR                               = 0x8800)
    * </p>
    */
   public static final int VLM_ERROR                               = 0x8800;

   /**
    * Attach attempted to server with valid, existing connection.
    *
    * <p>(ALREADY_ATTACHED                        = 0x8800)
    * </p>
    */
   public static final int ALREADY_ATTACHED                        = 0x8800;

   /**
    * Attach attempted to server with valid, existing connection.
    *
    * <p>(NWE_ALREADY_ATTACHED                    = 0x8800)
    * </p>
    */
   public static final int NWE_ALREADY_ATTACHED                    = 0x8800;

   /**
    * Request attempted with invalid or non-attached connection handle.
    *
    * <p>(INVALID_CONNECTION                      = 0x8801)
    * </p>
    */
   public static final int INVALID_CONNECTION                      = 0x8801;

   /**
    * Request attempted with invalid or non-attached connection handle.
    *
    * <p>(NWE_CONN_INVALID                        = 0x8801)
    * </p>
    */
   public static final int NWE_CONN_INVALID                        = 0x8801;

   /**
    * <p>(DRIVE_IN_USE                            = 0x8802)
    * </p>
    */
   public static final int DRIVE_IN_USE                            = 0x8802;

   /**
    * <p>(NWE_DRIVE_IN_USE                        = 0x8802)
    * </p>
    */
   public static final int NWE_DRIVE_IN_USE                        = 0x8802;

   /**
    * Map drive attempted but unable to add new current directory structure.
    *
    * <p>(CANT_ADD_CDS                            = 0x8803)
    * </p>
    */
   public static final int CANT_ADD_CDS                            = 0x8803;

   /**
    * <p>(DRIVE_CANNOT_MAP                        = 0x8803)
    * </p>
    */
   public static final int DRIVE_CANNOT_MAP                        = 0x8803;

   /**
    * Map drive attempted but unable to add new current directory structure.
    *
    * <p>(NWE_DRIVE_CANNOT_MAP                    = 0x8803)
    * </p>
    */
   public static final int NWE_DRIVE_CANNOT_MAP                    = 0x8803;

   /**
    * Map drive attempted with invalid path specification.
    *
    * <p>(BAD_DRIVE_BASE                          = 0x8804)
    * </p>
    */
   public static final int BAD_DRIVE_BASE                          = 0x8804;

   /**
    * Map drive attempted with invalid path specification.
    *
    * <p>(NWE_DRIVE_BAD_PATH                      = 0x8804)
    * </p>
    */
   public static final int NWE_DRIVE_BAD_PATH                      = 0x8804;

   /**
    * Attempt to receive from the selected transport failed.
    *
    * <p>(NET_READ_ERROR                          = 0x8805)
    * </p>
    */
   public static final int NET_READ_ERROR                          = 0x8805;

   /**
    * <p>(NET_RECV_ERROR                          = 0x8805)
    * </p>
    */
   public static final int NET_RECV_ERROR                          = 0x8805;

   /**
    * Attempt to receive from the selected transport failed.
    *
    * <p>(NWE_NET_RECEIVE                         = 0x8805)
    * </p>
    */
   public static final int NWE_NET_RECEIVE                         = 0x8805;

   /**
    * Network send attempted with an un-specific network error.
    *
    * <p>(UNKNOWN_NET_ERROR                       = 0x8806)
    * </p>
    */
   public static final int UNKNOWN_NET_ERROR                       = 0x8806;

   /**
    * Network send attempted with an un-specific network error.
    *
    * <p>(NWE_NET_UNKNOWN                         = 0x8806)
    * </p>
    */
   public static final int NWE_NET_UNKNOWN                         = 0x8806;

   /**
    * Server request attempted with invalid server connection slot.
    *
    * <p>(SERVER_INVALID_SLOT                     = 0x8807)
    * </p>
    */
   public static final int SERVER_INVALID_SLOT                     = 0x8807;

   /**
    * <p>(BAD_SERVER_SLOT                         = 0x8807)
    * </p>
    */
   public static final int BAD_SERVER_SLOT                         = 0x8807;

   /**
    * Server request attempted with invalid server connection slot.
    *
    * <p>(NWE_SERVER_BAD_SLOT                     = 0x8807)
    * </p>
    */
   public static final int NWE_SERVER_BAD_SLOT                     = 0x8807;

   /**
    * Attach attempted to server with no connection slots available.
    *
    * <p>(NO_SERVER_SLOTS                         = 0x8808)
    * </p>
    */
   public static final int NO_SERVER_SLOTS                         = 0x8808;

   /**
    * Attach attempted to server with no connection slots available.
    *
    * <p>(NWE_SERVER_NO_SLOTS                     = 0x8808)
    * </p>
    */
   public static final int NWE_SERVER_NO_SLOTS                     = 0x8808;

   /**
    * Attempt to send on the selected transport failed.
    *
    * <p>(NET_WRITE_ERROR                         = 0x8809)
    * </p>
    */
   public static final int NET_WRITE_ERROR                         = 0x8809;

   /**
    * <p>(CONNECTION_IN_ERROR_STATE               = 0x8809)
    * </p>
    */
   public static final int CONNECTION_IN_ERROR_STATE               = 0x8809;

   /**
    * <p>(NET_SEND_ERROR                          = 0x8809)
    * </p>
    */
   public static final int NET_SEND_ERROR                          = 0x8809;

   /**
    * Attempt to send on the selected transport failed.
    *
    * <p>(NWE_NET_SEND                            = 0x8809)
    * </p>
    */
   public static final int NWE_NET_SEND                            = 0x8809;

   /**
    * Attempted to find route to server where no route exists.
    *
    * <p>(SERVER_NO_ROUTE                         = 0x880A)
    * </p>
    */
   public static final int SERVER_NO_ROUTE                         = 0x880A;

   /**
    * Attempted to find route to server where no route exists.
    *
    * <p>(NWE_SERVER_NO_ROUTE                     = 0x880A)
    * </p>
    */
   public static final int NWE_SERVER_NO_ROUTE                     = 0x880A;

   /**
    * <p>(BAD_LOCAL_TARGET                        = 0x880B)
    * </p>
    */
   public static final int BAD_LOCAL_TARGET                        = 0x880B;

   /**
    * <p>(NWE_BAD_LOCAL_TARGET                    = 0x880B)
    * </p>
    */
   public static final int NWE_BAD_LOCAL_TARGET                    = 0x880B;

   /**
    * Attempted request with too many request fragments specified.
    *
    * <p>(TOO_MANY_REQ_FRAGS                      = 0x880C)
    * </p>
    */
   public static final int TOO_MANY_REQ_FRAGS                      = 0x880C;

   /**
    * Attempted request with too many request fragments specified.
    *
    * <p>(NWE_REQ_TOO_MANY_REQ_FRAGS              = 0x880C)
    * </p>
    */
   public static final int NWE_REQ_TOO_MANY_REQ_FRAGS              = 0x880C;

   /**
    * <p>(CONNECT_LIST_OVERFLOW                   = 0x880D)
    * </p>
    */
   public static final int CONNECT_LIST_OVERFLOW                   = 0x880D;

   /**
    * <p>(NWE_CONN_LIST_OVERFLOW                  = 0x880D)
    * </p>
    */
   public static final int NWE_CONN_LIST_OVERFLOW                  = 0x880D;

   /**
    * Attempt to receive more data than the reply buffer had room for.
    *
    * <p>(BUFFER_OVERFLOW                         = 0x880E)
    * </p>
    */
   public static final int BUFFER_OVERFLOW                         = 0x880E;

   /**
    * <p>(MORE_DATA_ERROR                         = 0x880E)
    * </p>
    */
   public static final int MORE_DATA_ERROR                         = 0x880E;

   /**
    * Attempt to receive more data than the reply buffer had room for.
    *
    * <p>(NWE_BUFFER_OVERFLOW                     = 0x880E)
    * </p>
    */
   public static final int NWE_BUFFER_OVERFLOW                     = 0x880E;

   /**
    * <p>(NO_CONN_TO_SERVER                       = 0x880F)
    * </p>
    */
   public static final int NO_CONN_TO_SERVER                       = 0x880F;

   /**
    * Attempt to get connection for a server not connected.
    *
    * <p>(NO_CONNECTION_TO_SERVER                 = 0x880F)
    * </p>
    */
   public static final int NO_CONNECTION_TO_SERVER                 = 0x880F;

   /**
    * Attempt to get connection for a server not connected.
    *
    * <p>(NWE_SERVER_NO_CONN                      = 0x880F)
    * </p>
    */
   public static final int NWE_SERVER_NO_CONN                      = 0x880F;

   /**
    * <p>(NO_ROUTER_FOUND                         = 0x8810)
    * </p>
    */
   public static final int NO_ROUTER_FOUND                         = 0x8810;

   /**
    * <p>(NWE_NO_ROUTER_FOUND                     = 0x8810)
    * </p>
    */
   public static final int NWE_NO_ROUTER_FOUND                     = 0x8810;

   /**
    * <p>(BAD_FUNC_ERROR                          = 0x8811)
    * </p>
    */
   public static final int BAD_FUNC_ERROR                          = 0x8811;

   /**
    * Attempted function call to non- existent or illegal function.
    *
    * <p>(INVALID_SHELL_CALL                      = 0x8811)
    * </p>
    */
   public static final int INVALID_SHELL_CALL                      = 0x8811;

   /**
    * Attempted function call to non- existent or illegal function.
    *
    * <p>(NWE_FUNCTION_INVALID                    = 0x8811)
    * </p>
    */
   public static final int NWE_FUNCTION_INVALID                    = 0x8811;

   /**
    * <p>(SCAN_COMPLETE                           = 0x8812)
    * </p>
    */
   public static final int SCAN_COMPLETE                           = 0x8812;

   /**
    * <p>(LIP_RESIZE_ERROR                        = 0x8812)
    * </p>
    */
   public static final int LIP_RESIZE_ERROR                        = 0x8812;

   /**
    * <p>(NWE_SCAN_COMPLETE                       = 0x8812)
    * </p>
    */
   public static final int NWE_SCAN_COMPLETE                       = 0x8812;

   /**
    * <p>(UNSUPPORTED_NAME_FORMAT_TYPE            = 0x8813)
    * </p>
    */
   public static final int UNSUPPORTED_NAME_FORMAT_TYPE            = 0x8813;

   /**
    * <p>(INVALID_DIR_HANDLE                      = 0x8813)
    * </p>
    */
   public static final int INVALID_DIR_HANDLE                      = 0x8813;

   /**
    * <p>(NWE_UNSUPPORTED_NAME_FORMAT_TYP         = 0x8813)
    * </p>
    */
   public static final int NWE_UNSUPPORTED_NAME_FORMAT_TYP         = 0x8813;

   /**
    * <p>(HANDLE_ALREADY_LICENSED                 = 0x8814)
    * </p>
    */
   public static final int HANDLE_ALREADY_LICENSED                 = 0x8814;

   /**
    * <p>(OUT_OF_CLIENT_MEMORY                    = 0x8814)
    * </p>
    */
   public static final int OUT_OF_CLIENT_MEMORY                    = 0x8814;

   /**
    * <p>(NWE_HANDLE_ALREADY_LICENSED             = 0x8814)
    * </p>
    */
   public static final int NWE_HANDLE_ALREADY_LICENSED             = 0x8814;

   /**
    * <p>(HANDLE_ALREADY_UNLICENSED               = 0x8815)
    * </p>
    */
   public static final int HANDLE_ALREADY_UNLICENSED               = 0x8815;

   /**
    * <p>(PATH_NOT_OURS                           = 0x8815)
    * </p>
    */
   public static final int PATH_NOT_OURS                           = 0x8815;

   /**
    * <p>(NWE_HANDLE_ALREADY_UNLICENSED           = 0x8815)
    * </p>
    */
   public static final int NWE_HANDLE_ALREADY_UNLICENSED           = 0x8815;

   /**
    * <p>(INVALID_NCP_PACKET_LENGTH               = 0x8816)
    * </p>
    */
   public static final int INVALID_NCP_PACKET_LENGTH               = 0x8816;

   /**
    * <p>(PATH_IS_PRINT_DEVICE                    = 0x8816)
    * </p>
    */
   public static final int PATH_IS_PRINT_DEVICE                    = 0x8816;

   /**
    * <p>(NWE_INVALID_NCP_PACKET_LENGTH           = 0x8816)
    * </p>
    */
   public static final int NWE_INVALID_NCP_PACKET_LENGTH           = 0x8816;

   /**
    * <p>(SETTING_UP_TIMEOUT                      = 0x8817)
    * </p>
    */
   public static final int SETTING_UP_TIMEOUT                      = 0x8817;

   /**
    * <p>(PATH_IS_EXCLUDED_DEVICE                 = 0x8817)
    * </p>
    */
   public static final int PATH_IS_EXCLUDED_DEVICE                 = 0x8817;

   /**
    * <p>(NWE_SETTING_UP_TIMEOUT                  = 0x8817)
    * </p>
    */
   public static final int NWE_SETTING_UP_TIMEOUT                  = 0x8817;

   /**
    * <p>(SETTING_SIGNALS                         = 0x8818)
    * </p>
    */
   public static final int SETTING_SIGNALS                         = 0x8818;

   /**
    * <p>(PATH_IS_INVALID                         = 0x8818)
    * </p>
    */
   public static final int PATH_IS_INVALID                         = 0x8818;

   /**
    * <p>(NWE_SETTING_SIGNALS                     = 0x8818)
    * </p>
    */
   public static final int NWE_SETTING_SIGNALS                     = 0x8818;

   /**
    * <p>(SERVER_CONNECTION_LOST                  = 0x8819)
    * </p>
    */
   public static final int SERVER_CONNECTION_LOST                  = 0x8819;

   /**
    * <p>(NOT_SAME_DEVICE                         = 0x8819)
    * </p>
    */
   public static final int NOT_SAME_DEVICE                         = 0x8819;

   /**
    * <p>(NWE_SERVER_CONNECTION_LOST              = 0x8819)
    * </p>
    */
   public static final int NWE_SERVER_CONNECTION_LOST              = 0x8819;

   /**
    * <p>(OUT_OF_HEAP_SPACE                       = 0x881A)
    * </p>
    */
   public static final int OUT_OF_HEAP_SPACE                       = 0x881A;

   /**
    * <p>(NWE_OUT_OF_HEAP_SPACE                   = 0x881A)
    * </p>
    */
   public static final int NWE_OUT_OF_HEAP_SPACE                   = 0x881A;

   /**
    * <p>(INVALID_SERVICE_REQUEST                 = 0x881B)
    * </p>
    */
   public static final int INVALID_SERVICE_REQUEST                 = 0x881B;

   /**
    * <p>(INVALID_SEARCH_HANDLE                   = 0x881B)
    * </p>
    */
   public static final int INVALID_SEARCH_HANDLE                   = 0x881B;

   /**
    * <p>(NWE_INVALID_SERVICE_REQUEST             = 0x881B)
    * </p>
    */
   public static final int NWE_INVALID_SERVICE_REQUEST             = 0x881B;

   /**
    * <p>(INVALID_TASK_NUMBER                     = 0x881C)
    * </p>
    */
   public static final int INVALID_TASK_NUMBER                     = 0x881C;

   /**
    * <p>(INVALID_DEVICE_HANDLE                   = 0x881C)
    * </p>
    */
   public static final int INVALID_DEVICE_HANDLE                   = 0x881C;

   /**
    * <p>(NWE_INVALID_TASK_NUMBER                 = 0x881C)
    * </p>
    */
   public static final int NWE_INVALID_TASK_NUMBER                 = 0x881C;

   /**
    * <p>(INVALID_MESSAGE_LENGTH                  = 0x881D)
    * </p>
    */
   public static final int INVALID_MESSAGE_LENGTH                  = 0x881D;

   /**
    * <p>(INVALID_SEM_HANDLE                      = 0x881D)
    * </p>
    */
   public static final int INVALID_SEM_HANDLE                      = 0x881D;

   /**
    * <p>(NWE_INVALID_MESSAGE_LENGTH              = 0x881D)
    * </p>
    */
   public static final int NWE_INVALID_MESSAGE_LENGTH              = 0x881D;

   /**
    * <p>(EA_SCAN_DONE                            = 0x881E)
    * </p>
    */
   public static final int EA_SCAN_DONE                            = 0x881E;

   /**
    * <p>(INVALID_CFG_HANDLE                      = 0x881E)
    * </p>
    */
   public static final int INVALID_CFG_HANDLE                      = 0x881E;

   /**
    * <p>(NWE_EA_SCAN_DONE                        = 0x881E)
    * </p>
    */
   public static final int NWE_EA_SCAN_DONE                        = 0x881E;

   /**
    * <p>(BAD_CONNECTION_NUMBER                   = 0x881F)
    * </p>
    */
   public static final int BAD_CONNECTION_NUMBER                   = 0x881F;

   /**
    * <p>(INVALID_MOD_HANDLE                      = 0x881F)
    * </p>
    */
   public static final int INVALID_MOD_HANDLE                      = 0x881F;

   /**
    * <p>(NWE_BAD_CONNECTION_NUMBER               = 0x881F)
    * </p>
    */
   public static final int NWE_BAD_CONNECTION_NUMBER               = 0x881F;

   /**
    * <p>(ASYN_FIRST_PASS                         = 0x8820)
    * </p>
    */
   public static final int ASYN_FIRST_PASS                         = 0x8820;

   /**
    * Attempt to open a connection to a DS tree other than the default tree.
    *
    * <p>(NWE_MULT_TREES_NOT_SUPPORTED            = 0x8820)
    * </p>
    */
   public static final int NWE_MULT_TREES_NOT_SUPPORTED            = 0x8820;

   /**
    * <p>(INVALID_DEVICE_INDEX                    = 0x8821)
    * </p>
    */
   public static final int INVALID_DEVICE_INDEX                    = 0x8821;

   /**
    * <p>(INVALID_CONN_HANDLE                     = 0x8822)
    * </p>
    */
   public static final int INVALID_CONN_HANDLE                     = 0x8822;

   /**
    * <p>(INVALID_QUEUE_ID                        = 0x8823)
    * </p>
    */
   public static final int INVALID_QUEUE_ID                        = 0x8823;

   /**
    * <p>(INVALID_PDEVICE_HANDLE                  = 0x8824)
    * </p>
    */
   public static final int INVALID_PDEVICE_HANDLE                  = 0x8824;

   /**
    * <p>(INVALID_JOB_HANDLE                      = 0x8825)
    * </p>
    */
   public static final int INVALID_JOB_HANDLE                      = 0x8825;

   /**
    * <p>(INVALID_ELEMENT_ID                      = 0x8826)
    * </p>
    */
   public static final int INVALID_ELEMENT_ID                      = 0x8826;

   /**
    * <p>(ALIAS_NOT_FOUND                         = 0x8827)
    * </p>
    */
   public static final int ALIAS_NOT_FOUND                         = 0x8827;

   /**
    * <p>(RESOURCE_SUSPENDED                      = 0x8828)
    * </p>
    */
   public static final int RESOURCE_SUSPENDED                      = 0x8828;

   /**
    * <p>(INVALID_QUEUE_SPECIFIED                 = 0x8829)
    * </p>
    */
   public static final int INVALID_QUEUE_SPECIFIED                 = 0x8829;

   /**
    * <p>(DEVICE_ALREADY_OPEN                     = 0x882A)
    * </p>
    */
   public static final int DEVICE_ALREADY_OPEN                     = 0x882A;

   /**
    * <p>(JOB_ALREADY_OPEN                        = 0x882B)
    * </p>
    */
   public static final int JOB_ALREADY_OPEN                        = 0x882B;

   /**
    * <p>(QUEUE_NAME_ID_MISMATCH                  = 0x882C)
    * </p>
    */
   public static final int QUEUE_NAME_ID_MISMATCH                  = 0x882C;

   /**
    * <p>(JOB_ALREADY_STARTED                     = 0x882D)
    * </p>
    */
   public static final int JOB_ALREADY_STARTED                     = 0x882D;

   /**
    * <p>(SPECT_DAA_TYPE_NOT_SUPPORTED            = 0x882E)
    * </p>
    */
   public static final int SPECT_DAA_TYPE_NOT_SUPPORTED            = 0x882E;

   /**
    * <p>(INVALID_ENVIR_HANDLE                    = 0x882F)
    * </p>
    */
   public static final int INVALID_ENVIR_HANDLE                    = 0x882F;

   /**
    * Internal server request attempted accross different server connections.
    *
    * <p>(NOT_SAME_CONNECTION                     = 0x8830)
    * </p>
    */
   public static final int NOT_SAME_CONNECTION                     = 0x8830;

   /**
    * Internal server request attempted across different server connections.
    *
    * <p>(NWE_CONN_NOT_SAME                       = 0x8830)
    * </p>
    */
   public static final int NWE_CONN_NOT_SAME                       = 0x8830;

   /**
    * Attempt to retrieve default connection with no primary connection set.
    *
    * <p>(PRIMARY_CONNECTION_NOT_SET              = 0x8831)
    * </p>
    */
   public static final int PRIMARY_CONNECTION_NOT_SET              = 0x8831;

   /**
    * <p>(NO_PRIMARY_SET                          = 0x8831)
    * </p>
    */
   public static final int NO_PRIMARY_SET                          = 0x8831;

   /**
    * Attempt to retrieve default connection with no primary connection set.
    *
    * <p>(NWE_CONN_PRIMARY_NOT_SET                = 0x8831)
    * </p>
    */
   public static final int NWE_CONN_PRIMARY_NOT_SET                = 0x8831;

   /**
    * <p>(KEYWORD_NOT_FOUND                       = 0x8832)
    * </p>
    */
   public static final int KEYWORD_NOT_FOUND                       = 0x8832;

   /**
    * <p>(PRINT_CAPTURE_NOT_IN_PROGRESS           = 0x8832)
    * </p>
    */
   public static final int PRINT_CAPTURE_NOT_IN_PROGRESS           = 0x8832;

   /**
    * <p>(NO_CAPTURE_SET                          = 0x8832)
    * </p>
    */
   public static final int NO_CAPTURE_SET                          = 0x8832;

   /**
    * Capture information requested on port with no capture in progress.
    *
    * <p>(NO_CAPTURE_IN_PROGRESS                  = 0x8832)
    * </p>
    */
   public static final int NO_CAPTURE_IN_PROGRESS                  = 0x8832;

   /**
    * Capture information requested on port with no capture in progress.
    *
    * <p>(NWE_PRN_CAPTURE_NOT_IN_PROGRESS         = 0x8832)
    * </p>
    */
   public static final int NWE_PRN_CAPTURE_NOT_IN_PROGRESS         = 0x8832;

   /**
    * <p>(BAD_BUFFER_LENGTH                       = 0x8833)
    * </p>
    */
   public static final int BAD_BUFFER_LENGTH                       = 0x8833;

   /**
    * Used to indicate length which caller requested on a GetDNC or SetDNC was too large.
    *
    * <p>(INVALID_BUFFER_LENGTH                   = 0x8833)
    * </p>
    */
   public static final int INVALID_BUFFER_LENGTH                   = 0x8833;

   /**
    * Used to indicate length which caller requested on a GetDNC or SetDNC was too large.
    *
    * <p>(NWE_BUFFER_INVALID_LEN                  = 0x8833)
    * </p>
    */
   public static final int NWE_BUFFER_INVALID_LEN                  = 0x8833;

   /**
    * <p>(NO_USER_NAME                            = 0x8834)
    * </p>
    */
   public static final int NO_USER_NAME                            = 0x8834;

   /**
    * <p>(NWE_USER_NO_NAME                        = 0x8834)
    * </p>
    */
   public static final int NWE_USER_NO_NAME                        = 0x8834;

   /**
    * Capture requested without having the local print spooler installed.
    *
    * <p>(NO_NETWARE_PRINT_SPOOLER                = 0x8835)
    * </p>
    */
   public static final int NO_NETWARE_PRINT_SPOOLER                = 0x8835;

   /**
    * Capture requested without having the local print spooler installed.
    *
    * <p>(NWE_PRN_NO_LOCAL_SPOOLER                = 0x8835)
    * </p>
    */
   public static final int NWE_PRN_NO_LOCAL_SPOOLER                = 0x8835;

   /**
    * Attempted function with an invalid function parameter specified.
    *
    * <p>(INVALID_PARAMETER                       = 0x8836)
    * </p>
    */
   public static final int INVALID_PARAMETER                       = 0x8836;

   /**
    * Attempted function with an invalid function parameter specified.
    *
    * <p>(NWE_PARAM_INVALID                       = 0x8836)
    * </p>
    */
   public static final int NWE_PARAM_INVALID                       = 0x8836;

   /**
    * <p>(CONFIG_FILE_OPEN_FAILED                 = 0x8837)
    * </p>
    */
   public static final int CONFIG_FILE_OPEN_FAILED                 = 0x8837;

   /**
    * <p>(NWE_CFG_OPEN_FAILED                     = 0x8837)
    * </p>
    */
   public static final int NWE_CFG_OPEN_FAILED                     = 0x8837;

   /**
    * <p>(NO_CONFIG_FILE                          = 0x8838)
    * </p>
    */
   public static final int NO_CONFIG_FILE                          = 0x8838;

   /**
    * <p>(NWE_CFG_NO_FILE                         = 0x8838)
    * </p>
    */
   public static final int NWE_CFG_NO_FILE                         = 0x8838;

   /**
    * <p>(CONFIG_FILE_READ_FAILED                 = 0x8839)
    * </p>
    */
   public static final int CONFIG_FILE_READ_FAILED                 = 0x8839;

   /**
    * <p>(NWE_CFG_READ_FAILED                     = 0x8839)
    * </p>
    */
   public static final int NWE_CFG_READ_FAILED                     = 0x8839;

   /**
    * <p>(CONFIG_LINE_TOO_LONG                    = 0x883A)
    * </p>
    */
   public static final int CONFIG_LINE_TOO_LONG                    = 0x883A;

   /**
    * <p>(NWE_CFG_LINE_TOO_LONG                   = 0x883A)
    * </p>
    */
   public static final int NWE_CFG_LINE_TOO_LONG                   = 0x883A;

   /**
    * <p>(CONFIG_LINES_IGNORED                    = 0x883B)
    * </p>
    */
   public static final int CONFIG_LINES_IGNORED                    = 0x883B;

   /**
    * <p>(NWE_CFG_LINES_IGNORED                   = 0x883B)
    * </p>
    */
   public static final int NWE_CFG_LINES_IGNORED                   = 0x883B;

   /**
    * Attempted request made with a parameter using foriegn resource.
    *
    * <p>(NOT_MY_RESOURCE                         = 0x883C)
    * </p>
    */
   public static final int NOT_MY_RESOURCE                         = 0x883C;

   /**
    * Attempted request made with a parameter using foriegn resource.
    *
    * <p>(NWE_RESOURCE_NOT_OWNED                  = 0x883C)
    * </p>
    */
   public static final int NWE_RESOURCE_NOT_OWNED                  = 0x883C;

   /**
    * <p>(DAEMON_INSTALLED                        = 0x883D)
    * </p>
    */
   public static final int DAEMON_INSTALLED                        = 0x883D;

   /**
    * <p>(NWE_DAEMON_INSTALLED                    = 0x883D)
    * </p>
    */
   public static final int NWE_DAEMON_INSTALLED                    = 0x883D;

   /**
    * Attempted load of print spooler with print spooler already installed.
    *
    * <p>(SPOOLER_INSTALLED                       = 0x883E)
    * </p>
    */
   public static final int SPOOLER_INSTALLED                       = 0x883E;

   /**
    * Attempted load of print spooler with print spooler already installed.
    *
    * <p>(NWE_PRN_SPOOLER_INSTALLED               = 0x883E)
    * </p>
    */
   public static final int NWE_PRN_SPOOLER_INSTALLED               = 0x883E;

   /**
    * <p>(CONN_TABLE_FULL                         = 0x883F)
    * </p>
    */
   public static final int CONN_TABLE_FULL                         = 0x883F;

   /**
    * Attempted to allocate a connection handle with no more local connection table entries.
    *
    * <p>(CONNECTION_TABLE_FULL                   = 0x883F)
    * </p>
    */
   public static final int CONNECTION_TABLE_FULL                   = 0x883F;

   /**
    * Attempted to allocate a connection handle with no more local connection table entries.
    *
    * <p>(NWE_CONN_TABLE_FULL                     = 0x883F)
    * </p>
    */
   public static final int NWE_CONN_TABLE_FULL                     = 0x883F;

   /**
    * <p>(CONFIG_SECTION_NOT_FOUND                = 0x8840)
    * </p>
    */
   public static final int CONFIG_SECTION_NOT_FOUND                = 0x8840;

   /**
    * <p>(NWE_CFG_SECTION_NOT_FOUND               = 0x8840)
    * </p>
    */
   public static final int NWE_CFG_SECTION_NOT_FOUND               = 0x8840;

   /**
    * <p>(BAD_TRAN_TYPE                           = 0x8841)
    * </p>
    */
   public static final int BAD_TRAN_TYPE                           = 0x8841;

   /**
    * Attempted function on a connection with an invalid transport selected.
    *
    * <p>(INVALID_TRANSPORT_TYPE                  = 0x8841)
    * </p>
    */
   public static final int INVALID_TRANSPORT_TYPE                  = 0x8841;

   /**
    * Attempted function on a connection with an invalid transport selected.
    *
    * <p>(NWE_TRAN_INVALID_TYPE                   = 0x8841)
    * </p>
    */
   public static final int NWE_TRAN_INVALID_TYPE                   = 0x8841;

   /**
    * <p>(TDS_TAG_IN_USE                          = 0x8842)
    * </p>
    */
   public static final int TDS_TAG_IN_USE                          = 0x8842;

   /**
    * <p>(NWE_TDS_TAG_IN_USE                      = 0x8842)
    * </p>
    */
   public static final int NWE_TDS_TAG_IN_USE                      = 0x8842;

   /**
    * <p>(TDS_OUT_OF_MEMORY                       = 0x8843)
    * </p>
    */
   public static final int TDS_OUT_OF_MEMORY                       = 0x8843;

   /**
    * <p>(NWE_TDS_OUT_OF_MEMORY                   = 0x8843)
    * </p>
    */
   public static final int NWE_TDS_OUT_OF_MEMORY                   = 0x8843;

   /**
    * Attempted TDS function with invalid tag.
    *
    * <p>(TDS_INVALID_TAG                         = 0x8844)
    * </p>
    */
   public static final int TDS_INVALID_TAG                         = 0x8844;

   /**
    * Attempted TDS function with invalid tag.
    *
    * <p>(NWE_TDS_INVALID_TAG                     = 0x8844)
    * </p>
    */
   public static final int NWE_TDS_INVALID_TAG                     = 0x8844;

   /**
    * Attempted TDS write with buffer that exceeded buffer.
    *
    * <p>(TDS_WRITE_TRUNCATED                     = 0x8845)
    * </p>
    */
   public static final int TDS_WRITE_TRUNCATED                     = 0x8845;

   /**
    * Attempted TDS write with buffer that exceeded buffer.
    *
    * <p>(NWE_TDS_WRITE_TRUNCATED                 = 0x8845)
    * </p>
    */
   public static final int NWE_TDS_WRITE_TRUNCATED                 = 0x8845;

   /**
    * <p>(NO_CONNECTION_TO_DS                     = 0x8846)
    * </p>
    */
   public static final int NO_CONNECTION_TO_DS                     = 0x8846;

   /**
    * <p>(NO_DIRECTORY_SERVICE_CONNECTION         = 0x8846)
    * </p>
    */
   public static final int NO_DIRECTORY_SERVICE_CONNECTION         = 0x8846;

   /**
    * Attempted request made to partially asynchronous function in busy state.
    *
    * <p>(SERVICE_BUSY                            = 0x8846)
    * </p>
    */
   public static final int SERVICE_BUSY                            = 0x8846;

   /**
    * <p>(NWE_DS_NO_CONN                          = 0x8846)
    * </p>
    */
   public static final int NWE_DS_NO_CONN                          = 0x8846;

   /**
    * Attempted request made to partially asynchronous function in busy state.
    *
    * <p>(NWE_SERVICE_BUSY                        = 0x8846)
    * </p>
    */
   public static final int NWE_SERVICE_BUSY                        = 0x8846;

   /**
    * Attempted connect failed to find any servers responding.
    *
    * <p>(NO_SERVER_ERROR                         = 0x8847)
    * </p>
    */
   public static final int NO_SERVER_ERROR                         = 0x8847;

   /**
    * Attempted connect failed to find any servers responding.
    *
    * <p>(NWE_SERVER_NOT_FOUND                    = 0x8847)
    * </p>
    */
   public static final int NWE_SERVER_NOT_FOUND                    = 0x8847;

   /**
    * Attempted function call to non-existant or not-loaded overlay.
    *
    * <p>(BAD_VLM_ERROR                           = 0x8848)
    * </p>
    */
   public static final int BAD_VLM_ERROR                           = 0x8848;

   /**
    * Attempted function call to non-existant or not-loaded overlay.
    *
    * <p>(NWE_VLM_INVALID                         = 0x8848)
    * </p>
    */
   public static final int NWE_VLM_INVALID                         = 0x8848;

   /**
    * Attempted map to network drive that was already mapped.
    *
    * <p>(NETWORK_DRIVE_IN_USE                    = 0x8849)
    * </p>
    */
   public static final int NETWORK_DRIVE_IN_USE                    = 0x8849;

   /**
    * Attempted map to network drive that was already mapped.
    *
    * <p>(NWE_DRIVE_ALREADY_MAPPED                = 0x8849)
    * </p>
    */
   public static final int NWE_DRIVE_ALREADY_MAPPED                = 0x8849;

   /**
    * Attempted map to local drive that was in use.
    *
    * <p>(LOCAL_DRIVE_IN_USE                      = 0x884A)
    * </p>
    */
   public static final int LOCAL_DRIVE_IN_USE                      = 0x884A;

   /**
    * Attempted map to local drive that was in use.
    *
    * <p>(NWE_DRIVE_LOCAL_IN_USE                  = 0x884A)
    * </p>
    */
   public static final int NWE_DRIVE_LOCAL_IN_USE                  = 0x884A;

   /**
    * Attempted map to next available drive when none were available.
    *
    * <p>(NO_DRIVES_AVAILABLE                     = 0x884B)
    * </p>
    */
   public static final int NO_DRIVES_AVAILABLE                     = 0x884B;

   /**
    * Attempted map to next available drive when none were available.
    *
    * <p>(NWE_DRIVE_NONE_AVAILABLE                = 0x884B)
    * </p>
    */
   public static final int NWE_DRIVE_NONE_AVAILABLE                = 0x884B;

   /**
    * The device is not redirected.
    *
    * <p>(DEVICE_NOT_REDIRECTED                   = 0x884C)
    * </p>
    */
   public static final int DEVICE_NOT_REDIRECTED                   = 0x884C;

   /**
    * The device is not redirected.
    *
    * <p>(NWE_DEVICE_NOT_REDIRECTED               = 0x884C)
    * </p>
    */
   public static final int NWE_DEVICE_NOT_REDIRECTED               = 0x884C;

   /**
    * Maximum number of files was reached.
    *
    * <p>(NO_MORE_SFT_ENTRIES                     = 0x884D)
    * </p>
    */
   public static final int NO_MORE_SFT_ENTRIES                     = 0x884D;

   /**
    * Maximum number of files was reached.
    *
    * <p>(NWE_FILE_MAX_REACHED                    = 0x884D)
    * </p>
    */
   public static final int NWE_FILE_MAX_REACHED                    = 0x884D;

   /**
    * Attempted unload failed.
    *
    * <p>(UNLOAD_ERROR                            = 0x884E)
    * </p>
    */
   public static final int UNLOAD_ERROR                            = 0x884E;

   /**
    * Attempted unload failed.
    *
    * <p>(NWE_UNLOAD_FAILED                       = 0x884E)
    * </p>
    */
   public static final int NWE_UNLOAD_FAILED                       = 0x884E;

   /**
    * Attempted re-use of already in use connection entry.
    *
    * <p>(IN_USE_ERROR                            = 0x884F)
    * </p>
    */
   public static final int IN_USE_ERROR                            = 0x884F;

   /**
    * Attempted re-use of already in use connection entry.
    *
    * <p>(NWE_CONN_IN_USE                         = 0x884F)
    * </p>
    */
   public static final int NWE_CONN_IN_USE                         = 0x884F;

   /**
    * Attempted request with too many reply fragments specified.
    *
    * <p>(TOO_MANY_REP_FRAGS                      = 0x8850)
    * </p>
    */
   public static final int TOO_MANY_REP_FRAGS                      = 0x8850;

   /**
    * Attempted request with too many reply fragments specified.
    *
    * <p>(NWE_REQ_TOO_MANY_REP_FRAGS              = 0x8850)
    * </p>
    */
   public static final int NWE_REQ_TOO_MANY_REP_FRAGS              = 0x8850;

   /**
    * Attempted to add a name into the name table after it was full.
    *
    * <p>(TABLE_FULL                              = 0x8851)
    * </p>
    */
   public static final int TABLE_FULL                              = 0x8851;

   /**
    * Attempted to add a name into the name table after it was full.
    *
    * <p>(NWE_NAME_TABLE_FULL                     = 0x8851)
    * </p>
    */
   public static final int NWE_NAME_TABLE_FULL                     = 0x8851;

   /**
    * Listen was posted on unopened socket.
    *
    * <p>(SOCKET_NOT_OPEN                         = 0x8852)
    * </p>
    */
   public static final int SOCKET_NOT_OPEN                         = 0x8852;

   /**
    * Listen was posted on unopened socket.
    *
    * <p>(NWE_SOCKET_NOT_OPEN                     = 0x8852)
    * </p>
    */
   public static final int NWE_SOCKET_NOT_OPEN                     = 0x8852;

   /**
    * Attempted enhanced memory operation failed.
    *
    * <p>(MEM_MGR_ERROR                           = 0x8853)
    * </p>
    */
   public static final int MEM_MGR_ERROR                           = 0x8853;

   /**
    * Attempted enhanced memory operation failed.
    *
    * <p>(NWE_MEMORY_MGR_ERROR                    = 0x8853)
    * </p>
    */
   public static final int NWE_MEMORY_MGR_ERROR                    = 0x8853;

   /**
    * An SFT3 switch occured mid-transfer.
    *
    * <p>(SFT3_ERROR                              = 0x8854)
    * </p>
    */
   public static final int SFT3_ERROR                              = 0x8854;

   /**
    * An SFT3 switch occured mid-transfer.
    *
    * <p>(NWE_SFT3_ERROR                          = 0x8854)
    * </p>
    */
   public static final int NWE_SFT3_ERROR                          = 0x8854;

   /**
    * The preferred directory server was not established but another directory server was returned.
    *
    * <p>(PREFERRED_NOT_FOUND                     = 0x8855)
    * </p>
    */
   public static final int PREFERRED_NOT_FOUND                     = 0x8855;

   /**
    * The preferred directory server was not established but another directory server was returned.
    *
    * <p>(NWE_DS_PREFERRED_NOT_FOUND              = 0x8855)
    * </p>
    */
   public static final int NWE_DS_PREFERRED_NOT_FOUND              = 0x8855;

   /**
    * Used to determine if the device is not used by VISE so pass it on to the next redirector, if any.
    *
    * <p>(DEVICE_NOT_RECOGNIZED                   = 0x8856)
    * </p>
    */
   public static final int DEVICE_NOT_RECOGNIZED                   = 0x8856;

   /**
    * Used to determine if the device is not used by VISE so pass it on to the next redirector.
    *
    * <p>(NWE_DEVICE_NOT_RECOGNIZED               = 0x8856)
    * </p>
    */
   public static final int NWE_DEVICE_NOT_RECOGNIZED               = 0x8856;

   /**
    * The network type (Bind/NDS) does not match the server version.
    *
    * <p>(BAD_NET_TYPE                            = 0x8857)
    * </p>
    */
   public static final int BAD_NET_TYPE                            = 0x8857;

   /**
    * The network type (Bind/NDS) does not match the server version.
    *
    * <p>(NWE_NET_INVALID_TYPE                    = 0x8857)
    * </p>
    */
   public static final int NWE_NET_INVALID_TYPE                    = 0x8857;

   /**
    * Generic open failure error, invalid path, access denied, etc...
    *
    * <p>(ERROR_OPENING_FILE                      = 0x8858)
    * </p>
    */
   public static final int ERROR_OPENING_FILE                      = 0x8858;

   /**
    * Generic open failure error, invalid path, access denied, etc...
    *
    * <p>(NWE_FILE_OPEN_FAILED                    = 0x8858)
    * </p>
    */
   public static final int NWE_FILE_OPEN_FAILED                    = 0x8858;

   /**
    * No preferred name specified.
    *
    * <p>(NO_PREFERRED_SPECIFIED                  = 0x8859)
    * </p>
    */
   public static final int NO_PREFERRED_SPECIFIED                  = 0x8859;

   /**
    * No preferred name specified.
    *
    * <p>(NWE_DS_PREFERRED_NOT_SPECIFIED          = 0x8859)
    * </p>
    */
   public static final int NWE_DS_PREFERRED_NOT_SPECIFIED          = 0x8859;

   /**
    * Error opening a socket.
    *
    * <p>(ERROR_OPENING_SOCKET                    = 0x885A)
    * </p>
    */
   public static final int ERROR_OPENING_SOCKET                    = 0x885A;

   /**
    * <p>(REQUESTER_FAILURE                       = 0x885A)
    * </p>
    */
   public static final int REQUESTER_FAILURE                       = 0x885A;

   /**
    * Error opening a socket.
    *
    * <p>(NWE_SOCKET_OPEN_FAILED                  = 0x885A)
    * </p>
    */
   public static final int NWE_SOCKET_OPEN_FAILED                  = 0x885A;

   /**
    * <p>(RESOURCE_ACCESS_DENIED                  = 0x885B)
    * </p>
    */
   public static final int RESOURCE_ACCESS_DENIED                  = 0x885B;

   /**
    * <p>(SIGNATURE_LEVEL_CONFLICT                = 0x8861)
    * </p>
    */
   public static final int SIGNATURE_LEVEL_CONFLICT                = 0x8861;

   /**
    * <p>(NWE_SIGNATURE_LEVEL_CONFLICT            = 0x8861)
    * </p>
    */
   public static final int NWE_SIGNATURE_LEVEL_CONFLICT            = 0x8861;

   /**
    * Process lock on conn handle failed, process ID not recognized.
    *
    * <p>(NO_LOCK_FOUND                           = 0x8862)
    * </p>
    */
   public static final int NO_LOCK_FOUND                           = 0x8862;

   /**
    * Process lock on conn handle failed, process ID not recognized.
    *
    * <p>(NWE_NO_LOCK_FOUND                       = 0x8862)
    * </p>
    */
   public static final int NWE_NO_LOCK_FOUND                       = 0x8862;

   /**
    * Process lock on conn handle failed, process lock table full.
    *
    * <p>(LOCK_TABLE_FULL                         = 0x8863)
    * </p>
    */
   public static final int LOCK_TABLE_FULL                         = 0x8863;

   /**
    * Process lock on conn handle failed, process lock table full.
    *
    * <p>(NWE_LOCK_TABLE_FULL                     = 0x8863)
    * </p>
    */
   public static final int NWE_LOCK_TABLE_FULL                     = 0x8863;

   /**
    * <p>(INVALID_MATCH_DATA                      = 0x8864)
    * </p>
    */
   public static final int INVALID_MATCH_DATA                      = 0x8864;

   /**
    * <p>(NWE_INVALID_MATCH_DATA                  = 0x8864)
    * </p>
    */
   public static final int NWE_INVALID_MATCH_DATA                  = 0x8864;

   /**
    * <p>(MATCH_FAILED                            = 0x8865)
    * </p>
    */
   public static final int MATCH_FAILED                            = 0x8865;

   /**
    * <p>(NWE_MATCH_FAILED                        = 0x8865)
    * </p>
    */
   public static final int NWE_MATCH_FAILED                        = 0x8865;

   /**
    * <p>(NO_MORE_ENTRIES                         = 0x8866)
    * </p>
    */
   public static final int NO_MORE_ENTRIES                         = 0x8866;

   /**
    * <p>(NWE_NO_MORE_ENTRIES                     = 0x8866)
    * </p>
    */
   public static final int NWE_NO_MORE_ENTRIES                     = 0x8866;

   /**
    * <p>(INSUFFICIENT_RESOURCES                  = 0x8867)
    * </p>
    */
   public static final int INSUFFICIENT_RESOURCES                  = 0x8867;

   /**
    * <p>(NWE_INSUFFICIENT_RESOURCES              = 0x8867)
    * </p>
    */
   public static final int NWE_INSUFFICIENT_RESOURCES              = 0x8867;

   /**
    * <p>(STRING_TRANSLATION                      = 0x8868)
    * </p>
    */
   public static final int STRING_TRANSLATION                      = 0x8868;

   /**
    * <p>(STRING_TRANSLATION_NEEDED               = 0x8868)
    * </p>
    */
   public static final int STRING_TRANSLATION_NEEDED               = 0x8868;

   /**
    * <p>(NWE_STRING_TRANSLATION                  = 0x8868)
    * </p>
    */
   public static final int NWE_STRING_TRANSLATION                  = 0x8868;

   /**
    * <p>(ACCESS_VIOLATION                        = 0x8869)
    * </p>
    */
   public static final int ACCESS_VIOLATION                        = 0x8869;

   /**
    * <p>(NWE_ACCESS_VIOLATION                    = 0x8869)
    * </p>
    */
   public static final int NWE_ACCESS_VIOLATION                    = 0x8869;

   /**
    * <p>(NOT_AUTHENTICATED                       = 0x886A)
    * </p>
    */
   public static final int NOT_AUTHENTICATED                       = 0x886A;

   /**
    * <p>(NWE_NOT_AUTHENTICATED                   = 0x886A)
    * </p>
    */
   public static final int NWE_NOT_AUTHENTICATED                   = 0x886A;

   /**
    * <p>(INVALID_LEVEL                           = 0x886B)
    * </p>
    */
   public static final int INVALID_LEVEL                           = 0x886B;

   /**
    * <p>(NWE_INVALID_LEVEL                       = 0x886B)
    * </p>
    */
   public static final int NWE_INVALID_LEVEL                       = 0x886B;

   /**
    * <p>(RESOURCE_LOCK_ERROR                     = 0x886C)
    * </p>
    */
   public static final int RESOURCE_LOCK_ERROR                     = 0x886C;

   /**
    * <p>(NWE_RESOURCE_LOCK                       = 0x886C)
    * </p>
    */
   public static final int NWE_RESOURCE_LOCK                       = 0x886C;

   /**
    * <p>(INVALID_NAME_FORMAT                     = 0x886D)
    * </p>
    */
   public static final int INVALID_NAME_FORMAT                     = 0x886D;

   /**
    * <p>(NWE_INVALID_NAME_FORMAT                 = 0x886D)
    * </p>
    */
   public static final int NWE_INVALID_NAME_FORMAT                 = 0x886D;

   /**
    * <p>(OBJECT_EXISTS                           = 0x886E)
    * </p>
    */
   public static final int OBJECT_EXISTS                           = 0x886E;

   /**
    * <p>(NWE_OBJECT_EXISTS                       = 0x886E)
    * </p>
    */
   public static final int NWE_OBJECT_EXISTS                       = 0x886E;

   /**
    * <p>(OBJECT_NOT_FOUND                        = 0x886F)
    * </p>
    */
   public static final int OBJECT_NOT_FOUND                        = 0x886F;

   /**
    * <p>(NWE_OBJECT_NOT_FOUND                    = 0x886F)
    * </p>
    */
   public static final int NWE_OBJECT_NOT_FOUND                    = 0x886F;

   /**
    * <p>(UNSUPPORTED_TRAN_TYPE                   = 0x8870)
    * </p>
    */
   public static final int UNSUPPORTED_TRAN_TYPE                   = 0x8870;

   /**
    * <p>(NWE_UNSUPPORTED_TRAN_TYPE               = 0x8870)
    * </p>
    */
   public static final int NWE_UNSUPPORTED_TRAN_TYPE               = 0x8870;

   /**
    * <p>(INVALID_STRING_TYPE                     = 0x8871)
    * </p>
    */
   public static final int INVALID_STRING_TYPE                     = 0x8871;

   /**
    * <p>(NWE_INVALID_STRING_TYPE                 = 0x8871)
    * </p>
    */
   public static final int NWE_INVALID_STRING_TYPE                 = 0x8871;

   /**
    * <p>(INVALID_OWNER                           = 0x8872)
    * </p>
    */
   public static final int INVALID_OWNER                           = 0x8872;

   /**
    * <p>(NWE_INVALID_OWNER                       = 0x8872)
    * </p>
    */
   public static final int NWE_INVALID_OWNER                       = 0x8872;

   /**
    * <p>(UNSUPPORTED_AUTHENTICATOR               = 0x8873)
    * </p>
    */
   public static final int UNSUPPORTED_AUTHENTICATOR               = 0x8873;

   /**
    * <p>(NWE_UNSUPPORTED_AUTHENTICATOR           = 0x8873)
    * </p>
    */
   public static final int NWE_UNSUPPORTED_AUTHENTICATOR           = 0x8873;

   /**
    * <p>(IO_PENDING                              = 0x8874)
    * </p>
    */
   public static final int IO_PENDING                              = 0x8874;

   /**
    * <p>(NWE_IO_PENDING                          = 0x8874)
    * </p>
    */
   public static final int NWE_IO_PENDING                          = 0x8874;

   /**
    * <p>(INVALID_DRIVE_NUM                       = 0x8875)
    * </p>
    */
   public static final int INVALID_DRIVE_NUM                       = 0x8875;

   /**
    * <p>(NWE_INVALID_DRIVE_NUMBER                = 0x8875)
    * </p>
    */
   public static final int NWE_INVALID_DRIVE_NUMBER                = 0x8875;

   /**
    * <p>(SVC_ALREADY_REGISTERED                  = 0x8880)
    * </p>
    */
   public static final int SVC_ALREADY_REGISTERED                  = 0x8880;

   /**
    * <p>(SVC_REGISTRY_FULL                       = 0x8881)
    * </p>
    */
   public static final int SVC_REGISTRY_FULL                       = 0x8881;

   /**
    * <p>(SVC_NOT_REGISTERED                      = 0x8882)
    * </p>
    */
   public static final int SVC_NOT_REGISTERED                      = 0x8882;

   /**
    * <p>(OUT_OF_RESOURCES                        = 0x8883)
    * </p>
    */
   public static final int OUT_OF_RESOURCES                        = 0x8883;

   /**
    * <p>(RESOLVE_SVC_FAILED                      = 0x8884)
    * </p>
    */
   public static final int RESOLVE_SVC_FAILED                      = 0x8884;

   /**
    * <p>(CONNECT_FAILED                          = 0x8885)
    * </p>
    */
   public static final int CONNECT_FAILED                          = 0x8885;

   /**
    * <p>(PROTOCOL_NOT_BOUND                      = 0x8886)
    * </p>
    */
   public static final int PROTOCOL_NOT_BOUND                      = 0x8886;

   /**
    * <p>(AUTHENTICATION_FAILED                   = 0x8887)
    * </p>
    */
   public static final int AUTHENTICATION_FAILED                   = 0x8887;

   /**
    * <p>(INVALID_AUTHEN_HANDLE                   = 0x8888)
    * </p>
    */
   public static final int INVALID_AUTHEN_HANDLE                   = 0x8888;

   /**
    * <p>(AUTHEN_HANDLE_ALREADY_EXISTS            = 0x8889)
    * </p>
    */
   public static final int AUTHEN_HANDLE_ALREADY_EXISTS            = 0x8889;

   /**
    * <p>(DIFF_OBJECT_ALREADY_AUTHEN              = 0x8890)
    * </p>
    */
   public static final int DIFF_OBJECT_ALREADY_AUTHEN              = 0x8890;

   /**
    * <p>(REQUEST_NOT_SERVICEABLE                 = 0x8891)
    * </p>
    */
   public static final int REQUEST_NOT_SERVICEABLE                 = 0x8891;

   /**
    * <p>(AUTO_RECONNECT_SO_REBUILD               = 0x8892)
    * </p>
    */
   public static final int AUTO_RECONNECT_SO_REBUILD               = 0x8892;

   /**
    * <p>(AUTO_RECONNECT_RETRY_REQUEST            = 0x8893)
    * </p>
    */
   public static final int AUTO_RECONNECT_RETRY_REQUEST            = 0x8893;

   /**
    * <p>(ASYNC_REQUEST_IN_USE                    = 0x8894)
    * </p>
    */
   public static final int ASYNC_REQUEST_IN_USE                    = 0x8894;

   /**
    * <p>(ASYNC_REQUEST_CANCELED                  = 0x8895)
    * </p>
    */
   public static final int ASYNC_REQUEST_CANCELED                  = 0x8895;

   /**
    * <p>(SESS_SVC_ALREADY_REGISTERED             = 0x8896)
    * </p>
    */
   public static final int SESS_SVC_ALREADY_REGISTERED             = 0x8896;

   /**
    * <p>(SESS_SVC_NOT_REGISTERED                 = 0x8897)
    * </p>
    */
   public static final int SESS_SVC_NOT_REGISTERED                 = 0x8897;

   /**
    * <p>(PREVIOUSLY_AUTHENTICATED                = 0x8899)
    * </p>
    */
   public static final int PREVIOUSLY_AUTHENTICATED                = 0x8899;

   /**
    * <p>(RESOLVE_SVC_PARTIAL                     = 0x889A)
    * </p>
    */
   public static final int RESOLVE_SVC_PARTIAL                     = 0x889A;

   /**
    * <p>(NO_DEFAULT_SPECIFIED                    = 0x889B)
    * </p>
    */
   public static final int NO_DEFAULT_SPECIFIED                    = 0x889B;

   /**
    * <p>(HOOK_REQUEST_NOT_HANDLED                = 0x889C)
    * </p>
    */
   public static final int HOOK_REQUEST_NOT_HANDLED                = 0x889C;

   /**
    * <p>(HOOK_REQUEST_BUSY                       = 0x889D)
    * </p>
    */
   public static final int HOOK_REQUEST_BUSY                       = 0x889D;

   /**
    * <p>(HOOK_REQUEST_QUEUED                     = 0x889D)
    * </p>
    */
   public static final int HOOK_REQUEST_QUEUED                     = 0x889D;

   /**
    * <p>(AUTO_RECONNECT_SO_IGNORE                = 0x889E)
    * </p>
    */
   public static final int AUTO_RECONNECT_SO_IGNORE                = 0x889E;

   /**
    * <p>(ASYNC_REQUEST_NOT_IN_USE                = 0x889F)
    * </p>
    */
   public static final int ASYNC_REQUEST_NOT_IN_USE                = 0x889F;

   /**
    * <p>(AUTO_RECONNECT_FAILURE                  = 0x88A0)
    * </p>
    */
   public static final int AUTO_RECONNECT_FAILURE                  = 0x88A0;

   /**
    * <p>(NET_ERROR_ABORT_APPLICATION             = 0x88A1)
    * </p>
    */
   public static final int NET_ERROR_ABORT_APPLICATION             = 0x88A1;

   /**
    * <p>(NET_ERROR_SUSPEND_APPLICATION           = 0x88A2)
    * </p>
    */
   public static final int NET_ERROR_SUSPEND_APPLICATION           = 0x88A2;

   /**
    * <p>(NET_ERROR_ABORTED_PROCESS_GROUP         = 0x88A3)
    * </p>
    */
   public static final int NET_ERROR_ABORTED_PROCESS_GROUP         = 0x88A3;

   /**
    * <p>(NET_ERROR_PASSWORD_HAS_EXPIRED          = 0x88A5)
    * </p>
    */
   public static final int NET_ERROR_PASSWORD_HAS_EXPIRED          = 0x88A5;

   /**
    * <p>(NET_ERROR_NETWORK_INACTIVE              = 0x88A6)
    * </p>
    */
   public static final int NET_ERROR_NETWORK_INACTIVE              = 0x88A6;

   /**
    * <p>(SHELL_FAILURE                           = 0x88FF)
    * </p>
    */
   public static final int SHELL_FAILURE                           = 0x88FF;

   /**
    * <p>(VLM_FAILURE                             = 0x88FF)
    * </p>
    */
   public static final int VLM_FAILURE                             = 0x88FF;

   /**
    * <p>(NWE_REQUESTER_FAILURE                   = 0x88FF)
    * </p>
    */
   public static final int NWE_REQUESTER_FAILURE                   = 0x88FF;
}


