/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/jncp/NSIException.java $
  $Revision: 7 $
  $Modtime: 1/28/00 11:07a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

/* @(#)NSIException.java        1.00  96/11/11    NSI Development Team
 *
 */

package com.novell.service.jncp;

/**
 * All non-runtime NSI exceptions inherit from NSIException<p>
 *
 * @version     1.00, 23 Oct 1996
 * @author      NSI Development Team
 */
public class NSIException
   extends RuntimeException
   implements NSIExceptionInterface
{
   protected int ccode;

   /**
    * The original exception that caused this NSIException to
    * be thrown. This field is set if there is additional
    * information that that could be obtained from the original
    * exception, or if the original exception could not be
    * mapped to a subclass of NSIException.
    * Can be null.
    * You should access and manipulate this field
    * through its get and set methods.
    *
    * @see #getRootCause
    * @see #setRootCause
    */
   protected Throwable rootException;


   /**
    * Constructs an NSIException with no detail message.
    * A detail message is a String that describes this particular exception.
    */
   public NSIException()
   {
      this (0);
   }

   /**
    * Constructs an NSIException with the specified detail message.
    * A detail message is a String that describes this particular exception.
    * @param s the detail message
    */
   public NSIException (String s)
   {
      super (s);
   }

   /**
    * Constructs an NSIException with a ccode-based generic detail message
    * and sets the root cause.
    * A detail message is a String that describes this particular exception.
    * @param c                   the ccode value
    * @param rootException       the root exception
    *
    * @depricated    use getter/setter methods
    */
   public NSIException (String s, Throwable rootException)
   {
      super(s);
      this.rootException = rootException;
   }

   /**
    * Constructs an NSIException with a ccode-based generic detail message.
    * A detail message is a String that describes this particular exception.
    * @param c the ccode value
    *
    * @depricated    use getter/setter methods
    */
   public NSIException(int c)
   {
      super("ccode = " + c + " (0x" + Integer.toHexString(c) + ")");
      ccode = c;
   }

   /**
    *
    */
   public NSIException (
         String s,
         int ccode,
         Throwable rootException)
   {
      super (s);

      this.ccode = ccode;
      this.rootException = rootException;
   }

   /**
    * Returns the stored ccode of the exception.
    */
   public int getCCode()
   {
      return ccode;
   }

   /**
    * Sets the stored ccode of the exception.
    */
   public void setCCode(int ccode)
   {
      this.ccode = ccode;
   }

   /**
    * Retrieves the root cause of this NSIException, if any.
    * The root cause of a nsi exception is used when the service provider
    * wants to indicate to the caller a non-nsi related exception
    * but at the same time want to use the NSIException structure
    * to indicate how far the naming operation proceeded.
    *
    * @return The possibly null exception that caused this nsi
    *    exception. If null, it means no root cause has been
    *      set for this nsi exception.
    *
    * @see #setRootCause
    * @see rootException
    */
   public Throwable getRootCause ()
   {
      return (rootException);
   }

   /**
    * Records that the root cause of this NSIException.
    * If <tt>e</tt> is <tt>this</tt>, this method does not do anything.
    *
    * @param e The possibly null exception that caused the nsi
    *     operation to fail. If null, it means this nsi
    *     exception has no root cause.
    *
    * @see #getRootCause
    * @see rootException
    */
   public void setRootCause (
         Throwable e)
   {
      if (e != this)
      {
         rootException = e;
      }
   }

   /**
    * Generates the string representation of this exception.
    * The string representation consists of the root cause (if any),
    * the remaining name (if it is not null),
    * and the explanation parameter from in the constructor
    * (if it is not null).
    * This string is used for debugging and not meant to be interpreted
    * programmatically.
    *
    * @return The non-null string containing the string representation
    * of this exception.
    */
   public String toString ()
   {
      StringBuffer answer = new StringBuffer ();

      if (rootException != null)
      {
         answer.append (
                     "[Root exception: " + rootException.toString() + "]");
      }
      answer.append (super.toString ());
      return (new String (answer));

   } /* toString () */

} /* NSIException */


