
/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#if !defined (NETATTRIBUTEVALUEFACTORYJNI_H)
#define NETATTRIBUTEVALUEFACTORYJNI_H


#if !defined (JNI_H)
#  include <jni.h>
#endif

#if !defined (NTYPES_H)
#  include <ntypes.h>
#endif

#if !defined (NWDSBUFT_H)
#  include <nwdsbuft.h>
#endif

#include "NetUnknownJNI.h"
#include "NetDistinguishedNameJNI.h"
#include "NetCaseExactStringJNI.h"
#include "NetCaseIgnoreStringJNI.h"
#include "NetClassNameJNI.h"
#include "NetNumericStringJNI.h"
#include "NetPrintableStringJNI.h"
#include "NetTelephoneNumberJNI.h"
#include "NetEMailAddressJNI.h"
#include "NetBackLinkJNI.h"
#include "NetBooleanJNI.h"
#include "NetFAXNumberJNI.h"
#include "NetCounterJNI.h"
#include "NetIntegerJNI.h"
#include "NetIntervalJNI.h"
#include "NetTimeJNI.h"
#include "NetNetAddressJNI.h"
#include "NetTypedNameJNI.h"
#include "NetObjectACLJNI.h"
#include "NetStreamJNI.h"
#include "NetOctetStringJNI.h"
#include "NetPathJNI.h"
#include "NetPostalAddressJNI.h"
#include "NetHoldJNI.h"
#include "NetReplicaPointerJNI.h"
#include "NetTimestampJNI.h"
#include "NetCaseIgnoreListJNI.h"
#include "NetOctetListJNI.h"


#define NETSYNTAXPKG    "com/novell/service/nds/net/"
#define NETPKG          "com/novell/service/jncpv2r/net/"
#define JNCPPKG         "com/novell/service/jncp/"


/* public final class NetAttrRecord implements Serializable
 * {
 *    //
 *    private String name;
 *    private int syntaxId;
 *    private NetAttributeValue[] values;
 * }
 */
typedef struct tagNetAttributeValueFactory
{
   jclass cls;

   jclass clsNetAttributeValue;

   // sNetAttributeValues
   pNetUnknown sNetUnknown;
   pNetDistinguishedName sNetDistinguishedName;
   pNetCaseExactString sNetCaseExactString;
   pNetCaseIgnoreString sNetCaseIgnoreString;
   pNetClassName sNetClassName;
   pNetNumericString sNetNumericString;
   pNetPrintableString sNetPrintableString;
   pNetTelephoneNumber sNetTelephoneNumber;
   pNetEMailAddress sNetEMailAddress;
   pNetBackLink sNetBackLink;
   pNetBoolean sNetBoolean;
   pNetFAXNumber sNetFAXNumber;
   pNetCounter sNetCounter;
   pNetInteger sNetInteger;
   pNetInterval sNetInterval;
   pNetTime sNetTime;
   pNetNetAddress sNetNetAddress;
   pNetTypedName sNetTypedName;
   pNetObjectACL sNetObjectACL;
   pNetStream sNetStream;
   pNetOctetString sNetOctetString;
   pNetPath sNetPath;
   pNetPostalAddress sNetPostalAddress;
   pNetHold sNetHold;
   pNetReplicaPointer sNetReplicaPointer;
   pNetTimestamp sNetTimestamp;
   pNetCaseIgnoreList sNetCaseIgnoreList;
   pNetOctetList sNetOctetList;

} NetAttributeValueFactory, N_FAR *pNetAttributeValueFactory;


N_EXTERN_FUNC_C (pNetAttributeValueFactory)
NetAttributeValueFactoryCreateStruct
(
   JNIEnv *env
);

N_EXTERN_FUNC_C (jobject)
NetAttributeValueFactoryCreateAttributeValue
(
   JNIEnv *env,
   pNetAttributeValueFactory sNetAttributeValueFactory,
   pBuf_T buf,
   nuint32 syntaxId
);

N_EXTERN_FUNC_C (jbyteArray)
NetAttributeValueFactory_toByteArray
(
   JNIEnv *env,
   nptr cAttrVal,
   nuint32 syntaxId,
   nuint32  cAttrValSize
);

N_EXTERN_FUNC_C (nptr)
NetAttributeValueFactory_toCStruct
(
   JNIEnv *env,
   jbyteArray value,
   nuint32 syntaxId
);

#endif /* NETATTRIBUTEVALUEFACTORYJNI_H */


