
/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#if !defined (NETBACKLINKJNI_H)
#define NETBACKLINKJNI_H


#if !defined (JNI_H)
#  include <jni.h>
#endif

#if !defined (NTYPES_H)
#  include <ntypes.h>
#endif

#if !defined (NWDSBUFT_H)
#  include <nwdsbuft.h>
#endif

#if !defined (_Included_com_novell_service_nds_net_NetBackLink)
#  include "com_novell_service_nds_net_NetBackLink.h"
#endif


#define NETSYNTAXPKG    "com/novell/service/nds/net/"
#define NETPKG          "com/novell/service/jncpv2r/net/"
#define JNCPPKG         "com/novell/service/jncp/"


/* public final class NetAttrRecord implements Serializable
 * {
 *    //
 *    private String name;
 *    private int syntaxId;
 *    private NetAttributeValue[] values;
 * }
 */
typedef struct tagNetBackLink
{
   jclass cls;

   struct
   {
      //
      jfieldID remoteId;
      jfieldID objectName;

   } ID;

} NetBackLink, N_FAR *pNetBackLink;


N_EXTERN_FUNC_C (pNetBackLink)
NetBackLinkCreateStruct
(
   JNIEnv *env
);

N_EXTERN_FUNC_C (jobject)
NetBackLinkCreate
(
   JNIEnv *env,
   pNetBackLink sNetBackLink,
   pBuf_T buf
);

N_EXTERN_FUNC_C (jbyteArray)
NetBackLink_toByteArray
(
   JNIEnv *env,
   nptr cValue,
   nuint32 cLength
);

N_GLOBAL_FUNC_C (nptr) 
NetBackLink_toCStruct
(
   JNIEnv      *env, 
   jbyteArray  value
);

#endif /* NETBACKLINKJNI_H */


