/* **************************************************************************

  %name:  jncp.h %
  %version: 6 %
  %date_modified:  Tue Feb 24 13:29:59 1998 %

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#ifndef __jncpv2r_H
#define __jncpv2r_H

#include <ntypes.h>

#define JNCP_PRODUCT_STRING \
   "Native Wrapper for Java Class Libraries for NetWare"

#define JNCP_VERSION_STRING "VeRsIoN=1.2.0"

#define JNCP_COPYRIGHT_STRING \
   "CoPyRiGhT=Copyright 1997-1999 Novell, Inc.  All rights reserved."

#ifdef N_PLAT_NLM

//
// 1 if aliasFunctions holds ptrs to MakeAndLockAlias, DeleteAndUnLockAlias
// 0 if the contents of aliasFunctions is undefined
//
N_EXTERN_VAR int _usingAliasFunctions;

typedef nptr (*alias_func_t)(nptr, nint32);

//
// if _aliasFunctions is 1, then:
// item 0 holds MakeAndLockAlias func ptr
// item 1 holds DeleteAndUnLockAlias func ptr
//
N_EXTERN_VAR alias_func_t _aliasFunctions[];


//
// 1 if netwareFunctions holds ptrs to kEnterNetWare, kExitNetWare
// 0 if the contents of netwareFunctions is undefined
//
N_EXTERN_VAR int _usingNetWareFunctions;

typedef void (*netware_func_t)();

//
// if _netwareFunctions is 1, then:
// item 0 holds kEnterNetWare func ptr
// item 1 holds kExitNetWare func ptr
//
N_EXTERN_VAR netware_func_t _netwareFunctions[];


N_EXTERN_FUNC(void) __InitAliasFunctions(void);
N_EXTERN_FUNC(void) __CleanupAliasFunctions(void);
N_EXTERN_FUNC(void) __InitNetWareFunctions(void);
N_EXTERN_FUNC(void) __CleanupNetWareFunctions(void);
N_EXTERN_FUNC(void) __InitGlobalThreadGroup(void);
N_EXTERN_FUNC(void) __CleanupGlobalThreadGroup(void);
N_EXTERN_FUNC(int)  GimmeNewThreadGroupAndUserPlease(void);
N_GLOBAL_FUNC(void) DoneWithThisThreadGroupAndUserThankYou(nint threadGroup);
N_EXTERN_FUNC(int)  shutDownThreadGroup(int threadGroup);

N_EXTERN_VAR _globalThreadGroup;

#endif // N_PLAT_NLM

N_EXTERN_FUNC(void) __InitNWCalls(void);
N_EXTERN_FUNC(void) __CleanupNWCalls(void);

#endif // __jncpv2r_H
