
/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/


#include <sys_api.h>

#include <stdlib.h>

#include <jni.h>

#include "com_novell_service_jncpv2r_net_NetEntryInfoEnumerator.h"

#include <ntypes.h>
#include "JNIString.h"
#include <nwnet.h>


#if defined (N_PLAT_NLM)
#  include "nlmsem.h"
#endif


#include "NetEntryInfoJNI.h"
#include "NetAttributeValueFactoryJNI.h"

#include "jdsEntryList.h"


#ifdef __cplusplus
extern "C" {
#endif


/***** com_novell_service_jncpv2r_net_NetJNI.h ****************************/

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    JDSPutAttributeValue
 * Signature: (IIII[B)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_JDSPutAttributeValue
(
   JNIEnv *env,
   jclass unused,
   /*in*/   jint           threadGroup,
   /*in*/   jint           context,
   /*in*/   jint           buf,
   /*in*/   jint           syntaxId,
   /*in*/   jbyteArray     attributeValue
)
{
   // JNI variables
   // NWNet variables
   NWDSCCODE ccode;
   nptr  cAttrVal = NULL;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (N_SUCCESS != ccode)
   {
      goto EXIT;
   }
#endif

   if (NULL != attributeValue)
   {
      cAttrVal = NetAttributeValueFactory_toCStruct (env, attributeValue, syntaxId);
   }

   ccode = NWDSPutAttrVal (
          (NWDSContextHandle) context,
                     (pBuf_T) buf,
                              syntaxId,
                              cAttrVal);

   if (NULL != cAttrVal)
   {
      sysFree (cAttrVal);
   }

#ifdef N_PLAT_NLM
   unwrapContext (saveThreadGroup);

EXIT:
#endif

   return (ccode);

} /* JDSPutAttributeValue () */

#ifdef __cplusplus
}
#endif


