
/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/


#include <jni.h>

#include <ntypes.h>

#include "JNIString.h"

#include <nwdserr.h>
#include <nwdsbuft.h>
#include <nwdsdsa.h>

#ifdef N_PLAT_NLM
#  include "nlmsem.h"
#endif


#include "jncpWire.h"
#include "jdsAttrRecordList.h"

#include "com_novell_service_jncpv2r_net_NetJNI.h"


#define NETPKG         "com/novell/service/jncpv2r/net/"
#define JNCPPKG        "com/novell/service/jncp/"


/***** com_novell_service_jncpv2r_net_NetJNI.h ****************************/

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    JDSReadObjectAttributes
 * Signature: (IIILjava/lang/String;III[[Lcom/novell/service/jncpv2r/net/NetAttrRecord;)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_net_NetJNI_JDSReadObjectAttributes
(
   JNIEnv *env,
   jclass unused,
   /*in*/   jint           threadGroup,
   /*in*/   jint           context,
   /*in*/   jint           sNetAttrRecord,
   /*in*/   jstring        objectName,
   /*in*/   jint           infoType,
   /*in*/   jint           attrNames,
   /*in*/   jint           bufferSize,
   /*out*/  jobjectArray   records
)
{
   // JNI variables
   // NWNet variables
   NWDSCCODE ccode;
   unicode cObjectName[MAX_DN_CHARS+1];
   nbool8 cAllAttrs;
   nint32 cIterationHandle = NO_MORE_ITERATIONS;
   // NJCL variables
   JDSList list = NULL;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext (&saveThreadGroup, threadGroup, context);
   if (N_SUCCESS != ccode)
   {
      goto EXIT;
   }
#endif

   // Convert Java variable to 'C' variable
   jstring2unicode (env, objectName, cObjectName, sizeof(cObjectName));

   list = jdsAttrRecordListCreate (
                                       env,
                      (pNetAttrRecord) sNetAttrRecord,
                                       infoType);

   cAllAttrs = (nbool8)(0 == attrNames) ? N_TRUE : N_FALSE;

   do
   {
      // NWNet variables
      pBuf_T cAttrRecords;

      // Alloc Buf_T
      if (N_SUCCESS != (ccode = NWDSAllocBuf (bufferSize, &cAttrRecords)))
      {
         goto CLEANUP;
      }

      // Make C API call
      ccode = NWDSRead (
                  (NWDSContextHandle) context,
                  (pnstr8) cObjectName,
                  (nuint32) infoType,
                  cAllAttrs,
                  (pBuf_T) attrNames,
                  &cIterationHandle,
                  (pBuf_T) cAttrRecords);

      list->AddBuffer (list, cAttrRecords);

   } while (N_SUCCESS == ccode && NO_MORE_ITERATIONS != cIterationHandle);

   if (N_SUCCESS == ccode)
   {
      (*env)->SetObjectArrayElement (
                                       env,
									   records,
									   0,
									   list->GetObjects (list));
   }
   else if (ERR_NO_SUCH_ATTRIBUTE == ccode)
   {
      ccode = N_SUCCESS;
      (*env)->SetObjectArrayElement (
                                       env,
									   records,
									   0,
									   list->Empty (list));
   }

CLEANUP:

   list->Destroy (&list);

#ifdef N_PLAT_NLM
   unwrapContext (saveThreadGroup);

EXIT:
#endif

   return (ccode);

} /* NJCLListEntries () */


