
/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/


#include <sys_api.h>

#include <jni.h>

#include <ntypes.h>

#include "jncpWire.h"

#include "NetEntryInfoJNI.h"


/* public final class NetEntryInfo implements NdsObjectInfo, Serializable
 * {
 *    //
 *    private boolean dereference;
 *
 *    //
 *    private int outputFlags;
 *    private int entryId;
 *    private int entryFlags;
 *    private int subordinateCount;
 *    private int modificationTime;
 *    private int modificationTimestamp;
 *    private int creationTimestamp;
 *    private int partitionRootId;
 *    private int parentId;
 *    private int revisionCount;
 *    private int replicaType;
 *    private String baseClass;
 *    private String entryRDN;
 *    private String entryDN;
 *    private String partitionRootDN;
 *    private String parentDN;
 *    private int purgeTime;
 *    private String dereferenceBaseClass;
 *    private int replicaNumber;
 *    private int replicaState;
 *    private String federationBoundary;
 *    private String schemaBoundary;
 * }
 */

#ifdef __cplusplus
extern "C" {
#endif


/***** NetEntryInfo.h *****************************************************/

N_GLOBAL_FUNC_C (pNetEntryInfo)
NetEntryInfoCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetEntryInfo;
   //NJCL variables
   pNetEntryInfo sNetEntryInfo;

   clsNetEntryInfo = (*env)->FindClass (env, NETPKG "NetEntryInfo");
   clsNetEntryInfo = (*env)->NewGlobalRef (env, clsNetEntryInfo);

   sNetEntryInfo = (pNetEntryInfo) sysMalloc (sizeof (NetEntryInfo));

   // assign jclass variables
   sNetEntryInfo->cls = clsNetEntryInfo;

   // assign jfieldID variables
   sNetEntryInfo->ID.dereference = (*env)->GetFieldID (env, clsNetEntryInfo, "dereference", "Z");

   sNetEntryInfo->ID.outputFlags = (*env)->GetFieldID (env, clsNetEntryInfo, "outputFlags", "I");
   sNetEntryInfo->ID.entryId = (*env)->GetFieldID (env, clsNetEntryInfo, "entryId", "I");
   sNetEntryInfo->ID.entryFlags = (*env)->GetFieldID (env, clsNetEntryInfo, "entryFlags", "I");
   sNetEntryInfo->ID.subordinateCount = (*env)->GetFieldID (env, clsNetEntryInfo, "subordinateCount", "I");
   sNetEntryInfo->ID.modificationTime = (*env)->GetFieldID (env, clsNetEntryInfo, "modificationTime", "I");

   sNetEntryInfo->ID.modificationTimestamp = (*env)->GetFieldID (env, clsNetEntryInfo, "modificationTimestamp", "I");
   sNetEntryInfo->ID.creationTimestamp = (*env)->GetFieldID (env, clsNetEntryInfo, "creationTimestamp", "I");

   sNetEntryInfo->ID.partitionRootId = (*env)->GetFieldID (env, clsNetEntryInfo, "partitionRootId", "I");
   sNetEntryInfo->ID.parentId = (*env)->GetFieldID (env, clsNetEntryInfo, "parentId", "I");
   sNetEntryInfo->ID.revisionCount = (*env)->GetFieldID (env, clsNetEntryInfo, "revisionCount", "I");
   sNetEntryInfo->ID.replicaType = (*env)->GetFieldID (env, clsNetEntryInfo, "replicaType", "I");
   sNetEntryInfo->ID.baseClass = (*env)->GetFieldID (env, clsNetEntryInfo, "baseClass", "Ljava/lang/String;");
   sNetEntryInfo->ID.entryRDN = (*env)->GetFieldID (env, clsNetEntryInfo, "entryRDN", "Ljava/lang/String;");
   sNetEntryInfo->ID.entryDN = (*env)->GetFieldID (env, clsNetEntryInfo, "entryDN", "Ljava/lang/String;");
   sNetEntryInfo->ID.partitionRootDN = (*env)->GetFieldID (env, clsNetEntryInfo, "partitionRootDN", "Ljava/lang/String;");
   sNetEntryInfo->ID.parentDN = (*env)->GetFieldID (env, clsNetEntryInfo, "parentDN", "Ljava/lang/String;");
   sNetEntryInfo->ID.purgeTime = (*env)->GetFieldID (env, clsNetEntryInfo, "purgeTime", "I");
   sNetEntryInfo->ID.dereferenceBaseClass = (*env)->GetFieldID (env, clsNetEntryInfo, "dereferenceBaseClass", "Ljava/lang/String;");
   sNetEntryInfo->ID.replicaNumber = (*env)->GetFieldID (env, clsNetEntryInfo, "replicaNumber", "I");
   sNetEntryInfo->ID.replicaState = (*env)->GetFieldID (env, clsNetEntryInfo, "replicaState", "I");
   sNetEntryInfo->ID.federationBoundary = (*env)->GetFieldID (env, clsNetEntryInfo, "federationBoundary", "Ljava/lang/String;");
   sNetEntryInfo->ID.schemaBoundary = (*env)->GetFieldID (env, clsNetEntryInfo, "schemaBoundary", "Ljava/lang/String;");

   return (sNetEntryInfo);

} /* NetEntryInfoCreateIDs () */


N_GLOBAL_FUNC_C (jobject)
NetEntryInfoCreate
(
   JNIEnv *env,
   pNetEntryInfo sNetEntryInfo,
   pBuf_T buf
)
{
//   pnstr8 curPos = *buf;
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;
   nuint32 outputFlags;

   jobject netEntryInfo = (*env)->AllocObject (env, sNetEntryInfo->cls);

   {
      NAlign32 (curPos);
      (*env)->SetIntField (
                              env,
                              netEntryInfo,
                              sNetEntryInfo->ID.outputFlags,
                        (jint)(outputFlags = jncpGetInt32 (env, curPos, limit)));
   }

   if (outputFlags & DSI_ENTRY_ID)
   {
      (*env)->SetIntField (
                              env,
                              netEntryInfo,
                              sNetEntryInfo->ID.entryId,
                       (jint) jncpGetInt32 (env, curPos, limit));
   }

   if (outputFlags & DSI_ENTRY_FLAGS)
   {
      (*env)->SetIntField (
                              env,
                              netEntryInfo,
                              sNetEntryInfo->ID.entryFlags,
                       (jint) jncpGetInt32 (env, curPos, limit));
   }

   if (outputFlags & DSI_SUBORDINATE_COUNT)
   {
      (*env)->SetIntField (
                              env,
                              netEntryInfo,
                              sNetEntryInfo->ID.subordinateCount,
                       (jint) jncpGetInt32 (env, curPos, limit));
   }

   if (outputFlags & DSI_MODIFICATION_TIME)
   {
      (*env)->SetIntField (env, netEntryInfo, sNetEntryInfo->ID.modificationTime, (jint) jncpGetInt32 (env, curPos, limit));
   }

   if (outputFlags & (DSI_MODIFICATION_TIMESTAMP | DSI_CREATION_TIMESTAMP))
   {

//NOTE: !implemented

      if (outputFlags & DSI_MODIFICATION_TIMESTAMP)
      {
         jncpSkipInt32 (env, curPos, limit);
         jncpSkipInt16 (env, curPos, limit);
         jncpSkipInt16 (env, curPos, limit);
//         entryIdID = (*env)->GetFieldID (env, clsNetEntryInfo, "entryId", "I");
//         (*env)->SetIntField (env, netEntryInfo, entryIdID, (jint) entryId);
      }

      if (outputFlags & DSI_CREATION_TIMESTAMP)
      {
         jncpSkipInt32 (env, curPos, limit);
         jncpSkipInt16 (env, curPos, limit);
         jncpSkipInt16 (env, curPos, limit);
//         entryIdID = (*env)->GetFieldID (env, clsNetEntryInfo, "entryId", "I");
//         (*env)->SetIntField (env, netEntryInfo, entryIdID, (jint) entryId);
      }
   }

   if (outputFlags & DSI_PARTITION_ROOT_ID)
   {
      (*env)->SetIntField (env, netEntryInfo, sNetEntryInfo->ID.partitionRootId, (jint) jncpGetInt32 (env, curPos, limit));
   }

   if (outputFlags & DSI_PARENT_ID)
   {
      (*env)->SetIntField (env, netEntryInfo, sNetEntryInfo->ID.parentId, (jint) jncpGetInt32 (env, curPos, limit));
   }

   if (outputFlags & DSI_REVISION_COUNT)
   {
      (*env)->SetIntField (env, netEntryInfo, sNetEntryInfo->ID.revisionCount, (jint) jncpGetInt32 (env, curPos, limit));
   }

   if (outputFlags & DSI_REPLICA_TYPE)
   {
      (*env)->SetIntField (env, netEntryInfo, sNetEntryInfo->ID.replicaType, (jint) jncpGetInt32 (env, curPos, limit));
   }

   if (outputFlags & DSI_BASE_CLASS)
   {
      jstring baseClass;

      (*env)->SetObjectField (env, netEntryInfo, sNetEntryInfo->ID.baseClass, (jobject)(baseClass = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, baseClass);
   }

   if (outputFlags & DSI_ENTRY_RDN)
   {
      jstring entryRDN;

      NAlign32 (curPos);
      (*env)->SetObjectField (env, netEntryInfo, sNetEntryInfo->ID.entryRDN, (jobject)(entryRDN = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, entryRDN);
   }

   if (outputFlags & DSI_ENTRY_DN)
   {
      jstring entryDN;

      NAlign32 (curPos);
      (*env)->SetObjectField (env, netEntryInfo, sNetEntryInfo->ID.entryDN, (jobject)(entryDN = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, entryDN);
   }

   if (outputFlags & DSI_PARTITION_ROOT_DN)
   {
      jstring partitionRootDN;

      NAlign32 (curPos);
      (*env)->SetObjectField (env, netEntryInfo, sNetEntryInfo->ID.partitionRootDN, (jobject)(partitionRootDN = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, partitionRootDN);
   }

   if (outputFlags & DSI_PARENT_DN)
   {
      jstring parentDN;

      NAlign32 (curPos);
      (*env)->SetObjectField (env, netEntryInfo, sNetEntryInfo->ID.parentDN, (jobject)(parentDN = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, parentDN);
   }

   if (outputFlags & DSI_PURGE_TIME)
   {
      NAlign32 (curPos);
      (*env)->SetIntField (env, netEntryInfo, sNetEntryInfo->ID.purgeTime, (jint) jncpGetInt32 (env, curPos, limit));
   }

   if (outputFlags & DSI_DEREFERENCE_BASE_CLASS)
   {
      jstring dereferenceBaseClass;

      NAlign32 (curPos);
      (*env)->SetObjectField (env, netEntryInfo, sNetEntryInfo->ID.dereferenceBaseClass, (jobject)(dereferenceBaseClass = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, dereferenceBaseClass);
   }

   if (outputFlags & DSI_REPLICA_NUMBER)
   {
      NAlign32 (curPos);
      (*env)->SetIntField (env, netEntryInfo, sNetEntryInfo->ID.replicaNumber, (jint) jncpGetInt32 (env, curPos, limit));
   }

   if (outputFlags & DSI_REPLICA_STATE)
   {
      NAlign32 (curPos);
      (*env)->SetIntField (env, netEntryInfo, sNetEntryInfo->ID.replicaState, (jint) jncpGetInt32 (env, curPos, limit));
   }

   if (outputFlags & DSI_FEDERATION_BOUNDARY)
   {
      jstring federationBoundary;

      NAlign32 (curPos);
      (*env)->SetObjectField (env, netEntryInfo, sNetEntryInfo->ID.federationBoundary, (jobject)(federationBoundary = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, federationBoundary);
   }

   if (outputFlags & DSI_SCHEMA_BOUNDARY)
   {
      jstring schemaBoundary;

      NAlign32 (curPos);
      (*env)->SetObjectField (env, netEntryInfo, sNetEntryInfo->ID.schemaBoundary, (jobject)(schemaBoundary = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, schemaBoundary);
   }

   return (netEntryInfo);

} /* NetEntryInfoCreate () */


N_GLOBAL_FUNC_C (jobject)
NetEntryInfoCreateFromMemory
(
   JNIEnv *env,
   pNetEntryInfo sNetEntryInfo,
   pnstr8 buf,
   nuint32 length
)
{
   ppnstr8 curPos = &buf;
   pnstr8 limit = (pnstr8) buf + (nuint32) length;
   nuint32 outputFlags;

   jobject netEntryInfo = (*env)->AllocObject (env, sNetEntryInfo->cls);

   {
      NAlign32 (curPos);
      (*env)->SetIntField (
                              env,
                              netEntryInfo,
                              sNetEntryInfo->ID.outputFlags,
                        (jint)(outputFlags = jncpGetInt32 (env, curPos, limit)));
   }

   if (outputFlags & DSI_ENTRY_ID)
   {
      (*env)->SetIntField (
                              env,
                              netEntryInfo,
                              sNetEntryInfo->ID.entryId,
                       (jint) jncpGetInt32 (env, curPos, limit));
   }

   if (outputFlags & DSI_ENTRY_FLAGS)
   {
      (*env)->SetIntField (
                              env,
                              netEntryInfo,
                              sNetEntryInfo->ID.entryFlags,
                       (jint) jncpGetInt32 (env, curPos, limit));
   }

   if (outputFlags & DSI_SUBORDINATE_COUNT)
   {
      (*env)->SetIntField (
                              env,
                              netEntryInfo,
                              sNetEntryInfo->ID.subordinateCount,
                       (jint) jncpGetInt32 (env, curPos, limit));
   }

   if (outputFlags & DSI_MODIFICATION_TIME)
   {
      (*env)->SetIntField (env, netEntryInfo, sNetEntryInfo->ID.modificationTime, (jint) jncpGetInt32 (env, curPos, limit));
   }

   if (outputFlags & (DSI_MODIFICATION_TIMESTAMP | DSI_CREATION_TIMESTAMP))
   {

//NOTE: !implemented

      if (outputFlags & DSI_MODIFICATION_TIMESTAMP)
      {
         jncpSkipInt32 (env, curPos, limit);
         jncpSkipInt16 (env, curPos, limit);
         jncpSkipInt16 (env, curPos, limit);
//         entryIdID = (*env)->GetFieldID (env, clsNetEntryInfo, "entryId", "I");
//         (*env)->SetIntField (env, netEntryInfo, entryIdID, (jint) entryId);
      }

      if (outputFlags & DSI_CREATION_TIMESTAMP)
      {
         jncpSkipInt32 (env, curPos, limit);
         jncpSkipInt16 (env, curPos, limit);
         jncpSkipInt16 (env, curPos, limit);
//         entryIdID = (*env)->GetFieldID (env, clsNetEntryInfo, "entryId", "I");
//         (*env)->SetIntField (env, netEntryInfo, entryIdID, (jint) entryId);
      }
   }

   if (outputFlags & DSI_PARTITION_ROOT_ID)
   {
      (*env)->SetIntField (env, netEntryInfo, sNetEntryInfo->ID.partitionRootId, (jint) jncpGetInt32 (env, curPos, limit));
   }

   if (outputFlags & DSI_PARENT_ID)
   {
      (*env)->SetIntField (env, netEntryInfo, sNetEntryInfo->ID.parentId, (jint) jncpGetInt32 (env, curPos, limit));
   }

   if (outputFlags & DSI_REVISION_COUNT)
   {
      (*env)->SetIntField (env, netEntryInfo, sNetEntryInfo->ID.revisionCount, (jint) jncpGetInt32 (env, curPos, limit));
   }

   if (outputFlags & DSI_REPLICA_TYPE)
   {
      (*env)->SetIntField (env, netEntryInfo, sNetEntryInfo->ID.replicaType, (jint) jncpGetInt32 (env, curPos, limit));
   }

   if (outputFlags & DSI_BASE_CLASS)
   {
      jstring baseClass;

      (*env)->SetObjectField (env, netEntryInfo, sNetEntryInfo->ID.baseClass, (jobject)(baseClass = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, baseClass);
   }

   if (outputFlags & DSI_ENTRY_RDN)
   {
      jstring entryRDN;

      NAlign32 (curPos);
      (*env)->SetObjectField (env, netEntryInfo, sNetEntryInfo->ID.entryRDN, (jobject)(entryRDN = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, entryRDN);
   }

   if (outputFlags & DSI_ENTRY_DN)
   {
      jstring entryDN;

      NAlign32 (curPos);
      (*env)->SetObjectField (env, netEntryInfo, sNetEntryInfo->ID.entryDN, (jobject)(entryDN = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, entryDN);
   }

   if (outputFlags & DSI_PARTITION_ROOT_DN)
   {
      jstring partitionRootDN;

      NAlign32 (curPos);
      (*env)->SetObjectField (env, netEntryInfo, sNetEntryInfo->ID.partitionRootDN, (jobject)(partitionRootDN = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, partitionRootDN);
   }

   if (outputFlags & DSI_PARENT_DN)
   {
      jstring parentDN;

      NAlign32 (curPos);
      (*env)->SetObjectField (env, netEntryInfo, sNetEntryInfo->ID.parentDN, (jobject)(parentDN = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, parentDN);
   }

   if (outputFlags & DSI_PURGE_TIME)
   {
      NAlign32 (curPos);
      (*env)->SetIntField (env, netEntryInfo, sNetEntryInfo->ID.purgeTime, (jint) jncpGetInt32 (env, curPos, limit));
   }

   if (outputFlags & DSI_DEREFERENCE_BASE_CLASS)
   {
      jstring dereferenceBaseClass;

      NAlign32 (curPos);
      (*env)->SetObjectField (env, netEntryInfo, sNetEntryInfo->ID.dereferenceBaseClass, (jobject)(dereferenceBaseClass = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, dereferenceBaseClass);
   }

   if (outputFlags & DSI_REPLICA_NUMBER)
   {
      NAlign32 (curPos);
      (*env)->SetIntField (env, netEntryInfo, sNetEntryInfo->ID.replicaNumber, (jint) jncpGetInt32 (env, curPos, limit));
   }

   if (outputFlags & DSI_REPLICA_STATE)
   {
      NAlign32 (curPos);
      (*env)->SetIntField (env, netEntryInfo, sNetEntryInfo->ID.replicaState, (jint) jncpGetInt32 (env, curPos, limit));
   }

   if (outputFlags & DSI_FEDERATION_BOUNDARY)
   {
      jstring federationBoundary;

      NAlign32 (curPos);
      (*env)->SetObjectField (env, netEntryInfo, sNetEntryInfo->ID.federationBoundary, (jobject)(federationBoundary = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, federationBoundary);
   }

   if (outputFlags & DSI_SCHEMA_BOUNDARY)
   {
      jstring schemaBoundary;

      NAlign32 (curPos);
      (*env)->SetObjectField (env, netEntryInfo, sNetEntryInfo->ID.schemaBoundary, (jobject)(schemaBoundary = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, schemaBoundary);
   }

   return (netEntryInfo);

} /* NetEntryInfoCreate () */

#ifdef __cplusplus
}
#endif


