/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#include <sys_api.h>

#include <unicode.h>

#include "jncpWire.h"

#include "NetHoldJNI.h"


#ifdef __cplusplus
extern "C" {
#endif


/* public final class NetHold
 *    extends NdsHold
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected int remoteId;
 *    protected String name;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetHold)
NetHoldCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetHold;
   jclass clsNetHoldLR;
   //NJCL variables
   pNetHold sNetHold;

   clsNetHoldLR = (*env)->FindClass (env, NETSYNTAXPKG "NetHold");
   clsNetHold = (*env)->NewGlobalRef (env, clsNetHoldLR);
   (*env)->DeleteLocalRef (env, clsNetHoldLR);

   sNetHold = (pNetHold) sysMalloc (sizeof (NetHold));

   if (NULL != sNetHold)
   {
      // assign jclass variables
      sNetHold->cls = clsNetHold;

      // assign jfieldID variables
      sNetHold->ID.objectName = (*env)->GetFieldID (env, clsNetHold, "objectName", "Ljava/lang/String;");
      sNetHold->ID.amount = (*env)->GetFieldID (env, clsNetHold, "amount", "I");
   }
   return (sNetHold);

} /* NetHoldCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetHoldCreate
(
   JNIEnv *env,
   pNetHold sNetHold,
   pBuf_T buf
)
{
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   jobject netHold = (*env)->AllocObject (env, sNetHold->cls);

   {
      nuint32 length;

      NAlign32 (curPos);
      length = jncpGetInt32 (env, curPos, limit);
   }

   {
      NAlign32 (curPos);
      (*env)->SetIntField (
                              env,
                              netHold,
                              sNetHold->ID.amount,
                       (jint) jncpGetInt32 (env, curPos, limit));
   }

   {
      jstring objectName;

      (*env)->SetObjectField (
                                 env,
                                 netHold,
                                 sNetHold->ID.objectName,
                        (jobject)(objectName = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, objectName);
   }

   return (netHold);

} /* NetHoldCreate () */


/***** NetAttrRecordJNI.h *************************************************/

/*
 *     typedef struct
 *     {
 *        pnstr8    objectName ;
 *        nuint32   amount ;
 *     } Hold_T;
 *
 *     CStruct
 *     | objectNameptr | amount | ObjectName |
 *
 *     Java Byte Array
 *     | objectName | amount |
 */

N_GLOBAL_FUNC_C (jbyteArray)
NetHold_toByteArray
(
   JNIEnv *env,
   nptr cValue,
   nuint32 cLength
)
{
   // JNI variables
//   jclass cls;
//   jmethodID getHandleMid, getSizeMid;
//   jint nhdlMemory, length;
   jbyteArray byteArray;
   // NWNet variables
   pHold_T hold;
   nuint8 *holdPtr, *ptr;

   // NdsMemory methods
//   cls = (*env)->GetObjectClass (env, values);
//   getHandleMid = (*env)->GetMethodID (env, cls, "getHandle", "()I");
//   getSizeMid = (*env)->GetMethodID (env, cls, "getSize", "()I");

   // NdsMemory.handle - ReplicaPointer C struct
//   nhdlMemory = (*env)->CallIntMethod (env, values, getHandleMid);
//   hold = (pHold_T) nhdlMemory;
   hold = (pHold_T) cValue;

   // NdsMemory.size - NWNet buffer size
//   length = (*env)->CallIntMethod (env, values, getSizeMid);

   // malloc temporary buffer
//   holdPtr = (nuint8 *) sysMalloc (length);
   holdPtr = (nuint8 *) sysMalloc (cLength);
   ptr = holdPtr;

   // build the temporary buffer
   unicpy ((unicode *) ptr, (unicode *) hold->objectName);
   ptr += (unilen ((unicode *) ptr) + 1) * sizeof (unicode);

   *(pnuint32) ptr = hold->amount;

   // allocate return byte[]
//   byteArray = (*env)->NewByteArray (env, length);
   byteArray = (*env)->NewByteArray (env, cLength);

   // copy temporary buffer to byte[]
//   (*env)->SetByteArrayRegion (env, byteArray, 0, length, (jbyte *) holdPtr);
   (*env)->SetByteArrayRegion (env, byteArray, 0, cLength, (jbyte *) holdPtr);

   // free temporary buffer
   sysFree (holdPtr);

   return (byteArray);

}  /* toByteArray () */
   

/*
 *
 */
N_GLOBAL_FUNC_C (nptr) 
NetHold_toCStruct
(
   JNIEnv      *env, 
   jbyteArray  values
)
{
   // JNI variables
   jbyte *byteArray, *ptr;
   jsize length;
   // NWNet variables
   pHold_T hold;
   nuint8 *dataPtr;

   // get byte[]
   byteArray = (*env)->GetByteArrayElements (env, values, 0);
   ptr = byteArray;

   // calculate NetMemory size
   length = (*env)->GetArrayLength (env, values) + sizeof(Hold_T);

   // malloc NetMemory buffer
   hold = (pHold_T) sysMalloc (length);
   dataPtr = (nuint8 *)(hold) + sizeof(Hold_T);

   // build the buffer
   hold->objectName = (pnchar) dataPtr;
   unicpy ((unicode *) hold->objectName, (unicode *) ptr);
   ptr += (unilen ((unicode *) ptr) + 1) * sizeof (unicode);

   hold->amount = *(nuint32 *) ptr;

   // release byte[]
   (*env)->ReleaseByteArrayElements (env, values, byteArray, JNI_ABORT);

   // return buffer
   return ((nptr) hold);

} /* toCStruct () */


#ifdef __cplusplus
}
#endif


