/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#include <sys_api.h>

#include <unicode.h>

#include <nwalias.h>

#include "jncpWire.h"

#include "NetNetAddressJNI.h"


#ifdef __cplusplus
extern "C" {
#endif


/* public final class NetNetAddress
 *    extends NdsNetAddress
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected int type;
 *    protected byte[] address;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetNetAddress)
NetNetAddressCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetNetAddress;
   jclass clsNetNetAddressLR;
   //NJCL variables
   pNetNetAddress sNetNetAddress;

   clsNetNetAddressLR = (*env)->FindClass (env, NETSYNTAXPKG "NetNetAddress");
   clsNetNetAddress = (*env)->NewGlobalRef (env, clsNetNetAddressLR);
   (*env)->DeleteLocalRef (env, clsNetNetAddressLR);

   sNetNetAddress = (pNetNetAddress) sysMalloc (sizeof (NetNetAddress));

   if (NULL != sNetNetAddress)
   {
      // assign jclass variables
      sNetNetAddress->cls = clsNetNetAddress;

      // assign jfieldID variables
      sNetNetAddress->ID.type = (*env)->GetFieldID (env, clsNetNetAddress, "type", "I");
      sNetNetAddress->ID.address = (*env)->GetFieldID (env, clsNetNetAddress, "address", "[B");
   }
   return (sNetNetAddress);

} /* NetNetAddressCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetNetAddressCreate
(
   JNIEnv *env,
   pNetNetAddress sNetNetAddress,
   pBuf_T buf
)
{
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   jobject netNetAddress = (*env)->AllocObject (env, sNetNetAddress->cls);

   {
      nuint32 length;

      NAlign32 (curPos);
      length = jncpGetInt32 (env, curPos, limit);
   }

   {
      (*env)->SetIntField (
                              env,
                              netNetAddress,
                              sNetNetAddress->ID.type,
                       (jint) jncpGetInt32 (env, curPos, limit));
   }

   {
      jbyteArray address;
      pnstr8 cAddress;
      nuint32 length;

      cAddress = jncpGetData (env, curPos, limit, &length);
      address = (*env)->NewByteArray (env, length); 
      (*env)->SetByteArrayRegion (env, address, 0, length, (jbyte *) cAddress); 
      (*env)->SetObjectField (
                                 env,
                                 netNetAddress,
                                 sNetNetAddress->ID.address,
                       (jobject) address);
      (*env)->DeleteLocalRef (env, address);
   }

   return (netNetAddress);

} /* NetNetAddressCreate () */


/***** NetAttrRecordJNI.h *************************************************/

/*
 * typedef struct
 * {
 *    NWNET_ADDR_TYPE addressType;
 *    NWNET_ADDR_LEN  addressLength;
 *    NWNET_ADDR     *address;
 * } Net_Address_T
 *
 * java array:
 *  | addressType | addressLength | address
 */

/*
 *
 */
N_GLOBAL_FUNC_C (jbyteArray)
NetNetAddress_toByteArray
(
   JNIEnv *env,
   nptr cValue,
   nuint32 cLength
)
{
   // JNI variables
   jbyteArray byteArray;
   // NWNet variables
   pNet_Address_T netAddress;
   nuint8 *netAddressPtr, *ptr;
   NWNET_ADDR_LEN addressLength;

   // NdsMemory.handle - ReplicaPointer C struct
   netAddress = (pNet_Address_T) cValue;

   // malloc temporary buffer
   netAddressPtr = (nuint8 *) sysMalloc (cLength);
   ptr = netAddressPtr;

   // build the temporary buffer
   *(NWNET_ADDR_TYPE *) ptr = netAddress->addressType;
   ptr += sizeof(NWNET_ADDR_TYPE);

   *(NWNET_ADDR_LEN *) ptr = addressLength = netAddress->addressLength;
   ptr += sizeof(NWNET_ADDR_LEN);

   memcpy (ptr, netAddress->address, addressLength);

   // allocate return byte[]
   byteArray = (*env)->NewByteArray (env, cLength);

   // copy temporary buffer to byte[]
   (*env)->SetByteArrayRegion (env, byteArray, 0, cLength, (jbyte *) netAddressPtr);

   // free temporary buffer
   sysFree (netAddressPtr);

   return (byteArray);

} /* toByteArray */


/*
 *
 */
N_GLOBAL_FUNC_C (nptr) 
NetNetAddress_toCStruct
(
   JNIEnv      *env, 
   jbyteArray  values
)
{
   // JNI variables
   jbyte *byteArray, *ptr;
   jsize length;
   // NWNet variables
   pNet_Address_T netAddress;
   nuint8 *dataPtr;
   NWNET_ADDR_LEN addressLength;

   // get byte[]
   byteArray = (*env)->GetByteArrayElements (env, values, 0);
   ptr = byteArray;

   // calculate NetMemory size
   length = (*env)->GetArrayLength (env, values) + sizeof(Net_Address_T);

   // malloc NetMemory buffer
   netAddress = (pNet_Address_T) sysMalloc (length);
   dataPtr = (nuint8 *)(netAddress) + sizeof(Net_Address_T);

   // build the buffer
   netAddress->addressType = *(NWNET_ADDR_TYPE *) ptr;
   ptr += sizeof(NWNET_ADDR_TYPE);

   netAddress->addressLength = addressLength = *(NWNET_ADDR_LEN *) ptr;
   ptr += sizeof(NWNET_ADDR_LEN);

   netAddress->address = (pnchar) dataPtr;
   memcpy (netAddress->address, ptr, addressLength);

   // release byte[]
   (*env)->ReleaseByteArrayElements (env, values, byteArray, JNI_ABORT);

   // return buffer
   return ((nptr) netAddress);

} /* toCStruct () */


#ifdef __cplusplus
}
#endif


