/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#include <sys_api.h>

#include "jncpWire.h"

#include "NetNumericStringJNI.h"


#ifdef __cplusplus
extern "C" {
#endif


/* public final class NetNumericString
 *    extends NdsNumericString
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected int remoteId;
 *    protected String name;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetNumericString)
NetNumericStringCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetNumericString;
   jclass clsNetNumericStringLR;
   //NJCL variables
   pNetNumericString sNetNumericString;

   clsNetNumericStringLR = (*env)->FindClass (env, NETSYNTAXPKG "NetNumericString");
   clsNetNumericString = (*env)->NewGlobalRef (env, clsNetNumericStringLR);
   (*env)->DeleteLocalRef (env, clsNetNumericStringLR);

   sNetNumericString = (pNetNumericString) sysMalloc (sizeof (NetNumericString));

   if (NULL != sNetNumericString)
   {
      // assign jclass variables
      sNetNumericString->cls = clsNetNumericString;

      // assign jfieldID variables
      sNetNumericString->ID.value = (*env)->GetFieldID (env, clsNetNumericString, "value", "Ljava/lang/String;");
   }
   return (sNetNumericString);

} /* NetNumericStringCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetNumericStringCreate
(
   JNIEnv *env,
   pNetNumericString sNetNumericString,
   pBuf_T buf
)
{
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   jobject netNumericString = (*env)->AllocObject (env, sNetNumericString->cls);

   {
      jstring value;

      NAlign32 (curPos);
      (*env)->SetObjectField (
                                 env,
                                 netNumericString,
                                 sNetNumericString->ID.value,
                        (jobject)(value = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, value);
   }

   return (netNumericString);

} /* NetNumericStringCreate () */


#ifdef __cplusplus
}
#endif


