/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#include <sys_api.h>

#include <unicode.h>

#include "jncpWire.h"

#include "NetObjectACLJNI.h"


#ifdef __cplusplus
extern "C" {
#endif


/* public final class NetObjectACL
 *    extends NdsObjectACL
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected String protectedAttrName;
 *    protected String subjectName;
 *    protected int privileges;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetObjectACL)
NetObjectACLCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetObjectACL;
   jclass clsNetObjectACLLR;
   //NJCL variables
   pNetObjectACL sNetObjectACL;

   clsNetObjectACLLR = (*env)->FindClass (env, NETSYNTAXPKG "NetObjectACL");
   clsNetObjectACL = (*env)->NewGlobalRef (env, clsNetObjectACLLR);
   (*env)->DeleteLocalRef (env, clsNetObjectACLLR);

   sNetObjectACL = (pNetObjectACL) sysMalloc (sizeof (NetObjectACL));

   if (NULL != sNetObjectACL)
   {
      // assign jclass variables
      sNetObjectACL->cls = clsNetObjectACL;

      // assign jfieldID variables
      sNetObjectACL->ID.protectedAttrName = (*env)->GetFieldID (env, clsNetObjectACL, "protectedAttrName", "Ljava/lang/String;");
      sNetObjectACL->ID.subjectName = (*env)->GetFieldID (env, clsNetObjectACL, "subjectName", "Ljava/lang/String;");
      sNetObjectACL->ID.privileges = (*env)->GetFieldID (env, clsNetObjectACL, "privileges", "I");
   }
   return (sNetObjectACL);

} /* NetObjectACLCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetObjectACLCreate
(
   JNIEnv *env,
   pNetObjectACL sNetObjectACL,
   pBuf_T buf
)
{
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   jobject netObjectACL = (*env)->AllocObject (env, sNetObjectACL->cls);

   {
      nuint32 length;

      NAlign32 (curPos);
      length = jncpGetInt32 (env, curPos, limit);
   }

   {
      jstring protectedAttrName;

      (*env)->SetObjectField (
                                 env,
                                 netObjectACL,
                                 sNetObjectACL->ID.protectedAttrName,
                        (jobject)(protectedAttrName = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, protectedAttrName);
   }

   {
      jstring subjectName;

      NAlign32 (curPos);
      (*env)->SetObjectField (
                                 env,
                                 netObjectACL,
                                 sNetObjectACL->ID.subjectName,
                        (jobject)(subjectName = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, subjectName);
   }

   {
      NAlign32 (curPos);
      (*env)->SetIntField (
                              env,
                              netObjectACL,
                              sNetObjectACL->ID.privileges,
                       (jint) jncpGetInt32 (env, curPos, limit));
   }

   return (netObjectACL);

} /* NetObjectACLCreate () */


/***** NetAttrRecordJNI.h *************************************************/

/*
 * typedef struct
 * {
 *    pnstr8    protectedAttrName ;
 *    pnstr8    subjectName ;
 *    nuint32   privileges ;
 * } Object_ACL_T;
 *
 * CStruct:
 *  | protAttrNameptr | subjectNamePtr | privileges | protAttrName | subjName |
 *
 * java array:
 *  | protectedAttrName | subjectName | privileges |
 * 
 */
N_GLOBAL_FUNC_C (jbyteArray)
NetObjectACL_toByteArray
(
   JNIEnv *env,
   nptr cValue,
   nuint32 cLength
)
{
   // JNI variables
   jbyteArray byteArray;
   // NWNet variables
   pObject_ACL_T objectACL;
   nuint8 *objectACLPtr, *ptr;

   // NdsMemory.handle - ReplicaPointer C struct
   objectACL = (pObject_ACL_T) cValue;

   // malloc temporary buffer
   objectACLPtr = (nuint8 *) sysMalloc (cLength);
   ptr = objectACLPtr;

   // build the temporary buffer
   unicpy ((unicode *) ptr, (unicode *) objectACL->protectedAttrName);
   ptr += (unilen ((unicode *) ptr) + 1) * sizeof (unicode);

   unicpy ((unicode *) ptr, (unicode *) objectACL->subjectName);
   ptr += (unilen ((unicode *) ptr) + 1) * sizeof (unicode);

   *(nuint32 *) ptr = objectACL->privileges;

   // allocate return byte[]
   byteArray = (*env)->NewByteArray (env, cLength);

   // copy temporary buffer to byte[]
   (*env)->SetByteArrayRegion (env, byteArray, 0, cLength, (jbyte *) objectACLPtr);

   // free temporary buffer
   sysFree (objectACLPtr);

   return (byteArray);

}  // fromCStruct ()


/*
 *
 */
N_GLOBAL_FUNC_C (nptr) 
NetObjectACL_toCStruct
(
   JNIEnv      *env, 
   jbyteArray  values
)
{
   // JNI variables
   jbyte *byteArray, *ptr;
   jsize length;
   // NWNet variables
   pObject_ACL_T objectACL;
   nuint8 *dataPtr;

   // get byte[]
   byteArray = (*env)->GetByteArrayElements (env, values, 0);
   ptr = byteArray;

   // calculate NetMemory size
   length = (*env)->GetArrayLength (env, values) + sizeof(Object_ACL_T);

   // malloc NetMemory buffer
   objectACL = (pObject_ACL_T) sysMalloc (length);
   dataPtr = (nuint8 *)(objectACL) + sizeof(Object_ACL_T);

   // build the buffer
   objectACL->protectedAttrName = (pnchar) dataPtr;
   unicpy ((unicode *) objectACL->protectedAttrName, (unicode *) ptr);
   length = (unilen ((unicode *) ptr) + 1) * sizeof (unicode);
   ptr += length;
   dataPtr += length;

   objectACL->subjectName = (pnchar) dataPtr;
   unicpy ((unicode *) objectACL->subjectName, (unicode *) ptr);
   ptr += (unilen ((unicode *) ptr) + 1) * sizeof (unicode);

   objectACL->privileges = *(nuint32 *) ptr;

   // release byte[]
   (*env)->ReleaseByteArrayElements (env, values, byteArray, JNI_ABORT);

   // return buffer
   return ((nptr) objectACL);

} /* toCStruct () */


#ifdef __cplusplus
}
#endif


