/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#include <sys_api.h>

#include "jncpWire.h"

#include "NetTimeJNI.h"


#ifdef __cplusplus
extern "C" {
#endif


/* public final class NetTime
 *    extends NdsTime
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected boolean value;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetTime)
NetTimeCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetTime;
   jclass clsNetTimeLR;
   //NJCL variables
   pNetTime sNetTime;

   clsNetTimeLR = (*env)->FindClass (env, NETSYNTAXPKG "NetTime");
   clsNetTime = (*env)->NewGlobalRef (env, clsNetTimeLR);
   (*env)->DeleteLocalRef (env, clsNetTimeLR);

   sNetTime = (pNetTime) sysMalloc (sizeof (NetTime));

   if (NULL != sNetTime)
   {
      // assign jclass variables
      sNetTime->cls = clsNetTime;

      // assign jfieldID variables
      sNetTime->ID.value = (*env)->GetFieldID (env, clsNetTime, "value", "I");
   }
   return (sNetTime);

} /* NetTimeCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetTimeCreate
(
   JNIEnv *env,
   pNetTime sNetTime,
   pBuf_T buf
)
{
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   jobject netTime = (*env)->AllocObject (env, sNetTime->cls);

   {
      nuint32 length;

      NAlign32 (curPos);
      length = jncpGetInt32 (env, curPos, limit);
   }

   {
      (*env)->SetIntField (
                              env,
                              netTime,
                              sNetTime->ID.value,
                       (jint) jncpGetInt32 (env, curPos, limit));
   }

   return (netTime);

} /* NetTimeCreate () */


