
/* **************************************************************************

  %name: netJNI.c %
  %version: 29 %
  %date_modified: Thu Mar  5 13:35:49 1998 %

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
//#define DEBUG_OUT true

#include <limits.h>

#include <jni.h>

#include "com_novell_service_jncpv2r_net_NetJNI.h"

#include "com_novell_service_jncpv2r_net_NetAsn1ID.h"
#include "com_novell_service_jncpv2r_net_NetAttributeInfo.h"
#include "com_novell_service_jncpv2r_net_NetIterationHandle.h"
#include "com_novell_service_jncpv2r_net_NetObjectInfo.h"

#include <ntypes.h>

#ifndef N_PLAT_NLM
#include <wtypes.h>
#include <winbase.h> // for SKADS Win32 DLL jump table
#endif

#include "JNIString.h"
#include <nwnet.h>
#include <obsolete/o_dsdsa.h>

#ifdef N_PLAT_NLM

#include <nwthread.h>
#include <nwadv.h>
#include <string.h>

#include <stdio.h>

#endif

#include "jncp.h"
#include "nlmsem.h"
#include "netJNI.h"

#define NETPKG         "com/novell/service/jncpv2r/net/"
#define JNCPPKG        "com/novell/service/jncp/"

N_GLOBAL_VAR SkadsJumpTable actualSkadsJumpTable;
N_GLOBAL_VAR pSkadsJumpTable _SkadsJumpTable = &actualSkadsJumpTable;

#ifndef N_PLAT_NLM
N_GLOBAL_VAR HMODULE globalDLLHandle = 0;
#endif

char *SkadsFunctionNames[] = {
      "NWDSItrCreateSearch",
      "NWDSItrCreateList",
      "NWDSItrDestroy",
      "NWDSItrClone",
      "NWDSItrAtFirst",
      "NWDSItrAtEOF",
      "NWDSItrGetInfo",
      "NWDSItrGetPosition",
      "NWDSItrSetPosition",
      "NWDSItrSetPositionFromIterator",
      "NWDSItrTypeDown",
      "NWDSItrSkip",
      "NWDSItrGetNext",
      "NWDSItrGetPrev",
      "NWDSItrGetCurrent",
      "NWDSItrCount" };

/***** nwdsacl.h **********************************************************/

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSGetEffectiveRights
 * Signature: (ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/novell/service/toolkit/jcl/NWInteger;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSGetEffectiveRights
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring subjectName,
   jstring objectName,
   jstring attrName,
   jobject privileges /*NWInteger*/ /*out*/
)
{
   NWDSCCODE ccode;
   unicode cSubjectName[MAX_DN_CHARS + 1];
   unicode cObjectName[MAX_DN_CHARS + 1];
   unicode cAttrName[MAX_SCHEMA_NAME_CHARS + 1];
   nuint32 cPrivileges;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Convert Names and load into c vars
   jstring2unicode (env, subjectName, cSubjectName, sizeof(cSubjectName));
   jstring2unicode (env, objectName, cObjectName, sizeof(cObjectName));
   jstring2unicode (env, attrName, cAttrName, sizeof(cAttrName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ((jint) ccode);
#endif

   ccode = NWDSGetEffectiveRights(
                  (NWDSContextHandle) context,
                  (pnstr8) cSubjectName,
                  (pnstr8) cObjectName,
                  (pnstr8) cAttrName,
                  &cPrivileges);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if (N_SUCCESS == ccode)
   {
      jclass cls;
      jmethodID mid;

      cls = (*env)->GetObjectClass (env, privileges);
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      if (0 == mid)
      {
         // if mid cannot resolve, GetMethodID will throw NoSuchMethodException
         // however, without a try clause an ugly JNI panic will happen.
         return(-1);
      }
      (*env)->CallVoidMethod (env, privileges, mid, (jint) cPrivileges);
   }
   return (ccode);

} /* NWDSGetEffectiveRights () */

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSListAttrsEffectiveRights
(
   NWDSContextHandle context,
   pnstr8            objectName,
   pnstr8            subjectName,
   nbool8            allAttrs,
   pBuf_T            attrNames,
   pnint32           iterationHandle,
   pBuf_T            privilegeInfo
);
*/

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSListAttrsEffectiveRights
 * Signature: (ILjava/lang/String;Ljava/lang/String;ZILcom/novell/service/jncpv2r/net/NetIterationHandle;I)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSListAttrsEffectiveRights
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring objectName,
   jstring subjectName,
   jboolean allAttrs,
   jint attrNames,
   jobject iterationHandle,
   jint privilegeInfo
)
{
   // JNI variables
   jclass      cls;
   jmethodID   getValueMid, setValueMid;
   // NWNet variables
   unicode     cObjectName[MAX_DN_CHARS + 1];
   unicode     cSubjectName[MAX_DN_CHARS + 1];
   nint32      cIterationHandle;
   NWDSCCODE   ccode;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // NetIterationHandle methods
   cls = (*env)->GetObjectClass(env, iterationHandle);
   getValueMid = (*env)->GetMethodID (env, cls, "getValue","()I");
   setValueMid = (*env)->GetMethodID (env, cls, "setValue","(I)V");

   // Convert Java variable to 'C' variable
   jstring2unicode (env, objectName, cObjectName, sizeof(cObjectName));

   // Convert Java variable to 'C' variable
   jstring2unicode (env, subjectName, cSubjectName, sizeof(cSubjectName));

   // Get iteration handle
   cIterationHandle = (nint32)(*env)->CallIntMethod (
                                          env,
                                          iterationHandle,
                                          getValueMid);

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   // Make C API call
   ccode = NWDSListAttrsEffectiveRights (
               (NWDSContextHandle) context,
               (pnstr8) cObjectName,
               (pnstr8) cSubjectName,
               (nbool8) allAttrs,
               (pBuf_T) attrNames,
               &cIterationHandle,
               (pBuf_T) privilegeInfo);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   // Convert C variables back to Java variables
   if (N_SUCCESS == ccode)
   {
      (*env)->CallVoidMethod (
                  env,
                  iterationHandle,
                  setValueMid,
                  (jint) cIterationHandle);
   }
   else
   {
      (*env)->CallVoidMethod (
                  env,
                  iterationHandle,
                  setValueMid,
                  (jint) NO_MORE_ITERATIONS);
   }

   return (ccode);

} /* NWDSListAttrsEffectiveRights () */


/***** nwdsapi.h **********************************************************/

/* Not Implemented
N_GLOBAL_LIBRARY( NWCCODE )
NWDSLoginAsServer
(
   NWDSContextHandle       context
);
*/

/***** nwdsasa.h **********************************************************/

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSAuthenticate()
*/

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSAuthenticateConn()
*/

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSChangeObjectPassword()
*/

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSGenerateObjectKeyPair()
*/

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSLogin()
*/

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSLogout()
*/

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSVerifyObjectPassword()
*/

/***** nwdsattr.h *********************************************************/


/***** nwdsaud.h **********************************************************/

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSAuditGetObjectID
 * Signature: (ILjava/lang/String;Lcom/novell/service/toolkit/jcl/NWInteger;Lcom/novell/service/toolkit/jcl/NWInteger;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSAuditGetObjectID
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring objectName,
   jobject conn,        /*NWInteger*/ /*out*/
   jobject objectID     /*NWInteger*/ /*out*/
)
{
   NWDSCCODE ccode;
   unicode cObjectName[MAX_DN_CHARS + 1];
   nuint32 cObjectID;
   NWCONN_HANDLE cConn;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   jstring2unicode(env, objectName, cObjectName, sizeof(cObjectName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSAuditGetObjectID (
               (NWDSContextHandle) context,
               (pnstr8) cObjectName,
               (NWCONN_HANDLE N_FAR *) &cConn,
               &cObjectID);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if (N_SUCCESS == ccode)
   {
      jclass         cls;
      jmethodID      mid;

      /* conn.setValue (cConn); */
      cls = (*env)->GetObjectClass(env, conn);
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod(env, conn, mid, (jint)cConn);

      /* objectID.setValue (cObjectID); */
      cls = (*env)->GetObjectClass(env, objectID);
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod(env, objectID, mid, (jint)cObjectID);
   }
   return (ccode);

} /* NWDSAuditGetObjectID () */

/***** nwdsbuft.h *********************************************************/

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSAllocBuf
 * Signature: (ILcom/novell/service/toolkit/jcl/NWInteger;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSAllocBuf
(
   JNIEnv *env,
   jclass unused,
   jint size,
   jobject buf /*NWInteger*/
)
{
   NWDSCCODE ccode;
   Buf_T *cBuf;

   ccode = NWDSAllocBuf (size, &cBuf);

   if (0 == ccode)
   {
      jclass cls;
      jmethodID mid;

      cls = (*env)->GetObjectClass(env, buf);
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod(env, buf, mid, (jint)cBuf);
   }
   return (ccode);

} /* NWDSAllocBuf () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSComputeAttrValSize
 * Signature: (IIILcom/novell/service/toolkit/jcl/NWInteger;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSComputeAttrValSize
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint buf,
   jint syntaxID,
   jobject attrValSize /*NWInteger*/ /*out*/
)
{
   NWDSCCODE ccode;
   nuint32  cAttrValSize;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSComputeAttrValSize(
               (NWDSContextHandle) context,
               (pBuf_T) buf,
               (nuint32) syntaxID,
               &cAttrValSize);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if (0 == ccode)
   {
      jclass cls;
      jmethodID mid;

      cls = (*env)->GetObjectClass(env, attrValSize);
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod (env, attrValSize, mid, (jint) cAttrValSize);
   }
   return (ccode);

} /* NWDSComputeAttrValSize () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSFreeBuf
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSFreeBuf
(
   JNIEnv *env,
   jclass unused,
   jint buf
)
{
   return (NWDSFreeBuf ((Buf_T *) buf));

} /* NWDSFreeBuf () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSGetAttrCount
 * Signature: (IILcom/novell/utility/java/lang/IntegerBuffer;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSGetAttrCount
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint buf,
   jobject attrCount /*IntegerBuffer*/ /*out*/
)
{
   NWDSCCODE ccode;
   nuint32 cAttrCount;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSGetAttrCount (
               (NWDSContextHandle) context,
               (pBuf_T) buf,
               &cAttrCount);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if (0 == ccode)
   {
      jclass cls;
      jmethodID mid;

      cls = (*env)->GetObjectClass (env, attrCount);
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod(env, attrCount, mid, (jint)cAttrCount);
   }
   return (ccode);

} /* NWDSGetAttrCount () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSGetAttrDef
 * Signature: (IILjava/lang/StringBuffer;Lcom/novell/service/jncpv2r/net/NetAttributeInfo;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSGetAttrDef
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint buf,
   jobject attrName, /*StringBuffer*/ /*out*/
   jobject attrInfo /*NDSAttributeInfo*/ /*out*/
)
{
   NWDSCCODE      ccode;
   unicode        cAttrName[(MAX_SCHEMA_NAME_CHARS +1)];
   Attr_Info_T    cAttrInfo;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSGetAttrDef (
               (NWDSContextHandle) context,
               (pBuf_T) buf,
               (pnstr8) cAttrName,
               &cAttrInfo);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if (0 == ccode)
   {
      jbyteArray     byteArray;
      int            i;
      jclass         cls;
      jmethodID      mid;
      jstring        string;
      jbyte          *pByte;

      // Copy the 'C' variables back into Java variables
      cls = (*env)->GetObjectClass(env, attrName);
      mid = (*env)->GetMethodID (env, cls, "append","(Ljava/lang/String;)Ljava/lang/StringBuffer;");
      if (0 == mid)
      {
         return(-1);
      }
      string = (*env)->NewString(env, cAttrName, unilen (cAttrName));
      (*env)->CallObjectMethod(env, attrName, mid, string);

      cls = (*env)->GetObjectClass(env, attrInfo);
      mid = (*env)->GetMethodID (env, cls, "setFlags","(I)V");
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod(env, attrInfo, mid, cAttrInfo);

      mid = (*env)->GetMethodID (env, cls, "setSyntaxID","(I)V");
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod(env, attrInfo, mid, (jint)cAttrInfo.attrSyntaxID);

      mid = (*env)->GetMethodID (env, cls, "setLowerLimit","(I)V");
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod(env, attrInfo, mid, (jint)cAttrInfo.attrLower);

      mid = (*env)->GetMethodID (env, cls, "setUpperLimit","(I)V");
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod(env, attrInfo, mid, (jint)cAttrInfo.attrUpper);

      // Alloc mem for byte array
      byteArray = (*env)->NewByteArray (env, MAX_ASN1_NAME);
      if (NULL == byteArray)
      {
         jclass clazz = (*env)->FindClass (env, JAVAPKG "OutOfMemoryError");

         (*env)->ThrowNew(env, clazz, "NdsNatives.NWDSGetAttrDef - NATIVE");

         return (-1);
      }

      // Copy data from cClassName.asn1ID.data to byte array
      pByte = (*env)->GetByteArrayElements(env, byteArray, NULL);
      for (i = 0; i < (int) MAX_ASN1_NAME; i++)
      {
         *(pByte + i) = cAttrInfo.asn1ID.data[i];
      }

      // Copy data from byte array to attrInfo.asn1ID.data
      mid = (*env)->GetMethodID (env, cls, "setAsn1IDData","([B)V");
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod(env, attrInfo, mid, byteArray);

      (*env)->ReleaseByteArrayElements(env, byteArray, pByte, JNI_ABORT);
   }
   return (ccode);

} /* NWDSGetAttrDef () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSGetAttrName
 * Signature: (IILjava/lang/StringBuffer;Lcom/novell/service/toolkit/jcl/NWInteger;Lcom/novell/service/toolkit/jcl/NWInteger;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSGetAttrName
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint buf,
   jobject attrName,       /*StringBuffer*/ /*out*/
   jobject attrValCount,   /*NWInteger*/ /*out*/
   jobject syntaxID        /*NWInteger*/ /*out*/
)
{
   NWDSCCODE   ccode;
   nuint32     cAttrValCount;
   unicode     cAttrName[MAX_DN_CHARS + 1];
   nuint32     cSyntaxID;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSGetAttrName (
               (NWDSContextHandle) context,
               (pBuf_T) buf,
               (pnstr8) cAttrName,
               &cAttrValCount,
               &cSyntaxID);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if (N_SUCCESS == ccode)
   {
      jclass      cls;
      jmethodID   mid;
      jstring     string;

      cls = (*env)->GetObjectClass(env, attrName);
      mid = (*env)->GetMethodID (
                        env,
                        cls,
                        "append",
                        "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
      if (0 == mid)
      {
         return(-1);
      }
      string = (*env)->NewString(env, cAttrName, unilen (cAttrName));
      (*env)->CallObjectMethod(env, attrName, mid, string);

      if (NULL != attrValCount)
      {
         cls = (*env)->GetObjectClass(env, attrValCount);
         mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
         if (0 == mid)
         {
            return(-1);
         }
         (*env)->CallVoidMethod(env, attrValCount, mid, (jint)cAttrValCount);
      }

      if (NULL != syntaxID)
      {
         cls = (*env)->GetObjectClass(env, syntaxID);
         mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
         if (0 == mid)
         {
            return(-1);
         }
         (*env)->CallVoidMethod(env, syntaxID, mid, (jint)cSyntaxID);
      }

   } /* if (N_SUCCESS == ccode) */

   return (ccode);

} /* NWDSGetAttrName () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSGetAttrVal
 * Signature: (IIILcom/novell/service/jncpv2r/net/NetMemory;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSGetAttrVal
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint buf,
   jint syntaxID,
   jobject attrVal /*NetMemory*/ /*out*/
)
{
   NWDSCCODE ccode;
   nptr  cAttrVal = NULL;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   /*
    * If attrVal  equals NULL,
    *    the value is skipped;
    * this is useful for simply counting attribute values.
    */
   if (NULL != attrVal)
   {
      jclass cls;
      jmethodID mid;

      cls = (*env)->GetObjectClass(env, attrVal);
      mid = (*env)->GetMethodID (env, cls, "getHandle","()I");
      if (0 == mid)
      {
         return(-1);
      }
      cAttrVal = (nptr)(*env)->CallIntMethod (env, attrVal, mid);
   }

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSGetAttrVal(
               (NWDSContextHandle) context,
               (pBuf_T) buf,
               syntaxID,
               cAttrVal);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return (ccode);

} /* NWDSGetAttrVal */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSGetClassDef
 * Signature: (IILjava/lang/StringBuffer;Lcom/novell/service/jncpv2r/net/NetClassInfo;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSGetClassDef
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint buf,
   jobject className, /*StringBuffer*/ /*out*/
   jobject classInfo /*NDSClassInfo*/ /*out*/
)
{
   NWDSCCODE      ccode;
   unicode        cClassName[MAX_SCHEMA_NAME_CHARS + 1];
   Class_Info_T   cClassInfo;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSGetClassDef(
               (NWDSContextHandle) context,
               (pBuf_T) buf,
               (pnstr8) cClassName,
               &cClassInfo);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if (0 == ccode)
   {
      jclass         cls;
      jmethodID      mid;
      jbyteArray     byteArray;
      jbyte          *pByte;
      int            i;
      jstring        string;

      cls = (*env)->GetObjectClass(env, className);
      mid = (*env)->GetMethodID (env, cls, "append","(Ljava/lang/String;)Ljava/lang/StringBuffer;");
      if (0 == mid)
      {
         return(-1);
      }
      string = (*env)->NewString(env, cClassName, unilen (cClassName));
      (*env)->CallObjectMethod(env, className, mid, string);

      cls = (*env)->GetObjectClass(env, classInfo);
      mid = (*env)->GetMethodID (env, cls, "setFlags","(I)V");
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod(env, classInfo, mid, cClassInfo.classFlags);

      // Alloc mem for byte array
      byteArray = (*env)->NewByteArray (env, MAX_ASN1_NAME);
      if (NULL == byteArray)
      {
         jclass clazz = (*env)->FindClass (env, JAVAPKG "OutOfMemoryError");

         (*env)->ThrowNew(env, clazz, "NdsNatives.NWDSGetClassDef - NATIVE");

         return (-1);
      }

      // Copy data from cClassName.asn1ID.data to byte array
      pByte = (*env)->GetByteArrayElements(env, byteArray, NULL);
      for (i = 0; i < (int)MAX_ASN1_NAME; i++)
      {
         *(pByte + i) = cClassInfo.asn1ID.data[i];
      }

      // Copy data from byte array to attrInfo.asn1ID.data
      mid = (*env)->GetMethodID (env, cls, "setAsn1IDData","([B)V");
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod(env, classInfo, mid, byteArray);

      (*env)->ReleaseByteArrayElements(env, byteArray, pByte, JNI_ABORT);
   }
   return (ccode);

} /* NWDSGetClassDef () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSGetClassDefCount
 * Signature: (IILcom/novell/utility/java/lang/IntegerBuffer;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSGetClassDefCount
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint buf,
   jobject classDefCount /*IntegerBuffer*/ /*out*/
)
{
   NWDSCCODE ccode;
   nuint32 cClassDefCount;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSGetClassDefCount (
               (NWDSContextHandle) context,
               (pBuf_T) buf,  // Typecast 32-bit integer as pointer
               &cClassDefCount); // Save results in 'C' variable

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if (0 == ccode)
   {  // Copy 'C' variable back into Java variable
      jclass cls;
      jmethodID mid;

      cls = (*env)->GetObjectClass (env, classDefCount);
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      if (0 == mid)
      {
         return (-1);
      }
      (*env)->CallVoidMethod (env, classDefCount, mid, cClassDefCount);
   }
   return (ccode);

} /* NWDSGetClassDefCount () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSGetClassItem
 * Signature: (IILjava/lang/StringBuffer;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSGetClassItem
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint buf,
   jobject classItem /*StringBuffer*/ /*out*/
)
{
   NWDSCCODE   ccode;
   unicode     cClassItem[(MAX_SCHEMA_NAME_CHARS +1)];

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSGetClassItem (
               (NWDSContextHandle) context,
               (pBuf_T) buf,     // Typecast 32-bit integer as pointer
               (pnstr8)cClassItem);      // Save results in 'C' string

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if (0 == ccode)
   {
      jclass         cls;
      jmethodID      mid;
      jstring        string;

      // Copy 'C' variables back into Java variables
      cls = (*env)->GetObjectClass(env, classItem);
      mid = (*env)->GetMethodID (env, cls, "append","(Ljava/lang/String;)Ljava/lang/StringBuffer;");
      if (0 == mid)
      {
         return(-1);
      }
      string = (*env)->NewString (env, cClassItem, unilen (cClassItem));
      (*env)->CallObjectMethod (env, classItem, mid, string);
   }
   return (ccode);

} /* NWDSGetClassItem () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSGetClassItemCount
 * Signature: (IILcom/novell/utility/java/lang/IntegerBuffer;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSGetClassItemCount
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint buf,
   jobject classItemCount /*IntegerBuffer*/ /*out*/
)
{
   NWDSCCODE ccode;
   nuint32 cClassItemCount;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSGetClassItemCount (
               (NWDSContextHandle) context,
               (pBuf_T) buf,
               &cClassItemCount);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if (0 == ccode)
   {
      jclass         cls;
      jmethodID      mid;

      // Copy 'C' variable back into Java variable
      cls = (*env)->GetObjectClass(env, classItemCount);
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod (env, classItemCount, mid, (jint)cClassItemCount);
   }
   return (ccode);

} /* NWDSGetClassItemCount () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSGetObjectCount
 * Signature: (IILcom/novell/service/toolkit/jcl/NWInteger;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSGetObjectCount
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint buf,
   jobject objectCount /*NWInteger*/ /*out*/
)
{
   NWDSCCODE ccode;
   nuint32 cObjectCount;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSGetObjectCount (
               (NWDSContextHandle) context,
               (pBuf_T) buf,     // Typecast 32-bit integer as pointer
               &cObjectCount);   // Save results in 'C' variable

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if (0 == ccode)
   {
      jclass         cls;
      jmethodID      mid;

      // Copy 'C' variable back into java variable
      cls = (*env)->GetObjectClass (env, objectCount);
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      if (0 == mid)
      {
         return (-1);
      }
      (*env)->CallVoidMethod (env, objectCount, mid, (jint) cObjectCount);
   }
   return (ccode);

} /* NWDSGetObjectCount () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSGetObjectName
 * Signature: (IILjava/lang/StringBuffer;Lcom/novell/service/toolkit/jcl/NWInteger;Lcom/novell/service/jncpv2r/net/NetObjectInfo;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSGetObjectName
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint buf,
   jobject objectName /*StringBuffer*/ /*out*/,
   jobject attrCount /*NWInteger*/ /*out*/,
   jobject objectInfo /*NDSObjectInfo*/ /*out*/)
{
   NWDSCCODE      ccode;
   Object_Info_T  cObjectInfo;
   unicode        cObjectName [MAX_DN_CHARS + 1];
   nuint32        cAttrCount;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSGetObjectName (
               (NWDSContextHandle) context,
               (pBuf_T) buf,     // Typecast 32-bit integer as pointer
               (pnstr8) cObjectName,  // Save results in 'C' variable
               &cAttrCount,      // Save results in 'C' variable
               &cObjectInfo);    // Save results in 'C' variable

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if (0 == ccode)
   {
      jclass         cls;
      jmethodID      mid;
      jstring        string;

      // Copy the cObjectName into the Java objectName string buffer
      cls = (*env)->GetObjectClass(env, objectName);
      mid = (*env)->GetMethodID (env, cls, "append","(Ljava/lang/String;)Ljava/lang/StringBuffer;");
      if (0 == mid)
      {
         return(-1);
      }
      string = (*env)->NewString(env, cObjectName, unilen (cObjectName));
      (*env)->CallObjectMethod(env, objectName, mid, string);

      // Copy the cAttrCount into the Java attrCount
      cls = (*env)->GetObjectClass(env, attrCount);
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod(env, attrCount, mid, (jint)cAttrCount);

      // Copy the cObjectInfo into the Java objectInfo
      cls = (*env)->GetObjectClass(env, objectInfo);
      mid = (*env)->GetMethodID (env, cls, "setObjectFlags","(I)V");
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod(env, objectInfo, mid, (jint)cObjectInfo.objectFlags);

      mid = (*env)->GetMethodID (env, cls, "setSubordinateCount","(I)V");
      if (0 == mid)
      {
         return(-1);
      }
      (*env)->CallVoidMethod(env, objectInfo, mid, (jint) cObjectInfo.subordinateCount);

      mid = (*env)->GetMethodID (env, cls, "setModificationTime","(I)V");
      (*env)->CallVoidMethod(env, objectInfo, mid, (jint) cObjectInfo.modificationTime);

      mid = (*env)->GetMethodID (env, cls, "setBaseClass","(Ljava/lang/String;)V");
      if (0 == mid)
      {
         return(-1);
      }
      string = (*env)->NewString(
                        env,
                        (unicode *)cObjectInfo.baseClass,
                        unilen ((unicode *)cObjectInfo.baseClass));
      (*env)->CallVoidMethod(env, objectInfo, mid, string);
   }
   return (ccode);

} /* NWDSGetObjectName () */

/* Not Implemented
N_GLOBAL_LIBRARY (NWDSCCODE)
NWDSGetObjectNameAndInfo
(
   NWDSContextHandle    context,
   pBuf_T               buf,
   pnstr8               objectName,
   pnuint32             attrCount,
   ppnstr8              objectInfo
);
*/

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSGetDSIInfo
 * Signature: (ILcom/novell/service/jncpv2r/net/NetMemory;ILcom/novell/service/jncpv2r/net/NetMemory;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSGetDSIInfo
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jobject buf,   /*NetMemory*/ /*in*/
   jint infoFlag,
   jobject data   /*NetMemory*/ /*out*/
)
{
   NWDSCCODE      ccode;
   // JNI variables
   jclass cls;
   jmethodID getHandleMid, getSizeMid;
   // NWNet variables
   nptr cBuf, cData;
   nuint32 cBufLen;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // NetMemory methods
   cls = (*env)->GetObjectClass (env, buf);
   getHandleMid = (*env)->GetMethodID (env, cls, "getHandle", "()I");
   getSizeMid = (*env)->GetMethodID (env, cls, "getSize", "()I");

   // buf.getHandle ()
   cBuf = (nptr)(*env)->CallIntMethod (env, buf, getHandleMid);

   // buf.getSize ()
   cBufLen = (nuint32)(*env)->CallIntMethod (env, buf, getSizeMid);

   // data.getHandle ()
   cData = (nptr)(*env)->CallIntMethod (env, data, getHandleMid);

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = (NWDSGetDSIInfo (
               (NWDSContextHandle) context,
               cBuf,
               cBufLen,
               (nuint32) infoFlag,
               cData));

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return (ccode);

} /* NWDSGetDSIInfo () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSGetPartitionInfo
 * Signature: (IILjava/lang/StringBuffer;Lcom/novell/utility/java/lang/IntegerBuffer;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSGetPartitionInfo
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint buf,
   jobject partitionName,
   jobject replicaType
)
{
   // NWNet variables
   NWDSCCODE   ccode;
   unicode     cPartitionName[MAX_DN_CHARS + 1];
   nuint32     cReplicaType;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   // Make C API call
   ccode = NWDSGetPartitionInfo(
               (NWDSContextHandle)context,
               (pBuf_T)buf,
               (pnstr8)cPartitionName,
               &cReplicaType);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   // Convert 'C' variable to Java variable
   if (ccode == N_SUCCESS)
   {
      jclass      cls;
      jmethodID   mid;
      jstring     string;

      // Copy the cPartitionName into the Java partitionName string buffer
      cls = (*env)->GetObjectClass(env, partitionName);
      mid = (*env)->GetMethodID (env, cls, "append","(Ljava/lang/String;)Ljava/lang/StringBuffer;");
      if (0 == mid)
      {
         return(-1);
      }
      string = (*env)->NewString(env, cPartitionName, unilen (cPartitionName));
      (*env)->CallObjectMethod(env, partitionName, mid, string);

      // Copy the cReplicaType into the Java replicaType
      cls = (*env)->GetObjectClass(env, replicaType);
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      (*env)->CallVoidMethod(env, replicaType, mid, (jint)cReplicaType);
   }
   return (ccode);

} /* NWDSGetPartitionInfo */

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSGetReplicaReferenceRootID
(
   NWDSContextHandle context,
   pBuf_T            buf,
   pnuint32          replicaRootID
);
*/

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSGetServerName
 * Signature: (IILjava/lang/StringBuffer;Lcom/novell/utility/java/lang/IntegerBuffer;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSGetServerName
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint buf,
   jobject serverName, /*StringBuffer*/ /*out*/
   jobject partitionCount  /*IntegerBuffer*/ /*out*/
)
{
   // NWNet variables
   NWDSCCODE   ccode;
   unicode     cServerName[MAX_DN_CHARS + 1];
   nuint32     cPartitionCount;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   // Make C API call
   ccode = NWDSGetServerName (
               (NWDSContextHandle) context,
               (pBuf_T) buf,
               (pnstr8) cServerName,
               &cPartitionCount);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   // Convert 'C' variable to Java variable
   if (ccode == N_SUCCESS)
   {
      // JNI variables
      jclass      cls;
      jmethodID   appendMid, setValueMid;

      // StringBuffer method
      cls = (*env)->GetObjectClass (env, serverName);
      appendMid = (*env)->GetMethodID (
                              env,
                              cls,
                              "append",
                              "(Ljava/lang/String;)Ljava/lang/StringBuffer;");

      // IntegerBuffer method
      cls = (*env)->GetObjectClass (env, partitionCount);
      setValueMid = (*env)->GetMethodID (env, cls, "setValue", "(I)V");


      // Copy the cServerName into the Java serverName string buffer
      (*env)->CallObjectMethod (
                  env,
                  serverName,
                  appendMid,
                  (*env)->NewString(env, cServerName, unilen (cServerName)));

      // Copy cPartitionCount into Java partitionCount
      (*env)->CallVoidMethod (
                  env,
                  partitionCount,
                  setValueMid,
                  (jint) cPartitionCount);
   }
   return (ccode);

} /* NWDSGetServerName () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSGetPartitionExtInfoPtr
 * Signature: (IILcom/novell/utility/java/lang/IntegerBuffer;Lcom/novell/utility/java/lang/IntegerBuffer;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSGetPartitionExtInfoPtr
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint buf,
   jobject infoPtr, /*IntegerBuffer*/ /*out*/
   jobject infoPtrEnd /*IntegerBuffer*/ /*out*/
)
{
   NWDSCCODE ccode;
   pnstr8 cInfoPtr;
   pnstr8 cInfoPtrEnd;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSGetPartitionExtInfoPtr(
               (NWDSContextHandle)context,
               (pBuf_T)buf,
               &cInfoPtr,
               &cInfoPtrEnd);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   // Convert 'C' variable to Java variable
   if (ccode == N_SUCCESS)
   {
      jclass      cls;
      jmethodID   mid;

      // Copy the cInfoPtr into the Java infoPtr
      cls = (*env)->GetObjectClass(env, infoPtr);
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      (*env)->CallVoidMethod(env, infoPtr, mid, (jint)cInfoPtr);

      // Copy the cInfoPtrEnd into the Java infoPtrEnd
      cls = (*env)->GetObjectClass(env, infoPtrEnd);
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      (*env)->CallVoidMethod(env, infoPtrEnd, mid, (jint)cInfoPtrEnd);
   }
   return (ccode);

} /* NWDSGetPartitionExtInfoPtr () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSGetPartitionExtInfo
 * Signature: (IIIILcom/novell/utility/java/lang/IntegerBuffer;Lcom/novell/service/jncpv2r/net/NetPartitionExtInfo;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSGetPartitionExtInfo
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint infoPtr,
   jint limit,
   jint infoFlag,
   jobject length, /*IntegerBuffer*/
   jobject data) /*NdsPartitionExtInfo*/ /*out*/
{
//NOTE: length is never used
//NOTE: have steve check
   unicode        cName[MAX_DN_CHARS + 1];
   nuint32        cLength;
   nuint32        cValue;
   TimeStamp_T    cTime;
   jobject        object;
   NWDSCCODE    ccode = -1;
   jclass      cls;
   jmethodID   mid;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   switch (infoFlag)
   {
      case DSP_LOCAL_PARTITION_ID:
      case DSP_PARTITION_ID:
      case DSP_REPLICA_TYPE:
      case DSP_REPLICA_STATE:
      case DSP_PARTITION_BUSY:
      case DSP_PURGE_TIME:
      {
         ccode = NWDSGetPartitionExtInfo (
                     (NWDSContextHandle)context,
                     (pnstr8)infoPtr,
                     (pnstr8)limit,
                     (nflag32)infoFlag,
                     &cLength,
                     &cValue);

         if (ccode != N_SUCCESS)
            break;

         cls = (*env)->FindClass(env, "com/novell/java/lang/IntegerBuffer");
         mid = (*env)->GetMethodID (env, cls, "<init>","(I)V");
         object = (*env)->NewObject(env, cls, mid, (jint) cValue);

         break;
      }

      case DSP_MODIFICATION_TIMESTAMP:
      {
         ccode = NWDSGetPartitionExtInfo((NWDSContextHandle)context,
                                        (pnstr8)infoPtr,
                                        (pnstr8)limit,
                                        (nflag32)infoFlag,
                                        &cLength,
                                        &cTime);
         if (ccode != N_SUCCESS)
            break;

         cls = (*env)->FindClass(env, "com/novell/service/nds/NdsTimestamp");
         mid = (*env)->GetMethodID (env, cls, "<init>","(JII)V");
         object = (*env)->NewObject(
                           env,
                           cls,
                           mid,
                           (jlong) cTime.wholeSeconds,
                           (jint) cTime.eventID,
                           (jint) cTime.replicaNum);
         break;
      }

      case DSP_PARTITION_DN:
      {
         ccode = NWDSGetPartitionExtInfo (
                     (NWDSContextHandle) context,
                     (pnstr8) infoPtr,
                     (pnstr8) limit,
                     (nflag32) infoFlag,
                     &cLength,
                     cName);

         if (ccode != N_SUCCESS)
            break;

         object = (*env)->NewString (env, cName, unilen (cName));
         break;
      }

      default:
      {
        ccode = ERR_BAD_KEY;
        break;
      }
   }

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if (ccode == N_SUCCESS)
   {
      cls = (*env)->GetObjectClass(env, data);
      mid = (*env)->GetMethodID (env, cls, "setValue","(Ljava/lang/Object;)V");
      (*env)->CallVoidMethod(env, data, mid, object);
   }
   return (ccode);

} /* NWDSGetPartitionExtInfo () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSGetSyntaxCount
 * Signature: (IILcom/novell/service/toolkit/jcl/NWInteger;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSGetSyntaxCount
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint buf,
   jobject syntaxCount /*NWInteger*/ /*out*/
)
{
   NWDSCCODE      ccode;
   nuint32        cSyntaxCount;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSGetSyntaxCount (
               (NWDSContextHandle) context,
               (pBuf_T) buf,
               &cSyntaxCount);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if (0 == ccode)
   {
      jclass         cls;
      jmethodID      mid;

      // Copy 'C' variable back into java variable
      cls = (*env)->GetObjectClass(env, syntaxCount);
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      (*env)->CallVoidMethod(env, syntaxCount, mid, (jint)cSyntaxCount);
   }
   return (ccode);

} /* NWDSGetSyntaxCount () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSGetSyntaxDef
 * Signature: (IILjava/lang/StringBuffer;Lcom/novell/service/jncpv2r/net/NetSyntaxInfo;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSGetSyntaxDef
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint buf,
   jobject syntaxName /*StringBuffer*/ /*out*/,
   jobject syntaxDef /*NDSSyntaxInfo*/ /*out*/
)
{
   NWDSCCODE      ccode;
   unicode        cSyntaxName [MAX_SCHEMA_NAME_CHARS + 1];
   Syntax_Info_T  cSyntaxDef;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSGetSyntaxDef (
               (NWDSContextHandle) context,
               (pBuf_T) buf,     // Typecast 32-bit integer as pointer
               (pnstr8) cSyntaxName,      // Save results in 'C' variable
               &cSyntaxDef);     // Save results in 'C' variable

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if (0 == ccode)
   {
      jclass         cls;
      jmethodID      mid;
      jstring        string;

      // Copy the cSyntaxName
      cls = (*env)->GetObjectClass(env, syntaxName);
      mid = (*env)->GetMethodID (env, cls, "append","(Ljava/lang/String;)Ljava/lang/StringBuffer;");
      string = (*env)->NewString(env, cSyntaxName, unilen (cSyntaxName));
      (*env)->CallObjectMethod(env, syntaxName, mid, string);

      cls = (*env)->GetObjectClass(env, syntaxDef);
      mid = (*env)->GetMethodID (env, cls, "setID","(I)V");
      (*env)->CallVoidMethod(env, syntaxDef, mid, (jint)cSyntaxDef.ID);

      mid = (*env)->GetMethodID (env, cls, "setFlags","(I)V");
      (*env)->CallVoidMethod(env, syntaxDef, mid, (jint)cSyntaxDef.flags);

      mid = (*env)->GetMethodID (env, cls, "setDefStr","(Ljava/lang/String;)V");
      string = (*env)->NewString(
                        env,
                        (unicode *)cSyntaxDef.defStr,
                        unilen ((unicode *)cSyntaxDef.defStr));
      (*env)->CallVoidMethod(env, syntaxDef, mid, string);
   }
   return (ccode);

} /* NWDSGetSyntaxDef () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSInitBuf
 * Signature: (III)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSInitBuf
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint operation,
   jint buf
)
{
   NWDSCCODE   ccode;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = (NWDSInitBuf(
               (NWDSContextHandle)context,
               (nuint32)operation,
               (pBuf_T)buf));

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return ccode;
} /* NWDSInitBuf () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSPutAttrName
 * Signature: (IILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSPutAttrName
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint buf,
   jstring attrName
)
{
   NWDSCCODE   ccode;
   unicode     cAttrName[MAX_DN_CHARS + 1];

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   jstring2unicode (env, attrName, cAttrName, sizeof(cAttrName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSPutAttrName(
               (NWDSContextHandle) context,
               (pBuf_T) buf,
               (pnstr8)cAttrName);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return (ccode);

} /*  NWDSPutAttrName () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSPutAttrVal
 * Signature: (IIII)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSPutAttrVal
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   /*in*/   jint context,
   /*in*/   jint buf,
   /*in*/   jint syntaxID,
   /*in*/   jint attrVal
)
{
   NWDSCCODE ccode;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = (NWDSPutAttrVal(
               (NWDSContextHandle) context,
               (pBuf_T) buf,
               syntaxID,
               (nptr) attrVal));

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return ccode;
} /* NWDSPutAttrVal () */

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSPutAttrNameAndVal
(
   NWDSContextHandle context,
   pBuf_T            buf,
   pnstr8            attrName,
   nuint32           syntaxID,
   nptr              attrVal
);
*/

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSPutChange
 * Signature: (IIILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSPutChange
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint buf,
   jint changeType,
   jstring attrName
)
{
   NWDSCCODE ccode;
   unicode cAttrName[MAX_DN_CHARS + 1];

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // put the java unicode string into c unicode style.
   jstring2unicode (env, attrName, cAttrName, sizeof(cAttrName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSPutChange (
               (NWDSContextHandle) context,
               (pBuf_T) buf,
               (nuint32) changeType,
               (pnstr8)cAttrName);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return (ccode);

} /* NWDSPutChange */

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSPutChangeAndVal
(
   NWDSContextHandle context,
   pBuf_T            buf,
   nuint32           changeType,
   pnstr8            attrName,
   nuint32           syntaxID,
   nptr              attrVal
);
*/

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSPutClassItem
 * Signature: (IILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSPutClassItem
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint buf,
   jstring itemName
)
{
   NWDSCCODE ccode;
   unicode     cItemName[MAX_DN_CHARS + 1];

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // put the java unicode string into c unicode style.
   jstring2unicode (env, itemName, cItemName, sizeof(cItemName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSPutClassItem (
               (NWDSContextHandle) context,
               (pBuf_T) buf,           // Typecast 32-bit integer as pointer
               (pnstr8) cItemName);     // Save results in 'C' variable

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return (ccode);

} /* NWDSPutClassItem () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSPutSyntaxName
 * Signature: (IILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSPutSyntaxName
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint buf,
   jstring syntaxName
)
{
   NWDSCCODE ccode;
   unicode cSyntaxName[MAX_DN_CHARS+1];

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   jstring2unicode(env, syntaxName, cSyntaxName, sizeof(cSyntaxName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSPutSyntaxName(
               (NWDSContextHandle) context,
               (pBuf_T) buf,
               (pnstr8) cSyntaxName);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return (ccode);

} /* NWDSPutSyntaxName () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSPutClassName
 * Signature: (IILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSPutClassName
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint buf,
   jstring className
)
{
   NWDSCCODE ccode;
   unicode cClassName[MAX_DN_CHARS+1];

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   jstring2unicode(env, className, cClassName, sizeof(cClassName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSPutClassName(
               (NWDSContextHandle) context,
               (pBuf_T) buf,
               (pnstr8) cClassName);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return (ccode);

} /* NWDSPutClassName () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSBeginClassItem
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSBeginClassItem
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint buf
)
{
   NWDSCCODE   ccode;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = (NWDSBeginClassItem(
                        (NWDSContextHandle) context,
                        (pBuf_T) buf));

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return ccode;
} /* NWDSBeginClassItem () */

/***** nwdsconn.h *********************************************************/

/*
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSOpenConnToNDSServer
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring serverName,
   jobject connHandle //IntegerBuffer out
)
{
   NWDSCCODE   ccode;
   unicode     cServerName[MAX_DN_CHARS + 1];
   NWCONN_HANDLE cConnHandle;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Convert Java variable to 'C' variable
   jstring2unicode (env, serverName, cServerName, sizeof(cServerName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   // Make C API call
   ccode = NWDSOpenConnToNDSServer(
               (NWDSContextHandle)context,
               (pnstr8)cServerName,
               &cConnHandle);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   // Copy cMajorVersion into Java majorVersion
   if (ccode == N_SUCCESS)
   {
      jclass      cls;
      jmethodID   mid;

      cls = (*env)->GetObjectClass(env, connHandle);
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      (*env)->CallVoidMethod(env, connHandle, mid, (jint)cConnHandle);
   }
   return ccode;

}  NWDSOpenConnToNDSServer () */

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSGetDefNameContext
(
   NWDSContextHandle context,
   nuint             nameContextLen,
   pnstr8            nameContext
);*/

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSSetDefNameContext
(
   NWDSContextHandle context,
   nuint             nameContextLen,
   pnstr8            nameContext
);*/

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSGetMonitoredConnRef
(
   NWDSContextHandle context,
   pnuint32          connRef
);*/

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSOpenMonitoredConn
(
   NWDSContextHandle context,
   pNWCONN_HANDLE    connHandle
);*/

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSScanConnsForTrees
(
   NWDSContextHandle context,
   nuint             numOfPtrs,
   pnuint            numOfTrees,
   ppnstr8           treeBufPtrs
);*/

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSScanForAvailableTrees
(
   NWDSContextHandle context,
   NWCONN_HANDLE     connHandle,
   pnstr             scanFilter,
   pnint32           scanIndex,
   pnstr             treeName
);*/

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSReturnBlockOfAvailableTrees
(
   NWDSContextHandle context,
   NWCONN_HANDLE     connHandle,
   pnstr             scanFilter,
   pnstr             lastBlocksString,
   pnstr             endBoundString,
   nuint32           maxTreeNames,
   ppnstr            arrayOfNames,
   pnuint32          numberOfTrees,
   pnuint32          totalUniqueTrees
);*/

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSCanDSAuthenticate()
*/

/***** nwdsdc.h ***********************************************************/

/* Not Implemented
N_EXTERN_LIBRARY (NWDSContextHandle)
NWDSCreateContext
(
   void
)
{
   return (NWDSCreateContext ());

}*/

/* Not Implemented
N_EXTERN_LIBRARY (NWDSContextHandle)
NWDSDuplicateContext
(
   NWDSContextHandle oldContext
)
{
   return (NWDSDuplicateContext (oldContext));

} * NWDSDuplicateContext () */

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSFreeContext
(
   NWDSContextHandle context
)
{
   return (NWDSFreeContext (context));

} * NWDSFreeContext () */

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSGetContext
(
   NWDSContextHandle context,
   nint              key,
   nptr              value
);*/

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSSetContext
(
   NWDSContextHandle context,
   nint              key,
   nptr              value
);*/

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSCreateContextHandle
(
   NWDSContextHandle N_FAR *newHandle
)
{
   NWDSCCODE ccode;
   NWDSContextHandle cContextHandle;

   ccode = NWDSCreateContextHandle (&cContextHandle);

   if (0 == ccode)
   {
      jclass cls;
      jmethodID mid;

      // Copy 'C' variable back into Java variable
      cls = (*env)->GetObjectClass (env, newHandle);
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      if (0 == mid)
      {
        return(-1);
     }
     (*env)->CallVoidMethod (env, newHandle, mid, cContextHandle);
   }
   return (ccode);

} * NWDSCreateContextHandle () */

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSDuplicateContextHandle
(
   NWDSContextHandle       srcContextHandle,
   NWDSContextHandle N_FAR *destContextHandle
)
{
   NWDSCCODE ccode;
   NWDSContextHandle cDestContextHandle;

   ccode = NWDSDuplicateContextHandle (
               srcContextHandle,
               &cDestContextHandle);

   if (0 == ccode)
   {
      jclass cls;
      jmethodID mid;

      // Copy 'C' variable back into Java variable
      cls = (*env)->GetObjectClass (env, destContextHandle);
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      if (0 == mid)
      {
         return (-1);
      }
      (*env)->CallVoidMethod (
                  env,
                  destContextHandle,
                  mid,
                  cDestContextHandle);
   }
   return (ccode);

} * NWDSDuplicateContextHandle () */

/***** nwdsdsa.h **********************************************************/

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSAddObject
 * Signature: (ILjava/lang/String;Lcom/novell/service/jncpv2r/net/NetIterationHandle;ZI)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSAddObject
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring objectName,
   jobject iterationHandle, /*NDSIterationHandle*/
   jboolean more,
   jint objectInfo
)
{
// NOTE: We are not handling the iterationHandle!
   NWDSCCODE ccode;
   unicode cObjectName[MAX_DN_CHARS + 1];

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // put the java unicode string into c unicode style.
   if ((*env)->GetStringLength(env, objectName) > MAX_DN_CHARS)
      return ERR_DN_TOO_LONG;
   jstring2unicode(env, objectName, cObjectName, sizeof(cObjectName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSAddObject (
               (NWDSContextHandle) context,
               (pnstr8) cObjectName,
               (pnint32) NULL, //(pnint32) &cIterationHandle,
               (nbool8) more,
               (pBuf_T) objectInfo);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return (ccode);

} /* NWDSAddObject () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSBackupObject
 * Signature: (ILjava/lang/String;Lcom/novell/service/jncpv2r/net/NetIterationHandle;I)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSBackupObject
(
   JNIEnv * env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring objectName,
   jobject iterationHandle, /*NDSIterationHandle*/
   jint bufHandle
)
{
   NWDSCCODE ccode;
   unicode cObjectName[MAX_DN_CHARS + 1];
   nint32  cIterationHandle;
   jclass cls;
   jmethodID mid;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // put the java unicode string into c unicode style.
   jstring2unicode(env, objectName, cObjectName, sizeof(cObjectName));

   //get iteration handle
   cls = (*env)->GetObjectClass(env, iterationHandle);
   mid = (*env)->GetMethodID (env, cls, "getValue","()I");
   cIterationHandle = (nint32)(*env)->CallIntMethod(env, iterationHandle, mid);

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSBackupObject((NWDSContextHandle)context,
                         (pnstr8)cObjectName,
                         (pnint32)&cIterationHandle,
                         (pBuf_T)bufHandle);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if(N_SUCCESS == ccode)
   {
      cls = (*env)->GetObjectClass(env, iterationHandle);
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      (*env)->CallVoidMethod(env, iterationHandle, mid, (jint)cIterationHandle);
   }
   else
   {
      cls = (*env)->GetObjectClass(env, iterationHandle);
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      (*env)->CallVoidMethod(env, iterationHandle, mid, (jint) NO_MORE_ITERATIONS);
   }
   return(ccode);

} /* NWDSBackupObject () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSCompare
 * Signature: (ILjava/lang/String;ILcom/novell/utility/java/lang/BooleanBuffer;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSCompare
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring object,
   jint bufHandle,
   jobject matched /*out*/
)
{
// FIXUP BBerg
   jclass cls;
   jmethodID mid;
   NWDSCCODE ccode;
   unicode *cObject;
   nbool8 Matched = (nbool8)matched;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // put the java unicode string into c unicode style.
   cObject = (unicode *)(*env)->GetStringChars(env, object, 0);

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSCompare((NWDSContextHandle)context,
                         (pnstr8)cObject,
                         (pBuf_T)bufHandle,
                         &Matched);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   (*env)->ReleaseStringChars(env, object, cObject);
    cls = (*env)->GetObjectClass(env, matched);
    mid = (*env)->GetMethodID(env, cls, "setValue","(I)V");
    (*env)->CallObjectMethod(env, matched, mid, Matched);
   return(ccode);

} /*  */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSGetPartitionRoot
 * Signature: (ILjava/lang/String;Ljava/lang/StringBuffer;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSGetPartitionRoot
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring objectName,
   jobject partitionRoot /*StringBuffer*/ /*out*/
)
{
   unicode         cPartitionRoot[MAX_DN_CHARS + 1];
   unicode         cObjectName[MAX_DN_CHARS + 1];
   NWDSCCODE       ccode = -1;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Convert Java variable to 'C' variable
   jstring2unicode(env, objectName, cObjectName, sizeof(cObjectName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   // Make C API call
   ccode = NWDSGetPartitionRoot((NWDSContextHandle)context,
                  (pnstr8)cObjectName, (pnstr8)cPartitionRoot);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   // Convert 'C' variable to Java variable
   if (ccode == N_SUCCESS)
   {
      jclass      cls;
      jmethodID   mid;
      jstring     string;

      cls = (*env)->GetObjectClass(env, partitionRoot);
      mid = (*env)->GetMethodID (env, cls, "append","(Ljava/lang/String;)Ljava/lang/StringBuffer;");
      string = (*env)->NewString(env, cPartitionRoot, unilen (cPartitionRoot));
      (*env)->CallObjectMethod(env, partitionRoot, mid, string);
   }
   return (ccode);

} /* NWDSGetPartitionRoot () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSList
 * Signature: (ILjava/lang/String;Lcom/novell/service/jncpv2r/net/NetIterationHandle;[B)I
 */
JNIEXPORT jint JNICALL
JNICALL Java_com_novell_service_jncpv2r_net_NetJNI_NWDSList
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring objectName,
   jobject iterationHandle,   /*NetIterationHandle*/
   jbyteArray subordinates
)
{
   // JNI variables
   jclass clsIterationHandle;
   jfieldID handleId;
   // NWNet variables
   NWDSCCODE ccode;
   unicode cObjectName[MAX_DN_CHARS+1];
   nint32 cIterationHandle;
   nuint32 oldFlags, newFlags;
   pBuf_T cSubordinates;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Alloc Buf_T
   ccode = NWDSAllocBuf (
               (*env)->GetArrayLength (env, subordinates),
               &cSubordinates);
   if (N_SUCCESS != ccode)
   {
      goto EXIT;
   }

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (N_SUCCESS != ccode)
   {
      goto CLEANUP;
   }
#endif

   ccode = NWDSGetContext ((NWDSContextHandle) context, DCK_DSI_FLAGS, &oldFlags);
   if (N_SUCCESS != ccode)
   {
      goto UNWRAP;
   }

   newFlags = oldFlags & ~DSI_BASE_CLASS | DSI_DEREFERENCE_BASE_CLASS;

   ccode = NWDSSetContext ((NWDSContextHandle) context, DCK_DSI_FLAGS, &newFlags);
   if (N_SUCCESS != ccode)
   {
      goto UNWRAP;
   }

   // Convert Java variable to 'C' variable
   jstring2unicode (env, objectName, cObjectName, sizeof(cObjectName));

   // Get iteration handle
   clsIterationHandle = (*env)->GetObjectClass (env, iterationHandle);
   handleId = (*env)->GetFieldID (env, clsIterationHandle, "handle", "I");
   cIterationHandle = (nint32)(*env)->GetIntField (env, iterationHandle, handleId);

   // Make C API call
   ccode = NWDSList (
               (NWDSContextHandle) context,
               (pnstr8) cObjectName,
               &cIterationHandle,
               cSubordinates);

   // Set iteration handle
   (*env)->SetIntField (env, iterationHandle, handleId, (jint) cIterationHandle);

   if (N_SUCCESS == ccode)
   {
      // copy Buf_T.curPos to byte[]
      (*env)->SetByteArrayRegion (
                  env,
                  subordinates,
                  0,
                  cSubordinates->curLen,
                  (jbyte *) cSubordinates->curPos);
   }

   NWDSSetContext ((NWDSContextHandle) context, DCK_DSI_FLAGS, &oldFlags);

UNWRAP:

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

#ifdef N_PLAT_NLM
CLEANUP:
#endif

   NWDSFreeBuf (cSubordinates);

EXIT:

   return (ccode);

} /* NWDSList () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSExtSyncList
 * Signature: 
 */
JNIEXPORT jint JNICALL
JNICALL Java_com_novell_service_jncpv2r_net_NetJNI_NWDSExtSyncList
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring objectName,
   jstring className,
   jstring subordinateName,
   jobject iterationHandle,   /*NetIterationHandle*/
   jint timeStamp,
   jboolean onlyContainers,
   jbyteArray subordinates
)
{
   // JNI variables
   jclass clsIterationHandle;
   jfieldID handleId;
   // NWNet variables
   NWDSCCODE ccode;
   unicode cObjectName[MAX_DN_CHARS + 1];
   unicode cClassName[MAX_SCHEMA_NAME_CHARS + 1];
   unicode cSubordinateName[MAX_DN_CHARS + 1];
   nint32 cIterationHandle;
   nuint32 oldFlags, newFlags;
   pBuf_T cSubordinates;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Alloc Buf_T
   ccode = NWDSAllocBuf (
               (*env)->GetArrayLength (env, subordinates),
               &cSubordinates);
   if (N_SUCCESS != ccode)
   {
      goto EXIT;
   }

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (N_SUCCESS != ccode)
   {
      goto CLEANUP;
   }
#endif

   ccode = NWDSGetContext ((NWDSContextHandle) context, DCK_DSI_FLAGS, &oldFlags);
   if (N_SUCCESS != ccode)
   {
      goto UNWRAP;
   }

   newFlags = oldFlags & ~DSI_BASE_CLASS | DSI_DEREFERENCE_BASE_CLASS;

   ccode = NWDSSetContext ((NWDSContextHandle) context, DCK_DSI_FLAGS, &newFlags);
   if (N_SUCCESS != ccode)
   {
      goto UNWRAP;
   }

   // Convert Java variables to 'C' variables
   jstring2unicode (env, objectName, cObjectName, sizeof(cObjectName));

   if (className != NULL)
      jstring2unicode (env, className, cClassName, sizeof(cClassName));

   if (subordinateName != NULL)
      jstring2unicode (env, subordinateName, cSubordinateName, sizeof(cSubordinateName));

   // Get iteration handle
   clsIterationHandle = (*env)->GetObjectClass (env, iterationHandle);
   handleId = (*env)->GetFieldID (env, clsIterationHandle, "handle", "I");
   cIterationHandle = (nint32)(*env)->GetIntField (env, iterationHandle, handleId);

   // Make C API call
   ccode = NWDSExtSyncList (
               (NWDSContextHandle) context,
               (pnstr8) cObjectName,
               className == NULL ? NULL : (pnstr8) cClassName,
               subordinateName == NULL ? NULL : (pnstr8) cSubordinateName,
               &cIterationHandle,
               (pTimeStamp_T) timeStamp,
               (nbool8) onlyContainers,
               cSubordinates);

   // Set iteration handle
   (*env)->SetIntField (env, iterationHandle, handleId, (jint) cIterationHandle);

   if (N_SUCCESS == ccode)
   {
      // copy Buf_T.curPos to byte[]
      (*env)->SetByteArrayRegion (
                  env,
                  subordinates,
                  0,
                  cSubordinates->curLen,
                  (jbyte *) cSubordinates->curPos);
   }

   NWDSSetContext ((NWDSContextHandle) context, DCK_DSI_FLAGS, &oldFlags);

UNWRAP:

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

#ifdef N_PLAT_NLM
CLEANUP:
#endif

   NWDSFreeBuf (cSubordinates);

EXIT:

   return (ccode);

} /* NWDSExtSyncList () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSListByClassAndName
 * Signature: 
 */
JNIEXPORT jint JNICALL
JNICALL Java_com_novell_service_jncpv2r_net_NetJNI_NWDSListByClassAndName
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring objectName,
   jstring className,
   jstring subordinateName,
   jobject iterationHandle,   /*NetIterationHandle*/
   jbyteArray subordinates
)
{
   // JNI variables
   jclass clsIterationHandle;
   jfieldID handleId;
   // NWNet variables
   NWDSCCODE ccode;
   unicode cObjectName[MAX_DN_CHARS + 1];
   unicode cClassName[MAX_SCHEMA_NAME_CHARS + 1];
   unicode cSubordinateName[MAX_DN_CHARS + 1];
   nint32 cIterationHandle;
   nuint32 oldFlags, newFlags;
   pBuf_T cSubordinates;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Alloc Buf_T
   ccode = NWDSAllocBuf (
               (*env)->GetArrayLength (env, subordinates),
               &cSubordinates);
   if (N_SUCCESS != ccode)
   {
      goto EXIT;
   }

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (N_SUCCESS != ccode)
   {
      goto CLEANUP;
   }
#endif

   ccode = NWDSGetContext ((NWDSContextHandle) context, DCK_DSI_FLAGS, &oldFlags);
   if (N_SUCCESS != ccode)
   {
      goto UNWRAP;
   }

   newFlags = oldFlags & ~DSI_BASE_CLASS | DSI_DEREFERENCE_BASE_CLASS;

   ccode = NWDSSetContext ((NWDSContextHandle) context, DCK_DSI_FLAGS, &newFlags);
   if (N_SUCCESS != ccode)
   {
      goto UNWRAP;
   }

   // Convert Java variables to 'C' variables
   jstring2unicode (env, objectName, cObjectName, sizeof(cObjectName));

   if (className != NULL)
      jstring2unicode (env, className, cClassName, sizeof(cClassName));

   if (subordinateName != NULL)
      jstring2unicode (env, subordinateName, cSubordinateName, sizeof(cSubordinateName));

   // Get iteration handle
   clsIterationHandle = (*env)->GetObjectClass (env, iterationHandle);
   handleId = (*env)->GetFieldID (env, clsIterationHandle, "handle", "I");
   cIterationHandle = (nint32)(*env)->GetIntField (env, iterationHandle, handleId);

   // Make C API call
   ccode = NWDSListByClassAndName (
               (NWDSContextHandle) context,
               (pnstr8) cObjectName,
               className == NULL ? NULL : (pnstr8) cClassName,
               subordinateName == NULL ? NULL : (pnstr8) cSubordinateName,
               &cIterationHandle,
               cSubordinates);

   // Set iteration handle
   (*env)->SetIntField (env, iterationHandle, handleId, (jint) cIterationHandle);

   if (N_SUCCESS == ccode)
   {
      // copy Buf_T.curPos to byte[]
      (*env)->SetByteArrayRegion (
                  env,
                  subordinates,
                  0,
                  cSubordinates->curLen,
                  (jbyte *) cSubordinates->curPos);
   }

   NWDSSetContext ((NWDSContextHandle) context, DCK_DSI_FLAGS, &oldFlags);

UNWRAP:

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

#ifdef N_PLAT_NLM
CLEANUP:
#endif

   NWDSFreeBuf (cSubordinates);

EXIT:

   return (ccode);

} /* NWDSListByClassAndName () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSListContainers
 * Signature: (ILjava/lang/String;Lcom/novell/service/jncpv2r/net/NetIterationHandle;[B)I
 */
JNIEXPORT jint JNICALL
JNICALL Java_com_novell_service_jncpv2r_net_NetJNI_NWDSListContainers
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring objectName,
   jobject iterationHandle,   /*NetIterationHandle*/
   jbyteArray subordinates
)
{
   // JNI variables
   jclass clsIterationHandle;
   jfieldID handleId;
   // NWNet variables
   NWDSCCODE ccode;
   unicode cObjectName[MAX_DN_CHARS+1];
   nint32 cIterationHandle;
   nuint32 oldFlags, newFlags;
   pBuf_T cSubordinates;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Alloc Buf_T
   ccode = NWDSAllocBuf (
               (*env)->GetArrayLength (env, subordinates),
               &cSubordinates);
   if (N_SUCCESS != ccode)
   {
      goto EXIT;
   }

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (N_SUCCESS != ccode)
   {
      goto CLEANUP;
   }
#endif

   ccode = NWDSGetContext ((NWDSContextHandle) context, DCK_DSI_FLAGS, &oldFlags);
   if (N_SUCCESS != ccode)
   {
      goto UNWRAP;
   }

   newFlags = oldFlags & ~DSI_BASE_CLASS | DSI_DEREFERENCE_BASE_CLASS;

   ccode = NWDSSetContext ((NWDSContextHandle) context, DCK_DSI_FLAGS, &newFlags);
   if (N_SUCCESS != ccode)
   {
      goto UNWRAP;
   }

   // Convert Java variable to 'C' variable
   jstring2unicode (env, objectName, cObjectName, sizeof(cObjectName));

   // Get iteration handle
   clsIterationHandle = (*env)->GetObjectClass (env, iterationHandle);
   handleId = (*env)->GetFieldID (env, clsIterationHandle, "handle", "I");
   cIterationHandle = (nint32)(*env)->GetIntField (env, iterationHandle, handleId);

   // Make C API call
   ccode = NWDSListContainers (
               (NWDSContextHandle) context,
               (pnstr8) cObjectName,
               &cIterationHandle,
               cSubordinates);

   // Set iteration handle
   (*env)->SetIntField (env, iterationHandle, handleId, (jint) cIterationHandle);

   if (N_SUCCESS == ccode)
   {
      // copy Buf_T.curPos to byte[]
      (*env)->SetByteArrayRegion (
                  env,
                  subordinates,
                  0,
                  cSubordinates->curLen,
                  (jbyte *) cSubordinates->curPos);
   }

   NWDSSetContext ((NWDSContextHandle) context, DCK_DSI_FLAGS, &oldFlags);

UNWRAP:

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

#ifdef N_PLAT_NLM
CLEANUP:
#endif

   NWDSFreeBuf (cSubordinates);

EXIT:

   return (ccode);

} /* NWDSListContainers () */

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSGetCountByClassAndName
(
   NWDSContextHandle context,
   pnstr8            objectName,
   pnstr8            className,
   pnstr8            subordinateName,
   pnint32           count
);*/

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSMapIDToName
 * Signature: (IIILjava/lang/StringBuffer;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSMapIDToName
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint connHandle,
   jint objectID,
   jobject object /*StringBuffer*/ /*out*/
)
{
   NWDSCCODE ccode;
   unicode cObjectName[(MAX_DN_CHARS + 1)];
   jclass         cls;
   jmethodID      mid;
   jstring        string;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSMapIDToName (
               (NWDSContextHandle) context,
               (NWCONN_HANDLE) connHandle,
               (nuint32) objectID,
               (pnstr8) cObjectName);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if (0 == ccode)
   {
      // Copy 'C' string into java string
      cls = (*env)->GetObjectClass(env, object);
      mid = (*env)->GetMethodID (env, cls, "append","(Ljava/lang/String;)Ljava/lang/StringBuffer;");
      string = (*env)->NewString(env, cObjectName, unilen (cObjectName));
      (*env)->CallObjectMethod(env, object, mid, string);
   }
   return (ccode);

} /* NWDSMapIDToName () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSMapNameToID
 * Signature: (IILjava/lang/String;Lcom/novell/utility/java/lang/IntegerBuffer;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSMapNameToID
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint connHandle,
   jstring objectName,
   jobject objectID
)
{
   NWDSCCODE ccode;
   unicode cObjectName[MAX_DN_BYTES];
   jclass         cls;
   jmethodID      mid;
   nuint32        cObjectID;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   //convert java string to unicode
   jstring2unicode(env, objectName, cObjectName, sizeof(cObjectName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSMapNameToID (
               (NWDSContextHandle) context,
               (NWCONN_HANDLE) connHandle,
               (pnstr8) cObjectName,
               (pnuint32) &cObjectID );

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if (0 == ccode)
   {
      cls = (*env)->GetObjectClass(env, objectID);
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      (*env)->CallVoidMethod(env, objectID, mid, (jint)cObjectID);
   }
   return (ccode);

} /* NWDSMapNameToID () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSModifyObject
 * Signature: (ILjava/lang/String;Lcom/novell/service/jncpv2r/net/NetIterationHandle;ZI)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSModifyObject
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring objectName,
   jobject iterationHandle, /*NDSIterationHandle*/ /*inout*/
   jboolean more,
   jint changes
)
{
   NWDSCCODE ccode;
   unicode cObjectName[MAX_DN_BYTES];
   nint32 cIterationHandle;
   jclass         cls;
   jmethodID      mid;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   //convert java string to unicode
   jstring2unicode(env, objectName, cObjectName, sizeof(cObjectName));

   // Get iteration handle
   cls = (*env)->GetObjectClass(env, iterationHandle);
   mid = (*env)->GetMethodID (env, cls, "getValue","()I");
   cIterationHandle = (nint32)(*env)->CallIntMethod(env, iterationHandle, mid);

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSModifyObject (
               (NWDSContextHandle) context,
               (pnstr8) cObjectName,   // Save results in 'C' variable
               (pnint32) NULL, //&cIterationHandle,
               (nbool8) more,
               (pBuf_T) changes);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if(N_SUCCESS == ccode)
   {
      cls = (*env)->GetObjectClass(env, iterationHandle);
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      (*env)->CallVoidMethod(env, iterationHandle, mid, (jint)cIterationHandle);
   }
   else
   {
      cls = (*env)->GetObjectClass(env, iterationHandle);
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      (*env)->CallVoidMethod(env, iterationHandle, mid, (jint) NO_MORE_ITERATIONS);
   }
   return (ccode);

} /* NWDSModifyObject */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSModifyDN
 * Signature: (ILjava/lang/String;Ljava/lang/String;Z)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSModifyDN
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring objectName,
   jstring newDN,
   jboolean deleteOldRDN
)
{
   NWDSCCODE   ccode;
   unicode cObjectName[MAX_DN_CHARS + 1];
   unicode cNewDN[MAX_DN_CHARS + 1];

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   //convert java string to unicode
   jstring2unicode (env, objectName, cObjectName, sizeof(cObjectName));
   jstring2unicode (env, newDN, cNewDN, sizeof(cNewDN));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = (NWDSModifyDN (
               (NWDSContextHandle) context,
               (pnstr8) cObjectName,
               (pnstr8) cNewDN,
               (nbool8) deleteOldRDN));

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return ccode;
} /* NWDSModifyDN () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSModifyRDN
 * Signature: (ILjava/lang/String;Ljava/lang/String;Z)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSModifyRDN
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring objectName,
   jstring newDN,
   jboolean deleteOldRDN
)
{
   NWDSCCODE   ccode;
   unicode cObjectName[(MAX_DN_CHARS + 1)];
   unicode cNewDN[(MAX_DN_CHARS + 1)];

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   //convert java string to unicode
   jstring2unicode(env, objectName, cObjectName, sizeof(cObjectName));
   jstring2unicode(env, newDN, cNewDN, sizeof(cNewDN));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSModifyRDN (
               (NWDSContextHandle) context,
               (pnstr8)cObjectName,
               (pnstr8)cNewDN,
               (nbool8) deleteOldRDN);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return (ccode);

} /* NWDSModifyRDN () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSMoveObject
 * Signature: (ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSMoveObject
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring objectName,
   jstring destParentDN,
   jstring destRDN
)
{
   NWDSCCODE ccode;
   unicode cObjectName[MAX_DN_CHARS + 1];
   unicode cDestParentDN[MAX_DN_CHARS + 1];
   unicode cDestRDN[MAX_RDN_CHARS + 1];

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // put the java unicode string into c unicode style.
   jstring2unicode(env, objectName, cObjectName, sizeof(cObjectName));
   jstring2unicode(env, destParentDN, cDestParentDN, sizeof(cDestParentDN));
   jstring2unicode(env, destRDN, cDestRDN, sizeof(cDestRDN));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSMoveObject(
               (NWDSContextHandle) context,
               (pnstr8) cObjectName,
               (pnstr8) cDestParentDN,
               (pnstr8) cDestRDN);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return(ccode);

} /* NWDSMoveObject () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSRead
 * Signature: (ILjava/lang/String;IZILcom/novell/service/jncpv2r/net/NetIterationHandle;I)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSRead
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring objectName,
   jint infoType,
   jboolean allAttrs,
   jint attrNames,
   jobject iterationHandle, /*NDSIterationHandle*/ /*inout*/
   jint objectInfo
)
{
   NWDSCCODE ccode;
   unicode cObjectName [MAX_DN_CHARS + 1];
   nint32 cIterationHandle;
   jclass         cls;
   jmethodID      mid;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // put the java unicode string into c unicode style.
   jstring2unicode(env, objectName, cObjectName, sizeof(cObjectName));

   // Get iteration handle
   cls = (*env)->GetObjectClass(env, iterationHandle);
   mid = (*env)->GetMethodID (env, cls, "getValue","()I");
   cIterationHandle = (nint32)(*env)->CallIntMethod(env, iterationHandle, mid);

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSRead (
               (NWDSContextHandle) context,
               (pnstr8) cObjectName,
               (nuint32) infoType,
               (nbool8) allAttrs,
               (pBuf_T) attrNames,
               &cIterationHandle,
               (pBuf_T) objectInfo);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if(N_SUCCESS == ccode)
   {
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      (*env)->CallVoidMethod(env, iterationHandle, mid, (jint)cIterationHandle);
   }
   else
   {
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      (*env)->CallVoidMethod(env, iterationHandle, mid, (jint) NO_MORE_ITERATIONS);
   }
   return (ccode);

} /* NWDSRead () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSReadObjectInfo
 * Signature: (ILjava/lang/String;Ljava/lang/StringBuffer;Lcom/novell/service/jncpv2r/net/NetObjectInfo;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSReadObjectInfo
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring objectName,
   jobject distinguishedName, /*StringBuffer*/ /*out*/ /*opt*/
   jobject objectInfo /*NDSObjectInfo*/ /*out*/ /*opt*/
)
{
   NWDSCCODE ccode;
   unicode cObjectName [MAX_DN_CHARS + 1];
   unicode cDistinguishedName [MAX_DN_CHARS + 1];
   Object_Info_T cObjectInfo;
   jclass         cls;
   jmethodID      mid;
   jstring        string;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   /* Convert Java variable to 'C' variable */
   jstring2unicode(env, objectName, cObjectName, sizeof(cObjectName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSReadObjectInfo (
               context,
               (pnstr8) cObjectName,
               NULL == distinguishedName ? NULL : (pnstr8) cDistinguishedName,
               NULL == objectInfo ? NULL : &cObjectInfo);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if (N_SUCCESS == ccode)
   {
      /* Copy 'C' variables back into 'Java' variables */
      if (NULL != distinguishedName)
      {
         cls = (*env)->GetObjectClass(env, distinguishedName);
         mid = (*env)->GetMethodID (env, cls, "append","(Ljava/lang/String;)Ljava/lang/StringBuffer;");
         string = (*env)->NewString(env, cDistinguishedName, unilen (cDistinguishedName));
         (*env)->CallObjectMethod(env, distinguishedName, mid, string);
      }
      if (NULL != objectInfo)
      {
         /* Copy 'C' cObjectInfo into 'Java' objectInfo */
         cls = (*env)->GetObjectClass(env, objectInfo);
         mid = (*env)->GetMethodID (env, cls, "setObjectFlags","(I)V");
         (*env)->CallVoidMethod(env, objectInfo, mid, (jint)cObjectInfo.objectFlags);

         mid = (*env)->GetMethodID (env, cls, "setSubordinateCount","(I)V");
         (*env)->CallVoidMethod(env, objectInfo, mid, (jint)cObjectInfo.subordinateCount);

         mid = (*env)->GetMethodID (env, cls, "setModificationTime","(I)V");
         (*env)->CallVoidMethod(env, objectInfo, mid, (jint) cObjectInfo.modificationTime);

         mid = (*env)->GetMethodID (env, cls, "setBaseClass","(Ljava/lang/String;)V");
         string = (*env)->NewString(
                           env,
                           (unicode *)cObjectInfo.baseClass,
                           unilen ((unicode *)cObjectInfo.baseClass));
         (*env)->CallVoidMethod(env, objectInfo, mid, string);
      }

   } /* if (N_SUCCESS == ccode) */

   return (ccode);

} /* NWDSReadObjectInfo () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSReadObjectDSIInfo
 * Signature: (ILjava/lang/String;Lcom/novell/service/jncpv2r/net/NetMemory;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSReadObjectDSIInfo
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring object,
   jobject objectInfo   /*NetMemory*/ /*in*/
)
{
   NWDSCCODE ccode;
   // JNI variables
   jclass cls;
   jmethodID getHandleMid, getSizeMid;
   // NWNet variables
   unicode cObject[MAX_DN_CHARS + 1];
   nptr  cObjectInfo;
   nuint32 cInfoLength;
   nuint32 oldFlags, newFlags;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // put the java unicode string into c unicode style.
   jstring2unicode (env, object, cObject, sizeof(cObject));

   // NetMemory methods
   cls = (*env)->GetObjectClass (env, objectInfo);
   getHandleMid = (*env)->GetMethodID (env, cls, "getHandle", "()I");
   getSizeMid = (*env)->GetMethodID (env, cls, "getSize", "()I");

   // objectInfo.getHandle ()
   cObjectInfo = (nptr)(*env)->CallIntMethod (env, objectInfo, getHandleMid);

   // objectInfo.getSize ()
   cInfoLength = (nuint32)(*env)->CallIntMethod (env, objectInfo, getSizeMid);


#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSGetContext ((NWDSContextHandle) context, DCK_DSI_FLAGS, &oldFlags);
   if (N_SUCCESS != ccode)
   {
      goto UNWRAP;
   }

   newFlags = 0x0003FFFF; // get all of DSIInfo

   ccode = NWDSSetContext ((NWDSContextHandle) context, DCK_DSI_FLAGS, &newFlags);
   if (N_SUCCESS != ccode)
   {
      goto UNWRAP;
   }

   // Make C API call
   ccode = (NWDSReadObjectDSIInfo (
               (NWDSContextHandle) context,
               (pnstr8) cObject,
               cInfoLength,
               cObjectInfo));

   // set context back to what it was when we came in
   NWDSSetContext ((NWDSContextHandle) context, DCK_DSI_FLAGS, &oldFlags);

UNWRAP:

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return ccode;

} /* NWDSReadObjectDSIInfo () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSRemoveObject
 * Signature: (ILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSRemoveObject
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring objectName
)
{
   NWDSCCODE ccode;
   unicode cObjectName[MAX_DN_CHARS+1];

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // put the java unicode string into c unicode style.
   jstring2unicode(env, objectName, cObjectName, sizeof(cObjectName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSRemoveObject((NWDSContextHandle)context,
                           (pnstr8)cObjectName);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return(ccode);

} /* NWDSRemoveObject () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSRestoreObject
 * Signature: (ILjava/lang/String;Lcom/novell/service/jncpv2r/net/NetIterationHandle;ZII)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSRestoreObject
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring objectName,
   jobject iterationHandle, /*NDSIterationHandle*/ /*inout*/
   jboolean more,
   jint size,
   jint backedUpBuf
)
{
   NWDSCCODE ccode =0;
   unicode cObjectName[MAX_DN_CHARS + 1];
   nint32  cIterationHandle;
   jclass         cls;
   jmethodID      mid;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   jstring2unicode(env, objectName, cObjectName, sizeof(cObjectName));

   // Get iteration handle
   cls = (*env)->GetObjectClass(env, iterationHandle);
   mid = (*env)->GetMethodID (env, cls, "getValue","()I");
   cIterationHandle = (nint32)(*env)->CallIntMethod(env, iterationHandle, mid);

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSRestoreObject((NWDSContextHandle)context,
                                 (pnstr8)cObjectName,
                                 &cIterationHandle,
                                 (nbool8)more,
                                 size,
                                 (pnuint8)backedUpBuf);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if(N_SUCCESS == ccode)
   {
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      (*env)->CallVoidMethod(env, iterationHandle, mid, (jint)cIterationHandle);
   }
   else
   {
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      (*env)->CallVoidMethod(env, iterationHandle, mid, (jint) NO_MORE_ITERATIONS);
   }

   return (ccode);

} /* NWDSRestoreObject */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSSearch
 * Signature: (ILjava/lang/String;IZIIZILcom/novell/service/jncpv2r/net/NetIterationHandle;ILcom/novell/service/toolkit/jcl/NWInteger;I)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSSearch
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring baseObjectName,
   jint scope,
   jboolean searchAliases,
   jint filter,
   jint infoType,
   jboolean allAttrs,
   jint attrNames,
   jobject iterationHandle, /*NDSIterationHandle*/ /*inout*/
   jint countObjectsToSearch,
   jobject countObjectsSearched, /*NWInteger*/ /*inout*/
   jint objectInfo
)
{
   NWDSCCODE ccode;
   unicode cBaseObjectName[MAX_DN_CHARS + 1];
   nint32  cIterationHandle;
   nint32  cCountObjectsSearched;
   jclass         cls;
   jmethodID      mid;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   //convert java string to unicode
   jstring2unicode(env, baseObjectName, cBaseObjectName, sizeof(cBaseObjectName));

   // Get iteration handle
   cls = (*env)->GetObjectClass(env, iterationHandle);
   mid = (*env)->GetMethodID (env, cls, "getValue","()I");
   cIterationHandle = (nint32)(*env)->CallIntMethod(env, iterationHandle, mid);

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSSearch (
               (NWDSContextHandle) context,
               (pnstr8)    cBaseObjectName,
               (nint)      scope,
               (nbool8)    searchAliases,
               (pBuf_T)    filter,
               (nuint32)   infoType,
               (nbool8)    allAttrs,
               (pBuf_T)    attrNames,
                           &cIterationHandle,
               (nint32)    countObjectsToSearch,
               (pnint32)   &cCountObjectsSearched,
               (pBuf_T)    objectInfo);


#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if(N_SUCCESS == ccode)
   {
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      (*env)->CallVoidMethod(env, iterationHandle, mid, (jint)cIterationHandle);

      cls = (*env)->GetObjectClass(env, countObjectsSearched);
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      (*env)->CallVoidMethod(env, countObjectsSearched, mid, (jint)cCountObjectsSearched);
   }
   else
   {
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      (*env)->CallVoidMethod(env, iterationHandle, mid, (jint) NO_MORE_ITERATIONS);
   }
   return (ccode);

} /* NWDSSearch () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSOpenStream
 * Signature: (ILjava/lang/String;Ljava/lang/String;ILcom/novell/service/toolkit/jcl/NWInteger;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSOpenStream
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring objectName,
   jstring attrName,
   jint flags,
   jobject fileHandle /*NWInteger*/ /*out*/
)
{
   NWDSCCODE      ccode;
   unicode cObjectName[MAX_DN_CHARS+1];
   unicode cAttrName[MAX_SCHEMA_NAME_CHARS+1];
   NWFILE_HANDLE  cFileHandle;
   jclass         cls;
   jmethodID      mid;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // put the java unicode string into c unicode style.
   jstring2unicode(env, objectName, cObjectName, sizeof(cObjectName));
   jstring2unicode(env, attrName, cAttrName, sizeof(cAttrName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSOpenStream((NWDSContextHandle)context,
                           (pnstr8)cObjectName,
                           (pnstr8)cAttrName,
                           flags,
                           &cFileHandle);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if(N_SUCCESS == ccode)
   {
      cls = (*env)->GetObjectClass(env, fileHandle);
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      (*env)->CallVoidMethod(env, fileHandle, mid, (jint)cFileHandle);
   }
   return(ccode);

} /* NWDSOpenStream () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSWhoami
 * Signature: (ILjava/lang/StringBuffer;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSWhoami
(
   JNIEnv   *env,
   jclass   unused,
   jint     threadGroup,/*in*/
   jint     context,    /*in*/
   jobject  objectName  /*out*/ /*StringBuffer*/
)
{
   // NWNet variables
   NWDSCCODE ccode;
   unicode cObjectName[MAX_DN_CHARS + 1];

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   // Make C API call
   ccode = NWDSWhoAmI (
               (NWDSContextHandle) context,
               (char *) cObjectName);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   // Convert 'C' variable to Java variable
   if (0 == ccode)
   {
      // JNI variables
      jclass cls;
      jmethodID appendMid;

      // StringBuffer method
      cls = (*env)->GetObjectClass (env, objectName);
      appendMid = (*env)->GetMethodID (
                              env,
                              cls,
                              "append",
                              "(Ljava/lang/String;)Ljava/lang/StringBuffer;");

      // Copy the cObjectName into the Java objectName StringBuffer
      (*env)->CallObjectMethod (
                  env,
                  objectName,
                  appendMid,
                  (*env)->NewString (env, cObjectName, unilen (cObjectName)));
   }

   return ((jint) ccode);

} /* NWDSWhoami () */


/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSGetServerDN
 * Signature: (IIILjava/lang/StringBuffer;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSGetServerDN
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint connHandle,
   jobject serverDN                 /*StringBuffer*/ /*out*/
)
{
   // JNI variables
   // NWNet variables
   NWDSCCODE   ccode;
   unicode cServerDN[MAX_DN_CHARS + 1];

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   // Make C API call
   ccode = NWDSGetServerDN (
               (NWDSContextHandle) context,
               (NWCONN_HANDLE) connHandle,
               (pnstr8) cServerDN);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   // Convert C variables back to Java variables
   if (0 == ccode)
   {
      // JNI variables
      jclass cls;
      jmethodID mid;
      jstring string;

      // Copy 'C' string into java string
      cls = (*env)->GetObjectClass (env, serverDN);
      mid = (*env)->GetMethodID (env, cls, "append","(Ljava/lang/String;)Ljava/lang/StringBuffer;");
      string = (*env)->NewString (env, cServerDN, unilen (cServerDN));
      (*env)->CallObjectMethod (env, serverDN, mid, string);
   }

   return (ccode);

} /* NWDSGetServerDN () */


/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSGetServerAddresses
 * Signature: (IILcom/novell/utility/java/lang/IntegerBuffer;I)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSGetServerAddresses
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint conn,
   jobject countNetAddresses,  /*IntegerBuffer*/ /*out*/
   jint netAddresses
)
{
   nuint32     cCountNetAddresses;
   NWDSCCODE   ccode = -1;
   jclass      cls;
   jmethodID   mid;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   // Make C API call
   ccode = NWDSGetServerAddresses (
               (NWDSContextHandle)context,
               (nuint32)conn, &cCountNetAddresses,
               (pBuf_T)netAddresses);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   // Copy cMajorVersion into Java majorVersion
   if (ccode == N_SUCCESS) {
      cls = (*env)->GetObjectClass(env, countNetAddresses);
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      (*env)->CallVoidMethod(env, countNetAddresses, mid, (jint)cCountNetAddresses);
   }
   return (ccode);

} /* NWDSGetServerAddresses () */

/***** nwdsfilt.h *********************************************************/

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSAddFilterToken
 * Signature: (IIII)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSAddFilterToken
(
   JNIEnv *env,
   jclass unused,
   jint cur,
   jint tok,
   jint  val,
   jint syntaxID
)
{
   NWDSCCODE ccode;

   ccode = NWDSAddFilterToken(
               (pFilter_Cursor_T) cur,
               (nuint16) tok,
               (nptr)val,
               syntaxID);

   return (ccode);

} /* NWDSAddFilterToken () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSAllocFilter
 * Signature: (Lcom/novell/service/toolkit/jcl/NWInteger;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSAllocFilter
(
   JNIEnv *env,
   jclass unused,
   jobject cur /*NWInteger*/
)
{
   NWDSCCODE ccode;
   Filter_Cursor_T *cCur;
   jclass cls;
   jmethodID mid;

   ccode = NWDSAllocFilter (&cCur);

   if (0 == ccode)
   {
      cls = (*env)->GetObjectClass(env, cur);
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      (*env)->CallVoidMethod(env, cur, mid, (jint)cCur);
   }
   return (ccode);

} /* NWDSAllocFilter () */

/* Not Implemented
N_EXTERN_LIBRARY (void)
NWDSFreeFilter
(
   pFilter_Cursor_T  cur,
   void (N_FAR N_CDECL *freeVal)(nuint32 syntax, nptr val)
);*/

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSPutFilter
 * Signature: (IIII)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSPutFilter
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint buf,
   jint cur,
   jint freeVal)
{
   NWDSCCODE ccode;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSPutFilter(
               (NWDSContextHandle) context,
               (pBuf_T) buf,           // Typecast 32-bit integer as pointer
               (pFilter_Cursor_T) cur,
               (void *)freeVal);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return (ccode);

} /* NWDSPutFilter () */

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSDelFilterToken
(
   pFilter_Cursor_T  cur,
   void (N_FAR N_CDECL *freeVal)(nuint32 syntax, nptr val)
);*/

/***** nwdsmisc.h *********************************************************/

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSCloseIteration
 * Signature: (III)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSCloseIteration
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint handle,
   jint operation
)
{
   NWDSCCODE ccode;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSCloseIteration (
               (NWDSContextHandle) context,
               (int32) handle,
               (uint32) operation);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return (ccode);

} /* NWDSCloseIteration () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSGetSyntaxID
 * Signature: (ILjava/lang/String;Lcom/novell/service/toolkit/jcl/NWInteger;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSGetSyntaxID
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring attrName,
   jobject syntaxID /*NWInteger*/ /*out*/
)
{
   NWDSCCODE ccode;
   unicode cAttrName[MAX_SCHEMA_NAME_CHARS +1];
   nuint32 cSyntaxID;
   jclass         cls;
   jmethodID      mid;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   jstring2unicode(env, attrName, cAttrName, sizeof(cAttrName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSGetSyntaxID (
               (NWDSContextHandle) context,
               (pnstr8)cAttrName,
               &cSyntaxID);        // Save results in 'C' variable

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if (0 == ccode)
   {  // Copy the 'C' variable back into Java variable
      cls = (*env)->GetObjectClass(env, syntaxID);
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      (*env)->CallVoidMethod(env, syntaxID, mid, (jint)cSyntaxID);
   }
   return (ccode);

} /* NWDSGetSyntaxID () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSReadSyntaxes
 * Signature: (IIZILcom/novell/service/jncpv2r/net/NetIterationHandle;I)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSReadSyntaxes
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint infoType,
   jboolean allSyntaxes,
   jint syntaxNames,
   jobject iterationHandle, /*NDSIterationHandle*/
   jint syntaxDefs
)
{
   NWDSCCODE   ccode;
   nint32      cIterationHandle;
   jclass         cls;
   jmethodID      mid;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Get iteration handle
   cls = (*env)->GetObjectClass(env, iterationHandle);
   mid = (*env)->GetMethodID (env, cls, "getValue","()I");
   cIterationHandle = (nint32)(*env)->CallIntMethod(env, iterationHandle, mid);

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSReadSyntaxes (
               (NWDSContextHandle) context,
               infoType,
               (nbool8) allSyntaxes,
               (pBuf_T) syntaxNames,
               &cIterationHandle,
               (pBuf_T) syntaxDefs);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if(N_SUCCESS == ccode)
   {
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      (*env)->CallVoidMethod(env, iterationHandle, mid, (jint)cIterationHandle);
   }
   else
   {
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      (*env)->CallVoidMethod(env, iterationHandle, mid, (jint) NO_MORE_ITERATIONS);
   }
   return (ccode);

} /* NWDSReadSyntaxes */

/* Not Implemented
long COM_novell_nsi_libsWrapper_NdsNatives_NWDSReadSyntaxDef
(
   struct HCOM_novell_nsi_libsWrapper_NdsNatives *unused,
   long context,
   long syntaxID,
   struct HCOM_novell_nsi_nds_NDSSyntaxInfo *syntaxDef
)
{
   return -1;
} / * NWDSReadSyntaxDef () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSReplaceAttrNameAbbrev
 * Signature: (ILjava/lang/String;Ljava/lang/StringBuffer;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSReplaceAttrNameAbbrev
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring inStr,
   jobject outStr /*StringBuffer*/ /*out*/
)
{
   NWDSCCODE ccode;
   unicode cInStr[MAX_RDN_CHARS+1];
   unicode cOutStr[MAX_RDN_CHARS+1];
   jclass         cls;
   jmethodID      mid;
   jstring        string;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // put the java unicode string into c unicode style.
   jstring2unicode(env, inStr, cInStr, sizeof(cInStr));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSReplaceAttrNameAbbrev((NWDSContextHandle)context,
                         (pnstr8)cInStr,
                         (pnstr8)cOutStr);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if (N_SUCCESS == ccode)
   {  // Copy the 'C' variables back into Java variables
      cls = (*env)->GetObjectClass(env, outStr);
      mid = (*env)->GetMethodID (env, cls, "append","(Ljava/lang/String;)Ljava/lang/StringBuffer;");
      string = (*env)->NewString(env, cOutStr, unilen (cOutStr));
      (*env)->CallObjectMethod(env, outStr, mid, string);
   }
   return(ccode);

}  /* NWDSReplaceAttrNameAbbrev () */

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSGetObjectHostServerAddress
(
   NWDSContextHandle context,
   pnstr8            objectName,
   pnstr8            serverName,
   pBuf_T            netAddresses
);*/

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWGetNWNetVersion
 * Signature: (Lcom/novell/utility/java/lang/IntegerBuffer;Lcom/novell/utility/java/lang/IntegerBuffer;Lcom/novell/utility/java/lang/IntegerBuffer;Lcom/novell/utility/java/lang/IntegerBuffer;)V
 */
JNIEXPORT void JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWGetNWNetVersion
(
   JNIEnv *env,
   jclass unused,
   jobject majorVersion, /*IntegerBuffer*/ /*out*/
   jobject minorVersion, /*IntegerBuffer*/ /*out*/
   jobject revisionLevel, /*IntegerBuffer*/ /*out*/
   jobject betaReleaseLevel /*IntegerBuffer*/ /*out*/
)
{
   nuint8   cMajorVersion;
   nuint8   cMinorVersion;
   nuint8   cRevisionLevel;
   nuint8   cBetaReleaseLevel;
   jclass         cls;
   jmethodID      mid;

   // Make C API call
   NWGetNWNetVersion (
            &cMajorVersion,
            &cMinorVersion,
            &cRevisionLevel,
            &cBetaReleaseLevel);

   // Convert 'C' variable to Java variable
   // Copy cMajorVersion into Java majorVersion
   cls = (*env)->GetObjectClass(env, majorVersion);
   mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
   (*env)->CallVoidMethod(env, majorVersion, mid, (jint)cMajorVersion);

   // Copy cMinorVersion into Java minorVersion
   cls = (*env)->GetObjectClass(env, minorVersion);
   mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
   (*env)->CallVoidMethod(env, minorVersion, mid, (jint)cMinorVersion);

   // Copy cRevisionLevel into Java revisionLevel
   cls = (*env)->GetObjectClass(env, revisionLevel);
   mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
   (*env)->CallVoidMethod(env, revisionLevel, mid, (jint)cRevisionLevel);

   // Copy cBetaReleaseLevel into Java betaReleaseLevel
   cls = (*env)->GetObjectClass(env, betaReleaseLevel);
   mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
   (*env)->CallVoidMethod(env, betaReleaseLevel, mid, (jint)cBetaReleaseLevel);
}

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWIsDSServer
(
   NWCONN_HANDLE  conn,
   pnstr8         treeName
);*/

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSGetBinderyContext
(
   NWDSContextHandle context,
   NWCONN_HANDLE     connHandle,
   pnuint8           BinderyEmulationContext
);*/

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSRepairTimeStamps
(
   NWDSContextHandle context,
   pnstr8            partitionRoot
);*/

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWGetUTCTime
 * Signature: (ILcom/novell/utility/java/lang/IntegerBuffer;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWGetFileServerUTCTime
(
   JNIEnv *env,
   jclass unused,
   jint conn,
   jobject time /*IntegerBuffer*/ /*out*/
)
{
   // NWNet variables
   NWDSCCODE ccode;
   nuint32 cTime;

   ccode = NWGetFileServerUTCTime ((NWCONN_HANDLE) conn, &cTime);

   // Copy 'C' variables back into Java variables
   if (N_SUCCESS == ccode)
   {
      // JNI variables
      jclass cls;
      jmethodID setValueMid;

      // IntegerBuffer method
      cls = (*env)->GetObjectClass (env, time);
      setValueMid = (*env)->GetMethodID (env, cls, "setValue", "(I)V");

      // time.setValue (int)
      (*env)->CallVoidMethod(env, time, setValueMid, (jint) cTime);
   }
   return (ccode);

} /* NWGetFileServerUTCTime () */

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSGetDSVerInfo
(
   NWCONN_HANDLE  conn,
   pnuint32       dsVersion,
   pnuint32       rootMostEntryDepth,
   pnstr8         sapName,
   pnuint32       flags,
   punicode       treeName
)
{
   NWDSCCODE      ccode;
   nuint32       cDsVersion;
   nuint32       cRootMostEntryDepth;
   nuint32       cFlags;
   jclass         cls;
   jmethodID      mid;

   // Make C API call
   ccode = NWDSGetDSVerInfo(
      (NWCONN_HANDLE)  connHandle,
      &cDsVersion,
      &cRootMostEntryDepth,
      NULL,
      &cFlags,
      NULL);

   if (ccode == 0)
   {
      // Convert 'C' variable to Java variable
      // Copy cDsVersioninto Java dsVersion
      if (0 != dsVersion)
      {
         cls = (*env)->GetObjectClass(env, dsVersion);
         mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
         (*env)->CallVoidMethod(env, dsVersion, mid, (jint)cDsVersion);
      }

      // Copy cRootMostEntryDepth into Java rootMostEntryDepth
      if (0 != rootMostEntryDepth)
      {
         cls = (*env)->GetObjectClass(env, rootMostEntryDepth);
         mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
         (*env)->CallVoidMethod(env, rootMostEntryDepth, mid, (jint)cRootMostEntryDepth);
      }

      // Copy cFlags into Java flags
      if (0 != flags)
      {
         cls = (*env)->GetObjectClass(env, flags);
         mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
         (*env)->CallVoidMethod(env, flags, mid, (jint)cFlags);
      }
   }

   return ((jint) ccode);
}
*/

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSSyncReplicaToServer
 * Signature: (ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;II)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSSyncReplicaToServer
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring serverName,
   jstring partitionRootName,
   jstring destServerName,
   jint actionFlags,
   jint delaySeconds
)
{
   unicode     cServerName[MAX_DN_CHARS + 1];
   unicode     cPartitionRootName[MAX_DN_CHARS + 1];
   unicode     cDestServerName[MAX_DN_CHARS + 1];
   NWDSCCODE   ccode = -1;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Convert Java variable to 'C' variable
   jstring2unicode(env, partitionRootName, cServerName,
                           sizeof(cServerName));
   jstring2unicode(env, partitionRootName, cPartitionRootName,
                           sizeof(cPartitionRootName));
   jstring2unicode(env, destServerName, cDestServerName,
                           sizeof(cDestServerName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   // Make C API call
   ccode = NWDSSyncReplicaToServer((NWDSContextHandle)context,
            (pnstr8)cServerName, (pnstr8)cPartitionRootName,
            (pnstr8)cDestServerName, (nuint32)actionFlags,
            (nuint32)delaySeconds);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return ccode;

} /* NWDSSyncReplicaToServer */


/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSReloadDS
 * Signature: (IILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSReloadDS
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring serverName
)
{
   // NWNet variables
   NWDSCCODE   ccode;
   unicode     cServerName[MAX_DN_CHARS + 1];

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Convert Java variable to 'C' variable
   jstring2unicode (env, serverName, cServerName, sizeof(cServerName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   // Make C API call
   ccode = NWDSReloadDS (
               (NWDSContextHandle) context,
               (pnstr8) cServerName);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return (ccode);

} /* NWDSReloadDS */


/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWNetInit
(
   nptr  reserved1,
   nptr  reserved2
);*/

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWNetTerm
(
   nptr  reserved
);*/

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSGetNDSStatistics
(
   NWDSContextHandle context,
   pnstr8            serverName,
   nuint             statsInfoLen,
   pNDSStatsInfo_T   statsInfo
);*/

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSResetNDSStatistics
(
   NWDSContextHandle context,
   pnstr8            serverName
);*/

/***** nwdsname.h *********************************************************/

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSAbbreviateName
 * Signature: (ILjava/lang/String;Ljava/lang/StringBuffer;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSAbbreviateName
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring inName,
   jobject abbreviatedName /*StringBuffer*/
)
{
   NWDSCCODE ccode;
   unicode cInName [MAX_RDN_CHARS + 1];
   unicode cAbbreviatedName [MAX_RDN_CHARS + 1];
   jclass cls;
   jmethodID mid;
   jstring string;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // put the java unicode string into c unicode style.
   jstring2unicode(env, inName, cInName, sizeof(cInName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSAbbreviateName((NWDSContextHandle)context,
                         (pnstr8)cInName,
                         (pnstr8)cAbbreviatedName);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if (N_SUCCESS == ccode)
   {  // Copy the 'C' variables back into Java variables
      cls = (*env)->GetObjectClass(env, abbreviatedName);
      mid = (*env)->GetMethodID (env, cls, "append","(Ljava/lang/String;)Ljava/lang/StringBuffer;");
      string = (*env)->NewString(env, cAbbreviatedName, unilen (cAbbreviatedName));
      (*env)->CallObjectMethod(env, abbreviatedName, mid, string);
   }
   return(ccode);

} /* NWDSAbbreviateName () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSCanonicalizeName
 * Signature: (ILjava/lang/String;Ljava/lang/StringBuffer;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSCanonicalizeName
(
   JNIEnv * env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring objectName,
   jobject canonName /*StringBuffer*/ /*out*/
)
{
   NWDSCCODE ccode;
   unicode cObjectName [MAX_DN_CHARS + 1];
   unicode cCanonName [MAX_DN_CHARS + 1];
   jclass cls;
   jmethodID mid;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   jstring2unicode(env, objectName, cObjectName, sizeof(cObjectName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSCanonicalizeName (
               (NWDSContextHandle) context,
               (pnstr8) cObjectName,
               (pnstr8) cCanonName);


#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if (N_SUCCESS == ccode)
   {
      cls = (*env)->GetObjectClass(env, canonName);
      mid = (*env)->GetMethodID (env, cls, "append","(Ljava/lang/String;)Ljava/lang/StringBuffer;");
      (*env)->CallObjectMethod(env, canonName, mid, cCanonName);
   }
   return (ccode);

} /* NWDSCanonicalizeName () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSRemoveAllTypes
 * Signature: (ILjava/lang/String;Ljava/lang/StringBuffer;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSRemoveAllTypes
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring name,
   jobject typelessName /*StringBuffer*/ /*out*/
)
{
   NWDSCCODE ccode;
   unicode cName [MAX_DN_CHARS + 1];
   unicode cTypelessName [MAX_DN_CHARS + 1];
   jclass         cls;
   jmethodID      mid;
   jstring        string;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // put the java unicode string into c unicode style.
   jstring2unicode(env, name, cName, sizeof(cName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSRemoveAllTypes(
                                 (NWDSContextHandle)context,
                                 (pnstr8) cName,
                                 (pnstr8) cTypelessName);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if (N_SUCCESS == ccode)
   {  // Copy the 'C' variables back into Java variables
      cls = (*env)->GetObjectClass(env, typelessName);
      mid = (*env)->GetMethodID (env, cls, "append","(Ljava/lang/String;)Ljava/lang/StringBuffer;");
      string = (*env)->NewString(env, cTypelessName, unilen (cTypelessName));
      (*env)->CallObjectMethod(env, typelessName, mid, string);
   }
   return(ccode);

} /*  NWDSRemoveAllTypes () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSResolveName
 * Signature: (ILjava/lang/String;Lcom/novell/service/toolkit/jcl/NWInteger;Lcom/novell/service/toolkit/jcl/NWInteger;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSResolveName
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring objectName,
   jobject conn, /*NWInteger*/ /*out*/ /*opt*/
   jobject objectID /*NWInteger*/ /*out*/ /*opt*/
)
{
   NWDSCCODE      ccode;
   unicode cObjectName [MAX_RDN_CHARS + 1];
   NWCONN_HANDLE  cConn;
   nuint32        cObjectID;
   jclass         cls;
   jmethodID      mid;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   jstring2unicode(env, objectName, cObjectName, sizeof(cObjectName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSResolveName (
               (NWDSContextHandle) context,
               (pnstr8) cObjectName,
               &cConn,
               &cObjectID);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   if (N_SUCCESS == ccode)
   {
      /* Copy the 'C' variables back into Java variables */
      if (NULL != conn)
      {
         /* conn.setValue (cConn); */
         cls = (*env)->GetObjectClass(env, conn);
         mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
         (*env)->CallVoidMethod(env, conn, mid, (jint)cConn);
      }

      if (NULL != objectID)
      {
         /* objectID.setValue (cObjectID); */
         cls = (*env)->GetObjectClass(env, objectID);
         mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
         (*env)->CallVoidMethod(env, objectID, mid, (jint)cObjectID);
      }
   }
   return (ccode);

} /* NWDSResolveName () */

/* Not Implemented
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSCIStringsMatch
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring string1,
   jstring string2,
   jobject matches / *NWBoolean* / / *out* /
)
{
} / * NWDSCIStringsMatch () */

/***** nwdspart.h *********************************************************/

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSAddPartition
 * Signature: (ILjava/lang/String;Ljava/lang/String;Lcom/novell/service/jncpv2r/net/NetIterationHandle;ZI)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSAddPartition
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring server,
   jstring partitionRoot,
   jobject iterationHandle, /*NDSIterationHandle*/ /*inout*/
   jboolean more,
   jint objectInfo
)
{
   unicode     cPartitionRoot[MAX_DN_CHARS + 1];
   unicode     cServer[MAX_DN_CHARS + 1];
   nint32      cIterationHandle;
   NWDSCCODE   ccode = -1;
   jclass         cls;
   jmethodID      mid;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Convert Java variable to 'C' variable
   jstring2unicode(env, server, cServer, sizeof(cServer));
   jstring2unicode(env, partitionRoot, cPartitionRoot, sizeof(cPartitionRoot));

   // Get iteration handle
   cls = (*env)->GetObjectClass(env, iterationHandle);
   mid = (*env)->GetMethodID (env, cls, "getValue","()I");
   cIterationHandle = (nint32)(*env)->CallIntMethod(env, iterationHandle, mid);

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   // Make C API call
   ccode = NWDSAddPartition((NWDSContextHandle)context, (pnstr8)cServer,
            (pnstr8)cPartitionRoot, &cIterationHandle, (nbool8)more,
            (pBuf_T)objectInfo);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   // Convert C variables back to Java variables
   if(N_SUCCESS == ccode)
   {
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      (*env)->CallVoidMethod(env, iterationHandle, mid, (jint)cIterationHandle);
   }
   else
   {
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      (*env)->CallVoidMethod(env, iterationHandle, mid, (jint) NO_MORE_ITERATIONS);
   }
   return ccode;

} /* NWDSAddPartition () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSAddReplica
 * Signature: (ILjava/lang/String;Ljava/lang/String;I)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSAddReplica
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring server,
   jstring partitionRoot,
   jint replicaType
)
{
   unicode     cPartitionRoot[MAX_DN_CHARS + 1];
   unicode     cServer[MAX_DN_CHARS + 1];
   NWDSCCODE   ccode = -1;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Convert Java variable to 'C' variable
   jstring2unicode(env, server, cServer, sizeof(cServer));
   jstring2unicode(env, partitionRoot, cPartitionRoot, sizeof(cPartitionRoot));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   // Make C API call
   ccode = NWDSAddReplica((NWDSContextHandle)context, (pnstr8)cServer,
                  (pnstr8)cPartitionRoot, (nuint32)replicaType);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return ccode;

} /* NWDSAddReplica () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSChangeReplicaType
 * Signature: (ILjava/lang/String;Ljava/lang/String;I)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSChangeReplicaType
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring replicaName,
   jstring server,
   jint newReplicaType
)
{
   unicode     cReplicaName[MAX_DN_CHARS + 1];
   unicode     cServer[MAX_DN_CHARS + 1];
   NWDSCCODE   ccode = -1;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Convert Java variable to 'C' variable
   jstring2unicode(env, server, cServer, sizeof(cServer));
   jstring2unicode(env, replicaName, cReplicaName, sizeof(cReplicaName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   // Make C API call
   ccode = NWDSChangeReplicaType((NWDSContextHandle)context, (pnstr8)cReplicaName,
                              (pnstr8)cServer, (nuint32)newReplicaType);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return ccode;

} /* NWDSChangeReplicaType () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSJoinPartitions
 * Signature: (ILjava/lang/String;I)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSJoinPartitions
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring subordinatePartition,
   jint flags
)
{
   unicode     cSubordinatePartition[MAX_DN_CHARS + 1];
   NWDSCCODE   ccode = -1;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Convert Java variable to 'C' variable
   jstring2unicode(env, subordinatePartition, cSubordinatePartition,
                              sizeof(cSubordinatePartition));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   // Make C API call
   ccode = NWDSJoinPartitions((NWDSContextHandle)context,
               (pnstr8)cSubordinatePartition, flags);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return ccode;

} /* NWDSJoinPartitions () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSListPartitions
 * Signature: (ILcom/novell/service/jncpv2r/net/NetIterationHandle;Ljava/lang/String;I)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSListPartitions
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jobject iterationHandle, /*NetIterationHandle*/ /*inout*/
   jstring server,
   jint partitions
)
{
   // JNI variables
   jclass      cls;
   jmethodID   getValueMid, setValueMid;
   // NWNet variables
   unicode     cServer[MAX_DN_CHARS + 1];
   nint32      cIterationHandle;
   NWDSCCODE   ccode;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // NetIterationHandle methods
   cls = (*env)->GetObjectClass(env, iterationHandle);
   getValueMid = (*env)->GetMethodID (env, cls, "getValue","()I");
   setValueMid = (*env)->GetMethodID (env, cls, "setValue","(I)V");

   // Convert Java variable to 'C' variable
   jstring2unicode (env, server, cServer, sizeof(cServer));

   // Get iteration handle
   cIterationHandle = (nint32)(*env)->CallIntMethod (
                                          env,
                                          iterationHandle,
                                          getValueMid);

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   // Make C API call
   ccode = NWDSListPartitions (
               (NWDSContextHandle) context,
               &cIterationHandle,
               (pnstr8) cServer,
               (pBuf_T) partitions);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   // Convert C variables back to Java variables
   if (N_SUCCESS == ccode)
   {
      (*env)->CallVoidMethod (
                  env,
                  iterationHandle,
                  setValueMid,
                  (jint) cIterationHandle);
   }
   else
   {
      (*env)->CallVoidMethod (
                  env,
                  iterationHandle,
                  setValueMid,
                  (jint) NO_MORE_ITERATIONS);
   }

   return (ccode);

} /* NWDSListPartitions () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSListPartitionsExtInfo
 * Signature: (ILcom/novell/service/jncpv2r/net/NetIterationHandle;Ljava/lang/String;II)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSListPartitionsExtInfo
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jobject iterationHandle, /*NDSIterationHandle*/ /*inout*/
   jstring server,
   jint DSPFlags,
   jint partitions
)
{
   unicode      cServer[MAX_DN_CHARS + 1];
   nint32      cIterationHandle;
   NWDSCCODE   ccode = -1;
   jclass      cls;
   jmethodID   mid;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Convert Java variable to 'C' variable
   jstring2unicode(env, server, cServer, sizeof(cServer));

   // Get iteration handle
   cls = (*env)->GetObjectClass(env, iterationHandle);
   mid = (*env)->GetMethodID (env, cls, "getValue","()I");
   cIterationHandle = (nint32)(*env)->CallIntMethod(env, iterationHandle, mid);

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   // Make C API call
   ccode = NWDSListPartitionsExtInfo((NWDSContextHandle)context,
                        &cIterationHandle, (pnstr8)cServer,
                        (nflag32)DSPFlags, (pBuf_T)partitions);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   // Convert C variables back to Java variables
   if(N_SUCCESS == ccode)
   {
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      (*env)->CallVoidMethod(env, iterationHandle, mid, (jint)cIterationHandle);
   }
   else
   {
      mid = (*env)->GetMethodID (env, cls, "setValue","(I)V");
      (*env)->CallVoidMethod(env, iterationHandle, mid, (jint) NO_MORE_ITERATIONS);
   }

   return ccode;

} /* NWDSListPartitionsExtInfo () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSRemovePartition
 * Signature: (ILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSRemovePartition
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring partitionRoot
)
{
   unicode     cPartitionRoot[MAX_DN_CHARS + 1];
   NWDSCCODE   ccode = -1;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Convert Java variable to 'C' variable
   jstring2unicode(env, partitionRoot, cPartitionRoot, sizeof(cPartitionRoot));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   // Make C API call
   ccode = NWDSRemovePartition((NWDSContextHandle)context, (pnstr8)cPartitionRoot);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return ccode;

} /* NWDSRemovePartition () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSRemoveReplica
 * Signature: (ILjava/lang/String;Ljava/lang/String;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSRemoveReplica
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring server,
   jstring partitionRoot
)
{
   unicode     cServer[MAX_DN_CHARS + 1];
   unicode     cPartitionRoot[MAX_DN_CHARS + 1];
   NWDSCCODE   ccode = -1;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Convert Java variable to 'C' variable
   jstring2unicode(env, server, cServer, sizeof(cServer));
   jstring2unicode(env, partitionRoot, cPartitionRoot, sizeof(cPartitionRoot));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   // Make C API call
   ccode = NWDSRemoveReplica((NWDSContextHandle)context, (pnstr8)cServer,
                                    (pnstr8)cPartitionRoot);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return ccode;

} /* NWDSRemoveReplica () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSSplitPartition
 * Signature: (ILjava/lang/String;I)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSSplitPartition
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring subordinatePartition,
   jint flags
)
{
   unicode     cSubordinatePartition[MAX_DN_CHARS + 1];
   NWDSCCODE   ccode = -1;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Convert Java variable to 'C' variable
   jstring2unicode(env, subordinatePartition, cSubordinatePartition,
                              sizeof(cSubordinatePartition));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   // Make C API call
   ccode = NWDSSplitPartition((NWDSContextHandle)context,
               (pnstr8)cSubordinatePartition, flags);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return ccode;

} /* NWDSSplitPartition */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSPartitionReceiveAllUpdates
 * Signature: (ILjava/lang/String;Ljava/lang/String;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSPartitionReceiveAllUpdates
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring partitionRoot,
   jstring serverName
)
{
   unicode     cPartitionRoot[MAX_DN_CHARS + 1];
   unicode     cServerName[MAX_DN_CHARS + 1];
   NWDSCCODE   ccode = -1;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Convert Java variable to 'C' variable
   jstring2unicode(env, partitionRoot, cPartitionRoot, sizeof(cPartitionRoot));
   jstring2unicode(env, serverName, cServerName, sizeof(cServerName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   // Make C API call
   ccode = NWDSPartitionReceiveAllUpdates((NWDSContextHandle)context,
                  (pnstr8)cPartitionRoot, (pnstr8)cServerName);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return ccode;

} /* NWDSPartitionReceiveAllUpdates () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSPartitionSendAllUpdates
 * Signature: (ILjava/lang/String;Ljava/lang/String;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSPartitionSendAllUpdates
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring partitionRoot,
   jstring serverName
)
{
   unicode     cPartitionRoot[MAX_DN_CHARS + 1];
   unicode     cServerName[MAX_DN_CHARS + 1];
   NWDSCCODE   ccode = -1;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Convert Java variable to 'C' variable
   jstring2unicode(env, partitionRoot, cPartitionRoot, sizeof(cPartitionRoot));
   jstring2unicode(env, serverName, cServerName, sizeof(cServerName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   // Make C API call
   ccode = NWDSPartitionSendAllUpdates((NWDSContextHandle)context,
                  (pnstr8)cPartitionRoot, (pnstr8)cServerName);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return ccode;

} /* NWDSPartitionSendAllUpdates () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSSyncPartition
 * Signature: (ILjava/lang/String;Ljava/lang/String;I)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSSyncPartition
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring server,
   jstring partition,
   jint seconds
)
{
   unicode     cServer[MAX_DN_CHARS + 1];
   unicode     cPartition[MAX_DN_CHARS + 1];
   NWDSCCODE   ccode = -1;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Convert Java variable to 'C' variable
   jstring2unicode(env, server, cServer, sizeof(cServer));
   jstring2unicode(env, partition, cPartition, sizeof(cPartition));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   // Make C API call
   ccode = NWDSSyncPartition((NWDSContextHandle)context, (pnstr8)cServer,
                           (pnstr8)cPartition, (nuint32)seconds);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return ccode;

} /* NWDSSyncPartition () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSAbortPartitionOperation
 * Signature: (ILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSAbortPartitionOperation
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring partitionRoot
)
{
   unicode     cPartitionRoot[MAX_DN_CHARS + 1];
   NWDSCCODE   ccode = -1;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Convert the java unicode string into c unicode style.
   jstring2unicode(env, partitionRoot, cPartitionRoot, sizeof(cPartitionRoot));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   // call C API
   ccode = NWDSAbortPartitionOperation((NWDSContextHandle)context, (pnstr8)cPartitionRoot);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return ccode;

} /* NWDSAbortPartitionOperation () */

/***** nwdssch.h **********************************************************/

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSDefineAttr
 * Signature: (ILjava/lang/String;Lcom/novell/service/jncpv2r/net/NetAttributeInfo;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSDefineAttr
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring attrName,
   jobject attrDef /*NDSAttributeInfo*/
)
{
//NOTE: have steve check this
   NWDSCCODE      ccode;
   unicode        cAttrName[MAX_SCHEMA_NAME_CHARS + 1];
   Attr_Info_T    cAttrDef;
   jobject        asn1ID;
   jbyteArray     asn1IdData;
   jbyte          *asn1IDBytes = NULL;
   jclass         cls;
   jmethodID      mid;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Convert attrName and load into cAttrName
   jstring2unicode(env, attrName, cAttrName, sizeof(cAttrName));

   // Put attrDef.attrFlags into cAttrDef.attrFags
   cls = (*env)->GetObjectClass(env, attrDef);
   mid = (*env)->GetMethodID (env, cls, "getFlags","()I");
   cAttrDef.attrFlags = (nuint32)(*env)->CallIntMethod(env, attrDef, mid);

   // Put attrDef.attrSyntaxID into cAttrDef.attrSyntaxID
   mid = (*env)->GetMethodID (env, cls, "getSyntaxID","()I");
   cAttrDef.attrSyntaxID = (nuint32)(*env)->CallIntMethod(env, attrDef, mid);

   // Put attrDef.attrLower into cAttrDef.attrLower
   mid = (*env)->GetMethodID (env, cls, "getLowerLimit","()I");
   cAttrDef.attrLower = (nint32)(*env)->CallIntMethod(env, attrDef, mid);

   // Put attrDef.attrUpper into cAttrDef.attrUpper
   mid = (*env)->GetMethodID (env, cls, "getUpperLimit","()I");
   cAttrDef.attrUpper = (nint32)(*env)->CallIntMethod(env, attrDef, mid);

   // Get asn1ID from attrDef
   mid = (*env)->GetMethodID (env, cls, "getAsn1ID","()Lcom/novell/service/jncpv2r/net/NetAsn1ID;");
   asn1ID = (*env)->CallObjectMethod(env, attrDef, mid);

   // Get attrDef.asn1ID.data
   cls = (*env)->GetObjectClass(env, asn1ID);
   mid = (*env)->GetMethodID (env, cls, "getData","()[B");
   asn1IdData = (*env)->CallObjectMethod(env, asn1ID, mid);

   // Put attrDef.asn1ID.data into cAttrDef.asn1ID.data
   asn1IDBytes = (*env)->GetByteArrayElements (env, asn1IdData, NULL);
   memcpy (cAttrDef.asn1ID.data, asn1IDBytes, MAX_ASN1_NAME);
   (*env)->ReleaseByteArrayElements (env, asn1IdData, asn1IDBytes, JNI_ABORT);

   // Put length of string into cAttrDef.asn1ID.length
   cAttrDef.asn1ID.length = MAX_ASN1_NAME;

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSDefineAttr((NWDSContextHandle)context,
                           (pnstr8) cAttrName,
                           &cAttrDef);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return (ccode);

} /* NWDSDefineAttr () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSDefineClass
 * Signature: (ILjava/lang/String;Lcom/novell/service/jncpv2r/net/NetClassInfo;I)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSDefineClass
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring className,
   jobject classInfo, /*NDSClassInfo*/
   jint classItems
)
{
   NWDSCCODE      ccode;
   unicode        cClassName[MAX_SCHEMA_NAME_CHARS + 1];
   Class_Info_T   cClassInfo;
   jobject        asn1ID;
   jbyteArray     asn1IdData;
   jbyte          *asn1IDBytes = NULL;
   jclass         cls;
   jmethodID      mid;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Convert className and load into cClassName
   jstring2unicode(env, className, cClassName, sizeof(cClassName));

   // Put classInfo.classFlags into cClassInfo.classFags
   cls = (*env)->GetObjectClass(env, classInfo);
   mid = (*env)->GetMethodID (env, cls, "getFlags","()I");
   cClassInfo.classFlags = (nint32)(*env)->CallIntMethod(env, classInfo, mid);

   // Get asn1ID from classInfo
   mid = (*env)->GetMethodID (env, cls, "getAsn1ID","()Lcom/novell/service/jncpv2r/net/NetAsn1ID;");
   asn1ID = (*env)->CallObjectMethod(env, classInfo, mid);

   // Get classInfo.asn1ID.data
   cls = (*env)->FindClass(env, "com/novell/service/jncpv2r/net/NetAsn1ID");
   mid = (*env)->GetMethodID (env, cls, "getData","()[B");
   asn1IdData = (*env)->CallObjectMethod(env, asn1ID, mid);

   // Put classInfo.asn1ID.data into cClassInfo.asn1ID.data
   asn1IDBytes = (*env)->GetByteArrayElements (env, asn1IdData, NULL);
   memcpy (cClassInfo.asn1ID.data, asn1IDBytes, MAX_ASN1_NAME);
   (*env)->ReleaseByteArrayElements (env, asn1IdData, asn1IDBytes, JNI_ABORT);

   // Put length of string into cClassInfo.asn1ID.length
   cClassInfo.asn1ID.length = MAX_ASN1_NAME;

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSDefineClass((NWDSContextHandle)context,
                           (pnstr8) cClassName,
                           &cClassInfo,
                           (pBuf_T) classItems);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return (ccode);

} /* NWDSDefineClass () */

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSListContainableClasses
(
   NWDSContextHandle context,
   pnstr8            parentObject,
   pnint32           iterationHandle,
   pBuf_T            containableClasses
);*/

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSModifyClassDef
 * Signature: (ILjava/lang/String;I)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSModifyClassDef
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring className,
   jint optionalAttrs
)
{
   NWDSCCODE         ccode;
   unicode           cClassName[MAX_SCHEMA_NAME_CHARS + 1];

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Convert className and load into cClassName
   jstring2unicode(env, className, cClassName, sizeof(cClassName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSModifyClassDef(
                  (NWDSContextHandle) context,
                  (pnstr8) cClassName,
                  (pBuf_T) optionalAttrs);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return (ccode);

} /* NWDSSModifyClassDef () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSReadAttrDef
 * Signature: (IIZILcom/novell/service/jncpv2r/net/NetIterationHandle;[B)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSReadAttrDef
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint infoType,
   jboolean allAttrs,
   jint attrNames,
   jobject iterationHandle, /*NDSIterationHandle*/ /*inout*/
   jbyteArray attrDefs
)
{
   // JNI variables
   jclass clsIterationHandle;
   jfieldID handleId;
   // NWNet variables
   NWDSCCODE ccode;
   nint32 cIterationHandle ;
   pBuf_T cAttrDefs;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Alloc Buf_T
   ccode = NWDSAllocBuf (
               (*env)->GetArrayLength (env, attrDefs),
               &cAttrDefs);
   if (N_SUCCESS != ccode)
   {
      goto EXIT;
   }

   // Get iteration handle
   clsIterationHandle = (*env)->GetObjectClass (env, iterationHandle);
   handleId = (*env)->GetFieldID (env, clsIterationHandle, "handle", "I");
   cIterationHandle = (nint32)(*env)->GetIntField (env, iterationHandle, handleId);

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (N_SUCCESS != ccode)
   {
      goto CLEANUP;
   }
#endif

   ccode = NWDSReadAttrDef (
               (NWDSContextHandle) context,
               infoType,
               (nbool8) allAttrs,
               (pBuf_T) attrNames,
               &cIterationHandle,
               cAttrDefs);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   // Set iteration handle
   (*env)->SetIntField (env, iterationHandle, handleId, (jint) cIterationHandle);

   if (N_SUCCESS == ccode)
   {
      // copy Buf_T.curPos to byte[]
      (*env)->SetByteArrayRegion (
                  env,
                  attrDefs,
                  0,
                  cAttrDefs->curLen,
                  (jbyte *) cAttrDefs->curPos);
   }

#ifdef N_PLAT_NLM
CLEANUP:
#endif

   NWDSFreeBuf (cAttrDefs);

EXIT:

   return (ccode);

} /* NWDSReadAttrDef () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSReadClassDef
 * Signature: (IIZILcom/novell/service/jncpv2r/net/NetIterationHandle;[B)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSReadClassDef
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jint infoType,
   jboolean allClasses,
   jint classNames,
   jobject iterationHandle, /*NDSIterationHandle*/ /*inout*/
   jbyteArray classDefs
)
{
   // JNI variables
   jclass clsIterationHandle;
   jfieldID handleId;
   // NWNet variables
   NWDSCCODE ccode;
   nint32 cIterationHandle;
   pBuf_T cClassDefs;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Alloc Buf_T
   ccode = NWDSAllocBuf (
               (*env)->GetArrayLength (env, classDefs),
               &cClassDefs);
   if (N_SUCCESS != ccode)
   {
      goto EXIT;
   }

   // Get iteration handle
   clsIterationHandle = (*env)->GetObjectClass (env, iterationHandle);
   handleId = (*env)->GetFieldID (env, clsIterationHandle, "handle", "I");
   cIterationHandle = (nint32)(*env)->GetIntField (env, iterationHandle, handleId);

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (N_SUCCESS != ccode)
   {
      goto CLEANUP;
   }
#endif

   ccode = NWDSReadClassDef (
               (NWDSContextHandle) context,
               infoType,
               (nbool8) allClasses,
               (pBuf_T) classNames,
               &cIterationHandle,
               cClassDefs);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   // Set iteration handle
   (*env)->SetIntField (env, iterationHandle, handleId, (jint) cIterationHandle);

   if(N_SUCCESS == ccode)
   {
      // copy Buf_T.curPos to byte[]
      (*env)->SetByteArrayRegion (
                  env,
                  classDefs,
                  0,
                  cClassDefs->curLen,
                  (jbyte *) cClassDefs->curPos);
   }

#ifdef N_PLAT_NLM
CLEANUP:
#endif

   NWDSFreeBuf (cClassDefs);

EXIT:

   return (ccode);

} /* NWDSReadClassDef () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSRemoveAttrDef
 * Signature: (ILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSRemoveAttrDef
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring attrName
)
{
   NWDSCCODE      ccode;
   unicode        cAttrName[MAX_SCHEMA_NAME_CHARS + 1];

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   jstring2unicode(env, attrName, cAttrName, sizeof(cAttrName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSRemoveAttrDef((NWDSContextHandle)context,
                           (pnstr8) cAttrName);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return (ccode);

} /* NWDSRemoveAttrDef () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSRemoveClassDef
 * Signature: (ILjava/lang/String;)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSRemoveClassDef
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring className
)
{
   NWDSCCODE      ccode;
   unicode        cClassName[MAX_SCHEMA_NAME_CHARS + 1];

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   jstring2unicode(env, className, cClassName, sizeof(cClassName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   ccode = NWDSRemoveClassDef((NWDSContextHandle)context,
                           (pnstr8) cClassName);

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   return (ccode);

} /* NWDSRemoveClassDef () */

/* Not Implemented
N_EXTERN_LIBRARY (NWDSCCODE)
NWDSSyncSchema
(
   NWDSContextHandle context,
   pnstr8            server,
   nuint32           seconds
);*/



N_EXTERN_FUNC(void) __InitSkadsFunctions(void)
{
   void *arr[sizeof(SkadsFunctionNames) / sizeof(char *)];
   int loadSuccessful = 1;
   int i;

#ifdef N_PLAT_NLM
   nint32 NLMHandle = GetNLMHandle();

   for (i = 0; i < sizeof(arr) / sizeof(void *); i++)
      arr[i] = (void *) ImportSymbol(NLMHandle, SkadsFunctionNames[i]);
#else
   HMODULE DLLHandle = LoadLibrary("NETWIN32.DLL");

   // use a little trick to get past the length-preceeded NLM strings
   for (i = 0; i < sizeof(arr) / sizeof(void *); i++)
      arr[i] = (void *) GetProcAddress(DLLHandle, SkadsFunctionNames[i]);
#endif

   for (i = 0; i < sizeof(arr) / sizeof(void *); i++)
   {
      if (arr[i] == NULL)
         loadSuccessful = 0;
   }

   if (loadSuccessful)
   {
      _SkadsJumpTable->createSearch = (ItrCreateSearch_t) arr[0];
      _SkadsJumpTable->createList = (ItrCreateList_t) arr[1];
      _SkadsJumpTable->destroy = (ItrDestroy_t) arr[2];
      _SkadsJumpTable->clone = (ItrClone_t) arr[3];

      _SkadsJumpTable->atFirst = (ItrAtFirst_t) arr[4];
      _SkadsJumpTable->atEOF = (ItrAtEOF_t) arr[5];
      _SkadsJumpTable->getInfo = (ItrGetInfo_t) arr[6];

      _SkadsJumpTable->getPosition = (ItrGetPosition_t) arr[7];
      _SkadsJumpTable->setPosition = (ItrSetPosition_t) arr[8];
      _SkadsJumpTable->setPositionFromIterator =
            (ItrSetPositionFromIterator_t) arr[9];
      _SkadsJumpTable->typeDown = (ItrTypeDown_t) arr[10];
      _SkadsJumpTable->skip = (ItrSkip_t) arr[11];
      _SkadsJumpTable->getNext = (ItrGetNext_t) arr[12];
      _SkadsJumpTable->getPrev = (ItrGetPrev_t) arr[13];
      _SkadsJumpTable->getCurrent = (ItrGetCurrent_t) arr[14];
      _SkadsJumpTable->count = (ItrCount_t) arr[15];

#ifndef N_PLAT_NLM
      globalDLLHandle = DLLHandle;
#endif
   }
   else
   {
      __CleanupSkadsFunctions();

      _SkadsJumpTable = NULL;
   }
}

N_EXTERN_FUNC(void) __CleanupSkadsFunctions(void)
{
   if (_SkadsJumpTable != NULL)
   {
#ifdef N_PLAT_NLM
      int NLMHandle = GetNLMHandle();
      int i;

      for (i = 0; i < sizeof(SkadsFunctionNames) / sizeof(char *); i++)
         UnimportSymbol(NLMHandle, SkadsFunctionNames[i]);
#else
      FreeLibrary(globalDLLHandle);
#endif
   }
}

void __ThrowNotPresentException(JNIEnv *env, const char *APIName)
{
   jclass cls = (*env)->FindClass(env, JNCPPKG "APINotPresentException");

   if (cls == 0)
      cls = (*env)->FindClass(env, "java/lang/ClassNotFoundException");

   (*env)->ThrowNew(env, cls, APIName);
}

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSItrCreateSearch
 * Signature: (IILjava/lang/String;IZIIIZILjava/lang/String;Ljava/lang/String;II[I)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSItrCreateSearch
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring baseObjectName,
   jint scope,
   jboolean searchAliases,
   jint filter,
   jint timeFilter,
   jint infoType,
   jboolean allAttrs,
   jint attrNames,
   jstring indexSelect,
   jstring sortKey,
   jint scalability,
   jint timeout,
   jintArray iterator
)
{
   NWDSCCODE ccode;
   unicode cBaseObjectName[MAX_DN_CHARS + 1];
   unicode cIndexSelect[MAX_SCHEMA_NAME_CHARS + 1];
   unicode cSortKey[MAX_SCHEMA_NAME_CHARS * 3 + 5]; // up to 3 attribute names (+ commas)
   nuint32 cIterator = UINT_MAX;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Convert Names and load into c vars
   if ((*env)->GetStringLength(env, baseObjectName) > MAX_DN_CHARS)
      return ERR_DN_TOO_LONG;
   jstring2unicode(env, baseObjectName, cBaseObjectName, sizeof(cBaseObjectName));

   if (indexSelect != NULL)
      jstring2unicode(env, indexSelect, cIndexSelect, sizeof(cIndexSelect));

   if (sortKey != NULL)
      jstring2unicode(env, sortKey, cSortKey, sizeof(cSortKey));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   if (_SkadsJumpTable != NULL)
   {
      ccode = (*_SkadsJumpTable->createSearch)(
            (NWDSContextHandle) context,
            (pnstr8) cBaseObjectName,
            (nint) scope,
            (nbool8) searchAliases,
            (pBuf_T) filter,
            (pTimeStamp_T) timeFilter,
            (nuint32) infoType,
            (nbool8) allAttrs,
            (pBuf_T) attrNames,
            indexSelect == NULL ? NULL : (pnstr8) cIndexSelect,
            sortKey == NULL ? NULL : (pnstr8) cSortKey,
            (nint) scalability,
            (nint) timeout,
            &cIterator);
   }
   else
   {
      __ThrowNotPresentException(env, "NWDSItrCreateSearch");
      ccode = -1;
   }

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   {
      jint temp = (jint) cIterator;

      (*env)->SetIntArrayRegion (env, iterator, 0, 1, &temp);
   }

   return ((jint) ccode);

} /* NWDSItrCreateSearch () */


/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSItrCreateList
 * Signature: (IILjava/lang/String;Ljava/lang/String;Ljava/lang/String;II[I)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSItrCreateList
(
   JNIEnv *env,
   jclass unused,
   jint threadGroup,
   jint context,
   jstring baseObjectName,
   jstring className,
   jstring subordinateName,
   jint scalability,
   jint timeout,
   jintArray iterator
)
{
   NWDSCCODE ccode;
   unicode cBaseObjectName[MAX_DN_CHARS + 1];
   unicode cClassName[MAX_SCHEMA_NAME_CHARS + 1];
   unicode cSubordinateName[MAX_DN_CHARS + 1];
   nuint32 cIterator = UINT_MAX;

#ifdef N_PLAT_NLM
   nint saveThreadGroup;
#endif

   // Convert Names and load into c vars
   if ((*env)->GetStringLength(env, baseObjectName) > MAX_DN_CHARS)
      return ERR_DN_TOO_LONG;
   jstring2unicode(env, baseObjectName, cBaseObjectName, sizeof(cBaseObjectName));

   if (className != NULL)
      jstring2unicode(env, className, cClassName, sizeof(cClassName));

   if (subordinateName != NULL)
      jstring2unicode(env, subordinateName, cSubordinateName, sizeof(cSubordinateName));

#ifdef N_PLAT_NLM
   ccode = wrapContext(&saveThreadGroup, threadGroup, context);
   if (0 != ccode)
      return ccode;
#endif

   if (_SkadsJumpTable != NULL)
   {
      ccode = (*_SkadsJumpTable->createList)(
            (NWDSContextHandle) context,
            (pnstr8) cBaseObjectName,
            className == NULL ? NULL : (pnstr8) cClassName,
            subordinateName == NULL ? NULL : (pnstr8) cSubordinateName,
            (nint) scalability,
            (nint) timeout,
            &cIterator);
   }
   else
   {
      __ThrowNotPresentException(env, "NWDSItrCreateList");
      ccode = -1;
   }

#ifdef N_PLAT_NLM
   unwrapContext(saveThreadGroup);
#endif

   {
      jint temp = (jint) cIterator;

      (*env)->SetIntArrayRegion(env, iterator, 0, 1, &temp);
   }

   return ((jint) ccode);

} /* NWDSItrCreateList () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSItrDestroy
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSItrDestroy
(
   JNIEnv *env,
   jclass unused,
   jint iterator
)
{
   NWDSCCODE ccode;

   if (_SkadsJumpTable != NULL)
   {
      ccode = (*_SkadsJumpTable->destroy)(
            (nuint32) iterator);
   }
   else
   {
      __ThrowNotPresentException(env, "NWDSItrDestroy");
      return (-1);
   }

   return ((jint) ccode);

} /* NWDSItrDestroy () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSItrClone
 * Signature: (I[I)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSItrClone
(
   JNIEnv *env,
   jclass unused,
   jint iterator,
   jintArray newIterator
)
{
   NWDSCCODE ccode;
   nuint32 pNewIterator = UINT_MAX;

   if (_SkadsJumpTable != NULL)
   {
      ccode = (*_SkadsJumpTable->clone)(
            (nuint32) iterator,
            &pNewIterator);
   }
   else
   {
      __ThrowNotPresentException(env, "NWDSItrClone");
      return (-1);
   }

   {
      jint temp = (jint) pNewIterator;

      (*env)->SetIntArrayRegion (env, newIterator, 0, 1, &temp);
   }

   return ((jint) ccode);

} /* NWDSItrClone () */


/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSItrAtFirst
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSItrAtFirst
(
   JNIEnv *env,
   jclass unused,
   jint iterator
)
{
   nbool8 cItrAtFirst;

   if (_SkadsJumpTable != NULL)
   {
      cItrAtFirst = (*_SkadsJumpTable->atFirst)((nuint32) iterator);
   }
   else
   {
      __ThrowNotPresentException(env, "NWDSItrAtFirst");
      return (N_FALSE);
   }

   return ((jboolean) cItrAtFirst);

} /* NWDSItrAtFirst () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSItrAtEOF
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSItrAtEOF
(
   JNIEnv *env,
   jclass unused,
   jint iterator
)
{
   nbool8 cItrAtEOF;

   if (_SkadsJumpTable != NULL)
   {
      cItrAtEOF = (*_SkadsJumpTable->atEOF)((nuint32) iterator);
   }
   else
   {
      __ThrowNotPresentException(env, "NWDSItrAtEOF");
      return (N_FALSE);
   }

   return ((jboolean) cItrAtEOF);

} /* NWDSItrAtEOF () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSItrGetInfo
 * Signature: (I[Z[Z)I
 */
JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSItrGetInfo
(
   JNIEnv *env,
   jclass unused,
   jint iterator,
   jbooleanArray isScalable,
   jbooleanArray isPositionable
)
{
   NWDSCCODE ccode;
   nbool8 cIsScalable;
   nbool8 cIsPositionable;
   jboolean temp;

   if (_SkadsJumpTable != NULL)
   {
      ccode = (*_SkadsJumpTable->getInfo)(
                                             (nuint32) iterator,
                                             &cIsScalable,
                                             &cIsPositionable);
   }
   else
   {
      __ThrowNotPresentException (env, "NWDSItrGetInfo");
      return (-1);
   }

   if (N_SUCCESS == ccode)
   {
      // Copy the cIsScalable into the Java isScalable boolean array
      temp = (jboolean) cIsScalable;
      (*env)->SetBooleanArrayRegion (env, isScalable, 0, 1, &temp);

      // Copy the cIsPositionable into the Java isPositionable boolean array
      temp = (jboolean) cIsPositionable;
      (*env)->SetBooleanArrayRegion (env, isPositionable, 0, 1, &temp);

   }

   return ((jint) ccode);

} /* NWDSItrGetInfo () */


/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSItrGetPosition
 * Signature: (I[II)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSItrGetPosition
(
   JNIEnv *env,
   jclass unused,
   jint iterator,
   jintArray position,
   jint timeout
)
{
   NWDSCCODE ccode;
   nuint32 cPosition;

   if (_SkadsJumpTable != NULL)
   {
      ccode = (*_SkadsJumpTable->getPosition)(
                                                (nuint32) iterator,
                                                &cPosition,
                                                (nuint32) timeout);
   }
   else
   {
      __ThrowNotPresentException(env, "NWDSItrGetPosition");
      return (-1);
   }

   {
      jint temp = (jint) cPosition;

      (*env)->SetIntArrayRegion (env, position, 0, 1, &temp);
   }

   return ((jint) ccode);

} /* NWDSItrGetPosition () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSItrSetPosition
 * Signature: (III)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSItrSetPosition
(
   JNIEnv *env,
   jclass unused,
   jint iterator,
   jint position,
   jint timeout
)
{
   NWDSCCODE ccode;

   if (_SkadsJumpTable != NULL)
   {
      ccode = (*_SkadsJumpTable->setPosition)(
            (nuint32) iterator,
            (nuint32) position,
            (nuint32) timeout);
   }
   else
   {
      __ThrowNotPresentException(env, "NWDSItrSetPosition");
      return (-1);
   }

   return ((jint) ccode);

} /* NWDSItrSetPosition () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSItrSetPositionFromIterator
 * Signature: (III)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSItrSetPositionFromIterator
(
   JNIEnv *env,
   jclass unused,
   jint iterator,
   jint srcIterator,
   jint timeout
)
{
   NWDSCCODE ccode;

   if (_SkadsJumpTable != NULL)
   {
      ccode = (*_SkadsJumpTable->setPositionFromIterator)(
            (nuint32) iterator,
            (nuint32) srcIterator,
            (nuint32) timeout);
   }
   else
   {
      __ThrowNotPresentException(env, "NWDSItrSetPositionFromIterator");
      return (-1);
   }

   return ((jint) ccode);

} /* NWDSItrSetPositionFromIterator () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSItrTypeDown
 * Signature: (ILjava/lang/String;Ljava/lang/String;I)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSItrTypeDown
(
   JNIEnv *env,
   jclass unused,
   jint iterator,
   jstring attribute,
   jstring value,
   jint timeout
)
{
   NWDSCCODE ccode;
   unicode cAttribute[MAX_SCHEMA_NAME_CHARS + 1];
   unicode cValue[MAX_DN_CHARS + 1];

   jstring2unicode(env, attribute, cAttribute, sizeof(cAttribute));
   jstring2unicode(env, value, cValue, sizeof(cValue));

   if (_SkadsJumpTable != NULL)
   {
      ccode = (*_SkadsJumpTable->typeDown)(
            (nuint32) iterator,
            (pnstr8) cAttribute,
            (pnstr8) cValue,
            DS_ITR_UNICODE_STRING,
            (nuint32) timeout);
   }
   else
   {
      __ThrowNotPresentException(env, "NWDSItrTypeDown");
      return (-1);
   }

   return ((jint) ccode);

} /* NWDSItrTypeDown () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSItrSkip
 * Signature: (III[I)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSItrSkip
(
   JNIEnv *env,
   jclass unused,
   jint iterator,
   jint numToSkip,
   jint timeout,
   jintArray numSkipped
)
{
   NWDSCCODE ccode;
   nint32 cNumSkipped = 0;

   if (_SkadsJumpTable != NULL)
   {
      ccode = (*_SkadsJumpTable->skip)(
                                (nuint32) iterator,
                                 (nint32) numToSkip,
                                (nuint32) timeout,
                                         &cNumSkipped);
   }
   else
   {
      __ThrowNotPresentException(env, "NWDSItrSkip");
      return (-1);
   }

   {
      jint temp = (jint) cNumSkipped;

      (*env)->SetIntArrayRegion (env, numSkipped, 0, 1, &temp);
   }

   return ((jint) ccode);

} /* NWDSItrSkip () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSItrGetNext
 * Signature: (IIILcom/novell/service/jncpv2r/net/NetIterationHandle;I)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSItrGetNext
(
   JNIEnv *env,
   jclass unused,
   jint iterator,
   jint numEntries,
   jint timeout,
   jobject iterationHandle,
   jint data
)
{
   NWDSCCODE ccode;
   nint32 cIterationHandle;
   jclass cls = (*env)->GetObjectClass(env, iterationHandle);
   jfieldID fid = (*env)->GetFieldID(env, cls, "handle", "I");

   cIterationHandle = (nint32)(*env)->GetIntField (env, iterationHandle, fid);

   if (_SkadsJumpTable != NULL)
   {
      ccode = (*_SkadsJumpTable->getNext)(
            (nuint32) iterator,
            (nuint32) numEntries,
            (nuint32) timeout,
            &cIterationHandle,
            (pBuf_T) data);
   }
   else
   {
      __ThrowNotPresentException(env, "NWDSItrGetNext");
      return (-1);
   }

   (*env)->SetIntField (env, iterationHandle, fid, (jint) cIterationHandle);

   return ((jint) ccode);

} /* NWDSItrGetNext () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSItrGetPrev
 * Signature: (IIILcom/novell/service/jncpv2r/net/NetIterationHandle;I)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSItrGetPrev
(
   JNIEnv *env,
   jclass unused,
   jint iterator,
   jint numEntries,
   jint timeout,
   jobject iterationHandle,
   jint data
)
{
   // JNI variables
   jclass cls = (*env)->GetObjectClass(env, iterationHandle);
   jfieldID fid = (*env)->GetFieldID(env, cls, "handle", "I");
   // NWNet variables
   NWDSCCODE ccode = N_FAILURE;
   nint32 cIterationHandle;

   cIterationHandle = (nint32)(*env)->GetIntField (env, iterationHandle, fid);

   if (_SkadsJumpTable != NULL)
   {
      ccode = (*_SkadsJumpTable->getPrev)(
                                   (nuint32) iterator,
                                   (nuint32) numEntries,
                                   (nuint32) timeout,
                                            &cIterationHandle,
                                    (pBuf_T) data);
   }
   else
   {
      __ThrowNotPresentException(env, "NWDSItrGetPrev");
   }

   (*env)->SetIntField (env, iterationHandle, fid, (jint) cIterationHandle);

   return ((jint) ccode);

} /* NWDSItrGetPrev () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSItrGetCurrent
 * Signature: (ILcom/novell/service/jncpv2r/net/NetIterationHandle;I)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSItrGetCurrent
(
   JNIEnv *env,
   jclass unused,
   jint iterator,
   jobject iterationHandle,
   jint data
)
{
   // JNI variables
   jclass cls = (*env)->GetObjectClass(env, iterationHandle);
   jfieldID fid = (*env)->GetFieldID(env, cls, "handle", "I");
   // NWNet variables
   NWDSCCODE ccode = N_FAILURE;
   nint32 cIterationHandle;

   cIterationHandle = (nint32)(*env)->GetIntField (env, iterationHandle, fid);

   if (_SkadsJumpTable != NULL)
   {
      ccode = (*_SkadsJumpTable->getCurrent)(
            (nuint32) iterator,
            &cIterationHandle,
            (pBuf_T) data);
   }
   else
   {
      __ThrowNotPresentException (env, "NWDSItrGetCurrent");
   }

   (*env)->SetIntField (env, iterationHandle, fid, (jint) cIterationHandle);

   return ((jint) ccode);

} /* NWDSItrGetCurrent () */

/*
 * Class:     com_novell_service_jncpv2r_net_NetJNI
 * Method:    NWDSItrCount
 * Signature: (IIIZ[I)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_net_NetJNI_NWDSItrCount
(
   JNIEnv *env,
   jclass unused,
   jint iterator,
   jint timeout,
   jint maxCount,
   jboolean updatePosition,
   jintArray count
)
{
   NWDSCCODE ccode = N_FAILURE;
   nuint32 cCount = 0;

   if (_SkadsJumpTable != NULL)
   {
      ccode = (*_SkadsJumpTable->count)(
                                (nuint32) iterator,
                                (nuint32) timeout,
                                (nuint32) maxCount,
                                 (nbool8) updatePosition,
                                         &cCount);
   }
   else
   {
      __ThrowNotPresentException (env, "NWDSItrItrCount");
   }

   {
      jint temp = (jint) cCount;

      (*env)->SetIntArrayRegion (env, count, 0, 1, &temp);
   }

   return ((jint) ccode);

} /* NWDSItrCount () */


