/****************************************************************************
  $Workfile: netJNI.h $
  $Revision: 2 $
  $Modtime:: 12/03/96 12:35p                               $
  $Copyright:

  Copyright (c) 1989-1995 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.$

 ***************************************************************************/

#if !defined(NETJNI_H)
#define NETJNI_H

#include <nwitr.h>

N_EXTERN_FUNC(void) __InitSkadsFunctions(void);
N_EXTERN_FUNC(void) __CleanupSkadsFunctions(void);

N_TYPEDEF_CALLBACK (NWDSCCODE, ItrCreateSearch_t)(
      NWDSContextHandle context, pnstr8 baseObjectName, nint scope,
      nbool8 searchAliases, pBuf_T filter, pTimeStamp_T pTimeFilter,
      nuint32 infoType, nbool8 allAttrs, pBuf_T attrNames,
      pnstr8 indexSelect, pnstr8 sortKey, nuint32 scalability,
      nuint32 timeout, pnuint32 pIterator);
N_TYPEDEF_CALLBACK (NWDSCCODE, ItrCreateList_t)(
      NWDSContextHandle context, pnstr8 baseObjectName, pnstr8 className,
      pnstr8 subordinateName, nuint32 scalability, nuint32 timeout,
      pnuint32 pIterator);
N_TYPEDEF_CALLBACK (NWDSCCODE, ItrDestroy_t)(nuint32 Iterator);
N_TYPEDEF_CALLBACK (NWDSCCODE, ItrClone_t)(nuint32 Iterator,
      pnuint32 pNewIterator);

N_TYPEDEF_CALLBACK (nbool8, ItrAtFirst_t)(nuint32 Iterator);

N_TYPEDEF_CALLBACK (nbool8, ItrAtEOF_t)(nuint32 Iterator);

N_TYPEDEF_CALLBACK (NWDSCCODE, ItrGetInfo_t)
   (
      nuint32 Iterator,
      pnbool8 pIsScalable,
      pnbool8 pIisPositionable
   );

N_TYPEDEF_CALLBACK (NWDSCCODE, ItrGetPosition_t)(nuint32 Iterator,
      pnuint32 pPosition, nuint32 timeout);
N_TYPEDEF_CALLBACK (NWDSCCODE, ItrSetPosition_t)(nuint32 Iterator,
      nuint32 position, nuint32 timeout);
N_TYPEDEF_CALLBACK (NWDSCCODE, ItrSetPositionFromIterator_t)(
      nuint32 Iterator, nuint32 srcIterator, nuint32 timeout);
N_TYPEDEF_CALLBACK (NWDSCCODE, ItrTypeDown_t)(nuint32 Iterator,
      pnstr8 attribute, pnstr8 value, nuint32 byteUniFlag, nuint32 timeout);
N_TYPEDEF_CALLBACK (NWDSCCODE, ItrSkip_t)(nuint32 Iterator, nint32 numToSkip,
      nuint32 timeout, pnint32 pNumSkipped);
N_TYPEDEF_CALLBACK (NWDSCCODE, ItrGetNext_t)
   (
      nuint32 Iterator,
      nuint32 numEntries,
      nuint32 timeout,
      pnint32 pIterationHandle,
      pBuf_T pData
   );

N_TYPEDEF_CALLBACK (NWDSCCODE, ItrGetPrev_t)
   (
      nuint32 Iterator,
      nuint32 numEntries,
      nuint32 timeout,
      pnint32 pIterationHandle,
      pBuf_T pData);

N_TYPEDEF_CALLBACK (NWDSCCODE, ItrGetCurrent_t)(nuint32 Iterator,
      pnint32 pIterationHandle, pBuf_T pData);
N_TYPEDEF_CALLBACK (NWDSCCODE, ItrCount_t)(nuint32 Iterator, nuint32 timeout,
      nuint32 maxCount, nbool8 updatePosition, pnuint32 pCount);

//
// the SKADS functions have to be loaded dynamically on
//   the Win32 and NLM platforms so that we don't require client DLL
//   updates on Win32 boxes or Service Pack 6 on Green River servers.
//   This is the jump table for this dynamic loading.
//
typedef struct SkadsJumpTable_tag
{
   ItrCreateSearch_t createSearch;
   ItrCreateList_t createList;
   ItrDestroy_t destroy;
   ItrClone_t clone;
   ItrAtFirst_t atFirst;
   ItrAtEOF_t atEOF;
   ItrGetInfo_t getInfo;
   ItrGetPosition_t getPosition;
   ItrSetPosition_t setPosition;
   ItrSetPositionFromIterator_t setPositionFromIterator;
   ItrTypeDown_t typeDown;
   ItrSkip_t skip;
   ItrGetNext_t getNext;
   ItrGetPrev_t getPrev;
   ItrGetCurrent_t getCurrent;
   ItrCount_t count;
} SkadsJumpTable, N_FAR *pSkadsJumpTable;

N_EXTERN_VAR pSkadsJumpTable _SkadsJumpTable;


#endif /* !NETJNI_H */


