/*
 * @(#)hpi.h	1.9 98/09/15
 *
 * Copyright 1994-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

/*
 * Host Porting Interface. This defines the "porting layer" for
 * POSIX.1 compliant operating systems.
 */

#ifndef _JAVASOFT_HPI_H_
#define _JAVASOFT_HPI_H_

#include <stdio.h>

#include "jni.h"
#include "bool.h"
#include "hpi_md.h"
#include "dll.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifdef NETWARE
#define GC_NOT_OK        0
#define GC_OK            1

typedef struct  sys_thread sys_thread_t;
typedef struct  sys_mon sys_mon_t;

//SCOTT#include <portable.h>	// for ADDR
typedef struct {
  void    (*TerminateJVM)(int criticalErr, int exitFlag);
  char *  (*GetLoadPath)( void );
  char *  (*Getenv)(const char *, int);
  int     (*Putenv)(const char *, int);
  int     (*MonitorTry)(sys_thread_t *, sys_mon_t *);
  int     (*MonitorCleanup)(sys_thread_t *, sys_mon_t *);
  int     (*setGCFlag)(int flag);
  int     (*ThreadGetOSThreadID)(sys_thread_t *);
} HPI_NetwareInterface;
#endif


/*
 * memory allocations
 */
typedef struct {
    /*
     * Malloc must return a unique pointer if size == 0.
     */
  void *  (*Malloc)(size_t size);
  void *  (*Realloc)(void *ptr, size_t new_size);
    /*
     * Free must allow ptr == NULL to be a no-op.
     */
  void	  (*Free)(void *ptr);
    /*
     * Calloc must return a unique pointer for if
     * n_item == 0 || item_size == 0.
     */
  void *  (*Calloc)(size_t n_item, size_t item_size);
  char *  (*Strdup)(const char *str);

  void *  (*MapMem)(size_t req_size, size_t *maped_size);
  void *  (*UnmapMem)(void *req_addr, size_t req_size, size_t *unmap_size);
  /*
   * CommitMem should round the ptr down to the nearest page and
   * round the size up to the nearest page so that the committed
   * region is at least as large as the requested region.
   */
  void *  (*CommitMem)(void *ptr, size_t size, size_t *actual);
  /*
   * sysDecommitMem should round the ptr up to the nearest page and
   * round the size down to the nearest page so that the decommitted
   * region is no greater than the requested region.
   */
  void *  (*DecommitMem)(void *ptr, size_t size, size_t *actual);

#define HPI_PAGE_ALIGNMENT	    (64 * 1024)

  void *  (*AllocBlock)(size_t size, void **headP);
  void    (*FreeBlock)(void *head);
} HPI_MemoryInterface;

/*
 * dynamic linking libraries
 */
typedef struct {
  void	 (*BuildLibName)(char *buf, int buf_len, char *path, char *name);
  int    (*BuildFunName)(char *name, int name_len, int arg_size, int en_idx);

  void * (*LoadLibrary)(const char *name, char *err_buf, int err_buflen);
  void   (*UnloadLibrary)(void *lib);
  void * (*FindLibraryEntry)(void *lib, const char *name);
} HPI_LibraryInterface;

typedef void (*signal_handler_t)(int sig, void *siginfo, void *context);

#define HPI_SIG_DFL (signal_handler_t)0
#define HPI_SIG_ERR (signal_handler_t)-1
#define HPI_SIG_IGN (signal_handler_t)1

typedef struct {
  char *name; /* name such as green/native threads. */
  int  isMP;
} HPI_SysInfo;

typedef struct {
#if !defined (_JVM_NT64) && !defined(_JVM_MODESTO)
  HPI_SysInfo *    (*GetSysInfo)(void);
#endif
  long 	           (*GetMilliTicks)(void);
  jlong            (*TimeMillis)(void);

#if !defined (_JVM_NT64) && !defined(_JVM_MODESTO)
  signal_handler_t (*Signal)(int sig, signal_handler_t handler);
  void             (*Raise)(int sig);
  void             (*SignalNotify)(int sig);
  int              (*SignalWait)(void);
#endif

  int              (*Shutdown)(void);

  int              (*SetLoggingLevel)(int level);
  bool_t           (*SetMonitoringOn)(bool_t on);  
  int              (*GetLastErrorString)(char *buf, int len);
} HPI_SystemInterface;

/*
 * threads and monitors
 */
#ifndef NETWARE
typedef struct  sys_thread sys_thread_t;
typedef struct  sys_mon sys_mon_t;
#endif

#define HPI_OK	        0
#define HPI_ERR	       -1
#define HPI_INTRPT     -2    /* Operation was interrupted */
#define HPI_TIMEOUT    -3    /* A timer ran out */
#define HPI_NOMEM      -5    /* Ran out of memory */
#define HPI_NORESOURCE -6    /* Ran out of some system resource */

/* There are three basic states: RUNNABLE, MONITOR_WAIT, and CONDVAR_WAIT.
 * When the thread is suspended in any of these states, the 
 * HPI_THREAD_SUSPENDED bit will be set 
 */
enum {
    HPI_THREAD_RUNNABLE = 1,
    HPI_THREAD_MONITOR_WAIT,
    HPI_THREAD_CONDVAR_WAIT
};

#define HPI_MINIMUM_PRIORITY	    1
#define HPI_MAXIMUM_PRIORITY	    10
#define HPI_NORMAL_PRIORITY	    5

#define HPI_THREAD_SUSPENDED        0x8000
#define HPI_THREAD_INTERRUPTED      0x4000

typedef struct {
    sys_thread_t *owner;
    int          entry_count;
    sys_thread_t **monitor_waiters;
    sys_thread_t **condvar_waiters;
    int          sz_monitor_waiters;
    int          sz_condvar_waiters;
    int          n_monitor_waiters;
    int          n_condvar_waiters;
} sys_mon_info;

typedef struct {
  int 	         (*ThreadBootstrap)(sys_thread_t **tidP,
				    sys_mon_t **qlockP,
				    int nReservedBytes);
  int 	         (*ThreadCreate)(sys_thread_t **tidP,
				 long stk_size,
				 void (*func)(void *),
				 void *arg);
  sys_thread_t * (*ThreadSelf)(void);
  void           (*ThreadYield)(void);
  int	         (*ThreadSuspend)(sys_thread_t *tid);
  int	         (*ThreadResume)(sys_thread_t *tid);
  int	         (*ThreadSetPriority)(sys_thread_t *tid, int prio);
  int	         (*ThreadGetPriority)(sys_thread_t *tid, int *prio);
  void *         (*ThreadStackPointer)(sys_thread_t *tid); 
  long *         (*ThreadRegs)(sys_thread_t *tid, int *regs);
  int	         (*ThreadSingle)(void);
  void	         (*ThreadMulti)(void);
  int            (*ThreadEnumerateOver)(int (*func)(sys_thread_t *, void *),
					void *arg);
  int            (*ThreadCheckStack)(void);
  void	         (*ThreadPostException)(sys_thread_t *tid, void *arg);
  void           (*ThreadInterrupt)(sys_thread_t *tid);
  int            (*ThreadIsInterrupted)(sys_thread_t *tid, int clear);
  int            (*ThreadAlloc)(sys_thread_t **tidP);
  int            (*ThreadFree)(void);
  jlong          (*ThreadCPUTime)(void);
  int            (*ThreadGetStatus)(sys_thread_t *tid, sys_mon_t **monitor);
  void *         (*ThreadInterruptEvent)(void);
  void *         (*ThreadNativeID)(sys_thread_t *tid);
  
  /* These three functions are used by the CPU time profiler.
   * sysThreadIsRunning determines whether the thread is running (not just 
   * runnable). It is only safe to call this function after calling
   * sysThreadProfSuspend.
   */
  bool_t         (*ThreadIsRunning)(sys_thread_t *tid);
  void           (*ThreadProfSuspend)(sys_thread_t *tid);
  void           (*ThreadProfResume)(sys_thread_t *tid);
  
  int            (*AdjustTimeSlice)(int ms);
  
  size_t         (*MonitorSizeof)(void);
  int            (*MonitorInit)(sys_mon_t *mid);
  int            (*MonitorDestroy)(sys_mon_t *mid);
  int            (*MonitorEnter)(sys_thread_t *self, sys_mon_t *mid);
  bool_t         (*MonitorEntered)(sys_thread_t *self, sys_mon_t *mid);
  int            (*MonitorExit)(sys_thread_t *self, sys_mon_t *mid);
  int            (*MonitorNotify)(sys_thread_t *self, sys_mon_t *mid);
  int            (*MonitorNotifyAll)(sys_thread_t *self, sys_mon_t *mid);
  int 	         (*MonitorWait)(sys_thread_t *self, sys_mon_t *mid, jlong ms);
  bool_t         (*MonitorInUse)(sys_mon_t *mid);
  sys_thread_t * (*MonitorOwner)(sys_mon_t *mid);
  int            (*MonitorGetInfo)(sys_mon_t *mid, sys_mon_info *info);
  
} HPI_ThreadInterface;

/*
 * files
 */

#define HPI_FILETYPE_REGULAR    (0)
#define HPI_FILETYPE_DIRECTORY  (1)
#define HPI_FILETYPE_OTHER      (2)

typedef struct {
  char *         (*NativePath)(char *path);
  int            (*FileType)(const char *path);
  int            (*Open)(const char *name, int openMode, int filePerm);
  int            (*Close)(int fd);
  jlong          (*Seek)(int fd, jlong offset, int whence);
  int            (*SetLength)(int fd, jlong length);
  int            (*Sync)(int fd);
  int            (*Available)(int fd, jlong *bytes);
  size_t         (*Read)(int fd, void *buf, unsigned int nBytes);
  size_t         (*Write)(int fd, const void *buf, unsigned int nBytes);
  int            (*FileSizeFD)(int fd, jlong *size);
} HPI_FileInterface;

/*
 * sockets
 */
struct sockaddr;
struct hostent;

typedef struct {
  int              (*Close)(int fd);
  long             (*Available)(int fd, long *pbytes);
  int              (*Connect)(int fd, struct sockaddr *him, int len);
  int              (*Accept)(int fd, struct sockaddr *him, int *len);
#ifdef NETWARE
  int              (*SendTo)(int fd, jbyteArray javaobj, int offset, int len, int flags,
			     struct sockaddr *to, int tolen);
  int              (*RecvFrom)(int fd, jbyteArray javaobj, int offset, int nbytes, int flags,
			       struct sockaddr *from, int *fromlen);
#else
  int              (*SendTo)(int fd, char *buf, int len, int flags,
			     struct sockaddr *to, int tolen);
  int              (*RecvFrom)(int fd, char *buf, int nbytes, int flags,
			       struct sockaddr *from, int *fromlen);
#endif
  int              (*Listen)(int fd, long count);
#ifdef NETWARE
  int              (*Recv)(int fd, jbyteArray javaobj, int offset, int nBytes, int flags);
  int              (*Send)(int fd, jbyteArray javaobj, int offset, int nBytes, int flags);
#else
  int              (*Recv)(int fd, char *buf, int nBytes, int flags);
  int              (*Send)(int fd, char *buf, int nBytes, int flags);
#endif
  int              (*Timeout)(int fd, long timeout); 
  struct hostent * (*GetHostByName)(char *hostname);
  int              (*Socket)(int domain, int type, int protocol);
} HPI_SocketInterface;

/*
 * callbacks.
 */
typedef struct vm_calls {
    int    (*jio_fprintf)(FILE *fp, const char *fmt, ...);
    void   (*panic)(const char *fmt, ...);
    void   (*monitorRegister)(sys_mon_t *mid, char *info_str);

    void   (*monitorContendedEnter)(sys_thread_t *self, sys_mon_t *mid);
    void   (*monitorContendedEntered)(sys_thread_t *self, sys_mon_t *mid);
    void   (*monitorContendedExit)(sys_thread_t *self, sys_mon_t *mid);
} vm_calls_t;

#ifdef __cplusplus
}
#endif

#endif /* !_JAVASOFT_HPI_H_ */
