/*
 * @(#)hpi_md.h	1.3 98/06/30
 *
 * Copyright 1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

#ifndef _HPI_MD_H_
#define _HPI_MD_H_

#include "timeval_md.h"
#include "io_md.h"
#include "path_md.h"
#include "byteorder_md.h"

#define PROCSTACKSIZE (128 * 1024)

#define HPI_TIMEOUT_INFINITY ((jlong)(-1))


#define NUMBER_OF_LOCK_TRIES 10

/* Try the lock a few times.  If the owner changes, assume we */
/*   can jump into the wait queue and get the lock.  If owner hasn't */
/*   changed we assume the JVM to be in a hung state or dog slow */
#define JAVA_TRY_LOCK( self, lock, trylock )                 \
{                                                            \
    int tryrc;                                               \
    void *m_owner = NULL;                                    \
                                                             \
    trylock = NUMBER_OF_LOCK_TRIES;                          \
    while ( trylock-- > 0 )                                  \
    {                                                        \
        tryrc = sysMonitorTry(self, lock);                   \
        if ( tryrc != -1 )                                   \
        {                                                    \
            if ( m_owner == NULL )                           \
                m_owner = sysMonitorOwner( lock );           \
            break;                                           \
        }                                                    \
        ThreadSwitchWithDelay();                             \
    }                                                        \
    if ( trylock <= 0 )    /* Failed to get lock? */         \
    {                      /* Is lock owned by new owner? */ \
        if ( m_owner != (void *)sysMonitorOwner( lock ) )    \
        {                  /* new owner, just slow??? */     \
            sysMonitorEnter( self, lock );                   \
            trylock = 1;                                     \
        }                                                    \
    }                                                        \
}

#define JAVA_RELEASE_LOCK( self, lock, trylock )             \
{                                                            \
    if ( trylock > 0 )                                       \
        sysMonitorExit(self, lock);                          \
}

int sysGetReservedBytes(bool_t);

#endif /* _HPI_MD_H_ */
