/*
 * @(#)sysmacros_md.h	1.12 96/11/23
 * 
 * Copyright (c) 1995, 1996 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 * CopyrightVersion 1.1_beta
 * 
 */

#ifndef _NW_SYSMACROS_MD_H_
#define _NW_SYSMACROS_MD_H_


#define INT_OP(x,op,y)  (((#op[0]=='/')||(#op[0]=='%')) ?              \
                         ( (((x)==0x80000000)&&((y)==-1)) ?            \
                             ((x) op 1) :                              \
                             ((x) op (y))) :                           \
                         ((x) op (y)))
#define NAN_CHECK(l,r,x) (!_isnan((l))&&!_isnan((r))) ? (x : 0)
#define IS_NAN(x) _isnan(x)

#ifdef DEBUG
#define sysAssert(expression) {         \
    if (!(expression)) {                \
        panic("\"%s\", line %d: assertion failure\n", __FILE__, __LINE__); \
    }                                   \
}
#else
#define sysAssert(expression) ((void) 0)
#endif

/*
 * Case insensitive compare of ASCII strings
 */
#define sysStricmp(a,b)		stricmp(a,b)

/*
 * Check whether an exception occurred.  This also gives us the oppor-
 * tunity to use the already-required exception check as a trap for other
 * system-specific conditions.
 */
#define sysCheckException(ee) \
	if (!exceptionOccurred(ee)) { \
	   continue; \
	}

// Is a Function
// #define sysIsAbsolute(s) ( (*(s) == '/' || *(s) == '\\') || (int)strchr( s+1, ':' ) )


/* Set up thread-local storage for second order monitor cache.  The
 * number of words of thread-local storage must be a power of 2!
 */
#define SYS_TLS_MONCACHE 8 /* must be power of 2 JLM*/
#define sysCurrentCacheKey(tid) (tid->cacheKey)
#define sysLocalMonCache(tid, hash) (tid->monitorCache[hash])


//extern void sysMemoryFlush (void);
#define sysMemoryFlush()  0
/*
#pragma aux sysMemoryFlush = \
	"lock xor 	DWORD PTR 0[esp],0"
*/

/*
 * Intel doesn't seem to support a weak consistency model for MP
 * so we define this to do nothing.
 */
#define sysStoreBarrier()               ((void) 0)

long *  sysInvokeNative(void *, void *, long *, char *, int, void *);

/* name of the default JIT compiler to be used on win32 */
//#define DEFAULT_JIT_NAME "symcjit"

#define JVM_ONLOAD_SYMBOLS   {"_JVM_OnLoad@12", "JVM_OnLoad"}

#endif /*_NW_SYSMACROS_MD_H_*/
