/*
 * Copyright (c) 1993-1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * The Java source code is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You shall
 * not disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.

 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
/*
 * @(#)typedefs_md.h	1.18 95/11/20
 *
 */

/*
 * NetWare dependent type definitions
 */

#ifndef _NW_TYPEDEF_MD_H_
#define _NW_TYPEDEF_MD_H_


#ifndef	WATCOM11
#define	_MAX_NAME	13
#include <stat.h>
#endif

// typedef char int8_t;
typedef unsigned char int8_t;

typedef unsigned int uint_t;
typedef long int32_t;
typedef unsigned long uint32_t;
#ifdef NETFIRE
typedef __int64 int64_t;
typedef unsigned __int64 uint64_t;
#endif
typedef int intptr_t;
typedef unsigned int uintptr_t;


#ifdef	WATCOM11

/*
 * WATCOM11 VERSION
 */

typedef unsigned __int64 uint64_t;
typedef __int64 int64_t;

#define ll_high(a)	((long)((a)>>32))
#define ll_low(a)	((long)(a))
#define int2ll(a)	((int64_t)(a))
#define ll2int(a)	((int)(a))
#define ll_add(a, b)	((a) + (b))
#define ll_and(a, b)	((a) & (b))
#define ll_div(a, b)	((a) / (b))
#define ll_mul(a, b)	((a) * (b))
#define ll_neg(a)	(-(a))
#define ll_not(a)	(~(a))
#define ll_or(a, b)	((a) | (b))
#define ll_shl(a, n)	((a) << (n))
#define ll_shr(a, n)	((a) >> (n))
#define ll_sub(a, b)	((a) - (b))
#define ll_ushr(a, n)	((uint64_t)(a) >> (n))
#define ll_xor(a, b)	((a) ^ (b))
#define uint2ll(a)	((uint64_t)(unsigned long)(a))
#define ll_rem(a,b)	((a) % (b))

/* well -- Watcom doesn't grok '#@op' -- too bad.. see win32 code for orig */

#ifdef	UNDEF
#define INT_OP(x,op,y)  (((#@op=='/')||(#@op=='%')) ?                  \
			 ( (((x)==0x80000000)&&((y)==-1)) ?            \
			     ((x) op 1) :                              \
			     ((x) op (y))) :                           \
			 ((x) op (y)))
#endif

#define NAN_CHECK(l,r,x) (!_isnan((l))&&!_isnan((r))) ? (x : 0)
#define IS_NAN(x) _isnan(x)

int32_t float2l(float f);
int32_t double2l(double f);
int64_t float2ll(float f);
#define ll2float(a)	((float) (a))
#define ll2double(a)	((double) (a))
int64_t double2ll(double f);

/* Useful on machines where jlong and jdouble have different endianness. */
#define ll2double_bits(a) ((void) 0)

/* comparison operators */
#define ll_ltz(ll)	((ll)<0)
#define ll_gez(ll)	((ll)>=0)
#define ll_eqz(a)	((a) == 0)
#define ll_nez(a)   ((a) != 0)
#define ll_eq(a, b)	((a) == (b))
#define ll_ne(a,b)	((a) != (b))
#define ll_ge(a,b)	((a) >= (b))
#define ll_le(a,b)	((a) <= (b))
#define ll_lt(a,b)	((a) < (b))
#define ll_gt(a,b)	((a) > (b))

#define ll_zero_const	((int64_t) 0)
#define ll_one_const	((int64_t) 1)

/* int64_t ll_shl(int64_t a, int bits); */

#define ll2ptr(a) ((void*)(a))
#define ptr2ll(a) ((jlong)(a))

int _isnan( double );
#pragma aux _isnan  = "and    edx, 0x7FFFFFFF"           \
                      "neg    eax"                       \
                      "mov    eax, 0x7FF00000"           \
                      "sbb    eax, edx"                  \
                      "shr    eax, 31"                   \
                      parm [eax edx] modify [edx] value [eax];


#else /* better be GCC */
#ifdef __GNUC__

/*
 * GNU VERSION -- NOT CONVERTED FOR JAVA11 YET -- JKM
 */

typedef unsigned long long uint64_t;
typedef long long int64_t;

#define ll_high(a)	((long)((a)>>32))
#define ll_low(a)	((long)(a))
#define int2ll(a)	((int64_t)(a))
#define ll2int(a)	((int)(a))
#define ll_add(a, b)	((a) + (b))
#define ll_and(a, b)	((a) & (b))
#define ll_div(a, b)	((a) / (b))
#define ll_mul(a, b)	((a) * (b))
#define ll_neg(a)	(-(a))
#define ll_not(a)	(~(a))
#define ll_or(a, b)	((a) | (b))
#define ll_shl(a, n)	((a) << (n))
#define ll_shr(a, n)	((a) >> (n))
#define ll_sub(a, b)	((a) - (b))
#define ll_ushr(a, n)	((unsigned long long)(a) >> (n))
#define ll_xor(a, b)	((a) ^ (b))
#define uint2ll(a)	((uint64_t)(unsigned long)(a))
#define ll_rem(a,b)	((a) % (b))

#define float2ll(f)	((int64_t) (f))
#define ll2float(a)	((float) (a))
#define ll2double(a)	((double) (a))
#define double2ll(f)	((int64_t) (f))

/* comparison operators */
#define ll_ltz(ll)	((ll)<0)
#define ll_gez(ll)	((ll)>=0)
#define ll_eqz(a)	((a) == 0)
#define ll_eq(a, b)	((a) == (b))
#define ll_ne(a,b)	((a) != (b))
#define ll_ge(a,b)	((a) >= (b))
#define ll_le(a,b)	((a) <= (b))
#define ll_lt(a,b)	((a) < (b))
#define ll_gt(a,b)	((a) > (b))

#define ll_zero_const	((int64_t) 0)
#define ll_one_const	((int64_t) 1)

#endif /* __GNUC__ */
#endif /* !WATCOM11 */

extern void ll2str(int64_t a, char *s, char *limit);

#include <stdlib.h>	/* For malloc() and free() */
// _MAX_PATH defined in STDLIB.H (included by sys/stat.h)
#define MAX_PATH _MAX_PATH

#define EXPORTED

#endif /* !_NW_TYPEDEF_MD_H_ */
