/*
 * @(#)sys_api.h	1.107 98/09/15
 *
 * Copyright 1994-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

#ifndef _JAVASOFT_SYS_API_H_
#define _JAVASOFT_SYS_API_H_

#include "hpi.h"

extern HPI_MemoryInterface  *hpi_memory_interface;
extern HPI_LibraryInterface *hpi_library_interface;
extern HPI_SystemInterface  *hpi_system_interface;

// XXXDER - For now no HPI thread APIs for the IA64 platforms
#if !defined(_JVM_NT64) && !defined(_JVM_MODESTO)
extern HPI_ThreadInterface  *hpi_thread_interface;
#endif

extern HPI_FileInterface    *hpi_file_interface;
extern HPI_SocketInterface  *hpi_socket_interface;

#ifdef NETWARE
extern HPI_NetwareInterface *hpi_netware_interface;


#define sysTerminateJVM(x,y)  hpi_netware_interface->TerminateJVM(x,y)
#define sysGetLoadPath()      hpi_netware_interface->GetLoadPath()
#define getenv(x)             hpi_netware_interface->Getenv(x,1)
#define putenv(x)             hpi_netware_interface->Putenv(x,1)
#define sysSetGCFlag(a)       hpi_netware_interface->setGCFlag(a)
#define sysThreadGetOSThreadID(a)  \
                              hpi_netware_interface->ThreadGetOSThreadID(a)
#endif


#ifdef NETWARE
#ifdef __cplusplus
extern "C"
{
#endif
extern void    *sysMalloc( size_t __size );
extern void    *sysCalloc( size_t __n, size_t __size );
extern void    *sysRealloc( void *__oldMem, size_t __size );
extern void    sysFree( void *__ptr );
extern char    *sysStrdup( const char *s1 );
#ifdef __cplusplus
}
#endif
#else
#define sysMalloc(x)          hpi_memory_interface->Malloc(x)
#define sysRealloc(x,y)       hpi_memory_interface->Realloc(x,y)
#define sysFree(x)            hpi_memory_interface->Free(x)
#define sysCalloc(x,y)        hpi_memory_interface->Calloc(x,y)
#define sysStrdup(x)          hpi_memory_interface->Strdup(x)
#endif
#define sysMapMem(x,y)        hpi_memory_interface->MapMem(x,y)
#define sysUnmapMem(x,y,z)    hpi_memory_interface->UnmapMem(x,y,z)
#define sysCommitMem(x,y,z)   hpi_memory_interface->CommitMem(x,y,z)
#define sysDecommitMem(x,y,z) hpi_memory_interface->DecommitMem(x,y,z)
#define sysAllocBlock(x,y)    hpi_memory_interface->AllocBlock(x,y)
#define sysFreeBlock(x)       hpi_memory_interface->FreeBlock(x)

#define sysBuildLibName(a,b,c,d) hpi_library_interface->BuildLibName(a,b,c,d)
#define sysBuildFunName(a,b,c,d) hpi_library_interface->BuildFunName(a,b,c,d)
#define sysLoadLibrary(a,b,c)        hpi_library_interface->LoadLibrary(a,b,c)
#define sysUnloadLibrary(a)      hpi_library_interface->UnloadLibrary(a)
#define sysFindLibraryEntry(a,b) hpi_library_interface->FindLibraryEntry(a,b)

#if defined(_JVM_NT64) || defined(_JVM_MODESTO)
#define sysGetSysInfo()          (0)
#else
#define sysGetSysInfo()          hpi_system_interface->GetSysInfo()
#endif
#define sysGetMilliTicks()       hpi_system_interface->GetMilliTicks()
#define sysTimeMillis()          hpi_system_interface->TimeMillis()

#if defined(_JVM_NT64) || defined(_JVM_MODESTO)
#define sysSignal(a,b)             (0)
#define sysRaise(a)                (0)
#define sysSignalNotify(a)         (0)
#define sysSignalWait()            (0)
#else
#define sysSignal(a,b)             hpi_system_interface->Signal(a,b)
#define sysRaise(a)                hpi_system_interface->Raise(a)
#define sysSignalNotify(a)         hpi_system_interface->SignalNotify(a)
#define sysSignalWait()            hpi_system_interface->SignalWait()
#endif

#define sysShutdown()              hpi_system_interface->Shutdown()
#define sysSetLoggingLevel(a)      hpi_system_interface->SetLoggingLevel(a)
#define sysSetMonitoringOn(a)      hpi_system_interface->SetMonitoringOn(a)
#define sysGetLastErrorString(a,b) hpi_system_interface->GetLastErrorString(a,b)

#if defined(_JVM_NT64) || defined(_JVM_MODESTO)
#define sysThreadBootstrap(a,b,c)  (0)
#define sysThreadCreate(a,b,c,d)   (0)
#else
#define sysThreadBootstrap(a,b,c)  hpi_thread_interface->ThreadBootstrap(a,b,c)
#define sysThreadCreate(a,b,c,d)   hpi_thread_interface->ThreadCreate(a,b,c,d)
#endif

#if defined(_JVM_NT64) || defined(_JVM_MODESTO)
#define sysThreadSelf()		(0)
#else
#ifndef NETWARE
#define sysThreadSelf()            hpi_thread_interface->ThreadSelf()
#endif
#endif

#if defined(_JVM_NT64) || defined(_JVM_MODESTO)
#define sysThreadYield()           (0)
#define sysThreadSuspend(a)        (0)
#define sysThreadResume(a)         (0)
#define sysThreadSetPriority(a,b)  (0)
#define sysThreadGetPriority(a,b)  (0)
#define sysThreadStackPointer(a)   (0)
#define sysThreadRegs(a,b)         (0)
#define sysThreadSingle()          (0)
#define sysThreadMulti()           (0)
#define sysThreadCheckStack()      (0)
#define sysThreadPostException(a,b) 	(0)
#define sysThreadInterrupt(a)      (0)
#define sysThreadIsInterrupted(a,b) 	(0)
#define sysThreadAlloc(a)          (0)
#define sysThreadFree()            (0)
#define sysThreadCPUTime()         (0)
#define sysThreadGetStatus(a,b)    (0)
#define sysThreadEnumerateOver(a,b) 	(0)
#define sysThreadIsRunning(a)      (0)
#define sysThreadProfSuspend(a)    (0)
#define sysThreadProfResume(a)     (0)
#define sysAdjustTimeSlice(a)      (0)
#else
#define sysThreadYield()           hpi_thread_interface->ThreadYield()
#define sysThreadSuspend(a)        hpi_thread_interface->ThreadSuspend(a)
#define sysThreadResume(a)         hpi_thread_interface->ThreadResume(a)
#define sysThreadSetPriority(a,b)  hpi_thread_interface->ThreadSetPriority(a,b)
#define sysThreadGetPriority(a,b)  hpi_thread_interface->ThreadGetPriority(a,b)
#define sysThreadStackPointer(a)   hpi_thread_interface->ThreadStackPointer(a)
#define sysThreadRegs(a,b)         hpi_thread_interface->ThreadRegs(a,b)
#define sysThreadSingle()          hpi_thread_interface->ThreadSingle()
#define sysThreadMulti()           hpi_thread_interface->ThreadMulti()
#define sysThreadCheckStack()      hpi_thread_interface->ThreadCheckStack()
#define sysThreadPostException(a,b) \
    hpi_thread_interface->ThreadPostException(a,b)
#define sysThreadInterrupt(a)      hpi_thread_interface->ThreadInterrupt(a)
#define sysThreadIsInterrupted(a,b) \
    hpi_thread_interface->ThreadIsInterrupted(a,b)
#define sysThreadAlloc(a)          hpi_thread_interface->ThreadAlloc(a)
#define sysThreadFree()            hpi_thread_interface->ThreadFree()
#define sysThreadCPUTime()         hpi_thread_interface->ThreadCPUTime()
#define sysThreadGetStatus(a,b)    hpi_thread_interface->ThreadGetStatus(a,b)
#define sysThreadEnumerateOver(a,b) \
    hpi_thread_interface->ThreadEnumerateOver(a,b)
#define sysThreadIsRunning(a)      hpi_thread_interface->ThreadIsRunning(a)
#define sysThreadProfSuspend(a)    hpi_thread_interface->ThreadProfSuspend(a)
#define sysThreadProfResume(a)     hpi_thread_interface->ThreadProfResume(a)
#define sysAdjustTimeSlice(a)      hpi_thread_interface->AdjustTimeSlice(a)
#endif // !defined(_JVM_NT64) && !defined(_JVM_MODESTO)

#ifndef NETWARE
#if defined(_JVM_NT64) || defined(_JVM_MODESTO)
#if 0
#define sysMonitorDestroy(a)       (0)
#define sysMonitorEnter(a,b)       (0)
#define sysMonitorEntered(a,b)     (0)
#define sysMonitorExit(a,b)        (0)
#define sysMonitorGetInfo(a,b)     (0)
#define sysMonitorInit(a)          (0)
#define sysMonitorInUse(a)         (0)
#define sysMonitorNotify(a,b)      (0)
#define sysMonitorNotifyAll(a,b)   (0)
#define sysMonitorOwner(a)         (0)
#define sysMonitorSizeof()         (0)
#define sysMonitorWait(a,b,c)      (0)
#endif
#else
#define sysMonitorDestroy(a)       hpi_thread_interface->MonitorDestroy(a)
#define sysMonitorEnter(a,b)       hpi_thread_interface->MonitorEnter(a,b)
#define sysMonitorEntered(a,b)     hpi_thread_interface->MonitorEntered(a,b)
#define sysMonitorExit(a,b)        hpi_thread_interface->MonitorExit(a,b)
#define sysMonitorGetInfo(a,b)     hpi_thread_interface->MonitorGetInfo(a,b)
#define sysMonitorInit(a)          hpi_thread_interface->MonitorInit(a)
#define sysMonitorInUse(a)         hpi_thread_interface->MonitorInUse(a)
#define sysMonitorNotify(a,b)      hpi_thread_interface->MonitorNotify(a,b)
#define sysMonitorNotifyAll(a,b)   hpi_thread_interface->MonitorNotifyAll(a,b)
#define sysMonitorOwner(a)         hpi_thread_interface->MonitorOwner(a)
#define sysMonitorSizeof()         hpi_thread_interface->MonitorSizeof()
#define sysMonitorWait(a,b,c)      hpi_thread_interface->MonitorWait(a,b,c)
#define sysRead(a,b,c)          	  hpi_file_interface->Read(a,b,c)
#define sysWrite(a,b,c)         	  hpi_file_interface->Write(a,b,c)
#endif
#endif // NETWARE



#if defined(_JVM_NT64) || defined(_JVM_MODESTO)
#define sysThreadInterruptEvent()  (0)
#define sysThreadNativeID(a)       (0)
#else
#define sysThreadInterruptEvent()  hpi_thread_interface->ThreadInterruptEvent()
#define sysThreadNativeID(a)       hpi_thread_interface->ThreadNativeID(a)
#endif

#define sysNativePath(a)        hpi_file_interface->NativePath(a)
#define sysFileType(a)          hpi_file_interface->FileType(a)
#define sysOpen(a,b,c)          hpi_file_interface->Open(a,b,c)
#define sysClose(a)             hpi_file_interface->Close(a)
#define sysSeek(a,b,c)          hpi_file_interface->Seek(a,b,c)
#define sysSetLength(a,b)       hpi_file_interface->SetLength(a,b)
#define sysSync(a)              hpi_file_interface->Sync(a)
#define sysAvailable(a,b)       hpi_file_interface->Available(a,b)
#define sysFileSizeFD(a,b)      hpi_file_interface->FileSizeFD(a,b)

#define sysSocketClose(a)        hpi_socket_interface->Close(a)
#define sysSocketAvailable(a,b)  hpi_socket_interface->Available(a,b)
#define sysConnect(a,b,c)        hpi_socket_interface->Connect(a,b,c)
#define sysAccept(a,b,c)         hpi_socket_interface->Accept(a,b,c)
#ifdef NETWARE
#define sysSendTo(a,b,c,d,e,f,g)   hpi_socket_interface->SendTo(a,b,c,d,e,f,g)
#define sysRecvFrom(a,b,c,d,e,f,g) hpi_socket_interface->RecvFrom(a,b,c,d,e,f,g)
#else
#define sysSendTo(a,b,c,d,e,f)   hpi_socket_interface->SendTo(a,b,c,d,e,f)
#define sysRecvFrom(a,b,c,d,e,f) hpi_socket_interface->RecvFrom(a,b,c,d,e,f)
#endif
#define sysListen(a,b)           hpi_socket_interface->Listen(a,b)
#ifdef NETWARE
#define sysRecv(a,b,c,d,e)         hpi_socket_interface->Recv(a,b,c,d,e)
#define sysSend(a,b,c,d,e)         hpi_socket_interface->Send(a,b,c,d,e)
#else
#define sysRecv(a,b,c,d)         hpi_socket_interface->Recv(a,b,c,d)
#define sysSend(a,b,c,d)         hpi_socket_interface->Send(a,b,c,d)
#endif
#define sysTimeout(a,b)          hpi_socket_interface->Timeout(a,b)
#define sysGetHostByName(a)      hpi_socket_interface->GetHostByName(a)
#define sysSocket(a,b,c)         hpi_socket_interface->Socket(a,b,c)

#define SYS_SIG_DFL HPI_SIG_DFL
#define SYS_SIG_ERR HPI_SIG_ERR
#define SYS_SIG_IGN HPI_SIG_IGN

#define SYS_OK	       HPI_OK
#define SYS_ERR	       HPI_ERR
#define SYS_INTRPT     HPI_INTRPT
#define SYS_TIMEOUT    HPI_TIMEOUT
#define SYS_NOMEM      HPI_NOMEM
#define SYS_NORESOURCE HPI_NORESOURCE

#define SYS_THREAD_RUNNABLE     HPI_THREAD_RUNNABLE
#define SYS_THREAD_MONITOR_WAIT HPI_THREAD_MONITOR_WAIT
#define SYS_THREAD_CONDVAR_WAIT HPI_THREAD_CONDVAR_WAIT

#define MinimumPriority	    HPI_MINIMUM_PRIORITY
#define MaximumPriority	    HPI_MAXIMUM_PRIORITY
#define NormalPriority	    HPI_NORMAL_PRIORITY

#define SYS_THREAD_SUSPENDED   HPI_THREAD_SUSPENDED
#define SYS_THREAD_INTERRUPTED HPI_THREAD_INTERRUPTED

#define PAGE_ALIGNMENT	    HPI_PAGE_ALIGNMENT

#define SYS_TIMEOUT_INFINITY HPI_TIMEOUT_INFINITY

#define SYS_FILETYPE_REGULAR      HPI_FILETYPE_REGULAR
#define SYS_FILETYPE_DIRECTORY    HPI_FILETYPE_DIRECTORY
#define SYS_FILETYPE_OTHER        HPI_FILETYPE_OTHER

#endif /* !_JAVASOFT_SYS_API_H_ */
