#ifndef __mut_h__
#define __mut_h__
/*============================================================================
=	NetWare Threads Package for NetWare Loadable Modules
=
=	Unpublished Copyright (C) 1996-1997 by Novell, Inc. All rights reserved.
=
=	No part of this file may be duplicated, revised, translated, localized or
=	modified in any manner or compiled, linked or uploaded or downloaded to or
=	from any computer system without the prior written consent of Novell, Inc.
==============================================================================
=							I n t e r n a l   H e a d e r
==============================================================================
=	Internal interfaces to mutexes. Traditionally, the library was developed
=	using NetWare semaphores in many places with an initial value of 1. This
=	is fixed here to use specific mutex primitives where possible. Obviously,
=	when loaded under traditional NetWare, semaphores will be used instead.
=	These interfaces parallel those in sem.h: _AllocSemaphore(), etc.
=
=	mut.h
==============================================================================
*/
#include <libtypes.h>

typedef struct				/* makes these locks recursive */
{
	T_Mutex	mutex;		/* underlying lock */
	T_Thread	threadID;	/* current owner of lock */
	int		count;		/* recursive ownership counter */
} T_RecMutNode;

/* prototypes... */
int			InitMutexPackage( void );
T_Mutex		_AllocMutex( const char *name, void *rTag );
void			_DeallocMutex( T_Mutex mutex );
int			_LockMutex( T_Mutex mutex );
int			_UnlockMutex( T_Mutex mutex );
int			_UnlockSpecificMutex( T_Mutex mutex );
int			_TryLockMutex( T_Mutex mutex );
T_Thread		_OwnerMutex( T_Mutex mutex );
void			_FreeUpProcessFromSpecificMutex( T_Mutex mutex, T_Process proc );

#endif
