/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/session/nds/NDSTreeSessionState.java $
  $Revision: 16 $
  $Modtime: 4/07/98 5:45p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
#include <ntypes.h>
#include <nwnet.h>
#include <jni.h>

N_EXTERN_FUNC(void) __InitNASAndExFunctions(void);
N_EXTERN_FUNC(void) __CleanupNASAndExFunctions(void);

N_EXTERN_FUNC (NWDSCCODE)
xNWDSCreateContextHandle
(
   pnint newThreadGroup,
   NWDSContextHandle N_FAR *newHandle
);

N_EXTERN_FUNC (NWDSCCODE)
xNWDSDuplicateContextHandle
(
   nint                    threadGroup,
   NWDSContextHandle       srcContextHandle,
   NWDSContextHandle N_FAR *destContextHandle
);

N_EXTERN_FUNC (NWDSCCODE)
xNWDSFreeContext
(
   nint              threadGroup,
   NWDSContextHandle context
);

N_EXTERN_FUNC (NWDSCCODE)
xNWDSLogin
(
   JNIEnv            *env,
   nint              threadGroup,
   NWDSContextHandle context,
   nflag32           optionsFlag,
   pnstr8            objectName,
   pnstr8            password,
   nuint32           validityPeriod,
   nuint32           extendedCharPasswordFlag
);

N_TYPEDEF_CALLBACK (NWRCODE, NWDSChangePwdEx_fp)(NWDSContextHandle, pnstr8, nuint32, nptr, nptr, nuint32);
N_TYPEDEF_CALLBACK (NWRCODE, NWDSGenerateKeyPairEx_fp)(NWDSContextHandle, pnstr8, nuint32, nptr, nuint32);
N_TYPEDEF_CALLBACK (NWRCODE, NWDSLoginEx_fp)(NWDSContextHandle, pnstr8, nuint32, nptr);
N_TYPEDEF_CALLBACK (NWRCODE, NWDSVerifyPwdEx_fp)(NWDSContextHandle, pnstr8, nuint32, nptr);
typedef struct ExtCharPassFunctionTable_tag
{
   NWDSChangePwdEx_fp change;
   NWDSGenerateKeyPairEx_fp generate;
   NWDSLoginEx_fp login;
   NWDSVerifyPwdEx_fp verify;
} ExtCharPassFunctionTable;

typedef int (*NASLoginWithContext_fp)(unicode*, char*, int, int, nint32*, unicode*);
typedef int (*NASLogout_fp)(nint32, int, int);
typedef struct NASFunctionTable_tag
{
   NASLoginWithContext_fp login;
   NASLogout_fp logout;
} NASFunctionTable;

N_EXTERN_FUNC (NWDSCCODE)
xNASLogin
(
   nint              threadGroup,
   NWDSContextHandle context,
   unicode *         objectName,
   pnstr8            password,
   nint32 *          nmasID,
   unicode *         authFDN
);

N_EXTERN_FUNC (NWDSCCODE)
xNWDSLoginAsService
(
   nint              threadGroup,
   NWDSContextHandle context,
   nflag32           optionsFlag,
   pnstr8            objectName,
   nuint32           validityPeriod
);


N_EXTERN_FUNC (NWDSCCODE)
xNWDSWhoAmI
(
   nint              threadGroup,
   NWDSContextHandle context,
   pnstr8            objectName
);

N_EXTERN_FUNC (NWDSCCODE)
xNWDSChangeObjectPassword
(
   JNIEnv            *env,
   nint              threadGroup,
   NWDSContextHandle context,
   nflag32           optionsFlag,
   pnstr8            objectName,
   pnstr8            oldPassword,
   pnstr8            newPassword,
   nuint32           extendedCharPasswordFlag
);

N_EXTERN_FUNC (NWDSCCODE)
xNWDSGenerateObjectKeyPair
(
   JNIEnv            *env,
   nint              threadGroup,
   NWDSContextHandle contextHandle,
   pnstr8            objectName,
   pnstr8            objectPassword,
   nflag32           optionsFlag,
   nuint32           extendedCharPasswordFlag
);

N_EXTERN_FUNC (NWDSCCODE)
xNWDSVerifyObjectPassword
(
   JNIEnv            *env,
   nint              threadGroup,
   NWDSContextHandle context,
   nflag32           optionsFlag,
   pnstr8            objectName,
   pnstr8            objectPassword,
   nuint32           extendedCharPasswordFlag
);

N_EXTERN_FUNC (NWDSCCODE)
xNWDSGetContext
(
   nint              threadGroup,
   NWDSContextHandle context,
   nint              key,
   nptr              value
);

N_EXTERN_FUNC (NWDSCCODE)
xNWDSSetContext
(
   nint              threadGroup,
   NWDSContextHandle context,
   nint              key,
   nptr              value
);

N_EXTERN_FUNC (NWDSCCODE)
xNWDSLogout
(
   nint              threadGroup,
   NWDSContextHandle context
);

N_EXTERN_FUNC (NWDSCCODE)
xNASLogout
(
   nint              threadGroup,
   NWDSContextHandle context,
   nint32            nmasID
);

N_EXTERN_FUNC (NWDSCCODE)
xNWDSCanDSAuthenticate
(
   nint              threadGroup,
   NWDSContextHandle context
);

N_EXTERN_FUNC (NWDSCCODE)
xNWDSSpecialIsDSAuthenticated
(
   nint              threadGroup,
   NWDSContextHandle context
);

N_EXTERN_FUNC (NWDSCCODE)
xNWDSAuthenticateConn
(
   nint              threadGroup,
   NWDSContextHandle context,
   NWCONN_HANDLE     connHandle
);




