
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/jncpv2r/net/NetAttrInfo.java $
  $Revision: 10 $
  $Modtime: 1/05/01 1:11p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.jncpv2r.net;


import java.io.Serializable;
import java.io.IOException;

import com.novell.java.io.EndianInputStream;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.NdsAttributeDefinitionInfo;


/** @internal
 *
 */
public final class NetAttrInfo
   implements NdsAttributeDefinitionInfo, Serializable
{
   private int type;

   private String name;
   private int flags;
   private int syntaxId;
   private int lowerLimit;
   private int upperLimit;
   private byte[] ASN1ID;


   /**
    *
    */
   public NetAttrInfo (
         EndianInputStream eis,
         int type)
      throws NSIException
   {
      this.type = type;

      try
      {
         eis.align32 ();
         // read attribute name
         eis.readLoHiInt ();
         name = eis.readLoHiChars ();

         /* DS_ATTR_DEF_NAMES */
         if (type == NetJNI.DS_ATTR_DEF_NAMES)
         {
            return;
         }

         eis.align32 ();
         // read attribute flags
         flags = eis.readLoHiInt ();
         // read syntax id
         syntaxId = eis.readLoHiInt ();
         // read value lower limit
         lowerLimit = eis.readLoHiInt ();
         // read value upper limit
         upperLimit = eis.readLoHiInt ();
         // read ASN.1 ID
         int length = eis.readLoHiInt ();
         ASN1ID = new byte[length];
         eis.readFully (ASN1ID);
      }
      catch (IOException e)
      {
         throw (new NSIException ());
      }

   } /* NetAttrInfo () */


   /**
    *
    */
   public String getName ()
   {
      return name;
   }

   /**
    *
    */
   public int getFlags ()
   {
      return flags;
   }

   /**
    *
    */
   public int getAttributeFlags ()
   {
      return flags;
   }

   /**
    *
    */
   public int getSyntaxID ()
   {
      return syntaxId;
   }

   /**
    *
    */
   public int getLowerLimit ()
   {
      return lowerLimit;
   }

   /**
    *
    */
   public int getUpperLimit ()
   {
      return upperLimit;
   }

   /**
    *
    */
   public byte[] getASN1ID ()
   {

 // NOTE: clone the ASN1ID

      return ASN1ID;
   }

} /* NetAttrInfo */


