/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/jncpv2r/net/NetAttrRecordEnumerator.java $
  $Revision: 14 $
  $Modtime: 1/05/01 1:11p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.jncpv2r.net;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.NoSuchElementException;

import com.novell.service.jncp.*;

import com.novell.service.session.SessionException;


/** @internal
 *
 */
public final class NetAttrRecordEnumerator implements Enumeration
{
   private NetAttrRecord[] records;
   private int count;


   /**
    *
    */
   public NetAttrRecordEnumerator (
         NetService service,
         String objectName,
         int infoType,
         NetBuffer attrNames,
         int bufferSize)
      throws NSIException
   {
      try
      {
         count = 0;
         records = service.readAttributes (
                                             objectName,
                                             infoType,
                                             attrNames.getHandle (),
                                             bufferSize);
      }
      catch (SessionException e)
      {
         throw (new NSIException ());
      }
      catch(RemoteException e)
      {
         throw NSIExceptionBuilder.build(e);
      }

   } /* NetAttrRecordEnumerator () */

   /**
    *
    */
   public boolean hasMoreElements ()
   {
      return (count < records.length);
   }

   /**
    *
    */
   public Object nextElement ()
   {
      try
      {
         return (records[count++]);
      }
      catch (ArrayIndexOutOfBoundsException e)
      {
         throw (new NoSuchElementException ());
      }
   }

} /* NetAttrRecordEnumerator */


