
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/jncpv2r/net/NetClassInfo.java $
  $Revision: 12 $
  $Modtime: 1/05/01 1:11p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.jncpv2r.net;


import java.io.Serializable;
import java.io.IOException;

import com.novell.java.io.EndianInputStream;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.NdsClassDefinitionInfo;


/** @internal
 *
 */
public final class NetClassInfo
   implements NdsClassDefinitionInfo, Serializable
{
   private int type;

   private String className;
   private int classFlags;
   private byte[] id;

   private String[] superClasses;
   private String[] containmentClasses;
   private String[] namingAttributes;
   private String[] mandatoryAttributes;
   private String[] optionalAttributes;

   private int          flags;
   private NetAsn1ID    asn1ID;

   /**
    * xxx.
    * </p>
    */
   public NetClassInfo ()
   {
      asn1ID = new NetAsn1ID ();
   }

   /**
    * xxx.
    * </p>
    */
   public NetClassInfo (
         int flags,
         NetAsn1ID asn1ID)
   {
      this.flags = flags;
      this.asn1ID = asn1ID;
   }

   /**
    *
    */
   public NetClassInfo (
         EndianInputStream eis,
         int type)
      throws NSIException
   {
      int length;
      int count;

      this.type = type;

      try
      {
         eis.align32 ();
         eis.readLoHiInt ();
         className = eis.readLoHiChars ();

         /* DS_CLASS_DEF_NAMES */
         if (type == NetJNI.DS_CLASS_DEF_NAMES)
         {
            return;
         }

         eis.align32 ();
         classFlags = eis.readLoHiInt ();
         length = eis.readLoHiInt ();
         id = new byte[length];
         eis.readFully (id);

         /* DS_INFO_CLASS_DEFS */
         if (type == NetJNI.DS_INFO_CLASS_DEFS)
         {
            return;
         }

         // read Super Classes
         eis.align32 ();
         if ((count = eis.readLoHiInt ()) > 0)
         {
            superClasses = new String[count];
            for (int i = 0; i < count; i++)
            {
               eis.align32 ();
               eis.readLoHiInt ();
               superClasses[i] = eis.readLoHiChars ();
            }
         }

         // read Containment Classes
         eis.align32 ();
         if ((count = eis.readLoHiInt ()) > 0)
         {
            containmentClasses = new String[count];
            for (int i = 0; i < count; i++)
            {
               eis.align32 ();
               eis.readLoHiInt ();
               containmentClasses[i] = eis.readLoHiChars ();
            }
         }

         // read Naming Attributes
         eis.align32 ();
         if ((count = eis.readLoHiInt ()) > 0)
         {
            namingAttributes = new String[count];
            for (int i = 0; i < count; i++)
            {
               eis.align32 ();
               eis.readLoHiInt ();
               namingAttributes[i] = eis.readLoHiChars ();
            }
         }

         // read Mandatory Attributes
         eis.align32 ();
         if ((count = eis.readLoHiInt ()) > 0)
         {
            mandatoryAttributes = new String[count];
            for (int i = 0; i < count; i++)
            {
               eis.align32 ();
               eis.readLoHiInt ();
               mandatoryAttributes[i] = eis.readLoHiChars ();
            }
         }

         // read Optional Attributes
         eis.align32 ();
         if ((count = eis.readLoHiInt ()) > 0)
         {
            optionalAttributes = new String[count];
            for (int i = 0; i < count; i++)
            {
               eis.align32 ();
               eis.readLoHiInt ();
               optionalAttributes[i] = eis.readLoHiChars ();
            }
         }

         /* DS_CLASS_DEFS || DS_EXPANDED_CLASS_DEFS */
         if (type == NetJNI.DS_CLASS_DEFS
               || type == NetJNI.DS_EXPANDED_CLASS_DEFS)
         {
            return;
         }

//NOTE: DS_FULL_CLASS_DEFS not implemented

         throw (new NSIException ());

      }
      catch (IOException e)
      {
         throw (new NSIException ());
      }

   } /* NetClassInfo () */



   /**
    *
    */
   public int getType ()
   {
      return (type);
   }

   /**
    *
    */
   public String getName ()
   {
      return (className);
   }

   /**
    *
    */
   public int getFlags ()
   {
      return flags;
   }

   /**
    *
    */
   public int getClassFlags ()
   {
      return classFlags;
   }

   /**
    *
    */
   public byte[] getASN1ID ()
   {
      return (id); // NOTE: clone this
   }

   /**
    *
    */
   public String[] getSuperClasses ()
   {
      return (superClasses);
   }

   /**
    *
    */
   public String[] getContainmentClasses ()
   {
      return (containmentClasses);
   }

   /**
    *
    */
   public String[] getNamingAttributes ()
   {
      return (namingAttributes);
   }

   /**
    *
    */
   public String[] getMandatoryAttributes ()
   {
      return (mandatoryAttributes);
   }

   /**
    *
    */
   public String[] getOptionalAttributes ()
   {
      return (optionalAttributes);
   }













   /**
    * xxx.
    * </p>
    *
    * @return                    xxx.
    */
   public NetAsn1ID getAsn1ID ()
   {
      return asn1ID; // NOTE: clone this
   }

   /**
    * xxx.
    * </p>
    *
    * @param   <i>classFlags</i> (in) xxx.
    */
   protected void setFlags (
         int flags)
   {
      this.flags = flags;
   }

   /**
    * xxx.
    * </p>
    *
    * @return                    xxx.
    *
    * @exception  NSIException   xxx.
    */
   protected void setAsn1IDData (
         byte [] data)
   {
      asn1ID.setData(data);
   }

   public void copy(NetClassInfo from)
   {
      this.type = from.type;

      this.className = from.className;
      this.classFlags = from.classFlags;
      System.arraycopy(this.id, 0, from.id, 0, this.id.length);

      System.arraycopy(
         this.superClasses,
         0,
         from.superClasses,
         0,
         this.superClasses.length);
      System.arraycopy(
         this.containmentClasses,
         0,
         from.containmentClasses,
         0,
         this.containmentClasses.length);
      System.arraycopy(
         this.namingAttributes,
         0,
         from.namingAttributes,
         0,
         this.namingAttributes.length);
      System.arraycopy(
         this.mandatoryAttributes,
         0,
         from.mandatoryAttributes,
         0,
         this.mandatoryAttributes.length);
      System.arraycopy(
         this.optionalAttributes,
         0,
         from.optionalAttributes,
         0,
         this.optionalAttributes.length);

      this.flags = from.flags;
      this.asn1ID.setData(
         from.asn1ID.getData());
   }

} /* NetClassInfo */

