
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/jncpv2r/net/NetJNI.java $
  $Revision: 37 $
  $Modtime: 8/24/01 11:38a $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.jncpv2r.net;


import com.novell.java.lang.IntegerBuffer;
import com.novell.java.lang.BooleanBuffer;

import com.novell.service.toolkit.jcl.NWInteger;
import com.novell.service.toolkit.jcl.NWBoolean;


/** @internal
 *
 */
public final class NetJNI
{
      /* Directory Services NCP verb and subverbs */
   public final static int  DS_NCP_VERB               = 104;

      /* subverbs */
   public final static int  DS_NCP_PING                  =   1;
   public final static int  DS_NCP_FRAGMENT              =   2;
   public final static int  DS_NCP_FRAGMENT_CLOSE        =   3;
   public final static int  DS_NCP_BINDERY_CONTEXT       =   4;
   public final static int  DS_NCP_MONITOR_CONNECTION    =   5;
   public final static int  DS_NCP_GET_DS_STATISTICS     =   6;
   public final static int  DS_NCP_RESET_DS_COUNTERS     =   7;
   public final static int  DS_NCP_RELOAD                =   8;
      /* 200 - 255 reserved for auditing */
   public final static int  DS_NCP_AUDITING              = 200;

      /* Directory Services Large Packet Verb Numbers */
   public final static int  DSV_UNUSED_0                    =  0;    /*0x00*/
   public final static int  DSV_RESOLVE_NAME                =  1;    /*0x01*/
   public final static int  DSV_READ_ENTRY_INFO             =  2;    /*0x02*/
   public final static int  DSV_READ                        =  3;    /*0x03*/
   public final static int  DSV_COMPARE                     =  4;    /*0x04*/
   public final static int  DSV_LIST                        =  5;    /*0x05*/
   public final static int  DSV_SEARCH                      =  6;    /*0x06*/
   public final static int  DSV_ADD_ENTRY                   =  7;    /*0x07*/
   public final static int  DSV_REMOVE_ENTRY                =  8;    /*0x08*/
   public final static int  DSV_MODIFY_ENTRY                =  9;    /*0x09*/
   public final static int  DSV_MODIFY_RDN                  = 10;    /*0x0A*/
   public final static int  DSV_DEFINE_ATTR                 = 11;    /*0x0B*/
   public final static int  DSV_READ_ATTR_DEF               = 12;    /*0x0C*/
   public final static int  DSV_REMOVE_ATTR_DEF             = 13;    /*0x0D*/
   public final static int  DSV_DEFINE_CLASS                = 14;    /*0x0E*/
   public final static int  DSV_READ_CLASS_DEF              = 15;    /*0x0F*/
   public final static int  DSV_MODIFY_CLASS_DEF            = 16;    /*0x10*/
   public final static int  DSV_REMOVE_CLASS_DEF            = 17;    /*0x11*/
   public final static int  DSV_LIST_CONTAINABLE_CLASSES    = 18;    /*0x12*/
   public final static int  DSV_GET_EFFECTIVE_RIGHTS        = 19;    /*0x13*/
   public final static int  DSV_ADD_PARTITION               = 20;    /*0x14*/
   public final static int  DSV_REMOVE_PARTITION            = 21;    /*0x15*/
   public final static int  DSV_LIST_PARTITIONS             = 22;    /*0x16*/
   public final static int  DSV_SPLIT_PARTITION             = 23;    /*0x17*/
   public final static int  DSV_JOIN_PARTITIONS             = 24;    /*0x18*/
   public final static int  DSV_ADD_REPLICA                 = 25;    /*0x19*/
   public final static int  DSV_REMOVE_REPLICA              = 26;    /*0x1A*/
   public final static int  DSV_OPEN_STREAM                 = 27;    /*0x1B*/
   public final static int  DSV_SEARCH_FILTER               = 28;    /*0x1C*/

   public final static int  DSV_CHANGE_REPLICA_TYPE         = 31;    /*0x1F*/

   public final static int  DSV_SYNC_PARTITION              = 38;    /*0x26*/
   public final static int  DSV_SYNC_SCHEMA                 = 39;    /*0x27*/
   public final static int  DSV_READ_SYNTAXES               = 40;    /*0x28*/
   public final static int  DSV_GET_REPLICA_ROOT_ID         = 41;    /*0x29*/
   public final static int  DSV_BEGIN_MOVE_ENTRY            = 42;    /*0x2A*/
   public final static int  DSV_FINISH_MOVE_ENTRY           = 43;    /*0x2B*/
   public final static int  DSV_RELEASE_MOVED_ENTRY         = 44;    /*0x2C*/
   public final static int  DSV_BACKUP_ENTRY                = 45;    /*0x2D*/
   public final static int  DSV_RESTORE_ENTRY               = 46;    /*0x2E*/

   public final static int  DSV_CLOSE_ITERATION             = 50;    /*0x32*/

   public final static int  DSV_GET_SERVER_ADDRESS          = 53;    /*0x35*/
   public final static int  DSV_SET_KEYS                    = 54;    /*0x36*/
   public final static int  DSV_CHANGE_PASSWORD             = 55;    /*0x37*/
   public final static int  DSV_VERIFY_PASSWORD             = 56;    /*0x38*/
   public final static int  DSV_BEGIN_LOGIN                 = 57;    /*0x39*/
   public final static int  DSV_FINISH_LOGIN                = 58;    /*0x3A*/
   public final static int  DSV_BEGIN_AUTHENTICATION        = 59;    /*0x3B*/
   public final static int  DSV_FINISH_AUTHENTICATION       = 60;    /*0x3C*/
   public final static int  DSV_LOGOUT                      = 61;    /*0x3D*/
   public final static int  DSV_REPAIR_RING                 = 62;    /*0x3E*/
   public final static int  DSV_REPAIR_TIMESTAMPS           = 63;    /*0x3F*/

   public final static int  DSV_DESIGNATE_NEW_MASTER        = 69;    /*0x45*/

   public final static int  DSV_CHECK_LOGIN_RESTRICTIONS    = 72;    /*0x48*/

   public final static int  DSV_ABORT_PARTITION_OPERATION   = 76;    /*0x4C*/

   public final static int  DSV_READ_REFERENCES             = 79;    /*0x4F*/
   public final static int  DSV_INSPECT_ENTRY               = 80;    /*0x50*/

   public final static int  DSV_ITERATOR                    = 110;   /* 0x6E */ 



      /* definitions used by DSV_MODIFY_ENTRY */
   public final static int  DS_ADD_ATTRIBUTE          = 0x00;
   public final static int  DS_REMOVE_ATTRIBUTE       = 0x01;
   public final static int  DS_ADD_VALUE              = 0x02;
   public final static int  DS_REMOVE_VALUE           = 0x03;
   public final static int  DS_ADDITIONAL_VALUE       = 0x04;
   public final static int  DS_OVERWRITE_VALUE        = 0x05;
   public final static int  DS_CLEAR_ATTRIBUTE        = 0x06;
   public final static int  DS_CLEAR_VALUE            = 0x07;


      /* definitions used by DSV_READ, DSV_SEARCH */
   public final static int  DS_ATTRIBUTE_NAMES        = 0x00;
   public final static int  DS_ATTRIBUTE_VALUES       = 0x01;
   public final static int  DS_EFFECTIVE_PRIVILEGES   = 0x02;
   public final static int  DS_VALUE_INFO             = 0x03;
   public final static int  DS_ABBREVIATED_VALUE      = 0x04;

      /* definitions used by DSV_SEARCH */
   public final static int  DS_SEARCH_ENTRY           =  0;
   public final static int  DS_SEARCH_SUBORDINATES    =  1;
   public final static int  DS_SEARCH_SUBTREE         =  2;
   public final static int  DS_ALIAS_REFERRAL         =  0;
   public final static int  DS_PARTITION_REFERRAL     =  1;
   public final static int  DS_SEARCH_ITEM            =  0;
   public final static int  DS_SEARCH_OR              =  1;
   public final static int  DS_SEARCH_AND             =  2;
   public final static int  DS_SEARCH_NOT             =  3;

   public final static int  DS_SEARCH_EQUAL           =  7;
   public final static int  DS_SEARCH_GREATER_OR_EQUAL=  8;
   public final static int  DS_SEARCH_LESS_OR_EQUAL   =  9;
   public final static int  DS_SEARCH_APPROX          = 10;
   public final static int  DS_SEARCH_PRESENT         = 15;
   public final static int  DS_SEARCH_RDN             = 16;
   public final static int  DS_SEARCH_BASE_CLASS      = 17;
   public final static int  DS_SEARCH_MODIFICATION_GE = 18;
   public final static int  DS_SEARCH_VALUE_TIME_GE   = 19;
   public final static int  DS_SEARCH_REFERENCES      = 20;

      /* definitions used by NWDSOpenStream */
   public final static int  DS_READ_STREAM            =  1;
   public final static int  DS_WRITE_STREAM           =  2;

      /* definitions used by NWDSAddFilterToken */
   public final static int FTOK_END       = 0;
   public final static int FTOK_OR        = 1;
   public final static int FTOK_AND       = 2;
   public final static int FTOK_NOT       = 3;
   public final static int FTOK_LPAREN    = 4;
   public final static int FTOK_RPAREN    = 5;
   public final static int FTOK_AVAL      = 6;
   public final static int FTOK_EQ        = 7;
   public final static int FTOK_GE        = 8;
   public final static int FTOK_LE        = 9;
   public final static int FTOK_APPROX    = 10;
   public final static int FTOK_ANAME     = 14;
   public final static int FTOK_PRESENT   = 15;
   public final static int FTOK_RDN       = 16;
   public final static int FTOK_BASECLS   = 17;
   public final static int FTOK_MODTIME   = 18;
   public final static int FTOK_VALTIME   = 19;

   public final static int FBIT_END       = (1 << FTOK_END);
   public final static int FBIT_OR        = (1 << FTOK_OR);
   public final static int FBIT_AND       = (1 << FTOK_AND);
   public final static int FBIT_NOT       = (1 << FTOK_NOT);
   public final static int FBIT_LPAREN    = (1 << FTOK_LPAREN);
   public final static int FBIT_RPAREN    = (1 << FTOK_RPAREN);
   public final static int FBIT_AVAL      = (1 << FTOK_AVAL);
   public final static int FBIT_EQ        = (1 << FTOK_EQ);
   public final static int FBIT_GE        = (1 << FTOK_GE);
   public final static int FBIT_LE        = (1 << FTOK_LE);
   public final static int FBIT_APPROX    = (1 << FTOK_APPROX);
   public final static int FBIT_ANAME     = (1 << FTOK_ANAME);
   public final static int FBIT_PRESENT   = (1 << FTOK_PRESENT);
   public final static int FBIT_RDN       = (1 << FTOK_RDN);
   public final static int FBIT_BASECLS   = (1 << FTOK_BASECLS);
   public final static int FBIT_MODTIME   = (1 << FTOK_MODTIME);
   public final static int FBIT_VALTIME   = (1 << FTOK_VALTIME);

   public final static int FBIT_OPERAND   = (FBIT_LPAREN  | FBIT_NOT   |
                                             FBIT_PRESENT | FBIT_RDN   |
                                             FBIT_BASECLS | FBIT_ANAME |
                                             FBIT_MODTIME | FBIT_VALTIME);
   public final static int FBIT_RELOP     = (FBIT_EQ | FBIT_GE | FBIT_LE |
                                             FBIT_APPROX);
   public final static int FBIT_BOOLOP    = (FBIT_AND | FBIT_OR);


      /* definitions used by DSV_READ_ATTR_DEF */
   public final static int  DS_SINGLE_VALUED_ATTR     = 0x0001;
   public final static int  DS_SIZED_ATTR             = 0x0002;
   public final static int  DS_NONREMOVABLE_ATTR      = 0x0004;
   public final static int  DS_READ_ONLY_ATTR         = 0x0008;
   public final static int  DS_HIDDEN_ATTR            = 0x0010;
   public final static int  DS_STRING_ATTR            = 0x0020;
   public final static int  DS_SYNC_IMMEDIATE         = 0x0040;
   public final static int  DS_PUBLIC_READ            = 0x0080;
   public final static int  DS_SERVER_READ            = 0x0100;
   public final static int  DS_WRITE_MANAGED          = 0x0200;
   public final static int  DS_PER_REPLICA            = 0x0400;
   public final static int  DS_ATTR_DEF_NAMES         = 0;
   public final static int  DS_ATTR_DEFS              = 1;

   /* definitions used by DSV_DEFINE_CLASS */
   public final static int  DS_CONTAINER_CLASS        = 0x01;
   public final static int  DS_EFFECTIVE_CLASS        = 0x02;
   public final static int  DS_NONREMOVABLE_CLASS     = 0x04;
   public final static int  DS_AMBIGUOUS_NAMING       = 0x08;
   public final static int  DS_AMBIGUOUS_CONTAINMENT  = 0x10;
   public final static int  DS_AUXILIARY_CLASS        = 0x20;
   public final static int  DS_OPERATIONAL_CLASS      = 0x40;

   /* definitions used by DSV_READ_CLASS_DEF */
   public final static int  DS_CLASS_DEF_NAMES        = 0x00;
   public final static int  DS_CLASS_DEFS             = 0x01;
   public final static int  DS_EXPANDED_CLASS_DEFS    = 0x02;
   public final static int  DS_INFO_CLASS_DEFS        = 0x03;
   public final static int  DS_FULL_CLASS_DEFS        = 0x04;

   /* definitions used by DSV_READ_SYNTAXES */
   public final static int  DS_SYNTAX_NAMES           = 0x00;
   public final static int  DS_SYNTAX_DEFS            = 0x01;

   public final static int  DS_STRING                 = 0x0001;   /* string, can be used in names */
   public final static int  DS_SINGLE_VALUED          = 0x0002;
   public final static int  DS_SUPPORTS_ORDER         = 0x0004;
   public final static int  DS_SUPPORTS_EQUAL         = 0x0008;
   public final static int  DS_IGNORE_CASE            = 0x0010;   /* Ignore case          */
   public final static int  DS_IGNORE_SPACE           = 0x0020;   /* Ignore white space   */
   public final static int  DS_IGNORE_DASH            = 0x0040;   /* Ignore dashes        */
   public final static int  DS_ONLY_DIGITS            = 0x0080;
   public final static int  DS_ONLY_PRINTABLE         = 0x0100;
   public final static int  DS_SIZEABLE               = 0x0200;


   /* Miscellaneous string lengths */
   public final static int  NW_MAX_USER_NAME_LEN      = 49;
   public final static int  NW_MAX_VOLUME_NAME_LEN    = 17;
   public final static int  NW_MAX_SERVER_NAME_LEN    = 49;
   public final static int  NW_MAX_TREE_NAME_LEN      = 33;
   public final static int  NW_MAX_SERVICE_TYPE_LEN   = 49;


   //
   // NetBuffer
   //

    /* Directory Context Key names */
   public final static int  DCK_FLAGS               =  1;
   public final static int  DCK_CONFIDENCE          =  2;
   public final static int  DCK_NAME_CONTEXT        =  3;
   public final static int  DCK_TRANSPORT_TYPE      =  4;
   public final static int  DCK_REFERRAL_SCOPE      =  5;
   public final static int  DCK_LAST_CONNECTION     =  8;
   public final static int  DCK_TREE_NAME           = 11;
   public final static int  DCK_DSI_FLAGS           = 12;
   /* NLM only--see NWDSIPXNetworkAddr */
   public final static int  DCK_LAST_SERVER_ADDRESS =  9;
   public final static int  DCK_LAST_ADDRESS_USED   = 10;

   /* values for DCK_FLAGS key */
   public final static int  DCV_DEREF_ALIASES        = 0x0001;
   public final static int  DCV_XLATE_STRINGS        = 0x0002;
   public final static int  DCV_TYPELESS_NAMES       = 0x0004;
   public final static int  DCV_ASYNC_MODE           = 0x0008;
   public final static int  DCV_CANONICALIZE_NAMES   = 0x0010;
   public final static int  DCV_DEREF_BASE_CLASS     = 0x0040;
   public final static int  DCV_DISALLOW_REFERRALS   = 0x0080;

   /* values for DCK_CONFIDENCE key */
   public final static int  DCV_LOW_CONF             = 0;
   public final static int  DCV_MED_CONF             = 1;
   public final static int  DCV_HIGH_CONF            = 2;

   /* values for DCK_REFERRAL_SCOPE key */
   public final static int  DCV_ANY_SCOPE            = 0;
   public final static int  DCV_COUNTRY_SCOPE        = 1;
   public final static int  DCV_ORGANIZATION_SCOPE   = 2;
   public final static int  DCV_LOCAL_SCOPE          = 3;
   /* values for NetBuffer size */
   public final static int  MAX_MESSAGE_LEN          = 63 * 1024;
   public final static int  DEFAULT_MESSAGE_LEN      =  4 * 1024;


   /* values for DSI_FLAGS key */
   public final static int DSI_OUTPUT_FIELDS           = 0x00000001;
   public final static int DSI_ENTRY_ID                = 0x00000002;
   public final static int DSI_ENTRY_FLAGS             = 0x00000004;
   public final static int DSI_SUBORDINATE_COUNT       = 0x00000008;
   public final static int DSI_MODIFICATION_TIME       = 0x00000010;
   public final static int DSI_MODIFICATION_TIMESTAMP  = 0x00000020;
   public final static int DSI_CREATION_TIMESTAMP      = 0x00000040;
   public final static int DSI_PARTITION_ROOT_ID       = 0x00000080;
   public final static int DSI_PARENT_ID               = 0x00000100;
   public final static int DSI_REVISION_COUNT          = 0x00000200;
   public final static int DSI_REPLICA_TYPE            = 0x00000400;
   public final static int DSI_BASE_CLASS              = 0x00000800;
   public final static int DSI_ENTRY_RDN               = 0x00001000;
   public final static int DSI_ENTRY_DN                = 0x00002000;
   public final static int DSI_PARTITION_ROOT_DN       = 0x00004000;
   public final static int DSI_PARENT_DN               = 0x00008000;
   public final static int DSI_PURGE_TIME              = 0x00010000;
   public final static int DSI_DEREFERENCE_BASE_CLASS  = 0x00020000;
   public final static int DSI_REPLICA_NUMBER          = 0x00040000;
   public final static int DSI_REPLICA_STATE           = 0x00080000;
   public final static int DSI_FEDERATION_BOUNDARY     = 0x00100000;
   public final static int DSI_SCHEMA_BOUNDARY         = 0x00200000;
	/*
	 * DSI_GUID is not in dswire.h or nwdsdc.h (as of 4/18/00). I'm wondering
	 * if it was temporarily in dswire.h and then removed.
	 */
   public final static int DSI_GUID                    = 0x00100000;
   public final static int DSI_COUNT                   = 23;

   /* definitions used by DSI_ENTRY_FLAGS */
   public final static int  DS_ALIAS_ENTRY         = 0x0001;
   public final static int  DS_PARTITION_ROOT      = 0x0002;
   public final static int  DS_CONTAINER_ENTRY     = 0x0004;
   public final static int  DS_CONTAINER_ALIAS     = 0x0008;
   public final static int  DS_MATCHES_LIST_FILTER = 0x0010;
   public final static int  DS_REFERENCE_ENTRY     = 0x0020;
   public final static int  DS_40X_REFERENCE_ENTRY = 0x0040;

   /* definitions used by DSI_REPLICA_TYPE */
   public final static int  RT_MASTER         = 0;
   public final static int  RT_SECONDARY      = 1;
   public final static int  RT_READONLY       = 2;
   public final static int  RT_SUBREF         = 3;

   /* values for DSP_FLAGS key */
   public final static int  DSP_OUTPUT_FIELDS          = 0x00000001;
   public final static int  DSP_PARTITION_ID           = 0x00000002;
   public final static int  DSP_REPLICA_STATE          = 0x00000004;
   public final static int  DSP_MODIFICATION_TIMESTAMP = 0x00000008;
   public final static int  DSP_PURGE_TIME             = 0x00000010;
   public final static int  DSP_LOCAL_PARTITION_ID     = 0x00000020;
   public final static int  DSP_PARTITION_DN           = 0x00000040;
   public final static int  DSP_REPLICA_TYPE           = 0x00000080;
   public final static int  DSP_PARTITION_BUSY         = 0x00000100;

   /* nwitr.h */
   /* error code */
      /* Iterator pointer is invalid */
   public final static int  ERR_ITR_INVALID_HANDLE       = -357;
      /* Pos out of range 0. - 1000. */
   public final static int  ERR_ITR_INVALID_POSITION     = -358;
      /* Unexpected or corrupt data */
   public final static int  ERR_ITR_INVALID_SEARCH_DATA  = -359;
      /* DS_SEARCH_SUBTREE not allowed */
   public final static int  ERR_ITR_INVALID_SCOPE        = -360;

   /* Iterator reached beg of data */
   public final static int ERR_BOF_HIT                   = -764;
   /* Iterator reached end of data */
   public final static int ERR_EOF_HIT                   = -765;

      /* First entry position in list */
   public final static int  DS_ITR_FIRST                 =    0;
      /* Last  entry position in list */
   public final static int  DS_ITR_LAST                  = 1000;
      /* End-of-file position. */
   public final static int  DS_ITR_EOF                   = 1001;

      /* Indicates a unicode string */
   public final static int  DS_ITR_UNICODE_STRING        = 0;
      /* Indicates a byte string */
   public final static int  DS_ITR_BYTE_STRING           = 2;


   public static native int NWDSAddFilterToken (
         /*in*/   int    cur, // filter cursor
         /*in*/   int    tok,
         /*in*/   int    val,
         /*in*/   int    syntaxID);


   /**
    *
    */
   public static native int JDSAddFilterToken (
         /*in*/   int                              cur,
         /*in*/   int                              tok,
         /*in*/   byte[]                           val,
         /*in*/   int                              syntaxID);


   public static native int NWDSAddObject (
         /*in*/   int                  threadGroup,
         /*in*/   int                  context,
         /*in*/   String               objectName,
         /*in*/   NetIterationHandle   iterationHandle,
         /*in*/   boolean              more,
         /*in*/   int                  buf);

   public static native int NWDSAllocBuf(
         /*in*/   int size,
         /*out*/  NWInteger buf);

   public static native int NWDSAllocFilter (
         /*out*/  NWInteger cur);

   public static native int NWDSBackupObject (
         /*in*/   int        threadGroup,
         /*in*/   int        context,
         /*in*/   String     objectName,
         /*in/out*/  NetIterationHandle   iterationHandle,
         /*out*/  int        objectInfo);

   public static native int NWDSBeginClassItem (
         /*in*/   int            threadGroup,
         /*in*/   int            context,
         /*in*/   int            buf);

   public static native int NWDSCompare (
         /*in*/   int            threadGroup,
         /*in*/   int            context,
         /*in*/   String         object,
         /*in*/   int            buf,
         /*in*/   BooleanBuffer  matched);

   public static native int NWDSCloseIteration (
         /*in*/   int            threadGroup,
         /*in*/   int            context,
         /*in*/   int            handle,
         /*in*/   int            operation);

// Moved to client.NetSession.
//
//   protected static native int NWDSCreateContext();
//
//   protected static native int NWDSCreateContextHandle(
//         /*out*/  NetContextHandle newHandle);
//
//   protected static native int NWDSDuplicateContext(
//         /*in*/   int oldContext);
//
//   protected static native int NWDSDuplicateContextHandle(
//         /*in*/   int srcContextHandle,
//         /*out*/  NetContextHandle destContextHandle);
//
//   protected static native int NWDSFreeContext(
//         /*in*/   int context);
//
//   protected static native int NWDSGetContext(
//         /*in*/   int context,
//         /*in*/   int key,
//         /*out*/  NetContextInfo value);
//
//   protected static native int NWDSSetContext(
//         /*in*/   int context,
//         /*in*/   int key,
//         /*in*/   NetContextInfo value);

   public static native int NWDSFreeBuf(
         /*in*/   int buf);

   public static native int NWDSGetAttrCount (
         /*in*/   int threadGroup,
         /*in*/   int context,
         /*in*/   int buf,
         /*out*/  IntegerBuffer attrCount);

   public static native int NWDSGetClassDefCount (
         /*in*/   int         threadGroup,
         /*in*/   int         context,
         /*in*/   int         buf,
         /*out*/  IntegerBuffer   classDefCount);

   public static native int NWDSGetAttrDef (
         /*in*/   int              threadGroup,
         /*in*/   int              context,
         /*in*/   int              buf,
         /*out*/  StringBuffer     attrName,
         /*out*/  NetAttributeInfo attrInfo);
//         /*out*/  NetAsn1ID       asn1ID); //NOTE: this is different than the Native Call

   public static native int NWDSGetClassDef (
         /*in*/   int               threadGroup,
         /*in*/   int               context,
         /*in*/   int               buf,
         /*out*/  StringBuffer      className,
         /*out*/  NetClassInfo      classInfo);
//         /*out*/  NetAsn1ID       asn1ID); //NOTE: this is different than the Native Call

   public static native int NWDSGetClassItemCount (
         /*in*/   int            threadGroup,
         /*in*/   int            context,
         /*in*/   int            buf,
         /*out*/  IntegerBuffer  itemCount);


   public static native int NWDSGetClassItem (
         /*in*/   int            threadGroup,
         /*in*/   int            context,
         /*in*/   int            buf,
         /*out*/  StringBuffer   itemName);

   public static native int NWDSGetObjectCount(
         /*in*/   int threadGroup,
         /*in*/   int context,
         /*in*/   int buf,
         /*out*/  NWInteger objectCount);

   public static native int NWDSGetObjectName(
         /*in*/   int threadGroup,
         /*in*/   int context,
         /*in*/   int buf,
         /*out*/  StringBuffer objectName,
         /*out*/  NWInteger attrCount,
         /*out*/  NetObjectInfo objectInfo);

   public static native int NWDSGetSyntaxCount (
         /*in*/   int            threadGroup,
         /*in*/   int            context,
         /*in*/   int            buf,
         /*out*/  NWInteger      syntaxCount);

   public static native int NWDSGetSyntaxDef (
         /*in*/   int            threadGroup,
         /*in*/   int            context,
         /*in*/   int            buf,
         /*out*/  StringBuffer   syntaxName,
         /*out*/  NetSyntaxInfo  syntaxDef);

   public static native int NWDSInitBuf(
         /*in*/   int threadGroup,
         /*in*/   int context,
         /*in*/   int operation,
         /*in*/   int buf);


   /**
    *
    */
   public static native int NWDSList (
         /*in*/      int threadGroup,
         /*in*/      int context,
         /*in*/      String objectName,
         /*in/out*/  NetIterationHandle iterationHandle,
         /*out*/     byte[] subordinates);

   /**
    *
    */
   public static native int NWDSListContainers (
         /*in*/      int threadGroup,
         /*in*/      int context,
         /*in*/      String objectName,
         /*in/out*/  NetIterationHandle iterationHandle,
         /*out*/     byte[] subordinates);

   /**
    *
    */
   public static native int NWDSListByClassAndName (
        int                  threadGroup,
        int                  context,
        String               objectName,
        String               className,
        String               subordinateName,
        NetIterationHandle   iterationHandle,
        byte[]               subordinates  //out
     );

   /**
    *
    */
   public static native int JDSListObjectEntries (
         /*in*/   int               threadGroup,
         /*in*/   int               context,
         /*in*/   int               sNetEntryInfo,
         /*in*/   String            objectName,
         /*in*/   int               bufferSize,
         /*out*/  NetEntryInfo[][]  entries);

   /**
    *
    */
   public static native int JDSReadObjectAttributes (
         /*in*/   int               threadGroup,
         /*in*/   int               context,
         /*in*/   int               sNetAttrRecord,
         /*in*/   String            object,
         /*in*/   int               infoType,
         /*in*/   int               attrNames,
         /*in*/   int               bufferSize,
         /*out*/  NetAttrRecord[][] records);


   public static native int NWDSPutChange (
         /*in*/   int            threadGroup,
         /*in*/   int            context,
         /*in*/   int            buf,
         /*out*/  int            changeType,
         /*out*/  String         attrName);

   public static native int NWDSPutClassItem (
         /*in*/   int         threadGroup,
         /*in*/   int         context,
         /*in*/   int         buf,
         /*out*/  String      itemName);


   public static native int NWDSPutFilter (
         /*in*/   int threadGroup,
         /*in*/   int context,
         /*in*/   int buf,
         /*in*/   int cur, // filter cursor
         /*in*/   int freeVal);


   /** 
    *
    */
   public static native int JDSPutFilter (
         /*in*/   int                        threadGroup,
         /*in*/   int                        context,
         /*in*/   int                        buf,
         /*in*/   int                        cur);


   public static native int NWDSReadObjectInfo (
         /*in*/   int            threadGroup,
         /*in*/   int            contextHandle,
         /*in*/   String         objectName,
         /*out*/  StringBuffer   distinguishedName,   // optional
         /*out*/  NetObjectInfo  objectInfo);         // optional


   public static native int NWDSMapIDToName (
         /*in*/   int            threadGroup,
         /*in*/   int            context,
         /*in*/   int            conn,
         /*in*/   int            objectID,
         /*out*/  StringBuffer   object);

   public static native int NWDSMapNameToID (
         /*in*/   int            threadGroup,
         /*in*/   int            context,
         /*in*/   int            connHandle,
         /*in*/   String         object,
         /*out*/  IntegerBuffer  objectID);


 public static native int NWDSModifyObject (
         /*in*/   int                  threadGroup,
     /*in*/       int                  context,
     /*in*/       String               objectName,
     /*in/out*/   NetIterationHandle   iterationHandle,
     /*in*/       boolean              more,
     /*in*/       int                  changes
   );

 public static native int NWDSModifyDN (
      int         threadGroup,
      int         context,
      String      objectName,
      String      newDN,
      boolean     deleteOldRDN
   );

 public static native int NWDSModifyRDN (
      int         threadGroup,
      int         context,
      String      objectName,
      String      newDN,
      boolean     deleteOldRDN
   );

 public static native int NWDSMoveObject (
      int         threadGroup,
      int         context,
      String      objectName,
      String      destParentDN,
      String      destRDN
   );

 public static native int NWDSOpenStream (
      int         threadGroup,
      int         context,
      String      objectName,
      String      attrName,
      int         flags,
      NWInteger   fileHandle);


 public static native int NWDSRead (
      int                  threadGroup,
      int                  context,
      String               object,
      int                  infoType,
      boolean              allAttrs,
      int                  attrNames,
      NetIterationHandle   iterationHandle,
      int                  objectInfo
   );


   /**
    *
    */
   public static native int NWDSReadAttrDef (
         /*in*/      int                  threadGroup,
         /*in*/      int                  context,
         /*in*/      int                  infoType,
         /*in*/      boolean              allAttrs,
         /*in*/      int                  attrNames,
         /*in/out*/  NetIterationHandle   iterationHandle,
         /*out*/     byte[]               attrDefs);


 public static native int NWDSRemoveObject (
      int        threadGroup,
      int        context,
      String     object
   );

   public static native int NWDSResolveName (
         /*in*/   int         threadGroup,
         /*in*/   int         context,
         /*in*/   String      objectName,
         /*out*/  NWInteger   conn,                   // optional
         /*out*/  NWInteger   objectID);              // optional

 public static native int NWDSRestoreObject (
      int         threadGroup,
      int         context,
      String      objectName,
      NetIterationHandle    iterationHandle,
      boolean     more,
      int         size,
      int         objectInfo
   );

 public static native int NWDSSearch (
      int         threadGroup,
      int         context,
      String      baseObjectName,
      int         scope,
      boolean     searchAliases,
      int         filter,    // a filter buffer.
      int         infoType,
      boolean     allAttrs,
      int         attrNames, // a buffer with the attribute names.
      NetIterationHandle  iterationHandle,
      int         countObjectsToSearch,
      NWInteger   countObjectsSearched,
      int         objectInfo // buffer to receive objects
   );


   /**
    *
    */
   public static native int NWDSGetServerDN (
         /*in*/   int         threadGroup,
         /*in*/   int            context,
         /*in*/   int            connHandle,
         /*out*/  StringBuffer   serverDN);


 public static native int NWDSAuditGetObjectID (
      int            threadGroup,
      int            context,
      String         objectName,
      NWInteger      conn,
      NWInteger      objectID
   );

   public static native int NWDSGetEffectiveRights (
         /*in*/   int         threadGroup,
         /*in*/   int         context,
         /*in*/   String      subjectName,
         /*in*/   String      objectName,
         /*in*/   String      attrName,
         /*out*/  NWInteger   privileges);

   public static native int NWDSListAttrsEffectiveRights (
         /*in*/      int                  threadGroup,
         /*in*/      int                  context,
         /*in*/      String               objectName,
         /*in*/      String               subjectName,
         /*in*/      boolean              allAttrs,
         /*in*/      int                  attrNames,
         /*in/out*/  NetIterationHandle   iterationHandle,
         /*out*/     int                  privilegeInfo);

   public static native int NWDSComputeAttrValSize (
      /*in*/   int         threadGroup,
      /*in*/   int         context,
      /*in*/   int         buf,
      /*in*/   int        syntaxID,
      /*out*/  NWInteger  attrValSize
   );

   public static native int NWDSAbbreviateName (
         /*in*/   int            threadGroup,
         /*in*/   int            context,
         /*in*/   String         inName,
         /*out*/  StringBuffer   abbreviatedName);

   public static native int NWDSCanonicalizeName (
         /*in*/   int            threadGroup,
         /*in*/   int            context,
         /*in*/   String         objectName,
         /*out*/  StringBuffer   canonName);

   public static native int NWDSRemoveAllTypes (
         /*in*/   int            threadGroup,
         /*in*/   int            context,
         /*in*/   String         name,
         /*out*/  StringBuffer   typelessName);

   public static native int NWDSCIStringsMatch (
         /*in*/   int         threadGroup,
         /*in*/   int         context,
         /*in*/   String      string1,
         /*in*/   String      string2,
         /*out*/  NWBoolean   matches);

   public static native int NWDSGetAttrName (
         /*in*/   int         threadGroup,
         /*in*/   int         context,
         /*in*/   int         buf,
         /*out*/  StringBuffer attrName,
         /*out*/  NWInteger   attrValCount,           // optional
         /*out*/  NWInteger   syntaxID);              // optional

 public static native int NWDSGetAttrVal (
      int         threadGroup,
      int         context,
      int         buf,
      int         syntaxID,
      NetMemory   attrVal
   );


   /**
    *
    */
   public static native int JDSGetAttributeValue (
         /*in*/   int                                 threadGroup,
         /*in*/   int                                 context,
         /*in*/   int                                 buf,
         /*in*/   int                                 syntaxId,
         /*out*/  byte[][]                            attributeValue);


 public static native int NWDSPutAttrName (
      int         threadGroup,
      int         context,
      int         buf,
      String      attrName
   );

 public static native int NWDSPutAttrVal (
      int         threadGroup,
      int         context,
      int         buf,
      int         syntaxID,
      int         attrVal
   );


   /**
    *
    */
   public static native int JDSPutAttributeValue (
         /*in*/   int                                 threadGroup,
         /*in*/   int                                 context,
         /*in*/   int                                 buf,
         /*in*/   int                                 syntaxId,
         /*in*/   byte[]                              attributeValue);


 public static native int NWDSGetSyntaxID (
      int         threadGroup,
      int         context,
      String      attrName,
      int[]       syntaxID
   );

 public static native int NWDSReplaceAttrNameAbbrev (
      int            threadGroup,
      int            context,
      String         inStr,
      StringBuffer   outStr
   );

 public static native int NWDSExtSyncList (
      int                  threadGroup,
      int                  context,
      String               objectName,
      String               className,
      String               subordinateName,
      NetIterationHandle   iterationHandle,
      int                  timeStamp,
      boolean              onlyContainers,
      byte[]               subordinates  //out
   );

 public static native int NWDSExtSyncRead (
      int         threadGroup,
      int         context,
      String      objectName,
      int         infoType,
      boolean     allAttrs,
      int         attrNames,        //in, the request buffer
      NetIterationHandle  iterationHandle,   //in-out
//    NDSTimeStamp timeStamp,       // in, the modification time.
      NetBuffer  objectInfo         //out, the request buffer
   );

 public static native int NWDSExtSyncSearch (
      int         threadGroup,
      int         context,
      String      baseObjectName,
      int         scope,
      boolean     searchAliases,
      int         filter,    //a filter buffer.
//    NDSTimeStamp timeStamp,
      int         infoType,
      boolean     allAttrs,
      int         attrNames, //a buffer with the attribute names.
      NetIterationHandle  iterationHandle,
      int         countObjectsToSearch,
      NWInteger   countObjectsSearched,
      NetBuffer   objectInfo
   );


   /**
    *
    */
   public static native int NWDSReadClassDef (
         /*in*/      int                  threadGroup,
         /*in*/      int                  context,
         /*in*/      int                  infoType,
         /*in*/      boolean              allClasses,
         /*in*/      int                  classNames,
         /*in/out*/  NetIterationHandle   iterationHandle,
         /*out*/     byte[]               classDefs);


 public static native int NWDSDefineAttr (
         /*in*/   int               threadGroup,
         /*in*/   int               context,
         /*in*/   String            attrName,
         /*in*/   NetAttributeInfo  attrDef);

 public static native int NWDSDefineClass (
         /*in*/   int            threadGroup,
         /*in*/   int            context,
         /*in*/   String         className,
         /*in*/   NetClassInfo   classInfo,
         /*in*/   int            classItems);

 public static native int NWDSRemoveClassDef (
         /*in*/   int            threadGroup,
         /*in*/   int            context,
         /*in*/   String         className);
/* unused
 public static native int NWDSListContainableClasses (
         /*in* /      int                  context,
         /*in* /      String               parentObject,
         /*in/out* /  NetIterationHandle   iterationHandle,
         /*out* /     NetBufferHandle      containableClasses);
*/

 public static native int NWDSModifyClassDef (
         /*in*/   int            threadGroup,
         /*in*/   int            context,
         /*in*/   String         className,
         /*in*/   int            optionalAttrs);

 public static native int NWDSReadSyntaxes (
         /*in*/      int                  threadGroup,
         /*in*/      int                  context,
         /*in*/      int                  infoType,
         /*in*/      boolean              allSyntaxes,
         /*in*/      int                  syntaxNames,
         /*in/out*/  NetIterationHandle   iterationHandle,
         /*out*/     int                  syntaxDefs);

 public static native int NWDSRemoveAttrDef (
         /*in*/   int            threadGroup,
         /*in*/   int            context,
         /*in*/   String         attrName);

 public static native int NWDSPutSyntaxName (
         /*in*/   int            threadGroup,
         /*in*/   int            context,
         /*in*/   int            buf,
         /*in*/   String         syntaxName);

 public static native int NWDSPutClassName (
         /*in*/   int            threadGroup,
         /*in*/   int            context,
         /*in*/   int            buf,
         /*in*/   String         itemName);

 public static native int NWDSReadSyntaxDef (
         /*in*/   int            threadGroup,
         /*in*/   int            context,
         /*in*/   int            syntaxID,
         /*out*/  NetSyntaxInfo  syntaxDef);

 public static native int NWDSSyncSchema (
         /*in*/   int            threadGroup,
         /*in*/   int            context,
         /*in*/   String         server,
         /*in*/   int            seconds);

   // ******************** Partition methods ********************

   public static native int NWDSAbortPartitionOperation (
      /*in*/   int            threadGroup,
      /*in*/   int            context,
      /*in*/   String         partitionRoot);


   public static native int NWDSAddPartition (
      /*in*/      int                  threadGroup,
      /*in*/      int                  context,
      /*in*/      String               server,
      /*in*/      String               partitionRoot,
      /*in/out*/  NetIterationHandle   iterationHandle,
      /*in*/      boolean              more,
      /*in*/      int                  objectInfo);


   public static native int NWDSAddReplica (
      /*in*/      int            threadGroup,
      /*in*/      int            context,
      /*in*/      String         server,
      /*in*/      String         partitionRoot,
      /*in*/      int            replicaType);


   public static native int NWDSChangeReplicaType (
      /*in*/      int            threadGroup,
      /*in*/      int            context,
      /*in*/      String         replicaName,
      /*in*/      String         server,
      /*in*/      int            newReplicaType);


   public static native int NWDSGetPartitionExtInfo (
      /*in*/      int                 threadGroup,
      /*in*/      int                 context,
      /*in*/      int                 infoPtr,
      /*in*/      int                 limit,
      /*in*/      int                 infoFlag,
      /*out*/     IntegerBuffer       length,   /* this is different than the C API */
      /*out*/     NetPartitionExtInfo data);    /* this is different than the C API */

   public static native int NWDSGetPartitionExtInfoPtr (
      /*in*/      int            threadGroup,
      /*in*/      int            context,
      /*in*/      int            buf,
      /*out*/     IntegerBuffer  infoPtr,       /* this is different than the C API */
      /*out*/     IntegerBuffer  infoPtrEnd);   /* this is different than the C API */

   public static native int NWDSGetPartitionInfo (
      /*in*/      int            threadGroup,
      /*in*/      int            context,
      /*in*/      int            buf,
      /*out*/     StringBuffer   partitionName,
      /*out*/     IntegerBuffer  replicaType);


   public static native int NWDSGetPartitionRoot (
      /*in*/   int            threadGroup,
      /*in*/   int            context,
      /*in*/   String         objectName,
      /*out*/  StringBuffer   partitionRoot);


   public static native int NWDSGetServerName (
      /*in*/      int            threadGroup,
      /*in*/      int            context,
      /*in*/      int            buf,
      /*out*/     StringBuffer   serverName,
      /*out*/     IntegerBuffer  partitionCount);


   public static native int NWDSJoinPartitions (
      /*in*/   int            threadGroup,
      /*in*/   int            context,
      /*in*/   String         subordinatePartition,
      /*in*/   int            flags);


   public static native int NWDSListPartitions (
      /*in*/      int            threadGroup,
      /*in*/      int                  context,
      /*in/out*/  NetIterationHandle   iterationHandle,
      /*in*/      String               server,
      /*out*/     int                  partitions);


   public static native int NWDSListPartitionsExtInfo (
      /*in*/      int            threadGroup,
      /*in*/      int                  context,
      /*in/out*/  NetIterationHandle   iterationHandle,
      /*in*/      String               server,
      /*in*/      int                  DSPFlags,
      /*in*/      int                  partitions);


   public static native int NWDSPartitionReceiveAllUpdates (
      /*in*/      int            threadGroup,
      /*in*/      int            context,
      /*in*/      String         partitionRoot,
      /*in*/      String         serverName);


   public static native int NWDSPartitionSendAllUpdates (
      /*in*/      int            threadGroup,
      /*in*/      int            context,
      /*in*/      String         partitionRoot,
      /*in*/      String         serverName);


   public static native int NWDSRemovePartition (
      /*in*/      int            threadGroup,
      /*in*/      int            context,
      /*in*/      String         partitionRoot);


   public static native int NWDSRemoveReplica (
      /*in*/      int            threadGroup,
      /*in*/      int            context,
      /*in*/      String         server,
      /*in*/      String         partitionRoot);


   public static native int NWDSSplitPartition (
      /*in*/   int            threadGroup,
      /*in*/   int            context,
      /*in*/   String         subordinatePartition,
      /*in*/   int            flags);


   public static native int NWDSSyncPartition (
      /*in*/      int            threadGroup,
      /*in*/      int            context,
      /*in*/      String         server,
      /*in*/      String         partition,
      /*in*/      int            seconds);


   public static native int NWDSSyncReplicaToServer (
      /*in*/      int            threadGroup,
      /*in*/      int            context,
      /*in*/      String         serverName,
      /*in*/      String         partitionRootName,
      /*in*/      String         destServerName,
      /*in*/      int            actionFlags,
      /*in*/      int            delaySeconds);


    // ******************** Nds server methods ********************
/*
   public static native int NWDSOpenConnToNDSServer(
      in      int            threadGroup,
      in      int            context,
      in      String         serverName,
      out     IntegerBuffer  connHandle);
*/
   public static native int NWDSGetServerAddresses(
      /*in*/      int            threadGroup,
      /*in*/      int            context,
      /*in*/      int            conn,
      /*out*/     IntegerBuffer  countNetAddresses,
      /*out*/     int            netAddresses);


   // ******************** Object Info methods ********************

   public static native int NWDSReadObjectDSIInfo (
      /*in*/   int         threadGroup,
      /*in*/   int         context,
      /*in*/   String      object,
      /*in*/   NetMemory   objectInfo);

   public static native int NWDSGetDSIInfo (
      /*in*/   int         threadGroup,
      /*in*/   int         context,
      /*in*/   NetMemory   buf,
      /*in*/   int         infoFlag,
      /*out*/  NetMemory   data);


   /**
    *
    */
   public static native int JDSReadObjectEntry (
         /*in*/   int               threadGroup,
         /*in*/   int               context,
         /*in*/   int               sNetEntryInfo,
         /*in*/   String            objectName,
         /*in*/   int               bufferSize,
         /*out*/  NetEntryInfo[]    entry);


   // ******************** Optimization methods ********************


   /**
    *
    */
   public static native int JDSGetEntryInfoStruct ();

   /**
    *
    */
   public static native int JDSGetAttrRecordStruct ();

   // ******************** Misc methods ********************

   public static native void NWGetNWNetVersion(
      /*out*/  IntegerBuffer   majorVersion,
      /*out*/  IntegerBuffer   minorVersion,
      /*out*/  IntegerBuffer   revisionLevel,
      /*out*/  IntegerBuffer   betaReleaseLevel);

   public static native int NWGetFileServerUTCTime (
      /*in*/   int            conn,
      /*out*/  IntegerBuffer  time);

   public static native int NWDSReloadDS (
         /*in*/   int                        threadGroup,
         /*in*/   int                        context,
         /*in*/   String                     serverName);


   // ******************** security methods ********************

   public static native int NWDSLogin (
         /*in*/   int threadGroup,
         /*in*/   int context,
         /*in*/   int optionsFlag,
         /*in*/   String objectName,
         /*in*/   String password,
         /*in*/   int validityPeriod);

   public static native int NWDSCanDSAuthenticate(
         /*in*/   int threadGroup,
         /*in*/   int context);

   public static native int NWDSAuthenticateConn(
         /*in*/   int threadGroup,
         /*in*/   int context,
         /*in*/   int connHandle);

   public static native int NWDSWhoami (
         /*in*/   int threadGroup,
         /*in*/   int context,
         /*out*/  StringBuffer objectName);

   public static native int NWDSChangeObjectPassword (
         /*in*/   int threadGroup,
         /*in*/   int context,
         /*in*/   int optionsFlag,
         /*in*/   String objectName,
         /*in*/   String oldPassword,
         /*in*/   String newPassword);

   public static native int NWDSLogout(
         /*in*/   int threadGroup,
         /*in*/   int context);


   // ******************** SKADS methods ********************

   public static native int NWDSItrCreateSearch (
      /*in*/   int      threadGroup,
      /*in*/   int      context,
      /*in*/   String   baseObjectName,
      /*in*/   int      scope,
      /*in*/   boolean  searchAliases,
      /*in*/   int      filter,     // a filter buffer
      /*in*/   int      timeFilter, // a time filter
      /*in*/   int      infoType,
      /*in*/   boolean  allAttrs,
      /*in*/   int      attrNames,  // a buffer with the attribute names.
      /*in*/   String   indexSelect,
      /*in*/   String   sortKey,
      /*in*/   int      scalability,
      /*in*/   int      timeout,
      /*out*/  int[]    iterator);

   public static native int NWDSItrCreateList (
      /*in*/   int      threadGroup,
      /*in*/   int      context,
      /*in*/   String   baseObjectName,
      /*in*/   String   className,
      /*in*/   String   subordinateName,
      /*in*/   int      scalability,
      /*in*/   int      timeout,
      /*out*/  int[]    iterator);

   public static native int NWDSItrDestroy (
      /*in*/   int   iterator);

   public static native int NWDSItrClone ( 
      /*in*/   int      iterator,
      /*out*/  int[]    newIterator);


   public static native boolean NWDSItrAtFirst (
      /*in*/   int   iterator);

   public static native boolean NWDSItrAtEOF (
      /*in*/   int   iterator);

   public static native int NWDSItrGetInfo (
      /*in*/   int   iterator,
      /*out*/  boolean[] isScalable,
      /*out*/  boolean[] isPositionable);


   public static native int NWDSItrGetPosition ( 
      /*in*/   int      iterator,
      /*out*/  int[]    position,
      /*in*/   int      timeout);

   public static native int NWDSItrSetPosition ( 
      /*in*/   int      iterator,
      /*in*/   int      position,
      /*in*/   int      timeout);

   public static native int NWDSItrSetPositionFromIterator ( 
      /*in*/   int   iterator,
      /*in*/   int   srcIterator,
      /*in*/   int      timeout);

   public static native int NWDSItrTypeDown ( 
      /*in*/   int      iterator,
      /*in*/   String   attribute,
      /*in*/   String   value,
      /*in*/   int      timeout);

   public static native int NWDSItrSkip ( 
      /*in*/   int   iterator,
      /*in*/   int   numToSkip,
      /*in*/   int   timeout,
      /*out*/  int[] numSkipped);

   public static native int NWDSItrGetNext ( 
      /*in*/      int                  iterator,
      /*in*/      int                  numEntries,
      /*in*/      int                  timeout,
      /*in/out*/  NetIterationHandle   iterationHandle,
      /*out*/     int                  data);

   public static native int NWDSItrGetPrev ( 
      /*in*/      int                  iterator,
      /*in*/      int                  numEntries,
      /*in*/      int                  timeout,
      /*in/out*/  NetIterationHandle   iterationHandle,
      /*out*/     int                  data);

   public static native int NWDSItrGetCurrent ( 
      /*in*/      int                  iterator,
      /*in/out*/  NetIterationHandle   iterationHandle,
      /*out*/     int                  data);

   public static native int NWDSItrCount ( 
      /*in*/   int      iterator,
      /*in*/   int      timeout,
      /*in*/   int      maxCount,
      /*in*/   boolean  updatePosition,
      /*out*/  int[]    count);

}


